# (c) Copyright Rosetta Commons Member Institutions.
# (c) This file is part of the Rosetta software suite and is made available under license.
# (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
# (c) For more information, see http://www.rosettacommons.org. Questions about this can be
# (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

import os, sys, os.path, popen2
import distutils.sysconfig

# Note: The globals authorize_command and install_command should be present above.  If not,
# make sure this file has been built with SConscript.rdwizard.

def install( destination = os.path.join(distutils.sysconfig.get_python_lib(), 'rdwizard') ):
    # Find the directory containing this file.
    my_dir = os.path.dirname( os.path.abspath(__file__) )

    # A list of commands that act like gksu (or similar).  This includes an empty string (e.g., attempt to run
    # without administrator priveleges), common Linux commands like gksu, and the 'authorize' wrapper packaged
    # with Rosetta Design Wizard for OS X and Windows (whose basename is the global authorize_command).
    admin_commands = [ '', 'gksu', 'gksudo', 'kdesu', 'beesu',
                       os.path.join(my_dir, authorize_command) ]

    # These are the files we want to copy over - everything except this setup.py file and the installation programs
    # authorize_command and install_command
    contents = os.listdir( my_dir )
    contents.remove( authorize_command )
    contents.remove( install_command )
    contents.remove( os.path.basename(__file__) )
    contents = [ os.path.join( my_dir, f ) for f in contents ]

    # This is the command to invoke to do the installation - install_command is added by SConscript.rdwizard above.
    install_popen_command = "%s %s %s" % ( os.path.join(my_dir, install_command),
                                           ' '.join( contents ),
                                           os.path.join(distutils.sysconfig.get_python_lib(), 'rdwizard') )

    # Iterate through the commands available and try to see if we can install successfully (getting a return code
    # of either 0 or None).  If so, we can assume installation was successful and return.  If not... bum bum BUM!
    # (Raise an Exception).
    for command in admin_commands:
        subproc = popen2.Popen3( command + ' ' + install_popen_command, capturestderr=True )
        status = subproc.wait()
        if status == 0 or status == None:
            return

    raise Exception()

if __name__ == "__main__":
    print "If you installed the rdwizard_launcher plugin and are seeing this message after attempting " + \
          "an install, please update to the latest version, available at http://rosettadesign.med.unc.edu/rdwizard."
