# (c) Copyright Rosetta Commons Member Institutions.
# (c) This file is part of the Rosetta software suite and is made available under license.
# (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
# (c) For more information, see http://www.rosettacommons.org. Questions about this can be
# (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
from pymol import cmd

class Prompt_manager:
    """ This controls the prompt at the top of the main view panel.


    To use:

    1)in the wizard class, instantiate a Prompt_manager instance
    2)implement the get_prompt function to return self.prompt_manager.prompt


    To show a temporary message, ie one that hides everything, is
    shown until something else is shown:

    0) call self.prompt_manager.set_text(id, text) where id is for
    example 'wait' and the text is for example "Initalizing ...."

    1) call self.prompt_manager.show_only(id)

    To present a question to which you expect the user to enter a text
    response:

    0)in the wizard class implement do_key like this:
    def do_key(self, k,x,y,m):
        if self.key_mode_fun: return self.key_mode_fun(k)

    1)call self.prompt_manager.set_prefix(id, text)
    where id is for example 'ask' and text the prefix such as "Enter
    amino acids to allow:"

    2)call self.prompt_manager.set_text(id, text) where id is
    the same as above and text is the initial text in the response.

    3)call self.prompt_manager.set_postfix(id, text) where id is
    the same as above and text is the cursor symbol for example "_".

    4)call self.prompt_manager.show(id)

    5)set self.key_mode_fun = lambda k: \
    self.prompt_manager.key_prompt_fun(self, id, k, on_return) where
    on_return is a call back function

    6)in on_return make sure self.key_mode_fun is set to None.

    """

    def __init__(self):
        self.prompt = ""
        self.show_keys = []
        self.alt_alt = []
        self.prefixes = {}
        self.texts = {}
        self.postfixes = {}
        self.show_only_flag = False

    def get_prefix(self, id):
        if id in self.prefixes:
            return self.prefixes[id]
        else:
            print "Rosetta Design Wizard: get_prefix: no such prompt id,", id

    def get_text(self, id):
        if id in self.texts:
            return self.texts[id]
        else:
            print "Rosetta Design Wizard: get_text: no such prompt id,", id

    def get_postfix(self, id):
        if id in self.postfixes:
            return self.postfixes[id]
        else:
            print "Rosetta Design Wizard: get_postfix: no such prompt id,", id

    def set_prefix(self, id, text=""):
        self.prefixes[id] = text
        self.do_update()

    def set_text(self, id, text=""):
        self.texts[id] = text
        self.do_update()

    def set_postfix(self, id, text=""):
        self.postfixes[id] = text
        self.do_update()

    def show(self, id=None):
        if self.show_only_flag:
            self.show_keys = self.alt_show
            self.show_only_flag = False

        if id is not None and id not in self.show_keys:
            self.show_keys.append(id)
        self.do_update()

    def show_only(self, id):
        self.alt_show = self.show_keys
        self.show_keys = [id]
        self.show_only_flag = True
        self.do_update()

    def hide(self, id):
        if id in self.show_keys:
            self.show_keys.remove(id)
        self.do_update()

    def do_update(self):
        self.prompt = []
        for id in self.show_keys:
            line = ""
            if id in self.prefixes:  line = line + self.prefixes[id]
            if id in self.texts:     line = line + self.texts[id]
            if id in self.postfixes: line = line + self.postfixes[id]
            self.prompt.append(line)
        cmd.refresh_wizard()


    def key_prompt_fun(self, id, k, on_return):
        text = lambda : self.get_text(id)
        set_text = lambda text = "" : self.set_text(id,text)

        if k==8 and text():  set_text(text()[:-1])    # backspace
        elif k==10 or k==13:                          #enter/line-feed
            self.hide(id)
            on_return()
        elif k>=65 and k<=90:                         #upper case letters
            if text(): set_text(text()+chr(k))
            else:      set_text(chr(k))
        elif k>=97 and k<=122:                        #lower case letters
            if text(): set_text(text()+chr(k).upper())
            else:      set_text(chr(k).upper())

        # do not pasa handling of key press on to higher level handler
        return 1
