# (c) Copyright Rosetta Commons Member Institutions.
# (c) This file is part of the Rosetta software suite and is made available under license.
# (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
# (c) For more information, see http://www.rosettacommons.org. Questions about this can be
# (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

import Tkinter, tkFileDialog, tkSimpleDialog
import Pmw
import time

import util
import rosetta_io

import sys


class Res_table:
    def __init__(self, app, controller ):

        self.do_debug = False

        #self.settings_data = util.read_settingsfile()

        self.parent = Tkinter.Toplevel( app.root )

        self.cmd = app.pymol.cmd
        self.controller = controller

        #mo begin get res_table in the right location
        inv = sys.modules.get("pymol.invocation",None)
        # mo This comes from PMGApp.py
        osFrame = { 'win32' : (4,60), 'irix'   : (0,41),
                    'darwin': (0,51), 'cygwin' : (0,60),
                    'linux' : (0,31), 'linux2' : (0,31) }

        if sys.platform in osFrame.keys():
            (self.xadjust,self.yadjust) = osFrame[sys.platform]
        else:
            self.yadjust = 51
            self.xadjust = 0

        self.width = 200
        self.height = 400
        self.xoffset =inv.options.win_x+220+inv.options.win_px-self.xadjust+5
        self.yoffset = inv.options.win_py-inv.options.ext_y-self.yadjust
        self.parent.geometry('%dx%d+%d+%d'%(self.width, self.height,
                                            self.xoffset, self.yoffset))
        #mo end get res_table in the right location

        self.parent.title("ResTable")


        self.display_defaults_in_compact_view = False


        #TODO change view and sort into dictionaries
        self.views = ['complete', 'compact', 'rosettapp']
        self.view = 'compact'

        self.sorts = ['res_id','task']
        self.sort = 'res_id'


        self.modified_obj_names = {}
        self.object_names = []
        self.pages = {}
        self.texts = {}

        self.are_objects = False

        ############
        # Menu Bar #
        ############

        self.menubar = Tkinter.Menu(self.parent)

        self.filemenu = Tkinter.Menu( self.menubar, tearoff=0 )

        self.filemenu.add_command( label="Open...",
                                   command=self.open_resfile )

        self.filemenu.add_separator()
        self.filemenu.add_command( label="Save",
                                   command=self.save_resfile )

        self.filemenu.add_command( label="Save As...",
                                   command=self.saveAs_resfile )

        self.filemenu.add_command( label="Export...",
                                   command=self.nullfun )

        self.filemenu.add_separator()
        self.filemenu.add_command( label="Close",
                                   command=self.nullfun )

        self.menubar.add_cascade( label="File", menu=self.filemenu )


        self.editmenu = Tkinter.Menu( self.menubar, tearoff=0 )

        self.editmenu.add_command( label="Undo",
                                   command=self.nullfun )

        self.editmenu.add_command( label="Redo",
                                   command=self.nullfun )

        self.editmenu.add_separator()
        self.editmenu.add_command( label="Cut",
                                   command=self.cut )

        self.editmenu.add_command( label="Copy",
                                   command=self.copy )

        self.editmenu.add_command( label="Paste",
                                   command=self.paste )

        self.editmenu.add_separator()
        self.editmenu.add_command( label="Select All",
                                   command=self.select_all )

        self.menubar.add_cascade( label="Edit",
                                  menu=self.editmenu )


        self.viewmenu = Tkinter.Menu(self.menubar, tearoff=0)
        self.viewmenu.add_command( label="View All",
                                   command = lambda v='complete': self.change_view( v ) )

        self.viewmenu.add_command( label="View Compact",
                                   command = lambda v='compact': self.change_view( v ) )

        #self.viewmenu.add_command( label="Rosetta++",
        #                           command = lambda v='rosettapp': self.change_view( v ) )

        self.menubar.add_cascade( label="View", menu=self.viewmenu )

        self.helpmenu = Tkinter.Menu( self.menubar, tearoff=0 )

        self.helpmenu.add_command( label="Contents", command=self.nullfun )

        self.helpmenu.add_command( label="Check for Updates...", command=self.check_for_updates )

        self.menubar.add_cascade( label="Help", menu=self.helpmenu )


        self.parent.config(menu=self.menubar)

        #TODO mo have this make sense
        #self.parent.protocol("WM_DELETE_WINDOW", lambda : self.cur_obj().close_res_table())

        ##############
        #end menubar #
        ##############

        #mo initialize the notebook
        self.notebook = Pmw.NoteBook(self.parent,
                                     borderwidth = 2,
                                     pagemargin = 0,
                                     raisecommand =\
                                     lambda page : self.cmd_notebook_raise())
        self.notebook.pack(fill = "both", expand = 1)

        #the update button at the bottom
        self.frm_bottom = Tkinter.Frame(self.parent)
        self.update = Tkinter.Button(self.frm_bottom,
                                     command=self.cmd_update,
                                     text='Update')
        self.update.pack(fill='both', expand = '1')
        self.frm_bottom.pack(fill='both')

        ##################
        # initalize mini #
        ##################

        self.debug("res_table.py done initializing")

        self.updater( force_once = True )
        self.parent.after(500, self.updater )


    def debug( self, message ):
        if self.do_debug:
            print message

    def onError( self, message ):
        print message

    def rdw( self ):
        self.debug( "res_table.rdw begin" )
        wizards = self.cmd.get_wizard_stack()
        self.debug( "got the wizards from the stack %s" % (str(wizards)) )
        for wizard in wizards:
            try:
                if wizard.name == "rosetta design wizard":
                    self.debug( "res_table.rdw found rdw" )
                    return wizard
            except:

                pass
        self.onError( "res_table.rdw did not find rdw, closing.")
        self.close()

    def open_resfile( self ):
        rdw = self.rdw()
        if not rdw: return

        obj_name = self.cur_obj()
        if obj_name:
            res_filename = tkFileDialog.askopenfilename()
            if res_filename:
                resfile = open( res_filename )
                text = resfile.read()
                resfile.close()

                self.update_resfile_text( obj_name, text )

    def save_resfile(self):
        rdw = self.rdw()
        if not rdw: return
        obj_name = self.cur_obj()
        if obj_name:
            resfilename = rdw.objects[ obj_name ].resfilename
            self.saveAs_resfile( resfilename )


    def saveAs_resfile(self, resfilename=None ):
        rdw = self.rdw()
        if not rdw: return

        obj_name = self.cur_obj()
        if obj_name:
            if not resfilename:
                resfilename = tkFileDialog.asksaveasfilename(
                    defaultextension="",
                    filetypes=[("Mini Rosetta Resfile","*"),
                               ("Rosetta++ Resfile","*"),
                               ("Compact Resfile","*")],
                    title=obj_name+" Resfile SaveAs")
            if resfilename:
                rdw.objects[ obj_name ].resfilename = resfilename
                resfile = open(resfilename, "w")
                resfile.write( rdw.get_view( obj_name ) )
                resfile.close()

    def cut( self ):
        """cut selected text from current page"""

        self.debug("in cut")

        cur_text = self.cur_text()
        if cur_text:
            selection = cur_text.get( Tkinter.SEL_FIRST, Tkinter.SEL_LAST )
            cur_text.delete( Tkinter.SEL_FIRST, Tkinter.SEL_LAST )
            cur_text.clipboard_clear()
            cur_text.clipboard_append( selection )


    def copy( self ):
        """copy selected text from current page"""
        cur_text = self.cur_text()
        if cur_text:
            try:
                selection = cur_text.get( Tkinter.SEL_FIRST, Tkinter.SEL_LAST )
                cur_text.clipboard_clear()
                cur_text.clipboard_append( selection )
            except:
                return

    def paste( self ):
        cur_text = self.cur_text()
        if cur_text:
            try:
                selection = cur_text.selection_get( selection='CLIPBOARD' )
                cur_text.insert( Tkinter.INSERT, selection )
            except:
                pass

    def select_all( self ):
        cur_text = self.cur_text()
        if cur_text:
            self.debug( "dir( cur_text ) %s" % (str(dir( cur_text ))))

            try:
                selection = cur_text.get( "1.0", Tkinter.END )
                cur_text.select( selection )
            except:
                return


    #TODO mo this is a temporary call back function for the (yet to be
    #implemented) menu buttons
    def nullfun(self):pass


    def close(self):   self.parent.destroy()


    def updater( self, force_once=False):
        self.debug( "begin updater" )
        rdw = self.rdw()
        if not rdw:
            self.onError( "res_table.updater did not get rdw, returning.")
            return

        self.debug( "res_table.updater got rdw")

        #initialized objects
        obj_names = rdw.objects.keys()
#        obj_names = rdw.get_native_object_names()

        for obj_name in self.object_names:
            if obj_name not in obj_names:
                self.delete_object( obj_name )


        for obj_name in obj_names:
            if obj_name not in self.object_names:
                self.add_object( obj_name )

        self.debug( "res_table.updater, syncronized objects with pages" )

        if self.are_objects:
            obj = rdw.objects[ self.cur_obj() ]
            self.debug( "res_table.updater examining object %s" % (obj.name) )
            if self.controller.handle_object_modified( obj.name ) or force_once:
                self.debug( "res_table.updater, %s has been modified" % obj.name )
                task_string = rdw.get_view( obj.name )
                self.debug( "got task string %s" % task_string )
                self.update_resfile_text( obj.name, task_string )
                self.debug( "updated resfile text" )

        self.debug( "end updater" )
        if not force_once:
            self.parent.after(500, self.updater )



    def add_object( self, obj_name ):
        """Adds the page for the object"""
        #TODO mo make a function that deletes an object
        if not obj_name: return None

        self.object_names.append(obj_name)


        #Making the name of the notebook tab id(  ) and then setting
        #the text manually is a work around because it does no accept
        #'_' characters!

        modified_obj_name = "~".join( obj_name.split("_") )
        self.modified_obj_names[ modified_obj_name ] = obj_name
        self.pages[ obj_name ] = self.notebook.add( modified_obj_name )
        self.notebook._pageAttrs[ modified_obj_name ][ 'tabbutton' ].config( text=obj_name )

        text =Pmw.ScrolledText(self.pages[obj_name],
                                    #hull_width = 175,
                                    #hull_height = 600,
                                    #usehullsize = True,
                                    text_wrap = 'none' )
        self.texts[ obj_name ] = text.component( 'text' )
        #self.texts[ obj_name ][ 'bg' ] = 'black'#'white'
        #self.texts[ obj_name ][ 'fg' ] = 'white'
        text.pack( fill='both', expand = '1' )

        self.are_objects = True

    def delete_object( self, obj_name ):
        self.debug( "delete object %s" % (obj_name) )
        self.notebook.delete( self.pages[ obj_name ] )

    def update_resfile_text( self, obj_name, text ):
        #delete all tags:
        cur_text = self.cur_text()
        for tag_name in cur_text.tag_names():
            if tag_name != 'sel':
                cur_text.tag_delete(tag_name)

        cur_text.delete("1.0", "end")
        cur_text.insert('end', text)
#        self.color_by_task()
        self.color_by_object()


    def cur_obj(self):
        """ returns the object who's notebook page is visible"""
        if self.are_objects:
            return self.modified_obj_names[ self.notebook.getcurselection() ]
        else:
            return None

    def cur_assoc_objs( self ):
        rdw = self.rdw()
        if not rdw: return

        if self.are_objects:
            native_obj_name = self.cur_obj()
            return rdw.get_decoy_object_names( native_obj_name )
        else:
            return None

    def cur_text( self ):
        if self.are_objects: return self.texts[ self.cur_obj() ]
        else:                return None

    def cmd_notebook_raise( self ):
        """mo call this when a menu tab is selected"""
        pass

    def cmd_update( self ):
        """mo update when the button is pressed.  This parses the text
        in the current page and sets it as the new residue-task
        specification."""
        self.debug( "restable.cmd_update" )
        rdw = self.rdw()
        if not rdw: return

        if not self.are_objects: return None
        text_obj = self.cur_text()

        text = text_obj.get( "1.0", "end" )
        successful = rdw.rosetta_io.set_task( rdw.objects[ self.cur_obj() ], text )
        if successful:
            self.controller.object_modified( self.cur_obj() )
            rdw.do_rosetta_design_update()


    def change_view( self, view ):
        rdw = self.rdw()
        if not rdw: return

        if view not in self.views:
            self.onError( "Undefined vew: %s" % (view) )

        self.debug( "changing view to %s" % (view) )
        for obj_name in self.cur_assoc_objs():
            rdw.objects[ obj_name ].view = view
            self.controller.object_modified( obj_name )



    def color_by_task( self ):
        cur_text = self.cur_text()
        text = cur_text.get( "1.0", "end" )
        lines = text.split( "\n" )

        for lineno in range(len(lines)-1):
            for name, color in rosetta_io.task_color_hex.iteritems():
                columnbegin = lines[ lineno ].find( name )
                if columnbegin >= 0:
                    cur_text.tag_add(
                        name,
                        "%i.%i"%( lineno + 1, columnbegin ),
                        "%i.%i"%( lineno + 1, columnbegin + len( name ) ) )
                    continue

        for name, color in rosetta_io.task_color_hex.iteritems():
            cur_text.tag_config( name, foreground=color )

    def color_by_object( self ):
        rdw = self.rdw()
        if not rdw: return

        cur_text = self.cur_text()
        text = cur_text.get( "1.0", "end" )
        lines = text.split( "\n" )

        obj = rdw.objects[self.cur_obj()]
        res_colors = obj.get_residue_colors()

        for lineno in range(len(lines)-1):
            columnbegin = 0
            rev_res_id = lines[lineno].split()[:2]
            if len(rev_res_id) != 2: continue
            resi, chain = rev_res_id
            res_id= (chain,resi)
            if res_id in res_colors.keys():
                cur_text.tag_add(
                    str(res_id),
                    "%i.%i"%(lineno + 1, 0),
                    "%i.%i"%(lineno + 1, len( lines[lineno])))
                color = util.hex_from_rgb(res_colors[res_id])
                cur_text.tag_config(str(res_id), foreground=color)


    def get_view(self, view = None):
        """return the the view flag"""

        assert self.are_objects

        if view == None:
            view = self.view
#        if view == 'complete':
#            return self.display_complete()
#        if view == 'compact':
#            return self.display_compact()
        if view == 'rosettapp':
            return self.rosetta_io.rosettapp_resfile( self.cur_obj() )


    def get_residue_task(self, obj=None):
        if not obj: obj = self.cur_obj()
        if not obj:
            self.onError( "no object, returning empty task!" )
            return ""
        return self.texts[ obj.name ].get( "1.0", "end" )

    def check_for_updates( self ):
        import rdwizard_launcher
        inst = rdwizard_launcher.Installer( rdwizard_launcher.PyMOL_App )
        inst.check_for_updates()

