# (c) Copyright Rosetta Commons Member Institutions.
# (c) This file is part of the Rosetta software suite and is made available under license.
# (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
# (c) For more information, see http://www.rosettacommons.org. Questions about this can be
# (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.


#A score object is part of a molComplex
#given a residue returns a real number
#given the object returns a real number
#
#
#There is a table with residues as the rows and scores as the columns
#The user can change the residues to either 'all', or a 'selection'
#The user can change the score terms shown
#The user can quickly color by score term

#There are tabs along the top for different objects


import Tkinter
import Pmw

import util
import rosetta_io
import pymol_io

import tkFileDialog

import sys

import math # for log function in sasaprobs


class Score_table:
    def __init__(self, r_io):

        self.rosetta_io = r_io
        self.parent = Tkinter.Toplevel()


        #mo begin get res_table in the right location
        inv = sys.modules.get("pymol.invocation",None)
        # mo This comes from PMGApp.py
        osFrame = { 'win32' : (4,60), 'irix'   : (0,41),
                    'darwin': (0,51), 'cygwin' : (0,60),
                    'linux' : (0,31), 'linux2' : (0,31) }

        if sys.platform in osFrame.keys():
            (self.xadjust,self.yadjust) = osFrame[sys.platform]
        else:
            self.yadjust = 51
            self.xadjust = 0

        self.width = 400
        self.height = 300
        self.xoffset =inv.options.win_x+220+inv.options.win_px-self.xadjust+5
        self.yoffset = inv.options.win_py-inv.options.ext_y-self.yadjust+380
        self.parent.geometry('%dx%d+%d+%d'%(self.width, self.height,
                                            self.xoffset, self.yoffset))
        #mo end get res_table in the right location

        self.parent.title("ScoreTable")



        self.objects = {}
        self.pages = {}
        self.texts = {}
        self.score_totals = {}

        self.are_objects = False

        #TODO mo have this make sense
        #self.parent.protocol("WM_DELETE_WINDOW", lambda : self.cur_obj().close_res_table())

        #mo initialize the notebook
        self.notebook = Pmw.NoteBook(self.parent, borderwidth = 1,
                                     pagemargin = 0)
        self.notebook.pack(fill = "both", expand = 1)


    def close(self):
        self.parent.destroy()


    def add_object(self, obj):
        """Adds the page for the object"""
        #TODO mo make a function that deletes an object
        self.are_objects = True
        #DEBUG
        print "adding object", obj.name,"to score_table"
        self.objects[obj.name] = obj
        try:
            self.pages[obj.name] = self.notebook.add(obj.name)
        except:
            print "failed to add page to note book, trying again..."
            self.notebook.delete(obj.name)
            self.pages[obj.name] = self.notebook.add(obj.name)

        text =Pmw.ScrolledText(self.pages[obj.name],
                                    #hull_width = 175,
                                    #hull_height = 600,
                                    #usehullsize = True,
                                    text_wrap = 'none')
        self.texts[obj.name] = text.component('text')
        self.texts[obj.name]['bg'] = 'white'
        text.pack(fill='both', expand = '1')

        #the update button at the bottom
        self.frm_bottom = Tkinter.Frame(self.pages[obj.name])
        self.score_totals = Tkinter.Entry(self.frm_bottom,
                                          text='Total Scores:')
        self.score_totals.pack(fill='both', expand='1')
        self.frm_bottom.pack(fill='both')


    def cur_obj(self):
        if self.are_objects:
            return self.objects[self.notebook.getcurselection()]
        else:
            return None

    def cur_text(self):
        if self.are_objects:
            cur_page = self.notebook.getcurselection()
            return self.texts[cur_page]
        else:
            return None
##        return self.texts[self.notebook.getcurselection()]


    #TODO mo quite possibly this should be in rosetta_io, or in molComplex...
    def parse_score_from_pdb(self, obj, pdb_file):
        """takes in a pdb as a string and extracts all energy score
        information"""
        assert pdb_file <> None

        #blast through pdb looking for object level energy terms
        for line in pdb_file:
            line = line.split()
            terms = self.rosetta_io.score_terms
            disp_terms = [ term+":" for term in terms]
            if len(line)>0 and line[0] in disp_terms:
                obj.obj_level_score_terms[line[0][:-1]] = line[1]

        #find the sasa prob score for each residue

        #put the file pointer back to the beginning of the file
        pdb_file.seek(0)

        #this is a dictionary (res_id -> real)
        sasaprobs = {}
        start = 0
        beginning_delimiter = 'sasaprob'
        end_delimiter = 'avgtot'
        for line in pdb_file:
            line = line.split()
            #find beginning
            if beginning_delimiter in line and start == 0:
                start = 1
                sasaprob_col = line.index('sasaprob')
                resi_col = line.index('res')
                chain_col = line.index('chain')
            elif start == 1:
                #find end
                if end_delimiter in line: break
                res_id = (line[chain_col],int(line[resi_col]))
                sasaprobs[res_id] = line[sasaprob_col]

        if start == 0:
            print "no scoring information! for obj", obj.name
            return False
        else:
            obj.residue_level_score_terms['sasaprob'] = sasaprobs
            return True

    def color_by_sasaprob(self, obj,pdb_filename=None):
        """color the object by the sasaprob score"""

        if not pdb_filename:
             pdb_filename = obj.score_filename

        if not pdb_filename:
            pdb_filename = tkFileDialog.askopenfilename()

        if not pdb_filename: return None

        try:
            f = open(pdb_filename)
        except:
            print "file "+pdb_filename+" unreadable "
            return None

        result = self.parse_score_from_pdb(obj, f)
        if result:

            #             sp = obj.residue_level_score_terms['sasaprob']
            #             #DEBUG mo
            #             print "residue_level_score_terms",sp


            #             sasaprobs = []
            #             for res_id in obj.res_ids:
            #                 print "res_id", res_id in sp
            #                 sasaprobs.append(sp[res_id])

            sasaprobs = [obj.residue_level_score_terms['sasaprob'][res_id]
                         for res_id in obj.res_ids]

            log_sasaprobs = [math.log(float(y)) for y in sasaprobs]
            pymol_io.color_by_data(obj, obj.res_ids, log_sasaprobs)
        f.close()

        obj.score_filename = pdb_filename


    def format_scores(self, obj, res_ids=None, terms=None):
        """ Display the scores for the specified residues"""

        if res_ids == None: res_ids = obj.res_ids
        if terms == None: terms = obj.residue_level_score_terms

        #mo make the header
        output = 'ch resi'
        for term in terms:
            if term in obj.residue_level_score_terms:
                output = output+"\t"+term
            else:
                print "display_scores WARNING: Obj", obj.name, "has no score term ", term

        output = output+"\n"

        for res_id in res_ids:
            chain, resi = res_id
            output = output            +\
                     chain.ljust(3)    +\
                     str(resi).ljust(5)
            for term in terms:
                output = output +  obj.residue_level_score_terms[term][res_id].rjust(5)

            output = output + '\n'

        return output

    def do_update(self):
        assert self.are_objects

        text = self.format_scores(self.cur_obj())
        self.cur_text().delete("1.0", "end")
        if text:
            self.cur_text().insert('end', text)
