#!/usr/local/bin/python
# (c) Copyright Rosetta Commons Member Institutions.
# (c) This file is part of the Rosetta software suite and is made available under license.
# (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
# (c) For more information, see http://www.rosettacommons.org. Questions about this can be
# (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

from rosetta_design_wizard import *
import sys

if len( sys.argv ) < 2:
    print "Please pass in the database as the first argument and a structure as the second."
    exit(1)

database_path = sys.argv[1]
pdb_filename = sys.argv[2]
print "database -> ", database_path
print "pdb_filename ->", pdb_filename

print "importing mini..."
init_mini( database_path )

print "initializing %s as 'STRUCT1' ..." % ( pdb_filename )
file = open( pdb_filename )
pdb = file.read()
file.close()

init_pose( "STRUCT1", pdb )

print "getting score for STRUCT1 ..."
abc = get_score("STRUCT1")

print "score", abc


print "setting packer_task STRUCT1.pdb"

resfile=\
"""
#Comments begin with a # sign

#blank lines are ignored

#put 'default' commands at the top:

NATRO
start
1 A PIKAA w
2 A POLAR
3 A PIKAA adw
"""
# #next the start token signals the start of residue-level commands
# start
# 5 A NATRO #the formatting is: first the resid, then commands
# 1 A ALLAAwc #note that resid order is arbitrary
# 8 A ALLAAxc
# 7 A PIKAA ACDEF #this is the proper formatting for PIKAA
# 22 A PIKAA QWERYIPLHGDSACNM #note that the string need not be in alpha order
# 4 A NOTAA QRSTVWYI #same formatting for NOTAA
# 23 A NOTAA NVCLHTREWQ #also out of order
# 11 A POLAR
# 15 A APOLAR EX 1 #a mode command and an EX command.  Note that this residue will NOT have EX 2 applied
# 17 A EX 1 EX 3 NATRO #EX commands can come before the mode commands, also note EX 2 not applied
# 2 A PIKAA E EX 4 LEVEL 3 EX 3 EX ARO 1 EX ARO 2 LEVEL 4 #5 commands here
# 30 A NATAA EX 1 EX 2 #recapitulating the default explicitly is legal
#"""

set_task("STRUCT1", resfile)
packer_task = get_task("STRUCT1")

print "the task is:"
print packer_task

run_task("STRUCT1")


print "new score is ...",
abc = get_score("STRUCT1")
print abc

print "the new detailed score is ->"
detailed_score = get_detailed_score("STRUCT1")
print detailed_score

print "getting score_terms..."
score_terms = get_score_terms()
print dir( score_terms )

local_score_terms = []
for term in score_terms:
    local_score_terms.append( term )
    print "term -> ", term

for i in range(1,10):
    print "getting weighted score..."
    score_val = get_weighted_score( 'STRUCT1', 'A', i, local_score_terms[ 0 ] )
    print "term -> %s position -> (%s, %s, %s) value-> %s" % (local_score_terms[ 0 ], 'STRUCT1', 'A', i, score_val )


print "num_res_types:"
print num_res_types( "STRUCT1")

for i in num_res_types("STRUCT1"):
    print "num res type %s" % i

#python test_bindings.py /users/momeara/svn/minirosetta_database_pure1 ~/LP17.pdb



for res_id in get_residues("STRUCT1"):
    chain, resi = res_id
    print "res_id->(%s,%s)" % (chain, resi)




class TestRestable :

    def __init__( self, struct_name ):
        print "get_init_state", get_init_state()
        assert get_init_state() == 1
        assert get_init_state_pose( struct_name ) == 1


        self.struct_name = struct_name

        #self.run_warning_test_cases()

        #self.run_header_test_cases()

        self.test_clean_residue_task("A", 1)
        self.test_set_residue_task("A", 1)

        #self.run_ex_test_cases()

    def run_warning_test_cases(self):
        tasks = []

        # this gives a warning that no 'start' is given and is ignored
        tasks.append( "")

        # this gives a warning that no task is specified and is ignored
        tasks.append( "start" )

        print "in run_warning_test_cases"
        print "tasks->",tasks

        for task in tasks:
            self.test_task( task )

    def run_header_test_cases(self):
        print "run_header_task_cases"
        tasks = []
        # pass
        tasks.append( "NATRO \n start ")

        # fail
        tasks.append("DERTH \n start ")

        for task in tasks:   self.test_task( task )

    def run_ex_test_cases( self ):
        pass


    def test_task( self, task_text ):

        assert get_init_state() == 1
        assert get_init_state_pose( self.struct_name ) == 1


        print "testing task \n'%s'\n" %task_text

        try:
            set_task( self.struct_name, task_text )
            error_msg = get_tracer();
            errors = self.clean_up_resfile_error( error_msg)
            if errors:
                print "in test_task, there was an error in resfile reader"
                print "the errors were '",errors, "' "
                print ""
            print "The output task->\n", get_task( self.struct_name )

        except:
            print "caught exception"

    def test_clean_residue_task( self, chain, resid ):
        print "clean residue task"

        clean_residue_task( self.struct_name, chain, resid )

    def test_set_residue_task( self, chain, resid ):
        print "running test_set_residue_task"
        try:

            set_residue_task( self.struct_name, chain, resid, "ALLAAxc")
        except:
            print "There was an error when trying to set the residue task:"
            tracer = get_tracer()
            if tracer:
                print tracer

        print "Here is the resulting task:"
        print get_task( self.struct_name )


    def clean_up_resfile_error( self, error_msg ):
        errors = error_msg.split( "\n" )
        output_errors = []
        for error in errors:
            if error == "RESFILE WARNING: reached the end of resfile without finding a 'start' token.":
                pass
            elif error == "RESFILE WARNING: No residue-specific behavior specified in resfile":
                pass
            elif error == "":
                pass
            else:
                output_errors.append( error )
        return output_errors




test_restable = TestRestable( "STRUCT1" )
