# (c) Copyright Rosetta Commons Member Institutions.
# (c) This file is part of the Rosetta software suite and is made available under license.
# (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
# (c) For more information, see http://www.rosettacommons.org. Questions about this can be
# (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
import os, sys
import inspect, pprint


def hex_from_rgb( rgb ):
    rgb = [ 256 * c for c in rgb ]
    r,g,b = rgb
    if r == 256: r = 255
    if g == 256: g = 255
    if b == 256: b = 255
    return '#%02x%02x%02x' % (r, g, b)



def compact_res_ids(res_ids):
    """Create a list of ranges from a list of residues, This is
    useful in making a selection in pymol and for compact display
    in the res_table."""

    if res_ids == []: return []

    compact = []

    res_ids.sort()
    #assert (res_ids == sorted(res_ids))

    ##BUG make sure the last range is included!

    cur_chain, beg = res_ids[0]
    cur = beg
    for chain, resi in res_ids[1:]:
        assert ( type(resi) == int )
        if chain == cur_chain and resi == cur + 1:
            cur += 1
        else:
            if beg == cur:
                compact.append((cur_chain,beg))
            else:
                compact.append((cur_chain,(beg,cur)))

            cur_chain = chain
            beg = resi
            cur = beg

    return compact


def pstack():
    for line in inspect.stack()[ 2: ]:
        print line[ 1: ]

def log(msg = None ):
    if msg:
        print msg, "%s,%d" % inspect.stack()[1][1:3]
    else:
        print  "%s,%d" % inspect.stack()[1][1:3]

def get_settingsfilename():
    """Determines and selects the most universally-available path for
    the rdwizard settings file."""
    import rdwizard

    result = None

    # Ordered list; the first element is where we'd prefer to keep the
    # settings file, the second would be second priority, etc.
    settings_file_priorities = []

    # Default mode: create database file in same directory as python module
    # rdwizard_module_folder = '/'.join( rdwizard.__file__.split('/')[:-1] )
    # settingsfilename = rdwizard_module_folder +  "/rdwizard.dat"

    # The best place to put the file: in the rdwizard module's directory
    settings_file_priorities.append( '/'.join( rdwizard.__file__.split('/')[:-1] ) + "/rdwizard.dat" )

    # The second best place to put the file: in the user's config directory
    # This should be a hidden file.
    settings_file_priorities.append( os.path.expanduser('~') + "/.rdwizard.dat" )

    # We can include more locations here of lower priorities later.
    # Next we test for existing settings files we can read, and if
    # there are none, we try to find the first one we can write to.

    # First check for existence and readability
    for filename in settings_file_priorities:
        if os.access( filename, os.F_OK ) and os.access( filename, os.R_OK ):
            result = filename

    # Next check for writability if there was not pre-existing file
    if result == None:
        for filename in settings_file_priorities:
            parent_dir = "/".join( filename.split("/")[:-1] )
            if os.access( parent_dir, os.W_OK ):
                result = filename

    #print "Rosetta Design Wizard: setting file ->", result

    return result


def read_settingsfile( settingsfilename=None ):

    if not settingsfilename:
        settingsfilename = get_settingsfilename()

    settings_data = {}

    if os.path.exists( settingsfilename ):
        settingsfile = open( settingsfilename )
        for line in settingsfile:
            split_line = line.split(" ")
            settings_data[ split_line[ 0 ] ] = ' '.join( split_line[ 1 : ] ).strip()
        settingsfile.close()
    else:
        print "Rosetta Design Wizard: Settings file does not exist... creating %s" % settingsfilename
        try:
            open( settingsfilename, 'w' ).close()
        except:
            print "Unable to open settings file: %s" % settingsfilename
            print "Perhapse you don't have sufficient rights to write to this directory?"

    return settings_data

def write_settingsfile( settings_data, settingsfilename=None ):
    if not settingsfilename:
        settingsfilename = get_settingsfilename()


    settingsfile = open( settingsfilename, 'w' )
    for key, value in settings_data.iteritems():
        settingsfile.write( "%s %s\n" % (key, value) )

    settingsfile.close()
    #except:
    #    print "Rosetta Design Wizard: Unable to open", self.settingsfilename, "to read program settings.  Perhapse it doesn't exist?"
    #    raise FileIO
