// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   utility/basic_sys_util.hh
/// @brief  All system functions in utility that have no other home
/// @author David Kim (dekim@u.washington.edu)


#ifndef INCLUDED_utility_basic_sys_util_HH
#define INCLUDED_utility_basic_sys_util_HH


// Package headers
#include <utility/exit.hh> // For historic reasons (exit used to be here)

// C++ headers
#include <string>


namespace utility {


/// @brief Sleep for a specified number of seconds
void
sys_sleep( double const seconds );


/// @brief Generate timestamp string
std::string
timestamp();


} // namespace utility


#endif // INCLUDED_utility_basic_sys_util_HH
