// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   test/core/scoring/methods/PairEnergy.cxxtest.hh
/// @brief  test suite for core::scoring::PairEnergy.cc
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com)

// Test headers
#include <cxxtest/TestSuite.h>

// Unit headers
#include <core/scoring/disulfides/FullatomDisulfideEnergy.hh>

#include <platform/types.hh>

// Package Headers
#include <test/util/pdb1rpb.hh>
#include <test/util/deriv_funcs.hh>
#include <test/core/init_util.hh>

#include <core/id/DOF_ID.hh>
#include <core/id/TorsionID.hh>
#include <core/pose/Pose.hh>
#include <core/scoring/ScoreFunction.hh>
#include <core/io/pdb/pose_io.hh>
#include <core/options/option.hh>

#include <core/optimization/MinimizerOptions.hh>
#include <core/optimization/AtomTreeMinimizer.hh>

#include <numeric/conversions.hh>

//Auto Headers
#include <core/conformation/Atom.fwd.hh>
#include <core/id/NamedStubID.hh>
#include <core/io/pdb/file_data.hh>
#include <core/pose/signals/ConformationEvent.hh>
#include <core/pose/signals/DestructionEvent.hh>
#include <core/pose/signals/EnergyEvent.hh>
#include <core/scoring/types.hh>
#include <core/scoring/constraints/Constraints.fwd.hh>
#include <ObjexxFCL/FArray.fwd.hh>


// --------------- Test Class --------------- //

// using declarations
using namespace core;
using namespace core::pose;
using namespace core::scoring;
using namespace core::scoring::methods;

class FullatomDisulfideEnergyTests : public CxxTest::TestSuite {

public:

	void setUp() {
		core_init();
	}

	void test_disulfE_deriv_check_w_total_flexibility()
	{
		core::pose::Pose pose = pdb1rpb_pose();
		core::scoring::ScoreFunction sfxn;
		sfxn.set_weight( dslf_ss_dst, 0.5 );
		sfxn.set_weight( dslf_cs_ang, 0.5 );
		sfxn.set_weight( dslf_ss_dih, 0.5 );
		sfxn.set_weight( dslf_ca_dih, 0.5 );

		kinematics::MoveMap movemap( create_movemap_to_allow_all_torsions() );
		AtomDerivValidator adv( pose, sfxn, movemap );
		adv.simple_deriv_check( true, 1e-5 ); // 1st argument true to make sure that start_score == start_func

	}

	void test_disulfE_deriv_check_w_partial_flexibility()
	{
		core::pose::Pose pose = pdb1rpb_pose();
		core::scoring::ScoreFunction sfxn;
		sfxn.set_weight( dslf_ss_dst, 0.5 );
		sfxn.set_weight( dslf_cs_ang, 0.5 );
		sfxn.set_weight( dslf_ss_dih, 0.5 );
		sfxn.set_weight( dslf_ca_dih, 0.5 );

		kinematics::MoveMap movemap;
		movemap.set_bb( 15, true ); // right in the middle
		AtomDerivValidator adv( pose, sfxn, movemap );
		adv.simple_deriv_check( true, 1e-5 ); // 1st argument true to make sure that start_score == start_func

	}

};


