// -*- mode:c++;tab-width:2;indent-tabs-mode:nil;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   utility/sql_database/Sqlite3ConnectionManager.cxxtest.hh
/// @brief  Test Sqlite3 Connection Manager
/// @author Matthew O'Meara (mattjomeara@gmail.com)


// Test Headers
#include <cxxtest/TestSuite.h>

// Unit Headers
#include <utility/sql_database/sqlite3_connection_manager.hh>


#ifdef DB_SQLITE3
// this class requires the DB_SQLITE3 compilation flag
// Enable with $./scons.py extras=sqlite

// External Headers
#include <sqlite3.h>

#endif

// C++ Headers
#include <string>
#include <iostream>

using std::cout;
using std::endl;

class Sqlite3ConnectionManagerTests : public CxxTest::TestSuite {

public:

  void
  setup() {}

  void test_sqlite3_connection_manger(){

#ifdef DB_SQLITE3
// this class requires the DB_SQLITE3 compilation flag
// Enable with $./scons.py extras=sqlite

    using namespace utility::sql_database;


    Sqlite3ConnectionManagerOP scm( Sqlite3ConnectionManager::get_instance() );

    // This opens three new connections to two different databases
    sqlite3 *con1, *con2, *con3, *con4, *con5, *con6;
    scm->get_connection("fake_db_fname_a.db3", con1);
    scm->get_connection("fake_db_fname_a.db3", con2);
    scm->get_connection("fake_db_fname_b.db3", con3);

    // This releases gives the connections back to the connection manager
    scm->free_connection( "fake_db_fname_a.db3", con1 );
    scm->free_connection( "fake_db_fname_a.db3", con2 );
    scm->free_connection( "fake_db_fname_b.db3", con3 );

    // should be a tracer but tracers are in core this is in utility!
    cout << "test_sqlite3_connection_manager containing 3 connections:" << endl;
    cout << scm;

    // Retrieve the connections again
    scm->get_connection("fake_db_fname_a.db3", con4 );
    scm->get_connection("fake_db_fname_a.db3", con5 );
    scm->get_connection("fake_db_fname_b.db3", con6 );

    TS_ASSERT( con4 == con2 );
    TS_ASSERT( con5 == con1 );
    TS_ASSERT( con6 == con3 );

    // should be a tracer but tracers are in core this is in utility!
    cout << "test_sqlite3_connection_manager containing no connections:" << endl;
    cout << scm;

#endif // DB_SQLITE3
  }

};
