// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   utility/sql_database/Sqlite3Interface.cxxtest.hh
/// @brief  Test Sqlite3 Interface
/// @author Matthew O'Meara (mattjomeara@gmail.com)

/// See doc/utility/sql_database/sqlite3_interface.dox for more information.
///
/// To Run this test make sure DB_SQLITE3 is defined by using the 'extra' keyword.
///
///   ./scons.py cat=test extras=sqlite
///   ./test/run.py --extras=sqlite -d <path/to/minirosetta/database>
///


// Test Headers
#include <cxxtest/TestSuite.h>

// Project Headers
#include <core/util/Tracer.hh>

#ifdef // DB_SQLITE3
// this class requires the DB_SQLITE3 compilation flag
// Enable with $./scons.py extras=sqlite

// Unit Headers
#include <utility/sql_database/sqlite3_interface.hh>

// External Headers
#include <sqlite3.h>

#endif

// C++ Headers
#include <string>
#include <iostream>


static core::util::Tracer TR("utility.sql_database.Sqlite3Interface.cxxtest");

class Sqlite3InterfaceTests : public CxxTest::TestSuite {

public:

	void
	setup() {}

	void
	test_sqlite3_interface(){

#ifdef // DB_SQLITE3
// this class requires the DB_SQLITE3 compilation flag
// Enable with $./scons.py extras=sqlite

		using namespace utility::sql_database;

		Sqlite3Interface sqlite3_interface( "test_db.sl3" );

		// A transaction groups together multiple statements to be more
		// efficient.
		sqlite3_interface.begin_transaction();

		sqlite3_interface.execute_sql( "\
CREATE TABLE table1 (\
		id INTEGER PRIMARY KEY AUTOINCREMENT,\
		value REAL,\
		math_const TEXT,\
		awesome BOOL );");


		sqlite3_interface << begin_row("table1")
			<< Sqlite3Interface::sqlite3_null
			<< 3.14
			<< "pi"
			<< true
			<< Sqlite3Interface::end_row;

		sqlite3_interface.end_transaction();

		sqlite3_interface << begin_row("table1")
		  << Sqlite3Interface::sqlite3_null
			<< 1.62
			<< "golden ratio"
			<< true
			<< Sqlite3Interface::end_row;


		TA_ASSERT( sqlite3_interface.last_key() == 2 );

#endif // DB_SQLITE3

	}

};


