#!/usr/local/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"
if ( @ARGV < 3 ) {

die ( "Usage: perl -P <pdbxxxx_chothia.pdb>  <fragment_size> <clustering_radius>\n" ) ;

}

require "$scripts/readinfo.pl";
require "$scripts/getminimum_per_identity.pl";
require "$scripts/ram_match_hacks.pl" ;
require "$scripts/ram_members_of_list.pl" ;

$minimum_resolution = 2.8 ;

@excluded_kink = ( "1hil" , "1seq" , "1l7t" , "1lo0" , "1dsf" ) ;
@excluded_extended = ( "1a3r" , "1dqd" , "1kn2" , "1yee" , "1mj8" , "25c8" , "43c9" ,"1d5i" , "1f8t" , "1il1" , "1mh5" , "1ncw" , "1uz8" , "1wej" ) ;
@excluded = ( @excluded_kink , @excluded_extended ) ;

@nminus4_to_nminus2 = ( "h3_8_98-" , "h3_9_99-" , "h3_10_100-" , "h3_11_100A-" , "h3_12_100B-" , "h3_13_100C-" , "h3_14_100D-" ) ;

$pdb = shift @ARGV ;
$fragment_size = shift @ARGV ;
$cluster_radius = shift @ARGV ;


&readinfo; # subroutine in readinfo.pl

open ( queryh3 , "FR02_.fasta" ) || die ( "File FR02_.fasta not found\n" ) ;
$lineskip = <queryh3> ;
$h3=<queryh3> ;
chop ($h3) ; $length_h3 = length ( $h3 ) ;
$Sequence_h3 = substr ( $h3 , 1 , $length_h3 - 2 ) ;
print "$h3 $Sequence_h3 $length_h3\n" ;
die ( "Exiting...Fragment size:$fragment_size larger than H3 length:$length_h3\n" ) if ( $fragment_size > $length_h3 ) ;

$npositions = $length_h3 - $fragment_size + 1 ;

for ( $i = 1 ; $i <= $npositions ; $i++ ) {
		$type = "h3frag\_$fragment_size\_$i" ;
		push @types, $type ;
}


foreach $type (@types) {
		&identifymatch ( $type ,$maximum_resolution , $npositions ) ;
}

sub identifymatch {

		my $type ;
		my $count = 0 ;
		($type,$maximum_resolution, my $npositions) = @_ ;
		( $tag , $fragment_size , $position ) = split ( /\_/ , $type ) ;
		$outfile = "$type\_list" ;
		open ( outfile , ">$outfile" ) ;
		open ( file , "query\_$type.align" ) ;
		$lineskip = 0 ;
		while ( $lineskip < 4 ) { $line = <file>; $lineskip++; }
		$line = <file> ;
		chop($line) ;
		while ($line ne '') {
				($query,$match,$per_identity,$alignment_length,$mismatch,$gapopen,$qs,$qe,$ss,$se,$evalue,$bitscore)=split(/\t/,$line)  ;
				$pdbcode_match = substr ( $match , 4 , 4 ) ;
				$pdbcode_chothia_match = "pdb$pdbcode_match\_chothia.pdb" ;

				my $filter_not_native = 1 ;
				my $filter_not_native = $Sequence_h3 ne $Seq { $pdbcode_chothia_match."h3" } ;
				my $filter_resol = $resol { $pdbcode_chothia_match } <= $minimum_resolution ;

				$filter_choose = ( $qs == $ss && $qe == $se ) ;
				$filter_fragment = $filter_not_excluded = 1 ;

				$filter_fragment = &members_of_list ( $match , "103.pdb" ) if ( $position == $npositions ) ;
				$filter_fragment = &members_of_list ( $match , "102.pdb" ) if ( $position == $npositions - 1 ) ;
				$filter_fragment = &members_of_list ( $match , "101.pdb" ) if ( $position == $npositions - 2 ) ;
				$filter_fragment = &members_of_list ( $match , @nminus4_to_nminus2 ) if ( $position == $npositions - 3 ) ;
				$filter_not_excluded = ! &members_of_list ( $match , @excluded ) ;

				if ( $filter_choose && $filter_not_excluded && $filter_fragment &&
						 $filter_not_native && $filter_resol ) {
						$count ++ ;
						printf outfile "$match\n" ;
						system2( "cp $abfrags/abfrags$fragment_size/$match ." ) unless ( -e $match ) ;
				}
				$line = <file> ;
				chop($line) ;
		}
		close(outfile) ;
		$profit_outfile = "profit_h3frags.out" ;
		$profit_rmsd_table = "profit_h3frags_rmsd_table" ;
		$which_framework = "FR02" ;
		$run_profit = 1 ;
		$which_atoms = 2 ;
		print " Processing $type...$count\n" ;

		unless  ( $count < 2 ) {

				system2(" rm -fr $profit_outfile $profit_rmsd_table" ) ;
				system2("perl -P $scripts/ram_profit_script_h3frags.pl $outfile $run_profit $which_atoms" );
				system2("perl -P $scripts/ram_create_rmsd_table_h3frags.pl $profit_outfile" );
				system2("rm -fr tmp.* rms.*") ;
				system2("cat $profit_rmsd_table | $docking_scripts/rms2avglink1.csh $cluster_radius") ;
				system2("perl -P $scripts/ram_cluster_h3frags.pl $position $which_framework $count $outfile" );
		} else {

				if ( $count == 1 ) {
						print "WARNING!  Only one fragment choice for position $position\n" ;
						system2("perl -P $scripts/ram_cluster_h3frags.pl $position $which_framework $count $outfile" ) ;
				} else  {
						print "WARNING !!!! DANGER !!!!! No fragments in file $outfile for position $position\nRosetta fragment file has not been created\n" ;
				}
		}
}


