#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

if ( @ARGV < 6 ) {
		print STDERR "Not enough arguments for script $0. Exiting...\nUsage: perl -P $0 <list> <light|heavy chain ID> <start_residue> <end_residue> <which_cdr_loop> <fragment_size>\nInput: List of pdb files, chain ID to obtain fragments, start and end residues, and the cdr loop (l1-l3, h1-h3)\n" ;
		die ( "This script should be run from $idealized\n" ) ;
}


 %threetoone=("ALA",A,"CYS",C,"ASP",D,"GLU",E,"PHE",F,"GLY",G,"HIS",H,"ILE",I,"LYS",K,"LEU",L,"MET",M,"ASN",N,"PRO",P,"GLN",Q,"ARG",R,"SER",S,"THR",T,"VAL",V,"TRP",W,"TYR",Y) ;
require "$scripts/readinfo.pl";
require "$scripts/readdsspline.pl" ;
require "$scripts/get_cterm_residues.pl" ;
require "$scripts/readpdbline.pl" ;
require "$scripts/removespaces.pl" ;
&readinfo ; # Subroutine in readinfo.pl ;


$list = shift @ARGV ;
$getchain = shift @ARGV ;
$start_residue = shift @ARGV ;
$end_residue = shift @ARGV ;
$which_cdr_loop = shift @ARGV ;
$fragment_size = shift @ARGV ;


open ( list , $list ) || die ( "Exiting. File $list not found\n" ) ;
$filename = <list> ;
chop ( $filename ) ;

while ( $filename ne '' ) {
    $lines_read = 0 ;
    $only_n_ca_c = 4 ;
    $len_cdr = $Length { $filename.$which_cdr_loop } ;
    $resol = $resol { $filename } ;
		
		$prefix = substr ( $filename , 0 , length ( $filename ) - 4 ) ;
    $pdbcode = substr ( $filename , 3 , 4 ) ;
    open ( filename , "$idealized/$filename" ) || die ( "Exiting. File $filename not found\n" ) ;
    
		$line = <filename> ;
    chop ( $line ) ;
		
    while ( $line ne '' ) {
				&readpdbline ( $line ) ;
				$residuenum = $residueno ;
				$filter_residuenum = ( $residuenum >= $start_residue && $residuenum <= $end_residue ) ;
				$filter_atomname = ( $atom eq "N" || $atom eq "CA" || $atom eq "C" || $atom eq "O" ) ;
				
				if ( $chain eq $getchain && $filter_residuenum && $filter_atomname ) {
						$lines_read++ ;
						$store_line { $lines_read } = $line ;
				}
				$line = <filename> ;
				chop ( $line ) ;
    }
    &write_fragments ( $lines_read ) ; 
		
    $filename = <list> ;
    chop ( $filename ) ;
}

sub write_fragments {
    my $lines_read = $_[0] ;
    $i = 1 ;
    while ( $i <= $lines_read - $only_n_ca_c*$fragment_size + 1 ) {
				$j = $i ;
				$linenew = '' ;
				$fragment = $resnum_range = '' ;
				
				while ( $j <= $i + $only_n_ca_c*$fragment_size -1 ) {
						$line = $store_line { $j } ;
						$index = int(($j-$i)/$only_n_ca_c ) + 1 ;
						$new_residueno = "   ".$index." " ;
						if ( &removespaces ( substr ( $line , 12 , 4 ) =~ "CA" ) ) {
								$residue = $threetoone { substr ( $line , 17 , 3 ) } ;
								$residuenum = &removespaces ( substr ( $line , 22 , 4 ) ) ;
								$insert_code = &removespaces ( substr ( $line , 26 , 1 ) ) ;
								$residueno = $residuenum.$insert_code ;
								$fragment = $fragment.$residue ;
								$resnum_range = $resnum_range."-".$residueno ;
						}
						substr ( $line , 22 , 5 ) = $new_residueno ;
						$linenew=$linenew.$line."\n" ;
						$j++ ;
				}
				$resnum_range =~ s/^-// ;
				$length_h3 = $Length { $filename."h3" } ;
				$outfile = "$fragment\_$pdbcode\_$fragment_size\_$which_cdr_loop\_$length_h3\_$resnum_range.pdb" ;
				
				open ( outfile , ">$abfrags/abfrags$fragment_size/$outfile" ) ;
				printf outfile "$linenew\n" ;
				close(outfile) ;
				$i = $i + $only_n_ca_c ;
		}
}




