#!/usr/bin/perl
die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

@types = ( "light" , "heavy" , "lfr" , "hfr" ) ;

foreach $type ( @types ) {
    $databasefile = "database.".$type ;
    open ( databasefile , "$database/$databasefile" ) || die ( "File $databasefile not found\n" ) ;
    $line = <databasefile> ;
    chop ( $line ) ;

    while ( $line ne '' ) {
				if ( $line =~ /\>/ ) {
						$pdb = substr ( $line , 1 , length ( $line ) - 1 ) ;
						push @pdbfiles, $pdb unless ( $seen { $pdb } ++ ) ;
				} else {
						$argument = $pdb.$type ;
						$sequence { $argument } = $line ;
				}
				$line = <databasefile> ;
				chop ( $line ) ;
    }
    close ( databasefile ) ;
}

open ( databaselightheavy , ">$database/database.lightheavy" ) ;
open ( databaselfrhfr , ">$database/database.lfrhfr" ) ;

foreach $pdb ( @pdbfiles ) {
    $sequence_light = $sequence { $pdb."light" } ;
    $sequence_heavy = $sequence { $pdb."heavy" } ;

    if ( $sequence_light ne '' && $sequence_heavy ne '' ) {
				$sequence_lightheavy = $sequence_light . $sequence_heavy ;
				printf databaselightheavy ">$pdb\n$sequence_lightheavy\n" ;
    }

    $sequence_lfr = $sequence { $pdb."lfr" } ;
    $sequence_hfr = $sequence { $pdb."hfr" } ;

    if ( $sequence_lfr ne '' && $sequence_hfr ne '' ) {
				$sequence_lfrhfr = $sequence_lfr . $sequence_hfr ;
				printf databaselfrhfr ">$pdb\n$sequence_lfrhfr\n" ;
    }
}
