#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"
require "$scripts/ram_read_matches.pl" || die ( "File $scripts/ram_read_matches.pl not found\n" ) ;
require "$scripts/readpdbline.pl" || die ( " File $scripts/readpdbline.pl not found\n" ) ;
require "$scripts/detect_chainbreak.pl" || die ( " File $scripts/detect_chainbreak.pl not found\n" ) ;

if ( @ARGV < 2 ) {
		print "Exiting...Not enough arguments\n Usage: perl -P $0 <pid/bit> <camelid:0|1>\n " ;
		die ( ) ;
}

$criterion = shift @ARGV ; # PID, Bit score, Consensus etc.
$camelid = shift @ARGV;

if( $camelid == 0 ) {
		open ( queryL , ">queryL.pdb" ) ;
}
open ( queryH , ">queryH.pdb" ) ;


%threetoone=("ALA",A,"CYS",C,"ASP",D,"GLU",E,"PHE",F,"GLY",G,"HIS",H,"ILE",I,"LYS",K,"LEU",L,"MET",M,"ASN",N,"PRO",P,"GLN",Q,"ARG",R,"SER",S,"THR",T,"VAL",V,"TRP",W,"TYR",Y);
%onetothree=("A",ALA,"C",CYS,"D",ASP,"E",GLU,"F",PHE,"G",GLY,"H",HIS,"I",ILE,"K",LYS,"L",LEU,"M",MET,"N",ASN,"P",PRO,"Q",GLN,"R",ARG,"S",SER,"T",THR,"V",VAL,"W",TRP,"Y",TYR);
my @types;
if( $camelid == 1 ) {
		@types = ( "hfr" ) ;
}
else {
		@types = ( "lfr" , "hfr" ) ;
}

&read_matches ; # Found in ram_read_matches.pl
$break_count = 0;
for $type ( @types ) {

		$templatefile = "templateL.pdb" if ( $type eq "lfr" ) ;
		$templatefile = "templateH.pdb" if ( $type eq "hfr" ) ;

		if ( $type eq "lfr" ) {
				$chn = "L"; $outputhandle = "queryL" ;
				&detect_chainbreaks( $templatefile );
				$new_count = 0;
				
				# hack to compensate for missing n-ter residues
				open( l1seqfile, "query.l1" );
				$l1seq = <l1seqfile>;
				$l1seq = <l1seqfile>;
				chomp( $l1seq );
				open( lfastafile, "query_l.fasta" );
				$lfasta = <lfastafile>;
				chomp( $lfasta );
				$lstart = index( $lfasta, $l1seq );

				for( $i = 23 - $lstart; $i <=114; $i++ ) {
						if( ($i >=  1 && $i <=  23 ) ||
								($i >= 35 && $i <=  49 ) ||
								($i >= 57 && $i <=  88 ) ||
								($i >= 98 && $i <= 114 ) ) {
								if( $chain_break_count == 0 
										|| $break_count == $chain_break_count ) {
										$fr[$new_count] = $i;
										$new_count++;
								}
								elsif( ( $i == $breakres[$break_count+1]) &&
											 ( $chn eq $breakchain[$break_count + 1] ) ) {
										$break_count++;
								}
								else {
										$fr[$new_count] = $i;
										$new_count++;
								}
								if( $i == 66 ) {
										system( "grep 66A query.chothia > temp.chothia" );
										if( -s "temp.chothia" ) {
												$fr[$new_count] = "66A";
												$new_count++;
										}
										system( "rm temp.chothia" );
										system( "grep 66B query.chothia > temp.chothia" );
										if( -s "temp.chothia" ) {
												$fr[$new_count] = "66B";
												$new_count++;
										}
										system( "rm temp.chothia" );
								}
							
						}
				}
		} elsif ( $type eq "hfr" ) {
				$chn = "H"; $outputhandle = "queryH" ;
				&detect_chainbreaks( $templatefile );
				$new_count = 0;

				# hack to compensate for missing n-ter residues
				open( h1seqfile, "query.h1" );
				$h1seq = <h1seqfile>;
				$h1seq = <h1seqfile>;
				chomp( $h1seq );
				open( hfastafile, "query_h.fasta" );
				$hfasta = <hfastafile>;
				chomp( $hfasta );
				$hstart = index( $hfasta, $h1seq );
				
				for( $i = 26 - $hstart; $i <=114; $i++ ) {
						if( ($i >=  1 && $i <=  25 ) ||
								($i >= 36 && $i <=  49 ) ||
								($i >= 66 && $i <=  82 ) ||
								($i >= 83 && $i <=  94 ) ||
								($i >=103 && $i <= 114 ) ) {
								if( $chain_break_count == 0 
										|| $break_count == $chain_break_count ) {
										$fr[$new_count] = $i;
										$new_count++;
								}
								elsif( ( $i == $breakres[$break_count + 1] ) &&
											 ( $chn eq $breakchain[$break_count + 1] ) )	{
										$break_count++;
								}
								else {
										$fr[$new_count] = $i;
										$new_count++;
								}
								if( $i == 82 ) {
										$fr[$new_count] = "82A";
										$new_count++;
										$fr[$new_count] = "82B";
										$new_count++;
										$fr[$new_count] = "82C";
										$new_count++;
								}
						}
				}
		}
		&readqueryfasta ( $type ) ;

		open ( templatefile , $templatefile ) || die ( "Exiting... File $templatefile not found\n" ) ;
		$line = <templatefile> ;
		chop ( $line ) ;
		while ( $line ne '' ) {
				if ( $line =~ /^ATOM/ ) {
						&readpdbline ( $line ) ; # Subroutine in readpdbline.pl
						$residueno = $residueno.$insert_code if ( $insert_code ne ' ' ) ;
						$found = 0 ;
						unless ( $alt_loc =~ /B/ ) {
								for ( $i = 0 ; $i <= @fr ; $i++ ) {
										$mut_res = @fraa[$i] ;
										$mut_res_no = @fr[$i] ;
										next if ($chain ne $chn or $residueno ne $mut_res_no) ;
										$found = 1 if($residueno eq $mut_res_no) ;
										last if ( $found ) ;
								}
								if ( $found ) {
										if ($mut_res eq $residue_single) {
												printf $outputhandle "$line\n" ;
										} else {
												$line =~ s/$residue/$onetothree{$mut_res}/ ;
												$h3noresbug = substr( $line, 17, 3 );
												if( $h3noresbug ne " H " ) {
														printf $outputhandle "$line\n" if ($atom eq "N" or $atom eq "CA" or $atom eq "C" or $atom eq "O") ;
												}
										}
								}
						}
				} else {
						printf $outputhandle "$line\n" unless ($line =~ /HEADER/ or $line =~ /TITLE/ or $line =~ /COMPND/) ;
				}
				$line = <templatefile> ;
				chop ( $line ) ;
		}
		close ( $outputhandle ) ;
}

sub readqueryfasta {
		my $type = $_[0]."svr" ;
		$fasta = "query.".$type ;
		open(fasta,$fasta) ;
		$line = <fasta> ;
		chop($line) ;
		$line=<fasta> ;
		chop($line) ;
		$string{$type}=$line ;
		@fraa = split(//,$string{$type}) ;

		if( $_[0] eq "lfr" ) {
				$query_fasta = "query_l.fasta";
		}
		elsif( $_[0] eq "hfr" ) {
				$query_fasta = "query_h.fasta";
		}
		open( query_fasta, $query_fasta );
		$query_line = <query_fasta>;
		chomp( $query_line );
		@query_fraa = split(//, $query_line );

		$last = $fraa[@fraa - 1];
		$query_last = $query_fraa[@query_fraa - 1];
		if( $last ne $query_last ) {
				$fraa[@fraa] = $query_last;
		}
		close( query_fasta );

		return ;
}
