#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

if ( @ARGV < 5 ) {
		print STDERR "Not enough arguments for script $0. Exiting...
Usage: perl -P $0 <list> <light|heavy chain ID> <start_residue> <end_residue> <which_cdr_loop> 
Input: List of pdb files, chain ID to obtain fragments, start and end residues, and the cdr loop (l1-l3, h1-h3)\n" ;
		die () ;
}

require "$scripts/readinfo.pl";
require "$scripts/readdsspline.pl" ;
require "$scripts/get_cterm_residues.pl" ;
&readinfo ; # Subroutine in readinfo.pl ;


$list = shift @ARGV ;
$getchain = shift @ARGV ;
$start_residue = shift @ARGV ;
$end_residue = shift @ARGV ;
$which_cdr_loop = shift @ARGV ;

$outfile = "fragments\_$which_cdr_loop\_$start_residue\_$end_residue" ;
open ( outfile , ">$fragments/$outfile" ) || die ( "Exiting.Unable to open $outfile\n" ) ;

open ( list , $list ) || die ( "Exiting. File $list not found\n" ) ;
$filename = <list> ;

chop ( $filename ) ;

while ( $filename ne '' ) {
    $lines_read = 0 ;
    $len_cdr = $Length { $filename.$which_cdr_loop } ;
    $resol = $resol { $filename } ;

    $prefix = substr ( $filename , 0 , length ( $filename ) - 4 ) ;
    $DSSP_FILE = $prefix.".dssp" ;
    $DSSP_PATH = "$dsspfiles/$DSSP_FILE" ;
    open ( DSSP_PATH , $DSSP_PATH ) || die ( "Exiting. File $DSSP_FILE not found\n" ) ;
		
    $lineskip = <DSSP_PATH> ;
    $line = <DSSP_PATH> ;
    chop ( $line ) ;

    while ( $line ne '' ) {
				&readdsspline ( $line ) ;
				$residuenum = $residueno ;
				$residuenum = substr ( $residueno , 0 , length ( $residueno ) - 1 ) if ( $residueno =~ /[A-Z]/ ) ;
				$filter_residuenum = ( $residuenum >= $start_residue && $residuenum <= $end_residue ) ;
				
				if ( $chain eq $getchain && $filter_residuenum ) {
						$lines_read++ ;
						$store_line { $lines_read } = $line ;
				}
				$line = <DSSP_PATH> ;
				chop ( $line ) ;
    }
		close( DSSP_PATH );
    &write_fragments ( $lines_read ) ;
		$filename = <list> ;
    chop ( $filename ) ;
}
close( list );
close( outfile );


sub write_fragments {
    my $lines_read = $_[0] ;
		
    for ( $i = 1 ; $i <= $lines_read - 2 ; $i++ ) {
				$iplus1 = $i + 1 ;
				$iplus2 = $i + 2 ;
				$line = $store_line { $i } ;
				$line_plus_1 = $store_line { $iplus1 } ;
				$line_plus_2 = $store_line { $iplus2 } ;

				$printseq = '' ;
				&readdsspline ( $line ) ;
				#printf outfile "%19s\t%-4s\t%1s\t%6.1f\t%6.1f\t%6.1f\t%2d\t%2.1f\n",$filename,$residueno,$residue_single,$omega,$phi,$psi,$len_cdr,$resol ;
				$pdbcode = substr( $filename, 3, 4);
				printf outfile "%5s%2s%6s%2s%2s%9.3f%9.3f%9.3f ", $pdbcode, $getchain, $residueno, $residue_single, L, $phi, $psi, $omega;
				$printseq = $printseq.$residue_single ;

				&readdsspline ( $line_plus_1 ) ;
				#printf outfile "%19s\t%-4s\t%1s\t%6.1f\t%6.1f\t%6.1f\t%2d\t%2.1f\n",$filename,$residueno,$residue_single,$omega,$phi,$psi,$len_cdr,$resol ;
				$pdbcode = substr( $filename, 3, 4);
				printf outfile "%5s%2s%6s%2s%2s%9.3f%9.3f%9.3f ", $pdbcode, $getchain, $residueno, $residue_single, L, $phi, $psi, $omega;
				$printseq = $printseq.$residue_single ;

				&readdsspline ( $line_plus_2 ) ;
				#printf outfile "%19s\t%-4s\t%1s\t%6.1f\t%6.1f\t%6.1f\t%2d\t%2.1f\n",$filename,$residueno,$residue_single,$omega,$phi,$psi,$len_cdr,$resol ;
				$pdbcode = substr( $filename, 3, 4);
				printf outfile "%5s%2s%6s%2s%2s%9.3f%9.3f%9.3f ", $pdbcode, $getchain, $residueno, $residue_single, L, $phi, $psi, $omega;
				$printseq = $printseq.$residue_single ;
				print outfile "$printseq\n" ;
		}
}
