#!/usr/bin/perl

sub detect_chainbreaks {

		die ( " Exiting...File rampaths.txt not found \n" )
				unless -e ( "rampaths.txt" ) ;
		
#include "rampaths.txt"
		
		require "$scripts/readpdbline.pl" ||
				die ( " File $scripts/readpdbline.pl not found\n" ) ;

		$pdb = $_[0] ;
		
		open( pdbfile, $pdb );
		$line = <pdbfile> ;
		chop ( $line ) ;
		until( $line =~ /^ATOM/ ) {
				$line = <pdbfile> ;
				chop ( $line ) ;
		}
		&readpdbline ( $line ) ; # Subroutine in readpdbline.pl
		$old_residueno = $residueno;
		$old_chain = $chain;
		
		#my @breakchain, @breakres;
		$chain_break_count = 0;
		
		while ( $line ne '' ) {
				if ( $line =~ /^ATOM/ ) {
						&readpdbline ( $line ) ; # Subroutine in readpdbline.pl
						if( $old_chain eq $chain ) {
								if($old_residueno == $residueno) {
										$old_residueno = $residueno;
								}
								elsif( ($old_residueno + 1 ) == $residueno) {
										$old_residueno++;
								}
								else {
										while( $old_residueno < ($residueno - 1) ) {
												$old_residueno++;
												$chain_break_count++;
												
												$breakchain[$chain_break_count] = $chain;
												$breakres[$chain_break_count] = $old_residueno;
										}
								}
						}
						$old_residueno = $residueno;
				$old_chain = $chain;
				}
				$line = <pdbfile> ;
				chop ( $line ) ;
		}
		
		close( pdbfile );

}

1;
