#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"
#include "utilities.txt"

if ( @ARGV < 2 ) {

die ("Usage: perl -P $0 <h3_fragment_size> <wordsize>\n" ) ;

}

$fragment_size = shift @ARGV ;
$wordsize = shift @ARGV ;

open ( queryh3 , "FR02_.fasta" ) || die ("File FR02_.fasta not found\n" ) ;
$lineskip = <queryh3> ;
$h3 = <queryh3> ;
chop ( $h3 ) ;
$length_h3 = length ( $h3 ) ;
die ( "Fragment size:$fragment_size $h3 longer than H3 length:$length_h3. Exiting...\n" )  if ( $fragment_size > $length_h3) ;

$i = 0 ;

while ( $i <= $length_h3 - $fragment_size ) {
		$frag = substr ( $h3 ,$i , $fragment_size ) ;
		$i++ ;
		$type = "h3frag\_$fragment_size\_$i" ;
		$outfile = "query.$type" ;
		open ( outfile ,  ">$outfile" ) ;
		push @types, $type unless ( $seen { $type } ++ ) ;
		printf outfile ">query.pdb\n$frag\n" ;
}

foreach $type ( @types ) {

		$outputtype = 9 ;
		$databasename = "database.h3frag$fragment_size" ;
		$databasepath = "$database/$databasename" ;
		$inputquery = "query.".$type ;
		$output = "query\_$type".".align" ;
		$evalue = 10000000 ;
		$matrix = "BLOSUM45" ;
		$numbertokeep = 100 ;
		system2(" $blast/blastall -p blastp  -d $databasepath -i $inputquery -o  $output -e $evalue -M $matrix -W $wordsize -m $outputtype -b $numbertokeep -P 1" );

}
