#!/usr/local/bin/perl
use Cwd ;

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"


if ( @ARGV < 10 ) {

print STDERR "Not enough arguments for script $0. Exiting...\n Usage: perl -P $0 <pdbxxxx\_chothia.pdb> <run_blast_prep:0|1> <run_blast_matches:0|1> <template_creation:0|1> <rosetta_graft_loop:0|1> <rosetta_make_fragments:0|1> <rosetta_build_loops:0|1> <nstruct_build> <fastafile_lightchain> <fastafile_heavychain> <camelid-optional> \n " ;

die () ;

}

require "$scripts/ram_kink_query.pl" ;

$chainL = "L" ;
$chainH = "H" ;

$currentdir = getcwd ( ) ;

$pdb = shift @ARGV;
$run_blast_prep = shift @ARGV ;
$run_blast_matches = shift @ARGV ;
$template_creation = shift @ARGV ;
$rosetta_graft_loop = shift @ARGV ;
$rosetta_make_fragments = shift @ARGV ;
$rosetta_build_loops = shift @ARGV ;
$nstruct_build = shift @ARGV ;
$fastafile_light = shift @ARGV ;
$fastafile_heavy = shift @ARGV ;
$camelid = 0;
if( @ARGV == 1 ) {
		$Fv_type = shift @ARGV;
		if( $Fv_type eq "camelid" ) {
				$camelid = 1;
		}
}

#Hardcoded variable values

$criterion = "bit" ;
$frameworktemplate = "ram" ;
$cdrtemplate = "ram" ;
$native_h3_reconstruct = 0 ;
$eliminate_natives = 0 ;
$which_framework = "FR02" ;
$deep_graft = 1 ;
$vlvhalignment = 2 ;
my $h3_fragment_type;
$additional_flags = 2 ; #Changed from 3 to 2 by Aroop on 4/8/10
$pdb_input = 0 ;
$fasta_input = 1 ;
my $h3_frag_end_res;
if( $camelid == 1 ) {
		$h3_fragment_type = 1 ;
		$h3_frag_end_res = 106;
}
else {
		$h3_fragment_type = 3 ;
		$h3_frag_end_res = 103;
}



$nstruct_grafting = 1 ;
$rosetta_3mer_fragments = "rosetta_3mer_fragments" ;
$ab_3mer_fragments = "ab_3mer_fragments" ;
$fragments_h3_94_103 = "fragments_h3_94_103" ;
$ab_fragment_resol_threshold = 2.5 ;

#End hardcoded variable values

$pdbcode = substr ( $pdb , 3 , 4 ) ;
$pdbdir = "$currentdir/$pdbcode" ;
$build_loop_dir = "$currentdir/build" ;
$refine_loop_dir = "$currentdir/refine" ;

system2("mkdir -p $build_loop_dir" );
system2( "cp $scripts/paths.txt paths.txt" ) ;
unlink ( "errorlog" ) ;


&do_blast_prep if ( $run_blast_prep ) ;
&get_blast_matches if ( $run_blast_matches ) ;
#&get_error ;
&create_template if ( $template_creation ) ;
&graft_canonical_loops if ( $rosetta_graft_loop ) ;
&make_fragments if ( $rosetta_make_fragments ) ;
&build_rosetta_loops if ( $rosetta_build_loops ) ;

sub do_blast_prep {
		system2("perl -P $scripts/ram_create_query_fasta.pl $pdb $chainL $chainH" ) if ( $pdb_input ) ;
		if( $camelid == 1 ) {
				system2("perl -P $scripts/temp_ram_camelid_mapping.pl" );
		}
		else {
				system2("perl -P $scripts/ram_mapping.pl" );
		}
		system2("perl -P $scripts/ram_create_query_database.pl $camelid" );
		if( $camelid == 0 ) {
				system2("perl -P $scripts/ram_create_query_database_lightheavy.pl" );
		}
}

sub get_blast_matches {
		system2("perl -P $scripts/ram_blastscript.pl $camelid" ) ;
		system2("perl -P $scripts/ram_id_perfect_matches.pl $camelid" ) ;
		system2("perl -P $scripts/ram_analyze_blast.pl $pdb $criterion $eliminate_natives $camelid" ) ;
}

sub get_error {
		if ( -e "errorlog" ) {
				printf STDERR "No sequence matches for one or more regions \n  Exiting homology modeling protocol\n" ;
				system2("cat errorlog" );
				die ( ) ;
		}
}

sub create_template {

		system2( "echo TER > terfile" ) ;
		system2("perl -P $scripts/ram_copytemplates.pl $pdb_input $criterion $frameworktemplate $cdrtemplate $pdb $camelid" ) ;
		system2("perl -P $scripts/ram_mutate_pdb.pl $criterion $camelid" ) ;
		if ( $camelid == 1 ) {
				system2("perl -P $scripts/remove_h3.pl queryH.pdb > intermediate.pdb");
				system2("$scripts/ram_blankcdrs.pl intermediate.pdb H $camelid > FR02.pdb" ) ;
				system2("$scripts/randomize_cdr_coord.pl FR02.pdb > temp.pdb" );
				system2("mv temp.pdb FR02.pdb" );
				
		}
		else {
				if ( $vlvhalignment == 1 ) {
						
# Superimpose lfr match onto the light chain of the hfr match pdb to create queryLfitted.pdb

						if ( $which_framework eq "FR01" ) {

								system2("perl -P $scripts/ram_profit_script.pl templateL.pdb queryH.pdb heavy > profit.in" ) ;
								system2("profit < profit.in >> profit.out" ) ;
								system2("grep Error profit.out" ) ;
								system2("cat queryL.pdb queryHfitted.pdb > FR01_nocdr.pdb" ) ;
								system2("$scripts/ram_blankcdrs.pl FR01_nocdr.pdb L $camelid > FR01_Lcdr.pdb" ) ;
								system2("$scripts/ram_blankcdrs.pl FR01_Lcdr.pdb H $camelid> FR01.pdb" ) ;
								
						} elsif ( $which_framework eq "FR02" ) {
								
								system2("perl -P $scripts/ram_profit_script.pl templateH.pdb queryL.pdb light > profit.in" ) ;
								system2("profit < profit.in > profit.out" ) ;
								system2("grep Error profit.out" ) ;
								system2("perl -P $scripts/remove_h3.pl queryHfitted.pdb > intermediate.pdb" );
								system2("mv intermediate.pdb queryHfitted.pdb" );						
								system2("cat queryLfitted.pdb queryH.pdb > FR02_nocdr.pdb" ) ;
								system2("$scripts/ram_blankcdrs.pl FR02_nocdr.pdb L $camelid > FR02_Lcdr.pdb" ) ;
								system2("$scripts/ram_blankcdrs.pl FR02_Lcdr.pdb H $camelid > FR02.pdb" ) ;
						}
						
				} elsif ( $vlvhalignment == 2 )  {
						
						if ( $which_framework eq "FR01" ) {
								
								system2("perl -P $scripts/ram_profit_script.pl templatelfrhfr.pdb queryL.pdb light > profit.in" ) ;
								system2("profit < profit.in > profit.out" ) ;
								system2("grep Error profit.out" ) ;
								
								system2("perl -P $scripts/ram_profit_script.pl templatelfrhfr.pdb queryH.pdb heavy > profit.in" ) ;
								system2("profit < profit.in >> profit.out" ) ;
								system2("grep Error profit.out" ) ;
								
								system2("cat queryLfitted.pdb queryHfitted.pdb > FR01_nocdr.pdb" ) ;
								system2("$scripts/ram_blankcdrs.pl FR01_nocdr.pdb L $camelid > FR01_Lcdr.pdb" ) ;
								system2("$scripts/ram_blankcdrs.pl FR01_Lcdr.pdb H $camelid > FR01.pdb" ) ;
								
						} elsif ( $which_framework eq "FR02" )  {
								system2("perl -P $scripts/ram_profit_script.pl templatelightheavy.pdb queryL.pdb light > profit.in" ) ;
								
								system2("profit < profit.in > profit.out" );
								
								system2("perl -P $scripts/ram_profit_script.pl templatelightheavy.pdb queryH.pdb heavy > profit.in" ) ;
								system2("profit < profit.in >> profit.out" ) ;
								system2("perl -P $scripts/remove_h3.pl queryHfitted.pdb > intermediate.pdb" );
								system2("mv intermediate.pdb queryHfitted.pdb" );
								system2("cat queryLfitted.pdb queryHfitted.pdb > FR02_nocdr.pdb" ) ;
								system2("$scripts/ram_blankcdrs.pl FR02_nocdr.pdb L $camelid > FR02_Lcdr.pdb" ) ;
								system2("$scripts/ram_blankcdrs.pl FR02_Lcdr.pdb H $camelid > FR02.pdb" ) ;
								system2("$scripts/randomize_cdr_coord.pl FR02.pdb > temp.pdb");
								system2("mv temp.pdb FR02.pdb" );
								
						}

				}
		}
		system2("perl -P $scripts/ram_setup_rrun.pl $pdb_input $pdb $criterion $deep_graft $camelid" ) ;

		if ( $pdb_input ) {
				system2("perl -P $scripts_alt/extractres.pl L 4 105 $pdb > nativeL.pdb " ) ;
				system2("perl -P $scripts_alt/extractres.pl H 4 110 $pdb > nativeH.pdb " ) ;
				system2("cat nativeL.pdb terfile nativeH.pdb terfile > $pdbcode.pdb" );
		}
		system2("perl $scripts/pre_graft_antibody_cleaner.pl $which_framework" ) ;
}

sub graft_canonical_loops {

		printf STDERR "START LOOP GRAFTING: $pdb\n"  ;

		system2("$scripts/pdb_cleaner.pl $which_framework | tee temp.pdb" ) ;
		system2("mv temp.pdb $which_framework.pdb" ) ;

		unless ( $native_h3_reconstruct )  {
				system( "grep C query.?? > disulftemp" );
				system( "grep \" C \" *query* | grep chothia | grep -v \"L C 23\" | grep -v \"L C 88\" | grep -v \"H C 22\" | grep -v \"H C 92\" >> disulftemp" );
				open( sulffile, "disulftemp" );
				$sulf = <sulffile>;
				chomp( $sulf );
				if( $camelid == 0 ) {
						if( $sulf eq '' ) {
								system2("$bin/rosetta.gcc aa $which_framework _ -antibody_modeler -nstruct $nstruct_grafting -quiet -l1 -l2 -l3 -h1 -h2 -graft_h3 -superimpose -deep 2 -use_pdb_numbering -ccd_closure -s $which_framework -native $pdbcode -find_disulf -norepack_disulf|tee rosetta$which_framework\_grafting.logfile") ;
								# system2("$bin/rosetta.gcc aa $which_framework _ -antibody_modeler -nstruct $nstruct_grafting -quiet -l1 -l2 -l3 -h1 -h2 -superimpose -deep 2 -use_pdb_numbering -ccd_closure -s $which_framework -native $pdbcode -find_disulf -norepack_disulf|tee rosetta$which_framework\_grafting.logfile") ; // aroop: removed for h3_graft }
						}
						else {
								system2("$bin/rosetta.gcc aa $which_framework _ -antibody_modeler -nstruct $nstruct_grafting -quiet -l1 -l2 -l3 -h1 -h2 -graft_h3 -superimpose -deep 2 -use_pdb_numbering -ccd_closure -s $which_framework -native $pdbcode | tee rosetta$which_framework\_grafting.logfile") ;
						}
				}
				else {
						if( $sulf eq '' ) {
								system2( "/home/aroop/simcode/mini/bin/antibody_mode.default.linuxgccrelease -database /home/aroop/simcode/minirosetta_database -out::level 550 -nstruct 1 -graft_h1 -graft_h2 -graft_h3 -camelid -out::prefix aa -ex1aro -ex1 -ex2 -in::file::fullatom -out::file::fullatom -mute core -unmute protocols.AntibodyModeler -s $which_framework.pdb -detect_disulf true -run::rebuild_disulf true -run::find_disulf true" );
						}
						else {
								system2( "/home/aroop/simcode/mini/bin/antibody_mode.default.linuxgccrelease -database /home/aroop/simcode/minirosetta_database -out::level 550 -nstruct 1 -graft_h1 -graft_h2 -graft_h3 -camelid -out::prefix aa -ex1aro -ex1 -ex2 -in::file::fullatom -out::file::fullatom -mute core -unmute protocols.AntibodyModeler -s $which_framework.pdb" );
						}

				}
				close( sulffile );
				system2( "rm disulftemp" );

		} else {
				if ( $camelid == 0 ) {
						$native_wo_h3 = "$pdbcode\_L_noh3.pdb"  ;
						system2("$scripts_alt/extractChains.pl L $pdbcode.pdb > $native_wo_h3" ) ;
						system2("$scripts_alt/extractres.pl H 4 94 $pdbcode.pdb >> $native_wo_h3" ) ;
						system2("$scripts_alt/extractres.pl H 103 110 $pdbcode.pdb >> $native_wo_h3" ) ;
						system2("$scripts/ram_blankcdrs_h3.pl $native_wo_h3 H $camelid > FR02.pdb" ) ;
						system2("$bin/rosetta.gcc aa $which_framework _ -antibody_modeler -nstruct $nstruct_grafting -quiet -use_pdb_numbering -s $which_framework -native $pdbcode -find_disulf -norepack_disulf|tee rosetta$which_framework\_grafting.logfile") ;
				}
				else {
						$native_wo_h3 = "$pdbcode\_L_noh3.pdb"  ;
						system2("$scripts_alt/extractres.pl H 4 94 $pdbcode.pdb > $native_wo_h3" ) ;
						system2("$scripts_alt/extractres.pl H 103 110 $pdbcode.pdb >> $native_wo_h3" ) ;
						system2("$scripts/ram_blankcdrs_h3.pl $native_wo_h3 H $camelid > FR02.pdb" ) ;
						system2("$bin/rosetta.gcc aa $which_framework _ -antibody_modeler -nstruct $nstruct_grafting -quiet -use_pdb_numbering -s $which_framework -native $pdbcode -find_disulf -norepack_disulf|tee rosetta$which_framework\_grafting.logfile") ;	
				}

		}
		printf STDERR "END LOOP GRAFTING: $pdb\n"  ;

		system2("python $docking_scripts/pdb_scripts/makefixdisulf.py aa$which_framework\_0001.pdb" ) ;
		if( -e "aa$which_framework\_0001.fixdisulf" )  {
				system2("mv aa$which_framework\_0001.fixdisulf $which_framework.fixdisulf" ) ;
		}

# Housekeeping
		system2( "cp $which_framework.pdb $which_framework.pdb.template" )  ;
		system2( "cp aa$which_framework\_0001.pdb $which_framework.pdb" )  ;
		system2( "cp aa$which_framework\_0001.pdb pdb$which_framework\_chothia.pdb" )  ;
# End Housekeeping

		# The following is commented out since in the new version, we do output
    # a structure with the CDR H3 grafted. Thus we want the CDR H3 to be there.
		##Outputing grafted PDB without CDR H3
		#system2( "$scripts/remove_h3.pl aa$which_framework\_0001.pdb > grafted_noH3.pdb" );
		system2( "cp aa$which_framework\_0001.pdb grafted_noH3.pdb" );

}

sub make_fragments {

		$fragment_file = "aa$which_framework\_03\_05.200\_v1\_3"  ;
		$fragment_file_9 = "aa$which_framework\_09\_05.200\_v1\_3"  ;

		if ( $h3_fragment_type == 1 )  {

				&make_rosetta_fragments ;
				system2( "cp $rosetta_3mer_fragments $fragment_file" )  ;

		} elsif ( $h3_fragment_type == 2 ) {

				&make_antibody_fragments  ;
				system2( "ln -s $ab_3mer_fragments $fragment_file" )  ;
				system2( "ln -s $rosettafrags/$pdbcode$fragment_file_9 $fragment_file_9" )  ;

		} elsif ( $h3_fragment_type == 3 ) {

				&make_rosetta_fragments ;
				&make_antibody_fragments ;
				system2("perl -P $scripts/ram_append_abfrags_to_rosettafrags2.pl $which_framework\_.fasta $rosetta_3mer_fragments $ab_3mer_fragments > $fragment_file") ;
		}
}

sub make_rosetta_fragments {

		chdir ( "$build_loop_dir" ) || die ( "Exiting. Unable to change to directory \'$build_loop_dir\'" )  ;

		$fragment_file = "aa$which_framework\_03\_05.200\_v1\_3" ;

		system2("cp $scripts/rampaths.txt .") unless -e "rampaths.txt" ;
		system2("cp ../$which_framework.pdb .") unless -e "$which_framework.pdb" ;
		system2("cp $scripts/paths.txt  paths.txt")  unless -e "paths.txt" ;
		system2("cp $scripts/utilities.txt .") ;

		system2("$scripts_alt/extractres.pl H 94 $h3_frag_end_res $which_framework.pdb > h3plus1.pdb" ) ;
		system2("$docking_scripts/pdb_scripts/pdb_fasta.pl h3plus1.pdb simple > $which_framework\_.fasta") ;

		unless ( -e $rosetta_3mer_fragments ) {
				print "Making fragments for heavy chain residues 94-$h3_frag_end_res...\n"  ;
				system2("perl -P $scripts/ram_make_rosetta_fragments.pl $which_framework $h3_frag_end_res |tee rosetta$which_framework\_frags.logfile") ;
				system2("mv $fragment_file $rosetta_3mer_fragments" ) ;
				print "Done\n" ;
		}
}


sub make_antibody_fragments {

		chdir ( "$build_loop_dir" ) || die ( "Exiting. Unable to change to directory \'$build_loop_dir\'" ) ;

		$fragment_file = "aa$which_framework\_03\_05.200\_v1\_3"  ;
		system2("ln -s $scripts/rampaths.txt .") unless -e "rampaths.txt"  ;
		system2("ln -s $pdbdir/$which_framework.pdb .") unless -e "$which_framework.pdb" ;
		system2("ln -s $scripts/paths.txt  paths.txt")  unless -e "paths.txt" ;
		system2("$scripts_alt/extractres.pl H 94 $h3_frag_end_res $which_framework.pdb > h3plus1.pdb" ) ;
		system2("$docking_scripts/pdb_scripts/pdb_fasta.pl h3plus1.pdb simple > $which_framework\_.fasta") ;
		system2("perl -P $scripts/ram_blastscript_h3frag.pl 3 0" ) ;
		system2("perl -P $scripts/ram_analyze_blast_h3frag.pl $pdb 3 0.2" ) ;
}

sub build_rosetta_loops {

		$mode = "build"  ;
		chdir ( "$build_loop_dir" )  ;

		system2( "cp $currentdir/hfr.pdb . " ) unless ( -e "hfr.pdb" )  ;
		if( $camelid == 0 ) {
				system2( "cp $currentdir/lfr.pdb . " ) unless ( -e "lfr.pdb" )  ;
				system2( "perl -P $scripts/ram_create_H3CterNter.pl $pdb" ) ;
		}
		else {
				system2( "cp $info/camelid_H3_CTERM ." );
				system2( "/home/aroop/simcode/mini/bin/antibody_mode.default.linuxgccrelease -database /home/aroop/simcode/minirosetta_database -out::level 550 -nstruct 1 -camelid -out::prefix aa -in::file::fullatom -out::file::fullatom -mute core -unmute protocols.AntibodyModeler -s $which_framework.pdb -camelid_constraints | tee constraints.out" );
				system2( "grep CONSTRAINTS constraints.out | cut -c41- > camelid.cst" );
				system2( "grep BOND camelid.cst | cut -c12-15,18-21 > $which_framework.disulf" );
				system2( "rm aa$which_framework\_0001.* *.fasc constraints.out" );
		}
		#randomizing CDR H3 loop to eliminate memory effects
		system2( "$scripts/randomize_cdrh3.pl FR02.pdb > temp.pdb" );
		system2( "mv temp.pdb FR02.pdb" );

		system2( "perl -P $scripts/ram_create_condor_script.pl $pdbcode $which_framework $mode $nstruct_build $additional_flags $camelid" ) ;
}





