#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

sub kink_query {


#Script to identify kinked/extended base from sequence alone
#Input : query.chothia file that contains chainID, residuenumber and residue information

#Not enough arguments for script $0. Exiting...\n Usage: $0: Script to identify kinked/extended CDR H3 base from sequence alone (Shirai 1999) \n Input: query.chothia file that contains chainID, residuenumber and residue information \n Usage: perl -P $0 <chainL> <chainH>\n"


$chainL = $_[0] ;
$chainH = $_[1] ;


if ( -e "query.h3" ) {

open ( queryh3 , "query.h3" ) ;

$lineskip = <queryh3> ;
$h3 = <queryh3> ;

chop ( $h3 ) ;
$lenh3 = length ( $h3 ) ;

if ( $lenh3 >= 5 ) {

$residue_n = substr ( $h3 , length ( $h3 ) - 1 , 1) ;
$residue_n_minus_1 = substr ( $h3 , length ( $h3 ) - 2 , 1) ;
$residue_n_minus_2 = substr ( $h3 , length ( $h3 ) - 3 , 1) ;
$residue_n_minus_3 = substr ( $h3 , length ( $h3 ) - 4 , 1) ;
}

}

if ( -e "query.h3nterm" ) {

open ( queryh3nterm , "query.h3nterm" ) ;

$lineskip = <queryh3nterm> ;
$h3nterm = <queryh3nterm> ;

chop ( $h3nterm ) ;

$residue_neg_1 = substr ( $h3nterm , 1 , 1 ) ;
$residue_0 = substr ( $h3nterm , 2 , 1 ) ;

} else {

print "query.h3nterm not found\n" ;
die () ;
}


if ( -e "query.l2nterm" ) {

open ( queryl2nterm , "query.l2nterm" ) ;

$lineskip = <queryl2nterm> ;
$l2nterm = <queryl2nterm> ;

chop ( $l2nterm ) ;

$residue_l_46 = substr ( $l2nterm , 0 , 1 ) ;
$residue_l_49 = substr ( $l2nterm , 3 , 1 ) ;

}

# (i) Base type identification

# i-a

$rule1a = $rule1b = $rule1c = $rule1d = $rule1b1 = $rule1c1 = $rule2 = $rule2a = $rule2b = $rule2c = 0 ;
$kinked = $extended = $extrabulge = 0 ;

$filter1 = $residue_n_minus_1 eq "D" ;
$filter2 = $residue_0 eq "K" || $residue_0 eq "R" ;
$filter3 = $residue_neg_1 eq "K" || $residue_neg_1 eq "R" ;
$filter4 = $residue_l_49 eq "K" || $residue_l_49 eq "R" ;
$filter5 = $residue_l_46 eq "K" || $residue_l_46 eq "R" ;
$filter6 = $residue_n_minus_3 eq "W" ;
$filter7 = $residue_n_minus_3 =~ /(F|I|L|M|Y)/ && $residue_n_minus_2 eq "G" ;

if ( $filter1 ) {

$rule1b = 1 if ( ! $filter2 ) ;
$rule1c = 1 if ( $filter2 && ! $filter3 ) ;
$rule1d = 1 if ( $filter2 && $filter3 ) ;

$rule1b1 = 1 if ( $rule1b && $filter4 ) ;
$rule1c1 = 1 if ( $rule1c && $filter5 ) ;

} else {

$rule1a = 1 ;

}

$rule2 = 1 if ( $filter6 || $filter7 ) ;

$kinked = 1 if ( $rule1a || $rule1c ) ;
$extended = 1 if ( $rule1b || $rule1d ) ;

if ( $rule1b1 ) {

$extended = 0 ;
$kinked = 1 ;

}

if ( $rule1c1 ) {

$kinked = 0 ;
$extended = 1 ;

}

$extrabulge = 1 if ( $rule2 ) ;

print "kinked=$kinked extended=$extended extrabulge=$extrabulge\n" ;

}
