#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

require "$scripts/ram_assignnumbering.pl" || die ( "File $scripts/ram_assignnumbering.pl not found\n" ) ;

%threetoone=("ALA",A,"CYS",C,"ASP",D,"GLU",E,"PHE",F,"GLY",G,"HIS",H,"ILE",I,"LYS",K,"LEU",L,"MET",M,"ASN",N,"PRO",P,"GLN",Q,"ARG",R,"SER",S,"THR",T,"VAL",V,"TRP",W,"TYR",Y);

&readfasta;
&findcdrs;
&assignnumbering ; # Subroutine in ram_assignnumbering.pl
&renumbercdrs;
&queryvlvhtype;


sub readfasta {

		open(lightfasta,"query_l.fasta") || die ( "File query_l.fasta not found" )  ;
		open(heavyfasta,"query_h.fasta") || die ( "FIle query_h.fasta not found" ) ;

		$lightseq = uc(<lightfasta>) ;
		$heavyseq = uc(<heavyfasta>) ;
		chop($lightseq) ;
		chop($heavyseq) ;
		open(chothia,">query.chothia") || die ( "Cannot open file query.chothia" )  ;
}

sub findcdrs{

		$l1found = $l3found = $h1found = $h3found = 0  ;
		$l1 = $l2 = $l3 = $h1 = $h2 = $h3 = ''  ;
		$lighterror = $heavyerror = 1  ;
		$frl1error = $frl4error = $frh1error = $frh4error = 1  ;

#*********L1***************************
		$var = $lightseq =~/C[A-Z]{1,17}(WYL|WLQ|WFQ|WYQ|WYH|WVQ|WVR|WWQ|WVK|WLL|WFL|WVF|WIQ|WYR|WNQ|WHL)/ ;
		if($var) {
				$temp=$& ;
				$lenl1=length ($temp)-4 ;
				$l1=substr($temp,1,$lenl1) ;
				$l1found = 1  ;
		}
#************************************

#***********L3********************
		$lightremaining = index( $lightseq, $l1 );
		$var = substr( $lightseq, $lightremaining, length($lightseq) ) =~/C[A-Z]{1,15}(F|V)G[A-Z]G/ ;
		if($var){
				$temp=$& ;
				$lenl3=length ($temp)-5 ;
				$l3=substr($temp,1,$lenl3) ;
				$l3found = 1  ;
		}
#****************************

#**************H1************

		$var = $heavyseq =~/C[A-Z]{1,16}(W)(I|V|F|Y|A|M|L|N)(R|K|Q|V|N|C)(Q|K|H|E|L|R)/ ;
		if($var) {
				$temp=$&if($var) ;
				$lenh1=length ($temp)-8 ;
				$h1=substr($temp,4,$lenh1) ;
				$h1found = 1  ;
		}

#******************************

#***********H3****************
		$heavyremaining = index( $heavyseq, $h1 );
		$var = substr( $heavyseq, $heavyremaining, length($heavyseq) ) =~/C[A-Z]{1,27}(W)G[A-Z](G|R|D|S)/ ;
		if($var){
				$temp=$& ;
				$lenh3=length ($temp)-7 ;
				$h3=substr($temp,3,$lenh3) ;
				$h3found = 1  ;
		}
#***************************


		$lighterror = 0 if ( $l1found && $l3found )  ;
		$heavyerror = 0 if ( $h1found && $h3found )  ;

		if ( $lighterror || $heavyerror ) {
				die ( "Error in light chain sequence\n" ) if ( $lighterror )  ;
				die ( "Error in heavy chain sequence\n" ) if ( $heavyerror ) ;
		}

		unless ( $lighterror )  {
				$l1start= index($lightseq,$l1) ;
				$l1end=$l1start+$lenl1-1 ;

				$l2start=$l1end+16 ;
				$l2end=$l2start+7-1 ;

				$l3start= index($lightseq,$l3) ;
				$l3end=$l3start+$lenl3-1 ;

				$l2=substr($lightseq,$l2start,7) ;
				$lenl2=7 ;
		}


		unless ( $heavyerror ) {
				$h1start = index($heavyseq,$h1) ;
				$h1end=$h1start+$lenh1-1 ;

				$h3start= index($heavyseq,$h3) ;
				$h3end=$h3start+$lenh3-1 ;

				$h2start=$h1end+15 ;
				$h2end=$h3start-33 ;

				$lenh2=$h2end-$h2start+1 ;
				$h2= substr($heavyseq,$h2start,$lenh2) ;
}


		$frl1=substr($lightseq,0,$l1start) ;
		$lenfrl1=length($frl1) ;
		$frl2=substr($lightseq,$l1end+1,15);
		$lenfrl2=length($frl2);
		$frl3=substr($lightseq,$l2end+1,$l3start-$l2end-1);
		$lenfrl3=length($frl3);
		$frl4=substr($lightseq,$l3end+1,12);
		$lenfrl4=length($frl4);
		$frh1=substr($heavyseq,0,$h1start);
		$lenfrh1=length($frh1);
		$frh2=substr($heavyseq,$h1end+1,$h2start-$h1end-1);
		$lenfrh2=length($frh2);
		$frh3=substr($heavyseq,$h2end+1,$h3start-$h2end-1);
		$lenfrh3=length($frh3);
		$frh4=substr($heavyseq,$h3end+1,12);
		$lenfrh4=length($frh4);
		$seq1=$frh1.$h1.$frh2.$h2.$frh3.$h3;


		$frl1error = 0 if ( $lenfrl1 >= 13 && $lenfrl1 <= 24 ) ;
		$frl4error = 0 if ( $lenfrl4 == 12 ) ;
		$frh1error = 0 if ( $lenfrh1 >= 21 && $lenfrh1 <= 26 ) ;
		$frh4error = 0 if ( $lenfrh4 == 10 ) ;

		die ( "Incorrect length of LIGHT chain framework region 1. This region should contain 13-24 residues\n " ) if ( $frl1error ) ;
		die ( "Incorrect length of LIGHT chain framework region 4. This region should contain 12 residues\n " ) if ( $frl1error ) ;
		die ( "Incorrect length of HEAVY chain framework region 1. This region should contain 21-26 residues\n " ) if ( $frl1error ) ;
		die ( "Incorrect length of HEAVY chain framework region 4. This region should contain 10 residues\n " ) if ( $frl1error ) ;

		$lightseqfv=$frl1.$l1.$frl2.$l2.$frl3.$l3.$frl4 ;
		$heavyseqfv=$frh1.$h1.$frh2.$h2.$frh3.$h3.$frh4 ;
}


sub renumbercdrs{


		$string[1]=$newnumberfrl1[$lenfrl1];
		$string[2]=$newnumberl1[$lenl1];
		$string[3]=$newnumberfrl2[$lenfrl2];
		$string[4]=$newnumberl2[$lenl2];
		$string[5]=$newnumberfrl3[$lenfrl3];
		$string[6]=$newnumberl3[$lenl3];
		$string[7]=$newnumberfrl4;

		$k=0;

		for($i=1;$i<=7;$i++) {
				@array=split(/,/,$string[$i]);
				$nelements=@array;
				for($j=0;$j <$nelements;$j++){
						$RESIDUE = substr($lightseqfv,$k,1);
						print chothia "L $RESIDUE $array[$j]\n" unless($RESIDUE eq '');
						$k++;
				}
		}

		$string[1]=$newnumberfrh1[$lenfrh1];
		$string[2]=$newnumberh1[$lenh1];
		$string[3]=$newnumberfrh2[$lenfrh2];
		$string[4]=$newnumberh2[$lenh2];
		$string[5]=$newnumberfrh3[$lenfrh3];
		$string[6]=$newnumberh3[$lenh3];
		$string[7]=$newnumberfrh4;

		$k=0;

		for($i=1;$i<=7;$i++){
				@array=split(/,/,$string[$i]);
				$nelements=@array;
				for($j=0;$j <$nelements;$j++){
						$RESIDUE = substr($heavyseqfv,$k,1);
						print chothia "H $RESIDUE $array[$j]\n" unless($RESIDUE eq '');
						$k++;
				}
		}
		close(chothia);
}

sub queryvlvhtype {

		open(chothia,"query.chothia");

		$line=<chothia>;
		chop($line);

		while($line ne ''){
				($chain,$residue,$residueno)=split(/ +/,$line);
				$argument=$chain.$residueno;
				$aa{$argument}=$residue;
				$line=<chothia>;
				chop($line);
		}
		@residuenos=(6,7,8,9,18,82,67,63);
		foreach $residueno(@residuenos) {

				$argument = "H"."$residueno";
				$motif=$motif.$aa{$argument};
		}
# Subtype definitions are from Andreas Pluckthun's article in JMB.

		$subtype = 1 if ($motif =~ /E[A-O,Q-Z]GPL[L|M|I][A|V|I|L]L/);
		$subtype = 2 if ($motif =~ /E[A-O,Q-Z]GG[L|M][M|L|I]F[V|L]/);
		$subtype = 3 if ($motif =~ /Q[A-O,Q-Z]G[A-Z][L|V]L[A|V]F/);
		$subtype = 4 if ($motif =~ /QPG[A-Z]VLAF/);

		open(vhtype,">query.vhtype") ;

		if ($subtype eq '' ) {
				print STDERR "Warning: No VH subtype found for motif $motif. Variable filter_vhtype will be set to 1\n" ;
				$subtype = 0 ;
		}

		printf vhtype "query.pdb   $subtype\n";
		$subtype="kappa";
		$l9=$aa{"L9"};
		if ($l9 eq ''){
				$l9="absent";
				$subtype="lambda";
		}
		open(vltype,">query.vltype") ;
		printf vltype "query.pdb   $subtype\n" ;
}
