#!/usr/bin/perl

if ( @ARGV < 3 ) {
		die ( "Exiting. Not enough arguments.
Usage: $0 <pdb filename to append to database> <species:Murine|Camel|Human|Humanized|So-Other|Fluvirus|Llama> <fragment type:Fr-Other|Fab|Fv|Hc-Dimer|Lc-Dimer>\n ") ;
}

$pdb = shift @ARGV;
$new_species = shift @ARGV;
$new_frag = shift @ARGV;

unless ( -e "./rampaths.txt" ) {
		die ( "File rampaths.txt not found\n" ) ;
}

#include "rampaths.txt"

open( existing, "cdrdatabase_new1" );
open( final, ">cdr_database_final" );
$cdr_line = <existing>;
chomp( $cdr_line );
close( existing );

@fields = split( /\ +/, $cdr_line );

$filename = $fields[0];
$R = $fields[1];
$val1 = $fields[2];
$val2 = $fields[3];
$val3 = $fields[4];
$val4 = $fields[5];
$val5 = $fields[6];
$val6 = $fields[7];
$VAL1 = $fields[8];
$VAL2 = $fields[9];
$VAL3 = $fields[10];
$VAL4 = $fields[11];
$VAL5 = $fields[12];
$VAL6 = $fields[13];
$species = $fields[14];
$date = $fields[15];
$vltype = $fields[16];
$frag = $fields[17];

open( pdbfile, $pdb );
$pdbfirst_line = <pdbfile>;
chomp( $pdbfirst_line );
@fields = split( /\ +/, $pdbfirst_line );
$unformat_date = $fields[-2];
$date1 = substr( $unformat_date, 0, 4);
$date2 = lc( substr( $unformat_date, 4, 5) ); 
$date = $date1.$date2;

system( "grep \"RESOLUTION\\.\" $pdb > resolution" );
open( resolution, "resolution" );
$resl_line = <resolution>;
chomp( $resl_line );
close( resolution );
system( "rm resolution" );
@resl_fields = split( /\ +/, $resl_line );
$R = $resl_fields[3];
$species = $new_species;
$frag = $new_frag;



printf final ( "%11s %3.1f %3d %3d %3d %3d %3d %3d %17s  %11s  %13s %13s  %22s  %24s %10s %9s  %6s %8s\n",$filename,$R,$val1,$val2,$val3,$val4,$val5,$val6,$VAL1,$VAL2,$VAL3,$VAL4,$VAL5,$VAL6,$species,$date,$vltype,$frag) ;

close( final );

system( "mv cdr_database_final cdrdatabase_new1" );
