#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

if ( @ARGV < 3 ) {
		die ( "Not enough arguments. Exiting..Usage: perl -P $0 <list_of_pdb_files> <run_profit: 0:1 = no:yes> <n_ca_c or n_ca_c_o\n" ) ;
}

require "$scripts/readinfo.pl";
require "$scripts/get_cterm_residues.pl" ;
&readinfo ;

@types = ( "h3frags" ) ;
$list = shift @ARGV ;
$run_profit = shift @ARGV ;
$which_atoms = shift @ARGV ;

open ( list , $list ) || die ( " File $list not found \n " ) ;
$line = <list> ;
chop ( $line ) ;
$pdbs = 0 ;

while ( $line ne '' ) {

		die ( "$line not found\n" ) unless ( -e $line ) ;
		$pdb [ $pdbs ] = $line ;
		$line = <list> ;
		chop ( $line ) ;
		$pdbs++ ;
}


$pdbs = $pdbs - 1 ;

for $type ( @types ) {
		$output = "profit\_$type.in" ;
		open (output , ">$output" ) ;
		print output "QUIET\n";
		for ($index1=0;$index1 < $pdbs;$index1++) {
				$reference = $pdb [ $index1 ] ;
				$pdbcode1 = substr ( $reference , 0 , 4 ) ;
				for ($index2=$index1+1;$index2 <= $pdbs;$index2++) {
						$mobile =$pdb[$index2] ;
						$pdbcode2 = substr ( $mobile , 0 , 4 ) ;
						print output  "ZONE CLEAR\n" ;
						print output  "ATOMS N,CA,C\n" if ( $which_atoms == 1 ) ;
						print output  "ATOMS N,CA,C,O\n" if ( $which_atoms == 2 ) ;
						print output  "$reference $mobile\n" ;
						print output  "reference $reference\n" ;
						print output  "mobile $mobile\n" ;
						print output "ZONE H1-H1\n" ;
						print output "ZONE H2-H2\n" ;
						print output "ZONE H3-H3\n" ;
						print output  "fit\n" ;
				}
		}
		system2(" profit < $output > profit\_$type.out ") if ( $run_profit ) ;
}



