#!/usr/local/bin/perl
use Cwd ;
die ( " Exiting...File rampaths.txt not found \n" )
		unless -e ( "rampaths.txt" ) ;
#include "rampaths.txt"

$pdb = "pdb1xyz_chothia.pdb";
$which_framework = "FR02" ;
$currentdir = getcwd ( ) ;
$build_loop_dir = "$currentdir/build" ;
$gap_broken_threshold = 1.9 ;

chdir ( "$build_loop_dir" ) ;

$scorefile = "aa$which_framework\_unique.fasc" ;
$scorefile_unbroken = "aa$which_framework\_unbroken.fasc" ;

system( "perl -P /home/aroop/simcode/antibody/scripts/ram_rm_scorefile_repeat_decoys.pl $pdb $which_framework" ) ;
system( "awk '{if(\$8 <= $gap_broken_threshold ) print \$0}' $scorefile > $scorefile_unbroken" ) ;
system( "grep aaFR $scorefile_unbroken | sort -k2 -n | cut -c-15 > temp.fasc" );

open( top10, "temp.fasc" );
$decoy = <top10>;
chomp( $decoy );
$count = 0;
$broken_pdbs = 0;

while( $count < 10 ) {
		
		$count++;
		$outfilename = "model".$count.".pdb";
		system( "grep ATOM $decoy > temp_only_atom.pdb" );
		system( "/home/aroop/simcode/rosetta_scripts/docking/pdb_scripts/extractres.pl H 94 103 temp_only_atom.pdb | grep ATOM > cdrh3.pdb" );
		$pdbfile = "cdrh3.pdb";
		open(pdbfile,$pdbfile);
		$line=<pdbfile>;
		chop($line);
		$n_x = $n_y = $n_z = $c_x = $c_y = $c_z = 0;
		$bond_flag = 1;
		while($line ne ''){
				$identifier = substr($line,0,6);
				$atomno = substr($line,6,5);
				$atom = substr($line,12,4);
				if( $atom eq " N  " || $atom eq " C  " ) {
						$alt_loc = substr($line,16,1);
						$residue = substr($line,17,3);
						$chain = substr($line,21,1);
						$residueno = substr($line,22,4);
						$insert_code=substr($line,26,1);
						$x = substr($line,30,8);
						$y = substr($line,38,8);
						$z =  substr($line,46,8);
						if( $atom eq " N  ") {
								$n_x = $x;
								$n_y = $y;
								$n_z = $z;
								if( !($c_x == 0 && $c_y == 0 && $c_z == 0 ) ) {
										$bond_length = sqrt( ($c_x - $n_x)**2 + 
																				 ($c_y - $n_y)**2 + 
																				 ($c_z - $n_z)**2 );
										if( $bond_length > $gap_broken_threshold ) {
												$bond_flag = 0;
												$broken_pdbs++;
												break;
										}
								}
						}
						if( $atom eq " C  " ) {
								$c_x = $x;
								$c_y = $y;
								$c_z = $z;
						}
				}
				
				$line = <pdbfile>;
				chop($line);
		}
		close( pdbfile );
		system( "rm $pdbfile temp_only_atom.pdb" );
		if( $bond_flag ) {
				system( "cp $decoy $outfilename" );
		}
		else {
				$count--;
		}
		$decoy = <top10>;
		chomp( $decoy );
}

close(top10);

if( $broken_pdbs > 0 ) {
		print( "\n\nSERVER WARNING: Skipped $broken_pdbs low-scoring Fv models because of broken CDR-H3 loop predictions\n" );
}

if( $count < 10 ) {
		open( top10, "temp.fasc" );
		$decoy = <top10>;
		chomp( $decoy );
		for( $i = $count + 1; $i <= 10; $i++ ) {
				$outfilename = "model".$count.".pdb";
				system( "cp $decoy $outfilename" );
				print( "\n\nSERVER WARNING: Low confidence prediction for CDR H3 loop conformation for rank $i Fv model (possibly broken CDR H3 loop)\n" );
				$decoy = <top10>;
				chomp( $decoy );
		}
		close( top10 );
}

system( "rm temp.fasc" );

for( $k = 1; $k <= 10; $k++ ) {
		$ref = "/home/aroop/simcode/antibody/info/orient.pdb" ;
		$mob = "model".$k.".pdb";
		chomp( $mob );
		@mobname = split( ".pdb", $mob );
		
		open( profit_hfr, "> profit_hfr.in" );
		
		print profit_hfr ("QUIET\n");
		print profit_hfr ("ZONE CLEAR\n");
		print profit_hfr ("ATOMS N,C,CA,O\n");
		print profit_hfr ("reference $ref\n");
		print profit_hfr ("mobile $mob\n");
		@starts = ( 5, 10, 36, 46, 66, 103 );
		@ends = ( 6, 25, 39, 49, 94, 110 );
		for( $i = 0; $i < 6; $i++ ) {
				for( $j = $starts[$i]; $j <= $ends[$i]; $j++ ) {
						$residue = `/home/aroop/simcode/rosetta_scripts/docking/pdb_scripts/extractres.pl H $j $j $mobname[0].pdb`;
						if( $residue ne '' ) {
								print profit_hfr ( "ZONE H$j-H$j\n" );
						}
				}
		}
		print profit_hfr ("fit\n");
		print profit_hfr ("WRITE $mobname[0]\_fitted.pdb\n" );
		
		close( profit_hfr );
		system( "profit < profit_hfr.in" );
		system( "rm profit_hfr.in" );
		system( "mv $mobname[0]\_fitted.pdb $mob" );
}


chdir( $currentdir );
