#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

if ( @ARGV < 6 ) {

print "Exiting...Not enough arguments\n Usage: perl -P $0 <pdb_input:1|0 = pdb|fasta> <pid/bit> <frameworktemplate:xtal|ram> <cdrtemplate:xtal|ram> <filename> <camelid:0|1>\n " ;

die ( ) ;

}

require "$scripts/ram_read_matches.pl" || die ( "File $scripts/ram_read_matches.pl not found\n" ) ;

$pdb_input = shift @ARGV ;
$criterion = shift @ARGV ; # PID, Bit score, Consensus etc.
$frameworktemplate = shift @ARGV ;
$cdrtemplate = shift @ARGV ;
$pdb = shift @ARGV ;
$camelid = shift @ARGV;
my @types;
if( $camelid == 1 ) {
		@types = ( "hfr" , "h1" , "h2" , "h3" ) ;
}
else {
		@types = ( "lfr" , "hfr" , "l1" , "l2" , "l3" , "h1" , "h2" , "h3" , "lfrhfr" , "lightheavy" ) ;
}

&read_matches ; # Found in ram_read_matches.pl

foreach $type ( @types ) {

		$file = "templateL.pdb" if ( $type eq "lfr" ) ;
		$file = "templateH.pdb" if ( $type eq "hfr" ) ;
		$file = "templatel1.pdb" if ( $type eq "l1" ) ;
		$file = "templatel2.pdb" if ( $type eq "l2" ) ;
		$file = "templatel3.pdb" if ( $type eq "l3" ) ;
		$file = "templateh1.pdb" if ( $type eq "h1" ) ;
		$file = "templateh2.pdb" if ( $type eq "h2" ) ;
		$file = "templateh3.pdb" if ( $type eq "h3" ) ; # This is a hack to copy the native H3
		$file = "templatelfrhfr.pdb" if ( $type eq "lfrhfr" ) ;
		$file = "templatelightheavy.pdb" if ( $type eq "lightheavy" ) ;

		$filter_fr = ( $type eq "lfr" || $type eq "hfr" || $type eq "lfrhfr" || $type eq "lightheavy" ) && ( $frameworktemplate eq "ram" ) ;
		$filter_cdr = ( $type ne "lfr" && $type ne "hfr" && $type ne "lfrhfr" &&
										$type ne "lightheavy" ) && ( $cdrtemplate eq "ram" ) ;


		if ( $filter_fr || $filter_cdr ) {

				$templatefile = $match_pid { $type } if ( $criterion eq "pid" ) ;
				$templatefile = $match_bit { $type } if ( $criterion eq "bit" ) ;
				$templatepath = "$pdbfiles/$templatefile" ;
				#$templatepath = "$testset/$pdb"  if ( $type eq "h3" ) ; // aroop: removed for h3_graft

				if ( ! -e $templatepath && -e "$testset/$templatefile" ) {
						$templatepath = "$testset/$templatefile" ; #This is a hack for cheating with known loops for some pdbs
				}

		} else {
				$templatefile = $pdb ;
				$templatepath = "$testset/$pdb" ;
}

		printf STDERR "Copying $templatepath as $file\n" ;
		#system2("cp $templatepath $file" ) unless ( ! $pdb_input && $type eq "h3" ) ; // aroop: removed for h3_graft
		system2("cp $templatepath $file" ) if ( ! $pdb_input ) ; # aroop: added for h3_graft
}
