#!/usr/bin/perl

die ( "Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" );
#include "rampaths.txt"

if ( @ARGV < 3 ) {
		die ( "Not enough arguments for script $0. Exiting...  \nUsage: $0 <reference.pdb> <mobile.pdb> <alignment:light|heavy>\n ") ;
}

$reference = shift @ARGV;
$mobile = shift @ARGV;
$alignment = shift @ARGV;

print "QUIET\n";
print "ZONE CLEAR\n";
print "ATOMS CA\n";
print "$reference $mobile\n";
print "reference $reference\n";
print "mobile $mobile\n";


if( $alignment eq "light" ) {
		$light_frmk_segments = 7;
		@light_start = ( 4, 10, 35, 45, 57, 71, 98 );
		@light_end = ( 6, 23, 38, 49, 66, 88, 104 );
		
		for( $i = 0; $i < $light_frmk_segments; $i++ ) {
				for( $j = $light_start[$i]; $j <= $light_end[$i]; $j++ ) {
						$residue = `$scripts_alt/extractres.pl L $j $j $reference`;
						$alt_residue = `$scripts_alt/extractres.pl L $j $j $mobile`;
						if( ($residue ne '') && ($alt_residue ne '') ) {
								print "ZONE L$j-L$j\n";
						}
				}
		}
		
		print "fit\n";
		print "WRITE queryLfitted.pdb\n";
		print "quit\n";
}

if( $alignment eq "heavy" ) {
		$heavy_frmk_segments = 6;
		@heavy_start = ( 5, 10, 36, 46, 66, 103 );
		@heavy_end = ( 6, 25, 39, 49, 94, 110 );
		
		for( $i = 0; $i < $heavy_frmk_segments; $i++ ) {
				for( $j = $heavy_start[$i]; $j <= $heavy_end[$i]; $j++ ) {
						$residue = `$scripts_alt/extractres.pl H $j $j $reference`;
						$alt_residue = `$scripts_alt/extractres.pl H $j $j $mobile`;
						if( ($residue ne '') && ($alt_residue ne '') ) {
								print "ZONE H$j-H$j\n";
						}
				}
		}
		
		print "fit\n";
		print "WRITE queryHfitted.pdb\n";
		print "quit\n";
}
