#!/usr/local/bin/perl
use Cwd ;

die ( " Exiting...File rampaths.txt not found \n" )
		unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"


if ( @ARGV < 2 ) {
		print STDERR "Not enough arguments for script $0. Exiting...\n Usage: perl -P $0 <pdbxxxx\_chothia.pdb> <which_framework:FR01|FR02>\n " ;
		die () ;
}

require "$scripts/ram_members_of_list.pl" ;
require "$scripts/removespaces.pl" ;
$pdb = shift @ARGV;
$which_framework = shift @ARGV ;

$currentdir = getcwd () ;
$pdbcode = substr ( $pdb , 3 , 4 ) ;
$pdbdir = "$currentdir" ;
$build_loop_dir = "$pdbdir/build" ;
$refine_loop_dir = "$pdbdir/refine" ;


#chdir ( "$build_loop_dir" ) || die ( "Exiting. Unable to change to directory $build_loop_dir\n" ) ;
$scorefile = "aaFR02.fasc" ;
$scorefile_unique = "aaFR02_unique.fasc" ;
$scorefile_original = "aaFR02_original.fasc" ;

system2("cp $scorefile $scorefile_original" );

open ( scorefile , $scorefile ) || die ( "File $scorefile not found\n" ) ;
open (scorefile_unique , ">$scorefile_unique" ) || die ( "Unable to open $scorefile_unique\n" ) ;

$line = <scorefile> ;
chop ( $line ) ;

while ( $line ne '' ) {
		if ( $line =~ /output_decoy/ ) {
				@array = split ( / +/ , $line ) ;
				$decoy = $array[0] ;
				$score { "score" } = $array [1] ;
				$score { "hb_srbb" } = $array[20] ;
				$score { "hb_lrbb" } = $array[21] ;
				$score { "fa_atr" } =$array[27] ;
				$score { "fa_rep" } = $array[28] ;
				$score { "hb_sc" } = $array[31] ;
				
				$is_match = &determine_decoy_match ( $decoy ) ;

				printf scorefile_unique "$line\n" if ( $is_match ) ;

		} else {
				printf scorefile_unique "$line\n" ;
		}

		$line = <scorefile> ;
		chop ( $line ) ;
}

#system2("mv $scorefile_new $scorefile" );
sub determine_decoy_match {
		my $decoy = $_[0] ;
		my @tagarray = ( "score" , "hb_srbb" , "hb_lrbb" , "fa_atr" , "fa_rep" ,
										 "hb_sc" ) ;
		open (decoy , $decoy ) || die ( "File $decoy not found\n" ) ;
		
		my $line = <decoy> ;
		chop ( $line ) ;
		
		until ( $line =~ /sasapack/ ) {
				if ( $line !~ /ATOM/ ) {
						my $tagmatch = &members_of_list ( $line , @tagarray ) ;
						if ( $tagmatch ) {
								$tag = &removespaces ( substr ( $line , 7 , 7 ) ) ;
								$scoredecoy = &removespaces ( substr ( $line , 17 ,9 ) ) ;
								$scoredecoy { $tag } = $scoredecoy ;
						}
				}

				$line = <decoy> ;
				chop ( $line )
				}

		$is_match = 1 ;
		foreach $tag ( @tagarray ) {
				$is_match = $is_match * ( $score { $tag } == $scoredecoy { $tag } ) ;
		}

		return $is_match ;
}


