#!/usr/bin/perl

$pdbfile = shift @ARGV;
open(pdbfile,$pdbfile)||die("PDB file $pdbfile not found\n");

$line=<pdbfile>;
chop($line);
$counter = 0;
while($line ne ''){
		
		$identifier = substr($line,0,6);
		$atomno = substr($line,6,5);
		$atom = substr($line,12,4);
		$alt_loc = substr($line,16,1);
		$residue = substr($line,17,3);
		$chain = substr($line,21,1);
		$residueno = substr($line,22,4);
		$insert_code=substr($line,26,1);
		$x = substr($line,30,8);
		$y = substr($line,38,8);
		$z =  substr($line,46,8);
		$occupancy = substr($line,54,6);
		$bfactor = substr($line,60,6);
		if( $bfactor eq "  0.00" || $bfactor eq "  1.00" ) {
				$bfactor = " 25.00";
		}

		
		$int_res = 0 + $residueno;
		
		if( ($chain =~ /H/) && ($int_res >= 95) && ($int_res <= 102) ) {
				$counter++;
				$x = rand( $counter );
				$y = rand( $counter );
				$z = rand( $counter );
		}
		if ($identifier =~ /TER/){
				printf "%-6s\n", $identifier;
		}
		else{
				printf "%-6s%5s %-4s%1s%3s %1s%4s%1s   %8.3f%8.3f%8.3f%6.2f%6.2f              \n",$identifier,$atomno,$atom,$alt_loc,$residue,$chain,$residueno,$insert_code,$x,$y,$z,$occupancy,$bfactor;
		}
		
		$line = <pdbfile>;
		chop($line);
}

