#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

require "$scripts/ram_assignnumbering.pl" || die ( "File $scripts/ram_assignnumbering.pl not found\n" ) ;

%threetoone=("ALA",A,"CYS",C,"ASP",D,"GLU",E,"PHE",F,"GLY",G,"HIS",H,"ILE",I,"LYS",K,"LEU",L,"MET",M,"ASN",N,"PRO",P,"GLN",Q,"ARG",R,"SER",S,"THR",T,"VAL",V,"TRP",W,"TYR",Y);

&readfasta;
&findcdrs;
&assign_camelid_numbering ; # Subroutine in ram_assignnumbering.pl
&renumbercdrs;

sub readfasta {

		open(heavyfasta,"query_h.fasta") || die ( "FIle query_h.fasta not found" );

		$heavyseq = uc(<heavyfasta>) ;
		chop($heavyseq) ;
		open(chothia,">query.chothia") || die ( "Cannot open file query.chothia" );
}

sub findcdrs{

		$h1found = $h3found = 0  ;
		$h1 = $h2 = $h3 = ''  ;
		$heavyerror = 1  ;
		$frh1error = $frh4error = 1  ;

#**************H1************

		$var = $heavyseq =~/C[A-Z]{1,16}(W)(I|V|F|Y|A|M|L|N|D)(R|K|Q|V|N)(Q|K|H|E|L|R)/;
		if($var) {
				$temp=$&if($var) ;
				$lenh1=length ($temp)-8 ;
				$h1=substr($temp,4,$lenh1) ;
				$h1found = 1  ;
		}

#******************************

#***********H3****************
		$heavyremaining = index( $heavyseq, $h1 );
		$var = substr( $heavyseq, $heavyremaining, length($heavyseq) ) =~/C[A-Z]{1,27}(W|R)G[A-Z](G|R|D|S)/ ;
		if($var){
				$temp=$& ;
				$lenh3=length ($temp)-7 ;
				$h3=substr($temp,3,$lenh3) ;
				$h3found = 1  ;
		}
#***************************


		$heavyerror = 0 if ( $h1found && $h3found )  ;

		if ( $heavyerror ) {
				die ( "Error in heavy chain sequence\n" ) if ( $heavyerror ) ;
		}

		unless ( $heavyerror ) {
				$h1start = index($heavyseq,$h1) ;
				$h1end=$h1start+$lenh1-1 ;

				$h3start= index($heavyseq,$h3) ;
				$h3end=$h3start+$lenh3-1 ;

				$h2start=$h1end+15 ;
				$h2end=$h3start-33 ;

				$lenh2=$h2end-$h2start+1 ;
				$h2= substr($heavyseq,$h2start,$lenh2) ;
		}


		$frh1=substr($heavyseq,0,$h1start);
		$lenfrh1=length($frh1);
		$frh2=substr($heavyseq,$h1end+1,$h2start-$h1end-1);
		$lenfrh2=length($frh2);
		$frh3=substr($heavyseq,$h2end+1,$h3start-$h2end-1);
		$lenfrh3=length($frh3);
		$frh4=substr($heavyseq,$h3end+1,12);
		$lenfrh4=length($frh4);
		$seq1=$frh1.$h1.$frh2.$h2.$frh3.$h3;


		$frh1error = 0 if ( $lenfrh1 >= 21 && $lenfrh1 <= 26 ) ;
		$frh4error = 0 if ( $lenfrh4 == 10 ) ;

		$heavyseqfv=$frh1.$h1.$frh2.$h2.$frh3.$h3.$frh4 ;
}


sub renumbercdrs{

		$string[1]=$newnumberfrh1[$lenfrh1];
		$string[2]=$newnumberh1[$lenh1];
		$string[3]=$newnumberfrh2[$lenfrh2];
		$string[4]=$newnumberh2[$lenh2];
		$string[5]=$newnumberfrh3[$lenfrh3];
		$string[6]=$newnumberh3[$lenh3];
		$string[7]=$newnumberfrh4;

		$k=0;

		for($i=1;$i<=7;$i++){
				@array=split(/,/,$string[$i]);
				$nelements=@array;
				for($j=0;$j <$nelements;$j++){
						$RESIDUE = substr($heavyseqfv,$k,1);
						print chothia "H $RESIDUE $array[$j]\n" unless($RESIDUE eq '');
						$k++;
				}
		}
		close(chothia);
}
