#ifndef OPTION_CC_GEN_HH
#define OPTION_CC_GEN_HH
#include <basic/options/option.hh>
#include <basic/options/option.cc.include.gen.hh>
#include <utility/options/OptionCollection.hh>
inline void add_rosetta_options_0( utility::options::OptionCollection &option ) {option.add( basic::options::OptionKeys::rigid::rigid, "rigid option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::rigid::chainbreak_bias, "Strength of bias applied to the translation component of rigid body moves to close chainbreak" ).def(0.00);
option.add( basic::options::OptionKeys::rigid::close_loops, "Perform loop closure at the end of medal" ).def(true);
option.add( basic::options::OptionKeys::rigid::fragment_cycles, "Number of fragment insertion/rigid body cycles" ).def(10000);
option.add( basic::options::OptionKeys::rigid::log_accepted_moves, "Write accepted moves to silent file output" ).def(false);
option.add( basic::options::OptionKeys::rigid::max_ca_ca_dist, "Maximum distance between consecutive CA atoms before chunk partitioning occurs" ).def(5.0);
option.add( basic::options::OptionKeys::rigid::medium_range_seqsep, "Constraints with sequence separation less than x are scored" ).def(30);
option.add( basic::options::OptionKeys::rigid::patch, "Patch file containing energy terms and their respective weights" );
option.add( basic::options::OptionKeys::rigid::residues_backbone_move, "Number of residues perturbed by a backbone move" ).def(5);
option.add( basic::options::OptionKeys::rigid::rotation, "Rotation magnitude" ).def(2.5);
option.add( basic::options::OptionKeys::rigid::sampling_prob, "Normalized, per-residue sampling probabilities" );
option.add( basic::options::OptionKeys::rigid::score, "Centroid-level score function" ).def("score3");
option.add( basic::options::OptionKeys::rigid::sequence_separation, "Maximum sequence separation for scoring chainbreaks" ).def(20);
option.add( basic::options::OptionKeys::rigid::short_range_seqsep, "Constraints with sequence separation less than x are scored" ).def(15);
option.add( basic::options::OptionKeys::rigid::small_cycles, "Number of small/shear cycles" ).def(8000);
option.add( basic::options::OptionKeys::rigid::stages, "Number of stages over which to interpolate ramped values" ).def(4);
option.add( basic::options::OptionKeys::rigid::temperature, "Monte Carlo temperature" ).def(2.0);
option.add( basic::options::OptionKeys::rigid::translation, "Translation magnitude" ).def(0.5);
option.add( basic::options::OptionKeys::in::in, "Input option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::in::termini, "Put full N and C termini on input structures" ).def(true);
option.add( basic::options::OptionKeys::in::ignore_unrecognized_res, "Do not abort if unknown residues are found in PDB file;  instead, ignore them. Note this implies -in:ignore_waters" ).def(false);
option.add( basic::options::OptionKeys::in::ignore_waters, "Do not abort if HOH water residues are found in PDB file;  instead, ignore them." ).def(false);
option.add( basic::options::OptionKeys::in::add_orbitals, "Will add orbitals to residues only. Does not include orbitals to ligands. Done through params file reading." ).def(false);
option.add( basic::options::OptionKeys::in::remember_unrecognized_res, "Ignore unrecognized residues, but remember them in PDBInfo." ).def(false);
option.add( basic::options::OptionKeys::in::remember_unrecognized_water, "Remember waters along with other unrecognized residues." ).def(false);
option.add( basic::options::OptionKeys::in::detect_disulf, "Forcably enable or disable disulfide detection. When unspecified, rosetta conservatively detects disulfides in full atom input based on SG distance, but will not form centroid disulfides. Setting `-detect_disulf true` will force  aggressive disulfide detection in centroid poses based on CB distance. Setting `-detect_disulf false` disables all detection, even in full atom poses. Note that disabling disulfides causes severe clashes for native disulfides." ).legal(true).legal(false);
option.add( basic::options::OptionKeys::in::fix_disulf, "Specify disulfide connectivity via a file. Disulfides are specified as two whitespace-seperated residue indicies per line. This option replaces the old '-run:fix_disulf' option." );
option.add( basic::options::OptionKeys::in::use_stupid_foldtree_format, "use the fold-tree format that existed for one week after revision 21447" ).def(false);
option.add( basic::options::OptionKeys::in::target_residues, "which residue numbers to pass for getDistConstraints" );
option.add( basic::options::OptionKeys::in::replonly_residues, "residue numbers regarded as repulsive-only residues" );
option.add( basic::options::OptionKeys::in::replonly_loops, "all loops will be regarded as repulsive-only" ).def(false);
option.add( basic::options::OptionKeys::in::use_database, "Read in structures from database.  Specify database via -inout:database_filename and wanted structures with -in:file:tags or select_structures_from_database" );
option.add( basic::options::OptionKeys::in::database_protocol, "Database to use when reading in structures" ).def(1);
option.add( basic::options::OptionKeys::in::select_structures_from_database, "specify an SQL query to determine which structures get read in from a database specified with -inout:database_filename.  SELECT query must return structures.tag" );
option.add( basic::options::OptionKeys::in::path::path, "Paths to search for input files (checked after type-specific paths)" ).def(".");
option.add( basic::options::OptionKeys::in::path::fragments, "Fragment file input search paths" );
option.add( basic::options::OptionKeys::in::path::pdb, "PDB file input search paths" );
option.add( basic::options::OptionKeys::in::path::database, "Database file input search paths.  If the database is not found the ROSETTA3_DB environment variable is tried." );
option.add( basic::options::OptionKeys::in::file::file, "Input file option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::in::file::s, "Name(s) of single PDB file(s) to process" );
option.add( basic::options::OptionKeys::in::file::l, "File(s) containing list(s) of PDB files to process" );
option.add( basic::options::OptionKeys::in::file::list, "File(s) containing list(s) of PDB files.  PDBs on the same line become one pose" );
option.add( basic::options::OptionKeys::in::file::native, "Native PDB filename" );
option.add( basic::options::OptionKeys::in::file::torsion_bin_probs, "File describing probabilities over torsion bins A,B,E,G,O" ).def("empty");
option.add( basic::options::OptionKeys::in::file::PCS_frag_cst, "File that containts PCS constraints for use in fragment picking" );
option.add( basic::options::OptionKeys::in::file::talos_phi_psi, "File that provides Phi-Psi angles in Talos+ format" );
option.add( basic::options::OptionKeys::in::file::talos_cs, "File that provides chemical shifts in Talos format" );
option.add( basic::options::OptionKeys::in::file::ambig_talos_cs_A, "File that provides 1st set of ambigious chemical shift options in Talos format" );
option.add( basic::options::OptionKeys::in::file::ambig_talos_cs_B, "File that provides 2nd set of ambigious chemical shift options in Talos format" );
option.add( basic::options::OptionKeys::in::file::native_exclude_res, "Residue numbers to be excluded from RMS calculation" );
option.add( basic::options::OptionKeys::in::file::tags, "Tag(s) of structures to be used from silent-file" );
option.add( basic::options::OptionKeys::in::file::user_tags, "user_tag(s) of structures to be used from silent-file" );
option.add( basic::options::OptionKeys::in::file::tagfile, "file with list of tags to be resampled from file given with in:resample:silent" ).def("TAGS");
option.add( basic::options::OptionKeys::in::file::frag_files, "Fragment input file names" );
option.add( basic::options::OptionKeys::in::file::frag_sizes, "Fragment file sizes" );
option.add( basic::options::OptionKeys::in::file::extra_res_fa, ".params file(s) for new fullatom residue types (e.g. ligands)" );
option.add( basic::options::OptionKeys::in::file::extra_res_mol, ".mol file(s) for new fullatom residue types (e.g. ligands)" );
option.add( basic::options::OptionKeys::in::file::extra_res_database, "the name of a database containing fullatom residue types (e.g. ligands)" );
option.add( basic::options::OptionKeys::in::file::extra_res_database_mode, "The type of database driver to use for -in:file:extra_res_database.  Acceptable values are 'mysql' or 'sqlite3'" ).def("sqlite3");
option.add( basic::options::OptionKeys::in::file::extra_res_database_resname_list, "Path to a list of residue names to be read in from the residue database.  The list should have one residue name per line" );
option.add( basic::options::OptionKeys::in::file::extra_res_cen, ".params file(s) for new centroid residue types (e.g. ligands)" );
option.add( basic::options::OptionKeys::in::file::extra_res_path, "directories with .params files.  Only files containing 'param' will be chosen" );
option.add( basic::options::OptionKeys::in::file::frag3, "No description" );
option.add( basic::options::OptionKeys::in::file::frag9, "No description" );
option.add( basic::options::OptionKeys::in::file::fragA, "No description" );
option.add( basic::options::OptionKeys::in::file::fragB, "No description" );
option.add( basic::options::OptionKeys::in::file::xyz, "Input coordinates in a raw XYZ format (three columns)" );
option.add( basic::options::OptionKeys::in::file::fragA_size, "No description" ).def(9);
option.add( basic::options::OptionKeys::in::file::keep_input_scores, "Keep/Don't keep scores from input file in Pose." ).def(true);
option.add( basic::options::OptionKeys::in::file::lazy_silent, "Activate LazySilentFileJobInputter" ).def(false);
option.add( basic::options::OptionKeys::in::file::silent, "silent input filename(s)" );
option.add( basic::options::OptionKeys::in::file::atom_tree_diff, "atom_tree_diff input filename(s)" );
option.add( basic::options::OptionKeys::in::file::zip, "zipped input file, used for BOINC database" );
option.add( basic::options::OptionKeys::in::file::boinc_wu_zip, "zipped input file with files for a specific BOINC workunit" );
option.add( basic::options::OptionKeys::in::file::fullatom, "Enable full-atom input of PDB or centroid structures" ).def(false);
option.add( basic::options::OptionKeys::in::file::centroid_input, "why input in the name twice ? in:file:centroid_input Enable centroid inputs of PDBs" ).def(false);
option.add( basic::options::OptionKeys::in::file::centroid, "Enable centroid inputs of PDBs" ).def(false);
option.add( basic::options::OptionKeys::in::file::treat_residues_in_these_chains_as_separate_chemical_entities, "Create a chemical jump for each residue in these chains (String of 1-letter chain IDs)" ).def(" ");
option.add( basic::options::OptionKeys::in::file::residue_type_set, "ResidueTypeSet for input files" ).def("fa_standard");
option.add( basic::options::OptionKeys::in::file::pca, "compute PCA projections" ).def("");
option.add( basic::options::OptionKeys::in::file::silent_energy_cut, "energy cut for silent-files" ).def(1.0);
option.add( basic::options::OptionKeys::in::file::silent_list, "Silent input filename list(s) - like -l is to -s " );
option.add( basic::options::OptionKeys::in::file::silent_renumber, "renumber decoys in not_universal_main or not" ).def(false);
option.add( basic::options::OptionKeys::in::file::silent_optH, "Call optH when reading a silent file" );
option.add( basic::options::OptionKeys::in::file::silent_struct_type, "Type of SilentStruct object to use in silent-file input" ).def("protein");
option.add( basic::options::OptionKeys::in::file::silent_read_through_errors, "will ignore decoys with errors and continue reading" ).def(false);
option.add( basic::options::OptionKeys::in::file::silent_score_prefix, "Prefix that is appended to all scores read in from a silent-file" ).def("");
option.add( basic::options::OptionKeys::in::file::silent_select_random, "Select a random subset of this number of decoys from every silent-file read" ).def(0);
option.add( basic::options::OptionKeys::in::file::silent_scores_wanted, "Only put these silent-scores into the Pose." );
option.add( basic::options::OptionKeys::in::file::fasta, "Fasta-formatted sequence file" );
option.add( basic::options::OptionKeys::in::file::pssm, "NCBI BLAST formatted position-specific scoring matrix" );
option.add( basic::options::OptionKeys::in::file::seq, "List of input files for constructing sequences" );
option.add( basic::options::OptionKeys::in::file::checkpoint, "Sequence profile (binary file format) prepared by NCBI BLAST" );
option.add( basic::options::OptionKeys::in::file::alignment, "Input file for sequence alignment" );
option.add( basic::options::OptionKeys::in::file::alignment2, "Input file for second sequence alignment " );
option.add( basic::options::OptionKeys::in::file::rama2b_map, "Ramachandran file used by rama2b" ).def("scoring/score_functions/rama/Rama08.dat");
option.add( basic::options::OptionKeys::in::file::psipred_ss2, "psipred_ss2 secondary structure definition file" ).def("tt");
option.add( basic::options::OptionKeys::in::file::dssp, "dssp secondary structure definition file" ).def("tt");
option.add( basic::options::OptionKeys::in::file::fail_on_bad_hbond, "exit if a hydrogen bonding error is detected" ).def(true);
option.add( basic::options::OptionKeys::in::file::movemap, "No description" ).def("default.movemap");
option.add( basic::options::OptionKeys::in::file::repair_sidechains, "attempt a repack/minmize to repair sidechain problems, such as proline geometry and his tautomerization" ).def(false);
option.add( basic::options::OptionKeys::in::file::no_binary_dunlib, "Do not attempt to read from or write to a binary file for the Dunbrack library" );
option.add( basic::options::OptionKeys::in::file::extended_pose, "number of extended poses to process in not_universal_main" ).def(1);
option.add( basic::options::OptionKeys::in::file::template_pdb, "Name of input template PDB files for comparative modeling" );
option.add( basic::options::OptionKeys::in::file::template_silent, "input templates for comparative modeling -- tag needs to fit alignment id" );
option.add( basic::options::OptionKeys::in::file::rdc, "Experimental NMR Residual Dipolar Coupling File --- one file per alignment medium" );
option.add( basic::options::OptionKeys::in::file::burial, "WESA-formatted burial prediction" );
option.add( basic::options::OptionKeys::in::file::vall, "Fragment database file, e.g vall.dat.2006-05-05" ).def("/sampling/filtered.vall.dat.2006-05-05");
option.add( basic::options::OptionKeys::in::file::rescore, "Governs whether input poses are rescored or not in not_universal_main, defaults to false." ).def(false);
option.add( basic::options::OptionKeys::in::file::spanfile, "Membrane spanning file" );
option.add( basic::options::OptionKeys::in::file::lipofile, "Membrane exposure file" );
option.add( basic::options::OptionKeys::in::file::sucker_params, "Parameter file containing SplineEnergy parameters" ).def("scoring/spline_energy_functions/sucker.params");
option.add( basic::options::OptionKeys::in::file::fold_tree, "User defined fold tree to be imposed on the pose after reading from disk" );
option.add( basic::options::OptionKeys::in::file::obey_ENDMDL, "Stop reading a PDB after ENDMDL card; effectively read only first model in multimodel NMR PDBs" ).def(false);
option.add( basic::options::OptionKeys::in::file::new_chain_order, "ensures chain from different MODEL records have differnet mini chains" ).def(false);
option.add( basic::options::OptionKeys::in::file::ddg_predictions_file, "File that contains mutational ddG information. Used by ddG task operation/filter." ).def("");
option.add( basic::options::OptionKeys::in::rdf::rdf, "rdf option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::in::rdf::sep_bb_ss, "separate RDFs by SS for backbone atypes " ).def(true);
option.add( basic::options::OptionKeys::MM::MM, "MM option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::MM::ignore_missing_bondangle_params, "ignore failed lookups for missing bond angle parameters" ).def(false);
option.add( basic::options::OptionKeys::mysql::mysql, "mysql option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::mysql::host, "mySQL database hostname" );
option.add( basic::options::OptionKeys::mysql::user, "mySQL database username" );
option.add( basic::options::OptionKeys::mysql::password, "mySQL database password" );
option.add( basic::options::OptionKeys::mysql::port, "mySQL database port" );
option.add( basic::options::OptionKeys::qsar::qsar, "qsar option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::qsar::weights, "select qsar weight set to use" ).def("standard");
option.add( basic::options::OptionKeys::residues::residues, "residues option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::residues::patch_selectors, "allow patch files that have CMDLINE_SELECTOR tags can be switched on with this option" );
option.add( basic::options::OptionKeys::PCS::PCS, "PCS option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::PCS::write_extra, "Write into the File PCS calc, PCS exp, PCS dev, tensor informations, AT EACH ENERGY EVALUATION. More suited for rescoring" );
option.add( basic::options::OptionKeys::PCS::normalization_id, "Normalize individual data set. The integer identify the normalization method to be used" );
option.add( basic::options::OptionKeys::inout::inout, "Ouput option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::inout::fold_tree_io, "Ignore 'CHECKPOINT' file and the overwrite the PDB file(s)" );
option.add( basic::options::OptionKeys::inout::dump_connect_info, "Output CONECT info between bonded atoms that are beyond 3.0 A apart; useful for coarse-grained representations." ).def(false);
option.add( basic::options::OptionKeys::inout::database_filename, "SQLite3 database filename (or mysql database name) to manage persistant data." );
option.add( basic::options::OptionKeys::inout::database_mode, "Database mode for pose IO" ).def("sqlite3");
option.add( basic::options::OptionKeys::out::out, "Ouput option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::out::overwrite, "Ignore 'CHECKPOINT' file and the overwrite the PDB file(s)" );
option.add( basic::options::OptionKeys::out::nstruct, "Number of times to process each input PDB" ).def(1);
option.add( basic::options::OptionKeys::out::shuffle_nstruct, "total number of decoys to produce" ).def(1);
option.add( basic::options::OptionKeys::out::prefix, "Prefix for output structure names, like old -series code" ).def("");
option.add( basic::options::OptionKeys::out::suffix, "Suffix for output structure names" ).def("");
option.add( basic::options::OptionKeys::out::no_nstruct_label, "Do not tag the first output structure with _0001" ).def(false);
option.add( basic::options::OptionKeys::out::pdb_gz, "Compress (gzip) output pdbs" ).def(false);
option.add( basic::options::OptionKeys::out::pdb, "Output PDBs" ).def(false);
option.add( basic::options::OptionKeys::out::silent_gz, "Use gzipped compressed output (silent run level)" ).def(false);
option.add( basic::options::OptionKeys::out::use_database, "Write out structures to database.  Specify database via -inout:database_filename and wanted structures with -in:file:tags" );
option.add( basic::options::OptionKeys::out::database_protocol_id, "Manually specify a protocol ID for database output. MPI distributed jobs are the only time when you will want to use this. It is a temporary workaround to a limitation of the MPI distributor" );
option.add( basic::options::OptionKeys::out::database_filter, "filter to use with database output. arguments for filter follow filter name" );
option.add( basic::options::OptionKeys::out::nooutput, "Surpress outputfiles" ).def(false);
option.add( basic::options::OptionKeys::out::output, "Force outputfiles" ).def(false);
option.add( basic::options::OptionKeys::out::scorecut, "Only output lowest energy fraction of structures - default 1.0, i.e. output all " ).def(1.0);
option.add( basic::options::OptionKeys::out::show_accessed_options, "In the end of the run show options that has been accessed." ).def(false);
option.add( basic::options::OptionKeys::out::sf, "filename for score output" ).def("score.fsc");
option.add( basic::options::OptionKeys::out::mute, "Mute specified Tracer chanels, specify 'all' to mute all chanels" );
option.add( basic::options::OptionKeys::out::unmute, "UnMute specified Tracer chanels, specify 'all' to mute all chanels" );
option.add( basic::options::OptionKeys::out::level, "Level of Tracer output, any level above will be muted. Availible levels: 0 - fatal, 100 - error, 200 - warning, 300 - info, 400 - debug, 500 - trace. For additional info please see: src/basic/Tracer.hh and doc page 'Tracer, tool for debug IO'. Default output level is 'info': 300" ).def(300);
option.add( basic::options::OptionKeys::out::std_IO_exit_error_code, "Specify error code that will be used to exit if std::IO error detected.This is useful if you want to detect situations like: Rosetta output wasredirected to a file but disk got full etc. Default value is 0 which mean that error detection code is turned off." ).def(0);
option.add( basic::options::OptionKeys::out::mute_warning, "Mute specified Tracer chanels for msgs with priority warning and less" );
option.add( basic::options::OptionKeys::out::mute_info, "Mute specified Tracer channels for msgs with priority info and less" );
option.add( basic::options::OptionKeys::out::mute_debug, "Mute specified Tracer channels for msgs with priority debug and less" );
option.add( basic::options::OptionKeys::out::unmute_error, "Unmute specified Tracer channels for msgs of priority ERROR and more" );
option.add( basic::options::OptionKeys::out::unmute_warning, "Unmute specified Tracer chanels for msgs with priority warning and more" );
option.add( basic::options::OptionKeys::out::unmute_info, "Unmute specified Tracer channels for msgs with priority info and more" );
option.add( basic::options::OptionKeys::out::unmute_debug, "Unmute specified Tracer channels for msgs with priority debug and more" );
option.add( basic::options::OptionKeys::out::chname, "Add Tracer chanel names to output" ).def(true);
option.add( basic::options::OptionKeys::out::dry_run, "If set ComparingTracer will not generate any asserts, and save all Tracer output to a file" ).def(false);
option.add( basic::options::OptionKeys::out::mpi_tracer_to_file, "MPI ONLY: Redirect all tracer output to this file with '_<mpi_rank>' appened as a suffix" ).def("tracer.out");
option.add( basic::options::OptionKeys::out::user_tag, "add this tag to structure tags: e.g., a process id" ).def("");
option.add( basic::options::OptionKeys::out::output_tag, "Prefix output files with this tag, if code checks for it" ).def("");
option.add( basic::options::OptionKeys::out::file::file, "Output file option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::out::file::o, "Name of output file" );
option.add( basic::options::OptionKeys::out::file::silent, "Use silent file output, use filename after this flag" ).def("default.out");
option.add( basic::options::OptionKeys::out::file::score_only, "Only output scores, no silent files or pdb files" ).def("default.sc");
option.add( basic::options::OptionKeys::out::file::atom_tree_diff, "Use atom_tree_diff file output, use filename after this flag" ).def("default.out");
option.add( basic::options::OptionKeys::out::file::atom_tree_diff_bb, "For atom_tree_diff output, how many digits of precision to use for backbone dihedrals" ).def(6);
option.add( basic::options::OptionKeys::out::file::atom_tree_diff_sc, "For atom_tree_diff output, how many digits of precision to use for sidechain dihedrals" ).def(4);
option.add( basic::options::OptionKeys::out::file::atom_tree_diff_bl, "For atom_tree_diff output, how many digits of precision to use for bond lengths" ).def(2);
option.add( basic::options::OptionKeys::out::file::alignment, "Output file for sequence alignment" ).def("out.align");
option.add( basic::options::OptionKeys::out::file::scorefile, "Write a scorefile to the provided filename" ).def("default.sc");
option.add( basic::options::OptionKeys::out::file::silent_struct_type, "Type of SilentStruct object to use in silent-file output" ).def("protein");
option.add( basic::options::OptionKeys::out::file::silent_preserve_H, "Preserve hydrogrens in PDB silent-file format." ).def(false);
option.add( basic::options::OptionKeys::out::file::silent_print_all_score_headers, "Print a SCORE header for every SilentStruct in a silent-file" ).def(false);
option.add( basic::options::OptionKeys::out::file::silent_decoytime, "Add time since last silent structure was written to score line" ).def(false);
option.add( basic::options::OptionKeys::out::file::silent_comment_bound, "String data longer than this ends up as remark rather than in score line" ).def(15);
option.add( basic::options::OptionKeys::out::file::raw, "Use silent-type file output" ).def(false);
option.add( basic::options::OptionKeys::out::file::fullatom, "Enable full-atom output of PDB or centroid structures" ).def(false);
option.add( basic::options::OptionKeys::out::file::suppress_zero_occ_pdb_output, "Suppress output of atoms with zero (or negative) occupancy" ).def(false);
option.add( basic::options::OptionKeys::out::file::output_virtual, "Output virtual atoms in output of PDB" ).def(false);
option.add( basic::options::OptionKeys::out::file::output_orbitals, "Output all orbitals into PDB" ).def(false);
option.add( basic::options::OptionKeys::out::file::weight_silent_scores, "weight scores in silent-file output." ).def(true);
option.add( basic::options::OptionKeys::out::file::design_contrast, "output list comparing design sequence to native sequence" ).def("redesign");
option.add( basic::options::OptionKeys::out::file::dont_rewrite_dunbrack_database, "disables the default behavior of rewriting the dunrack library in binary format if a binary version is not found" );
option.add( basic::options::OptionKeys::out::file::renumber_pdb, "use Rosetta residue numbering and arbitrary chain labels in pdb output" ).def(false);
option.add( basic::options::OptionKeys::out::file::pdb_parents, "If the pose contains a comment named template print this as a REMARK in the pdb file" ).def(false);
option.add( basic::options::OptionKeys::out::file::per_chain_renumbering, "when used in conjunction with renumber_pdb, restarts residue numbering at each chain" ).def(false);
option.add( basic::options::OptionKeys::out::file::residue_type_set, "ResidueTypeSet for output files" ).def("fa_standard");
option.add( basic::options::OptionKeys::out::file::frag_prefix, "Prefix for fragment output" ).def("default.frags");
option.add( basic::options::OptionKeys::out::file::output_torsions, "Output phi psi and omega torsions in the PDB output if the pose is ideal" ).def(false);
option.add( basic::options::OptionKeys::out::path::all, "Default file output path" ).def(".");
option.add( basic::options::OptionKeys::out::path::path, "Default file output path" ).def(".");
option.add( basic::options::OptionKeys::out::path::pdb, "PDB file output path" );
option.add( basic::options::OptionKeys::out::path::score, "Score file output path" );
option.add( basic::options::OptionKeys::out::path::movie, "Movie file output path" );
option.add( basic::options::OptionKeys::out::path::scratch, "use this path as scratch drive" ).def("/scratch/USERS/");
option.add( basic::options::OptionKeys::out::path::mpi_rank_dir, "put silent-output files in individual directory as determined by mpi-rank" ).def(false);
option.add( basic::options::OptionKeys::pocket_grid::pocket_grid, "pocket_grid option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::pocket_grid::pocket_grid_size, "grid spacing in Angstroms" ).def(0);
option.add( basic::options::OptionKeys::pocket_grid::pocket_grid_size_x, "grid spacing in Angstroms" ).def(10);
option.add( basic::options::OptionKeys::pocket_grid::pocket_grid_size_y, "grid spacing in Angstroms" ).def(10);
option.add( basic::options::OptionKeys::pocket_grid::pocket_grid_size_z, "grid spacing in Angstroms" ).def(10);
option.add( basic::options::OptionKeys::pocket_grid::pocket_grid_spacing, "grid spacing in Angstroms" ).def(0.5);
option.add( basic::options::OptionKeys::pocket_grid::pocket_max_spacing, "Maximum residue-residue distance to be considered a pocket" ).def(8);
option.add( basic::options::OptionKeys::pocket_grid::pocket_min_size, "Minimum pocket size to score, in cubic Angstroms" ).def(10);
option.add( basic::options::OptionKeys::pocket_grid::pocket_max_size, "Maximum pocket size to report, in cubic Angstroms, 0 for no limit" ).def(0);
option.add( basic::options::OptionKeys::pocket_grid::pocket_probe_radius, "radius of surface probe molecule" ).def(1.0);
option.add( basic::options::OptionKeys::pocket_grid::central_relax_pdb_num, "Residue number:(optional)Chain around which to do Pocket Constraint" ).def("-1");
option.add( basic::options::OptionKeys::pocket_grid::pocket_ntrials, "Number of trials to use for backrub" ).def(100000);
option.add( basic::options::OptionKeys::pocket_grid::pocket_num_angles, "Number of different pose angles to measure pocket score at" ).def(1);
option.add( basic::options::OptionKeys::pocket_grid::pocket_side, "Include only side chain residues for target surface" ).def(false);
option.add( basic::options::OptionKeys::pocket_grid::pocket_dump_pdbs, "Generate PDB files" ).def(false);
option.add( basic::options::OptionKeys::pocket_grid::pocket_dump_rama, "Generate Ramachandran maps for each pocket cluster" ).def(false);
option.add( basic::options::OptionKeys::pocket_grid::pocket_restrict_size, "Pockets that are too large return score of 0" ).def(false);
option.add( basic::options::OptionKeys::pocket_grid::pocket_psp, "Mark Pocket-Solvent-Pocket events as well" ).def(true);
option.add( basic::options::OptionKeys::pocket_grid::pocket_sps, "Unmark Solvent-Pocket-Solvent events" ).def(false);
option.add( basic::options::OptionKeys::pocket_grid::pocket_surface_score, "Score given to pocket surface" ).def(0);
option.add( basic::options::OptionKeys::pocket_grid::pocket_surface_dist, "Distance to consider pocket surface" ).def(2.5);
option.add( basic::options::OptionKeys::pocket_grid::pocket_buried_score, "Score given to deeply buried pocket points" ).def(5.0);
option.add( basic::options::OptionKeys::pocket_grid::pocket_buried_dist, "Distance to consider pocket buried" ).def(2.0);
option.add( basic::options::OptionKeys::pocket_grid::print_eggshell, "print the eggshell points into a PDB file" ).def(false);
option.add( basic::options::OptionKeys::fingerprint::fingerprint, "fingerprint option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::fingerprint::atom_radius_scale, "Scale to shrink the radius of atom" ).def(0.9);
option.add( basic::options::OptionKeys::fingerprint::atom_radius_buffer, "Value to subtract from all atomic radii, to match PocketGrid buffer thickness" ).def(1.0);
option.add( basic::options::OptionKeys::fingerprint::packing_weight, "Add weight to rho large deviation" ).def(1);
option.add( basic::options::OptionKeys::fingerprint::dist_cut_off, "set cut_off distance to add packing weight" ).def(5);
option.add( basic::options::OptionKeys::docking::kick_relax, "Add relax step at the end of symmetric docking" ).def(false);
option.add( basic::options::OptionKeys::docking::docking, "Docking option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::docking::view, "Decide whether to use the viewer (graphical) or not" ).def(false);
option.add( basic::options::OptionKeys::docking::no_filters, "Toggle the use of filters" ).def(false);
option.add( basic::options::OptionKeys::docking::design_chains, "Pass in the one-letter chain identifiers, separated by space, for each chain to design: -design_chains A B" ).shortd( "Which chains do we want to allow to design?" );
option.add( basic::options::OptionKeys::docking::recover_sidechains, "usually side-chains are taken from the input structure if it is fullatom - this overrides this behavior and takes sidechains from the pdb-file" ).shortd( "take sidechains from this pdb" );
option.add( basic::options::OptionKeys::docking::partners, "defines docking partners by ChainID, example: docking chains L+H with A is -partners LH_A" ).shortd( "defines docking partners by chainID for multichain docking partners" ).def("_");
option.add( basic::options::OptionKeys::docking::docking_local_refine, "Do a local refinement of the docking position (high resolution)" ).shortd( "Skip centroid mode" ).def(false);
option.add( basic::options::OptionKeys::docking::low_res_protocol_only, "Run only low resolution docking, skip high resolution docking" ).shortd( "Only low resolution" ).def(false);
option.add( basic::options::OptionKeys::docking::randomize1, "Randomize the first docking partner." ).shortd( "Randomize the first docking partner." ).def(false);
option.add( basic::options::OptionKeys::docking::randomize2, "Randomize the second docking partner." ).shortd( "Randomize the second docking partner." ).def(false);
option.add( basic::options::OptionKeys::docking::spin, "Spin a second docking partner around axes from center of mass of partner1 to partner2" ).shortd( "Spin a second docking partner." ).def(false);
option.add( basic::options::OptionKeys::docking::dock_pert, "Do a small perturbation with partner two: -dock_pert ANGSTROMS DEGREES.  Good values for protein docking are 3 A and 8 deg." ).shortd( "Do a small perturbation with partner two: -dock_pert ANGSTROMS DEGREES." ).n(2);
option.add( basic::options::OptionKeys::docking::uniform_trans, "No description" ).shortd( "Uniform random repositioning within a sphere of the given radius." );
option.add( basic::options::OptionKeys::docking::center_at_interface, "Perform all initial perturbations with the center of rotation at the interface between partners instead of at the center of mass of the oppposite partner." ).shortd( "Perform all initial perturbations with the center of rotation at the interface between partners" ).def(false);
option.add( basic::options::OptionKeys::docking::docking_centroid_outer_cycles, "Outer cycles during cking rigid body adaptive moves." ).shortd( "Outer cycles during docking rigid body adaptive moves." ).def(10);
option.add( basic::options::OptionKeys::docking::docking_centroid_inner_cycles, "Inner cycles during docking rigid body adaptive moves." ).shortd( "Inner cycles during docking rigid body adaptive moves." ).def(50);
option.add( basic::options::OptionKeys::docking::dock_min, "Minimize the final fullatom structure." ).shortd( "Minimize the final fullatom structure." ).def(false);
option.add( basic::options::OptionKeys::docking::flexible_bb_docking, "How to do flexible backbone docking, if at all. Choices include fixedbb, ccd, alc, and backrub." ).shortd( "How to do flexible backbone docking, if at all." ).def("fixedbb");
option.add( basic::options::OptionKeys::docking::flexible_bb_docking_interface_dist, "Distance between chains required to define a residue as having flexible backbone (ie. loop)." ).shortd( "Distance between chains required to define a residue as having flexible backbone (ie. loop)." ).def(10.0);
option.add( basic::options::OptionKeys::docking::ensemble1, "turns on ensemble mode for partner 1.  String is multi-model pdb file" ).shortd( "denotes partner1 as an ensemble" ).def("");
option.add( basic::options::OptionKeys::docking::ensemble2, "turns on ensemble mode for partner 2.  String is multi-model pdb file" ).shortd( "denotes partner2 as an ensemble" ).def("");
option.add( basic::options::OptionKeys::docking::dock_mcm_trans_magnitude, "The magnitude of the translational perturbation during mcm in docking." ).shortd( "The magnitude of the translational perturbation during mcm in docking." ).def(0.1);
option.add( basic::options::OptionKeys::docking::dock_mcm_rot_magnitude, "The magnitude of the rotational perturbation during mcm in docking." ).shortd( "The magnitude of the rotational perturbation during mcm in docking." ).def(5.0);
option.add( basic::options::OptionKeys::docking::dock_rtmin, "does rotamer trials with minimization, RTMIN" ).shortd( "does rotamer trials with minimization, RTMIN" ).def(false);
option.add( basic::options::OptionKeys::docking::sc_min, "does sidechain minimization of interface residues" ).shortd( "does sidechain minimization of interface residues" ).def(false);
option.add( basic::options::OptionKeys::docking::norepack1, "Do not repack the side-chains of partner 1." ).shortd( "Do not repack the side-chains of partner 1." ).def(false);
option.add( basic::options::OptionKeys::docking::norepack2, "Do not repack the side-chains of partner 2." ).shortd( "Do not repack the side-chains of partner 2." ).def(false);
option.add( basic::options::OptionKeys::docking::bb_min_res, "Minimize backbone at these positions." ).shortd( "Minimize backbone at these positions." );
option.add( basic::options::OptionKeys::docking::sc_min_res, "Minimize backbone at these positions." ).shortd( "Minimize backbone at these positions." );
option.add( basic::options::OptionKeys::docking::dock_ppk, "docking prepack mode" ).shortd( "docking prepack mode" ).def(false);
option.add( basic::options::OptionKeys::docking::max_repeats, "If a decoy does not pass the low- and high-resolution filters, how many attempts to make before failur" ).shortd( "how many repeats to use" ).def(1000);
option.add( basic::options::OptionKeys::docking::dock_lowres_filter, "manually sets the lowres docking filter: -dock_lowres_filter <INTERCHAIN_CONTACT CUTOFF> <INTERCHAIN_VDW CUTOFF> <RESTRAINT CUTOFF>. Default values for protein docking are 10.0 and 1.0" ).shortd( "manually sets the lowres docking filter: -dock_lowres_filter <INTERCHAIN_CONTACT CUTOFF> <INTERCHAIN_VDW CUTOFF> <RESTRAINT CUTOFF>" );
option.add( basic::options::OptionKeys::docking::multibody, "List of jumps allowed to move during docking" );
option.add( basic::options::OptionKeys::docking::ignore_default_docking_task, "Allows the user to define another task to give to Docking and will ignore the default DockingTask.  Task will default to designing everything if no other TaskFactory is given to docking." ).shortd( "Ignore the DockingTask" ).def(false);
option.add( basic::options::OptionKeys::docking::low_patch, "Name of weights patch file (without extension .wts) to use during rigid body " );
option.add( basic::options::OptionKeys::docking::high_patch, "Name of weights patch file (without extension .wts) to use during docking" );
option.add( basic::options::OptionKeys::docking::high_min_patch, "Name of weights patch file (without extension .wts) to use during " );
option.add( basic::options::OptionKeys::docking::pack_patch, "Name of weights patch file (without extension .wts) to use during packing" );
option.add( basic::options::OptionKeys::docking::use_legacy_protocol, "Use the legacy high resolution docking algorithm for output compatibility." ).shortd( "Use the legacy high resolution docking algorithm." ).def(false);
option.add( basic::options::OptionKeys::docking::ligand::ligand, "docking:ligand option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::docking::ligand::protocol, "Which protocol to run?" ).def("abbreviated");
option.add( basic::options::OptionKeys::docking::ligand::soft_rep, "Use soft repulsive potential?" ).def(false);
option.add( basic::options::OptionKeys::docking::ligand::tweak_sxfn, "Apply default modifications to the score function?" ).def(true);
option.add( basic::options::OptionKeys::docking::ligand::old_estat, "Emulate Rosetta++ electrostatics? (higher weight, ignore protein-protein)" ).def(false);
option.add( basic::options::OptionKeys::docking::ligand::random_conformer, "Start from a random ligand rotamer chosen from the library" ).def(false);
option.add( basic::options::OptionKeys::docking::ligand::improve_orientation, "Do N cycles of randomization to minimize clashes with backbone" );
option.add( basic::options::OptionKeys::docking::ligand::mutate_same_name3, "Allow ligand to 'design' to residue types with same name3?  Typically used for protonation states / tautomers." ).def(false);
option.add( basic::options::OptionKeys::docking::ligand::subset_to_keep, "When selecting a subset of ligand poses, what fraction (number if > 1.0) to keep?" ).def(0.05);
option.add( basic::options::OptionKeys::docking::ligand::min_rms, "When selecting a subset of ligand poses, all must differ by at least this amount." ).def(0.8);
option.add( basic::options::OptionKeys::docking::ligand::max_poses, "When selecting a subset of ligand poses, select as most this many." ).def(50);
option.add( basic::options::OptionKeys::docking::ligand::minimize_ligand, "Allow ligand torsions to minimize?" ).def(false);
option.add( basic::options::OptionKeys::docking::ligand::harmonic_torsions, "Minimize with harmonic restraints with specified stddev (in degrees)" ).def(10.0);
option.add( basic::options::OptionKeys::docking::ligand::use_ambig_constraints, "Use ambiguous constraints to restrain torsions instead of adding and removing constraints" ).def(false);
option.add( basic::options::OptionKeys::docking::ligand::shear_moves, "Do N pseudo-shear moves on ligand torsions per MCM cycle" ).def(0);
option.add( basic::options::OptionKeys::docking::ligand::minimize_backbone, "Allow protein backbone to minimize?  Restrained except near ligand." ).def(false);
option.add( basic::options::OptionKeys::docking::ligand::harmonic_Calphas, "Minimize with harmonic restraints with specified stddev (in Angstroms)" ).def(0.2);
option.add( basic::options::OptionKeys::docking::ligand::tether_ligand, "Restrain ligand to starting point with specified stddev (in Angstroms)" );
option.add( basic::options::OptionKeys::docking::ligand::start_from, "One or more XYZ locations to choose for the ligand:  -start_from X1 Y1 Z1  -start_from X2 Y2 Z2  ..." );
option.add( basic::options::OptionKeys::docking::ligand::option_file, "Name of Ligand Option File for use with multi_ligand_dock application" );
option.add( basic::options::OptionKeys::docking::ligand::rescore, "No docking (debug/benchmark mode)" ).def(false);
option.add( basic::options::OptionKeys::docking::ligand::grid::grid, "docking:ligand:grid option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::docking::ligand::grid::grid_kin, "Write kinemage version of generated grid to named file" );
option.add( basic::options::OptionKeys::docking::ligand::grid::grid_map, "Write grid to named file as electron density in BRIX (aka `O'-map) format" );
option.add( basic::options::OptionKeys::docking::symmetry::symmetry, "symmetry option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::docking::symmetry::minimize_backbone, "Allow protein backbone to minimize? " ).def(false);
option.add( basic::options::OptionKeys::docking::symmetry::minimize_sidechains, "Allow protein sidechains to minimize? " ).def(false);
option.add( basic::options::OptionKeys::pH::pH, "pH option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::pH::pH_mode, "Allow protonated/deprotonated versions of the residues based on pH" ).def(false);
option.add( basic::options::OptionKeys::pH::keep_input_protonation_state, "Read in residue protonation states from input pdb?" ).def(false);
option.add( basic::options::OptionKeys::pH::value_pH, "pH value input for the pHEnergy score" ).def(7.0);
option.add( basic::options::OptionKeys::pH::calc_pka::calc_pka, "calc_pka option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::pH::calc_pka::pka_for_resno, "Residue no whose pKa value is to be determined" ).def(-1);
option.add( basic::options::OptionKeys::pH::calc_pka::pka_for_chainno, "Chain no of the residue whose pKa is to be determined" ).def("A");
option.add( basic::options::OptionKeys::run::run, "Run option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::run::batches, "batch_flag_files" ).def("");
option.add( basic::options::OptionKeys::run::no_prof_info_in_silentout, "no time-columns appears in score/silent - files" ).def(false);
option.add( basic::options::OptionKeys::run::archive, "run MPIArchiveJobDistributor" ).def(false);
option.add( basic::options::OptionKeys::run::n_replica, "run MPIMultiCommJobDistributor with n_replica processes per job" ).def(1);
option.add( basic::options::OptionKeys::run::shuffle, "Shuffle job order" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::run::n_cycles, "Option to control miscellaneous cycles within protocols.  This has no core meaning - it is meant to reduce option-bloat by having every protocol define separate cycles options.  Check your protocol's documentation to see if it is used." ).lower(1).def(1);
option.add( basic::options::OptionKeys::run::repeat, "Repeat mover N times" ).lower(0).def(1);
option.add( basic::options::OptionKeys::run::max_min_iter, "Maximum number of iterations of dfpmin" ).def(200);
option.add( basic::options::OptionKeys::run::maxruntime, "Maximum runtime in seconds. JobDistributor will signal end if time is exceeded no matter how many jobs were finished." ).def(-1);
option.add( basic::options::OptionKeys::run::write_failures, "write failed structures to output" ).def(false);
option.add( basic::options::OptionKeys::run::clean, "clean input pdb befere processing them" ).shortd( "clean input pdb befere processing them" ).def(false);
option.add( basic::options::OptionKeys::run::benchmark, "Run in benchmark mode" );
option.add( basic::options::OptionKeys::run::test_cycles, "When running tests, use reduced cycles.  Cycles must be defined in the code itself" ).def(false);
option.add( basic::options::OptionKeys::run::memory_test_cycles, "use together with test_cycles to keep number of copies of anything as high as in production mode" ).def(false);
option.add( basic::options::OptionKeys::run::dry_run, "Run through structures/tasks/etc skipping the actual calculation step for testing of I/O and/or setup" ).def(false);
option.add( basic::options::OptionKeys::run::debug, "Run in debug mode" );
option.add( basic::options::OptionKeys::run::profile, "Run in profile mode" ).def(false);
option.add( basic::options::OptionKeys::run::max_retry_job, "If a job fails with FAIL_RETRY retry this many times at most" ).def(10);
option.add( basic::options::OptionKeys::run::verbosity, "Logging verbosity level" ).lower(0).upper(9).def(0);
option.add( basic::options::OptionKeys::run::version, "write out SVN version info, if it was available at compile time" ).def(true);
option.add( basic::options::OptionKeys::run::nodelay, "Do not delay launch of minirosetta" );
option.add( basic::options::OptionKeys::run::delay, "Wait N seconds before doing anything at all. Useful for cluster job staggering." ).def(0);
option.add( basic::options::OptionKeys::run::random_delay, "Wait a random amount of 0..N seconds before doing anything at all. Useful for cluster job staggering." ).def(0);
option.add( basic::options::OptionKeys::run::timer, "write out time per decoy in minutes in scorefile" );
option.add( basic::options::OptionKeys::run::series, "alternate way to specify the code name chain" ).def("ss");
option.add( basic::options::OptionKeys::run::protein, "protein <pdbcode> these options override the first three args" ).def("----");
option.add( basic::options::OptionKeys::run::chain, "-chain <chain_id>" ).def("-");
option.add( basic::options::OptionKeys::run::score_only, "calculate the score only and exit" ).def(false);
option.add( basic::options::OptionKeys::run::silent_input, "read start structures from compressed format requires -refold -s <.out file> -l <label/index list file> or use -all in place of -l <list> to use all files" );
option.add( basic::options::OptionKeys::run::decoystats, "calculate values of a series of additional structural properties, including counting unsatisfied buried Hbond donors and acceptors, SASApack, etc. Additional output associated with this flag is written both to stdout and to output PDB files" );
option.add( basic::options::OptionKeys::run::output_hbond_info, "print hydrogen bond info in the stats section of written out PDB files" );
option.add( basic::options::OptionKeys::run::wide_nblist_extension, "Amount to extend the wide neighbor list" ).def(2.0);
option.add( basic::options::OptionKeys::run::status, "Generate a status file" );
option.add( basic::options::OptionKeys::run::constant_seed, "Use a constant seed (1111111 unless specified)" );
option.add( basic::options::OptionKeys::run::jran, "Specify seed (requires -constant_seed)" ).def(1111111);
option.add( basic::options::OptionKeys::run::use_time_as_seed, "Use time as random number seed instead of default rng seed device." );
option.add( basic::options::OptionKeys::run::rng_seed_device, "Obtain random number seed from specified device." ).def("/dev/urandom");
option.add( basic::options::OptionKeys::run::seed_offset, "This value will be added to the random number seed. Useful when using time as seed 			and submitting many jobs to clusters.  Using the condor job id will force jobs that 			are started in the same second to still have different initial seeds" ).def(0);
option.add( basic::options::OptionKeys::run::rng, "Random number generation algorithm: Currently only mt19937 is a accepted here" ).legal("mt19937").def("mt19937");
option.add( basic::options::OptionKeys::run::run_level, "Specify runlevel by integer" ).def(0);
option.add( basic::options::OptionKeys::run::verbose, "Keyword runlevels (decreasing verbosity): gush yap chat inform quiet silent" ).legal("gush").legal("yap").legal("chat").legal("inform").legal("quiet").legal("silent");
option.add( basic::options::OptionKeys::run::silent, "use compressed output (also a runlevel)" );
option.add( basic::options::OptionKeys::run::regions, "Specify regions of the protein allowed to move" );
option.add( basic::options::OptionKeys::run::find_disulf, "Each time the pose is scored, attempt to find new disulfide bonds." ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::run::rebuild_disulf, "Attempt to build correct disulfide geometry when converting from a centroid pose to a full atom pose. Disulfides must be previously annotated, either by enabling -detect_disulf or by specifying a file to -fix_disulf." ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::run::movie, "Update _movie.pdb file for rasmol_rt" );
option.add( basic::options::OptionKeys::run::trajectory, "Write a pdb file of each accepted structure" );
option.add( basic::options::OptionKeys::run::IUPAC, "Use IUPAC hydrogen conventions in place of PDB conventions" );
option.add( basic::options::OptionKeys::run::preserve_header, "Maintain header info from input PDB when writing output PDBs" );
option.add( basic::options::OptionKeys::run::evolution, "evolutionary algorithm applied to fullatom refinement of structure models" );
option.add( basic::options::OptionKeys::run::suppress_checkpoints, "Override & switch off checkpoints." );
option.add( basic::options::OptionKeys::run::checkpoint, "Turn checkpointing on" );
option.add( basic::options::OptionKeys::run::delete_checkpoints, "delete the checkpoints after use" ).def(true);
option.add( basic::options::OptionKeys::run::checkpoint_interval, "Checkpoint time interval in seconds" ).lower(10).def(600);
option.add( basic::options::OptionKeys::run::protocol, "Which protocol to run, for Rosetta@home wrapper" ).legal("abrelax").legal("broker").legal("vf_abrelax").legal("ligand_dock").legal("relax").legal("symdock").legal("star").legal("loophash").legal("looprelax").legal("threading").legal("rbsegmentrelax").legal("boinc_debug").legal("parser").legal("jd2_scripting").legal("cm").legal("flxbb").legal("rna").legal("ddg").legal("canonical_sampling").legal("nonlocal_frags").legal("medal").def("abrelax");
option.add( basic::options::OptionKeys::run::remove_ss_length_screen, "Sets the use_ss_length_screen flag in the Fragment Mover to false" );
option.add( basic::options::OptionKeys::run::min_type, "type of minimizer to use" ).def("dfpmin");
option.add( basic::options::OptionKeys::run::min_tolerance, "minimizer tolerance" ).def(0.000001);
option.add( basic::options::OptionKeys::run::nblist_autoupdate, "Turn on neighborlist auto-updates for all minimizations" ).def(false);
option.add( basic::options::OptionKeys::run::nblist_autoupdate_narrow, "With nblist autoupdate: the reach in Angstroms for the narrow neighbor list" ).def(0.5);
option.add( basic::options::OptionKeys::run::nblist_autoupdate_wide, "With nblist autoupdate: the reach in Angstroms for the wide neighbor list" ).def(2.0);
option.add( basic::options::OptionKeys::run::skip_set_reasonable_fold_tree, "Do not run set_reasonable_fold_tree when creating a pose from a pdb.  Useful for unreasonable PDBs where the user sets a fold tree explicitly." ).def(false);
option.add( basic::options::OptionKeys::run::randomize_missing_coords, "Insert random coordinates for missing density atoms ( occupancy is zero ) and for any atoms with negative occupancy, randomizing coords is done by default" ).def(false);
option.add( basic::options::OptionKeys::run::ignore_zero_occupancy, "discard coords information for missing density atoms ( occupancy is zero ) defined in input structures.  Default is to keep those coordinates because this is a consistent problem for end users" ).def(true);
option.add( basic::options::OptionKeys::run::cycles_outer, "number of outer cycles" ).lower(1).def(1);
option.add( basic::options::OptionKeys::run::cycles_inner, "number of inner cycles" ).lower(1).def(1);
option.add( basic::options::OptionKeys::run::repack_rate, "repack after every [value] cycles during certain protocols" ).lower(1).def(10);
option.add( basic::options::OptionKeys::run::reinitialize_mover_for_each_job, "job distributor will generate fresh copy of its mover before each apply (once per job)" ).def(false);
option.add( basic::options::OptionKeys::run::reinitialize_mover_for_new_input, "job distributor will generate fresh copy of its mover whenever the pose being passed to the mover is going to change (e.g., next PDB in -l)" ).def(false);
option.add( basic::options::OptionKeys::run::multiple_processes_writing_to_one_directory, "activates .in_progress files used to communicate between independent processes that a job is underway.  UNSAFE but may be convenient." ).def(false);
option.add( basic::options::OptionKeys::run::jobdist_miscfile_ext, "extension for JobOutputter file() function (miscellaneous file output)." ).def(".data");
option.add( basic::options::OptionKeys::run::no_scorefile, "do not output scorefiles" ).def(false);
option.add( basic::options::OptionKeys::run::other_pose_to_scorefile, "write other_pose (JobOutputter) to a scorefile; path by other_pose_scorefile; be warned you can get garbage if scorefunctions for poses do not match.  Overridden by no_scorefile" ).def(false);
option.add( basic::options::OptionKeys::run::other_pose_scorefile, "Path to other_pose (JobOutputter) scorefiles.  Default is same scorefile as regular result poses.  The default will cause problems if your output poses were scored on different scorefunctions." ).def("");
option.add( basic::options::OptionKeys::run::intermediate_scorefiles, "write intermediate evaluations to disk (depends on your protocol if and how often this happens" ).def(false);
option.add( basic::options::OptionKeys::run::intermediate_structures, "write structures together with intermediate evaluations" ).def(false);
option.add( basic::options::OptionKeys::run::idealize_before_protocol, "run idealize first, before running whatever." );
option.add( basic::options::OptionKeys::run::interactive, "Signal Rosetta is to be run as a library in an interactive application. In particular, favor throwing exceptions on bad inputs rather than exiting." ).def(false);
option.add( basic::options::OptionKeys::run::condor, "if condor say yes -- proc_id counting starts at 0" ).def(false);
option.add( basic::options::OptionKeys::run::nproc, "number of process... needed if proc_id is specified" ).def(0);
option.add( basic::options::OptionKeys::run::proc_id, "give process number... Jobdistributor will only work on proc_id mod nproc part of work " ).def(0);
option.add( basic::options::OptionKeys::run::exit_if_missing_heavy_atoms, "quit if heavy atoms missing in pdb" ).def(false);
option.add( basic::options::OptionKeys::run::show_simulation_in_pymol, "Attach PyMOL observer to pose at the beginning of the simulation. Refreshes pose every [argument] seconds, default 5.  Don't forget to run the PyMOLPyRosettaServer.py script within PyMOL!" ).def(5.0);
option.add( basic::options::OptionKeys::jd2::jd2, "jd2 option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::jd2::pose_input_stream, "Use PoseInputStream classes for Pose input" ).def(false);
option.add( basic::options::OptionKeys::jd2::lazy_silent_file_reader, "use lazy silent file reader in job distributor, read in a structure only when you need to" ).def(false);
option.add( basic::options::OptionKeys::jd2::mpi_nowait_for_remaining_jobs, "exit immediately (not graceful -- not complete) if the last job has been sent out" ).def(false);
option.add( basic::options::OptionKeys::jd2::mpi_timeout_factor, "timeout is X times average job-completion time - set to 0 to switch off" ).def(3);
option.add( basic::options::OptionKeys::jd2::mpi_work_partition_job_distributor, "determine if we should use the WorkPartition job distributor" ).def(false);
option.add( basic::options::OptionKeys::jd2::mpi_file_buf_job_distributor, "determine if we should use the MPIFileBufJobDistributor (warning: silent output only)" ).def(true);
option.add( basic::options::OptionKeys::jd2::mpi_filebuf_jobdistributor, "same as mpi_file_buf_job_distributor but with more intuitive spacing... determine if we should use the MPIFileBufJobDistributor (warning: silent output only)" ).def(true);
option.add( basic::options::OptionKeys::jd2::mpi_fast_nonblocking_output, "By default the master node blocks while a slave node outputs to avoid two slaves writing to a score file or silent file at the same time setting this to true disables that feature" ).def(false);
option.add( basic::options::OptionKeys::jd2::dd_parser, "determine whether to use the dock_design_parser" ).def(false);
option.add( basic::options::OptionKeys::jd2::ntrials, "number of attempts at creating an output file for each nstruct. e.g., ntrials 3 and nstruct 10 would mean that each of 10 trajectories would attempt to write an output file 3 times and if unsuccessful would fail." );
option.add( basic::options::OptionKeys::jd2::generic_job_name, "job name when using GenericJobInputter (i.e. abinitio)" ).def("S");
option.add( basic::options::OptionKeys::jd2::no_output, "use NoOutputJobOutputter; do not store the pose after a run (no silent or scorefile)" ).def(false);
option.add( basic::options::OptionKeys::jd2::enzdes_out, "causes an enzdes-style scorefile (with information about catalytic res and some pose metric stuff ) to be written instead of the regular scorefile" ).def(false);
option.add( basic::options::OptionKeys::jd2::buffer_silent_output, "write structures to silent-files in blocks of N structures to" ).def(1);
option.add( basic::options::OptionKeys::jd2::buffer_flush_frequency, "when N structures (buffer_silent_output) are collected dump to file with probability X" ).def(1.0);
option.add( basic::options::OptionKeys::jd2::delete_old_poses, "Delete poses after they have been processed.  For jobs that process a large number of structures, the memory consumed by old poses is wasteful." ).def(false);
option.add( basic::options::OptionKeys::evaluation::evaluation, "evaluation option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::evaluation::rmsd_target, "[vector] determine rmsd against this/these structure(s)" );
option.add( basic::options::OptionKeys::evaluation::rmsd_column, "[vector] use xxx as column name: rms_xxx" );
option.add( basic::options::OptionKeys::evaluation::rmsd_select, "[vector] a bunch of loop files which makes rmsds with tags: rms_XXX, where XXX is basename of file" );
option.add( basic::options::OptionKeys::evaluation::align_rmsd_target, "[vector] determine rmsd against this/these structure(s) using simple sequence alignment" );
option.add( basic::options::OptionKeys::evaluation::structural_similarity, "[vector] measure average similarity against these structures (option specifies a silent-file)" );
option.add( basic::options::OptionKeys::evaluation::contact_map, "Calculate contact map similarity using the given native" );
option.add( basic::options::OptionKeys::evaluation::jscore_evaluator, "Calculate scores using the given score function weights files and, residue type set names (e.g score12 fa_standard score3 centroid)" );
option.add( basic::options::OptionKeys::evaluation::align_rmsd_column, "[vector] use xxx as column name for align_rmsd_target: rms_xxx" );
option.add( basic::options::OptionKeys::evaluation::align_rmsd_fns, "[vector] of sequence alignments used for align_rmsd files" );
option.add( basic::options::OptionKeys::evaluation::align_rmsd_format, "format for sequence alignment between structures used in evaluation" ).legal("grishin").legal("general").def("grishin");
option.add( basic::options::OptionKeys::evaluation::predicted_burial_fn, "file for burial predictions" ).def("");
option.add( basic::options::OptionKeys::evaluation::pool, "find closest matching structure in this pool and report tag and rmsd" );
option.add( basic::options::OptionKeys::evaluation::rmsd, "[vector/pairs] tripletts: rmsd_target (or NATIVE / IRMS) col_name selection_file (or FULL)" );
option.add( basic::options::OptionKeys::evaluation::chirmsd, "[vector/tripletts]: rmsd_target (or NATIVE / IRMS ) col_name selection_file ( or FULL) " );
option.add( basic::options::OptionKeys::evaluation::gdtmm, "for each rmsd evaluator also a gdtmm evaluator is created" ).def(false);
option.add( basic::options::OptionKeys::evaluation::score_with_rmsd, "score the pose on the same subset of atoms as in the rmsd poses" );
option.add( basic::options::OptionKeys::evaluation::constraints, "[vector] evaluate against these constraint sets" );
option.add( basic::options::OptionKeys::evaluation::constraints_column, "[vector] use xxx as column name: cst_xxx" );
option.add( basic::options::OptionKeys::evaluation::combined_constraints, "[vector] use xxx as cst-file but combine constraints before applying" );
option.add( basic::options::OptionKeys::evaluation::combined_constraints_column, "[vector] use xxx as cst-file but combine constraints before applying" );
option.add( basic::options::OptionKeys::evaluation::combine_statistics, "repeat constraint evaluation X times to get statistics of constraint combination" ).def(10);
option.add( basic::options::OptionKeys::evaluation::chemical_shifts, "compute chemical shift score with SPARTA+ use tuples: talos_file [cs]_column_name  (ATTENTION uses filesystem)" );
option.add( basic::options::OptionKeys::evaluation::sparta_dir, "[optional] point to an external resource for the sparta directory (instead of minirosetta_database)" ).def("SPARTA+");
option.add( basic::options::OptionKeys::evaluation::cam_shifts, "compute chemical shift score with Camshift talos_file [cs]_column_name  (ATTENTION uses filesystem)" );
option.add( basic::options::OptionKeys::evaluation::pales, "compute Residual Dipolar Couplings using the PALES program (ATTENTION uses filesystem)" );
option.add( basic::options::OptionKeys::evaluation::extra_score, "[vector] provide .wts files to generate extra columns" );
option.add( basic::options::OptionKeys::evaluation::extra_score_patch, "[vector] provide .patch files, set NOPATCH for columns that are not patched" );
option.add( basic::options::OptionKeys::evaluation::extra_score_column, "[vector] use xxx as column name: score_xxx" );
option.add( basic::options::OptionKeys::evaluation::extra_score_select, "[vector] /rigid/ files for selection, use SELECT_ALL as placeholder" );
option.add( basic::options::OptionKeys::evaluation::rdc_select, "[vector] as rmsd_select provide loop-file(RIGID) to compute RDC score on selected residues" );
option.add( basic::options::OptionKeys::evaluation::rdc_target, "[vector] as rmsd_target/column provide PDB wih missing density to compute RDC score on selected residues" );
option.add( basic::options::OptionKeys::evaluation::symmetric_rmsd, "calculate the rmsd symmetrically by checking all chain orderings" );
option.add( basic::options::OptionKeys::evaluation::rdc_column, "[vector] column names for rdc_select" );
option.add( basic::options::OptionKeys::evaluation::rdc, "[vector] rdc-files and column names for RDC calculation" );
option.add( basic::options::OptionKeys::evaluation::jump_nr, "adds the JumpNrEvaluator for the nrjumps column" ).def(false);
option.add( basic::options::OptionKeys::evaluation::score_exclude_res, "Calculates a select_score column based on all residues not excluded by the command line vector" );
option.add( basic::options::OptionKeys::evaluation::score_sscore_short_helix, "defines the maximum length of a helix that is not scored if it terminates a loop" ).def(5);
option.add( basic::options::OptionKeys::evaluation::score_sscore_maxloop, "defines the maximum length of a loop that is still considered for the sscore - score" ).def(3);
option.add( basic::options::OptionKeys::evaluation::rpf, "will compute RPF score with distance cutoff 5 and store in column rpf_score" ).def(false);
option.add( basic::options::OptionKeys::evaluation::window_size, "Window size for local RMSD calculations in windowed_rmsd app" ).def(5);
option.add( basic::options::OptionKeys::filters::filters, "filters option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::filters::disable_all_filters, "turn off all centroid filters: RG, CO, and Sheet" ).def(false);
option.add( basic::options::OptionKeys::filters::disable_rg_filter, "turn off RG filter" ).def(false);
option.add( basic::options::OptionKeys::filters::disable_co_filter, "turn off contact order filter" ).def(false);
option.add( basic::options::OptionKeys::filters::disable_sheet_filter, "turn off sheet filter" ).def(false);
option.add( basic::options::OptionKeys::filters::set_pddf_filter, "Turns on PDDF filter with a given score cutoff" ).def(5.0);
option.add( basic::options::OptionKeys::filters::set_saxs_filter, "Turns on SAXS energy filter with a given score cutoff" ).def(-3);
option.add( basic::options::OptionKeys::MonteCarlo::MonteCarlo, "MonteCarlo option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::MonteCarlo::temp_initial, "initial temperature for Monte Carlo considerations" ).lower(0.001).def(2);
option.add( basic::options::OptionKeys::MonteCarlo::temp_final, "final temperature for Monte Carlo considerations" ).lower(0.001).def(0.6);
option.add( basic::options::OptionKeys::frags::frags, "frags option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::frags::j, "Number of threads to use" );
option.add( basic::options::OptionKeys::frags::filter_JC, "Filter J-coupling values in the dynamic range " ).def(false);
option.add( basic::options::OptionKeys::frags::bounded_protocol, "makes the picker use bounded protocol to select fragments. This is teh default behavior" ).def(true);
option.add( basic::options::OptionKeys::frags::keep_all_protocol, "makes the picker use keep-all protocol to select fragments. The default is bounded protocol" ).def(false);
option.add( basic::options::OptionKeys::frags::quota_protocol, "quota protocol implies the use of a QuotaCollector and a QuotaSelelctor, no matter what user set up by other flags." ).def(false);
option.add( basic::options::OptionKeys::frags::nonlocal_pairs, "identifies and outputs nonlocal fragment pairs." ).def(false);
option.add( basic::options::OptionKeys::frags::fragment_contacts, "identifies and outputs fragment contacts." ).def(false);
option.add( basic::options::OptionKeys::frags::p_value_selection, "the final fragment selection will b based on p-value rather than on a total score for the given fragment" ).def(false);
option.add( basic::options::OptionKeys::frags::n_frags, "number of fragments per position" ).def(200);
option.add( basic::options::OptionKeys::frags::allowed_pdb, "provides a text file with allowed PDB chains (five characters per entry, e.g.'4mbA'). Only these PDB chains from Vall will be used to pick fragments" );
option.add( basic::options::OptionKeys::frags::ss_pred, "provides one or more files with secondary structure prediction (PsiPred SS2 format) , to be used by secondary structure scoring and quota selector. Each file name must be followed by a string ID." );
option.add( basic::options::OptionKeys::frags::spine_x, "provides phi and psi torsion angle predictions and solvent accessibility prediction from Spine-X" );
option.add( basic::options::OptionKeys::frags::depth, "provides residue depth values from DEPTH" );
option.add( basic::options::OptionKeys::frags::denied_pdb, "provides a text file with denied PDB chains (five characters per entry, e.g.'4mbA'). This way close homologs may be excluded from fragment picking." );
option.add( basic::options::OptionKeys::frags::frag_sizes, "sizes of fragments to pick from the vall" ).def(9).def(3).def(1);
option.add( basic::options::OptionKeys::frags::write_ca_coordinates, "Fragment picker will store CA Cartesian coordinates in output fragment files. By default only torsion coordinates are stored." ).def(false);
option.add( basic::options::OptionKeys::frags::annotate, "read the annotation from the rosetta++ fragment file" ).def(false);
option.add( basic::options::OptionKeys::frags::nr_large_copies, "make N copies for each standard 9mer (or so) fragment" ).def(1);
option.add( basic::options::OptionKeys::frags::n_candidates, "number of fragment candidates per position; the final fragments will be selected from them" ).def(200);
option.add( basic::options::OptionKeys::frags::write_rama_tables, "Fragment picker will spit out sequence specific ramachandran score tables for your viewing pleasure. These ramachandran tables are based on the secondary structure predictions fed into RamaScore, and you may occasionally want to look at what the program has defined." ).def(false);
option.add( basic::options::OptionKeys::frags::rama_C, "Constant in RamaScore equation, command line is for optimization tests" ).def(0.0);
option.add( basic::options::OptionKeys::frags::rama_B, "Constant in RamaScore equation, command line is for optimization tests" ).def(1.0);
option.add( basic::options::OptionKeys::frags::sigmoid_cs_A, "Constant in CSScore equation, command line is for optimization tests" ).def(2.0);
option.add( basic::options::OptionKeys::frags::sigmoid_cs_B, "Constant in CSScore equation, command line is for optimization tests" ).def(4.0);
option.add( basic::options::OptionKeys::frags::seqsim_H, "Secondary structure type prediction multiplier, for use in fragment picking" ).def(1.0);
option.add( basic::options::OptionKeys::frags::seqsim_E, "Secondary structure type prediction multiplier, for use in fragment picking" ).def(1.0);
option.add( basic::options::OptionKeys::frags::seqsim_L, "Secondary structure type prediction multiplier, for use in fragment picking" ).def(1.0);
option.add( basic::options::OptionKeys::frags::rama_norm, "Used to multiply rama table values after normalization, default (0.0) means use raw counts (unnormalized)" ).def(0.0);
option.add( basic::options::OptionKeys::frags::describe_fragments, "Writes scores for all fragments into a file" ).def("");
option.add( basic::options::OptionKeys::frags::write_sequence_only, "Fragment picker will output fragment sequences only. This option is for creating structure based sequence profiles using the FragmentCrmsdResDepth score." ).def(false);
option.add( basic::options::OptionKeys::frags::scoring::scoring, "scoring option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::frags::scoring::config, "scoring scheme used for picking fragments" ).def("");
option.add( basic::options::OptionKeys::frags::scoring::profile_score, "scoring scheme used for profile-profile comparison" ).def("L1");
option.add( basic::options::OptionKeys::frags::scoring::predicted_secondary, "provides one or more files with secondary structure prediction, to be used by secondary structure scoring and quota selector" ).def("");
option.add( basic::options::OptionKeys::frags::picking::picking, "picking option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::frags::picking::selecting_rule, "the way how fragments are selected from candidates, e.g. QuotaSelector of BestTotalScoreSelector" ).legal("QuotaSelector").legal("BestTotalScoreSelector").def("BestTotalScoreSelector");
option.add( basic::options::OptionKeys::frags::picking::selecting_scorefxn, "in the case user chose BestTotalScoreSelector to be used, this option provides a custom scoring function to be used at the selection step" );
option.add( basic::options::OptionKeys::frags::picking::quota_config_file, "provides a configuration file for quota selector" );
option.add( basic::options::OptionKeys::frags::picking::query_pos, "provide sequence position for which fragments will be picked. By default fragments are picked for the whole query sequence" );
option.add( basic::options::OptionKeys::frags::nonlocal::nonlocal, "nonlocal option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::frags::nonlocal::relax_input, "relax input before running protocol" );
option.add( basic::options::OptionKeys::frags::nonlocal::relax_input_with_coordinate_constraints, "relax input with coordinate constraints before running protocol" );
option.add( basic::options::OptionKeys::frags::nonlocal::relax_frags_repeats, "relax repeats for relaxing fragment pair" );
option.add( basic::options::OptionKeys::frags::nonlocal::single_chain, "non-local fragment pairs will be restricted to the same chain" );
option.add( basic::options::OptionKeys::frags::nonlocal::min_contacts_per_res, "minimum contacts per residue in fragment to be considered a fragment pair" ).def(1.0);
option.add( basic::options::OptionKeys::frags::nonlocal::max_ddg_score, "maximum DDG score of fragment pair" );
option.add( basic::options::OptionKeys::frags::nonlocal::max_rmsd_after_relax, "maximum rmsd of fragment pair after relax" );
option.add( basic::options::OptionKeys::frags::nonlocal::output_frags_pdbs, "output non-local fragment pair PDBs" );
option.add( basic::options::OptionKeys::frags::nonlocal::output_idealized, "output an idealized pose which can be used for generating a new VALL" );
option.add( basic::options::OptionKeys::frags::nonlocal::output_silent, "output non-local fragment pairs silent file" ).def(true);
option.add( basic::options::OptionKeys::frags::contacts::contacts, "contacts option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::frags::contacts::min_seq_sep, "minimum sequence separation between contacts" ).def(12);
option.add( basic::options::OptionKeys::frags::contacts::dist_cutoffs, "distance cutoffs to be considered a contact. contact counts will only be saved." ).def(9.0);
option.add( basic::options::OptionKeys::frags::contacts::centroid_distance_scale_factor, "Scaling factor for centroid distance cutoffs." ).def(1.0);
option.add( basic::options::OptionKeys::frags::contacts::type, "Atom considered for contacts" ).legal("ca").legal("cb").legal("cen").def(utility::vector1<std::string>(1,"ca"));
option.add( basic::options::OptionKeys::frags::contacts::neighbors, "number of adjacent residues to a contact for finding neighboring contacts" ).def(0);
option.add( basic::options::OptionKeys::frags::contacts::output_all, "output all contacts" ).def(false);
option.add( basic::options::OptionKeys::broker::broker, "broker option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::broker::setup, "setup file for topology-broker" ).def("NO_SETUP_FILE");
option.add( basic::options::OptionKeys::chunk::chunk, "chunk option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::chunk::pdb2, "file for chunk2" );
option.add( basic::options::OptionKeys::chunk::loop2, "rigid region for chunk2" );
option.add( basic::options::OptionKeys::nonlocal::nonlocal, "nonlocal option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::nonlocal::builder, "One of {simple, star}. Specifies how non-local abinitio should construct the fold tree" ).def("star");
option.add( basic::options::OptionKeys::nonlocal::chunks, "Decsribes how the structure is partitioned into chunks. Each residue must be present in 1 and only 1 chunk. Loop file format." );
option.add( basic::options::OptionKeys::nonlocal::max_chunk_size, "Maximum allowable chunk size for comparative modeling inputs. If the chunk exceeds this threshold, it is recursively decomposed into smaller pieces." ).def(20);
option.add( basic::options::OptionKeys::nonlocal::randomize_missing, "Randomize the coordinates of missing loops. This occurs often in broken-chain folding from a sequence alignment and template pdb. Default value is false to preserve existing behavior in ThreadingJobInputter" ).def(false);
option.add( basic::options::OptionKeys::nonlocal::rdc_weight, "Weight for the rdc energy term in nonlocal abinitio protocol" ).def(5);
option.add( basic::options::OptionKeys::abinitio::star::star, "star option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::abinitio::star::initial_dist_cutoff, "Maximum distance cutoff for restraints that constrain aligned residues to their initial positions" ).def(8.0);
option.add( basic::options::OptionKeys::abinitio::star::min_unaligned_len, "Minimum length of an unaligned region" ).def(3);
option.add( basic::options::OptionKeys::abinitio::star::short_loop_len, "StarAbinitio treats short loops differently from long ones. If the sequence separation between the consecutive aligned regions is <= short_loop_len, it is considered short, otherwise it is considered long." ).def(18);
option.add( basic::options::OptionKeys::abinitio::prob_perturb_weights, "Probability of perturbing score function weights" ).lower(0).upper(1).def(0);
option.add( basic::options::OptionKeys::abinitio::abinitio, "Ab initio mode" );
option.add( basic::options::OptionKeys::abinitio::membrane, "will use the membrane abinitio protocol. sequential insertion of TMH" ).def(false);
option.add( basic::options::OptionKeys::abinitio::kill_hairpins, "setup hairpin killing in score (kill hairpin file or psipred file)" );
option.add( basic::options::OptionKeys::abinitio::kill_hairpins_frequency, "automated hairpin killing frequency (for use with psipred file)" ).def(0.2);
option.add( basic::options::OptionKeys::abinitio::smooth_cycles_only, "Only smooth cycles in abinitio protocol" ).def(false);
option.add( basic::options::OptionKeys::abinitio::relax, "Do a relax after abinitio = abrelax ?" );
option.add( basic::options::OptionKeys::abinitio::final_clean_relax, "Do a final relax without constraints" );
option.add( basic::options::OptionKeys::abinitio::fastrelax, "Do a fastrelax after abinitio = abfastrelax ?" );
option.add( basic::options::OptionKeys::abinitio::multifastrelax, "Do a fastrelax after abinitio = abfastrelax ?" );
option.add( basic::options::OptionKeys::abinitio::debug, "No description" ).def(false);
option.add( basic::options::OptionKeys::abinitio::clear_pose_cache, "always clear extra-scores away before output" ).def(false);
option.add( basic::options::OptionKeys::abinitio::explicit_pdb_debug, "always dump pdb (not silent ) files during abinitio stages" ).def(false);
option.add( basic::options::OptionKeys::abinitio::use_filters, "use RG, contact-order and sheet filters " ).def(false);
option.add( basic::options::OptionKeys::abinitio::increase_cycles, "Increase number of cycles at each stage of fold_abinitio (or pose_abinitio) by this factor" ).lower(0.001).def(1.0);
option.add( basic::options::OptionKeys::abinitio::number_3mer_frags, "Number of top 3mer fragments to use in fold_abinitio protocol" ).lower(0).def(200);
option.add( basic::options::OptionKeys::abinitio::number_9mer_frags, "Number of top 9mer fragments to use in fold_abinitio protocol" ).lower(0).def(25);
option.add( basic::options::OptionKeys::abinitio::temperature, "Temperature used in fold_abinitio" ).def(2.0);
option.add( basic::options::OptionKeys::abinitio::rg_reweight, "Reweight contribution of radius of gyration to total score by this scale factor" ).def(1.0);
option.add( basic::options::OptionKeys::abinitio::strand_dist_cutoff, "Specify distance cutoff (in Angstroms) between strand dimers within which they are called paired" ).def(6.5);
option.add( basic::options::OptionKeys::abinitio::stretch_strand_dist_cutoff, "Allow strand distance cutoff to change from 6.5 A to a larger value (specified by '-max_strand_dist_cutoff <float>') linearly scaled according to sequence separation over a range specified by '-seq_sep_scale <float>' " );
option.add( basic::options::OptionKeys::abinitio::rsd_wt_helix, "Reweight env,pair,cb for helix residues by this factor" ).def(1.0);
option.add( basic::options::OptionKeys::abinitio::rsd_wt_strand, "Reweight env,pair,cb for strand residues by this factor" ).def(1.0);
option.add( basic::options::OptionKeys::abinitio::rsd_wt_loop, "Reweight env,pair,cb for loop residues by this factor" ).def(1.0);
option.add( basic::options::OptionKeys::abinitio::fast, "Runs protocol without minimization or gradients, giving a significant speed advantage For NOE data only, -fast yields essentially the protocol published by Bowers et al., JBNMR, 2000. For RDC data only, -fast omits the refinement step included in examples published in Rohl&Baker, JACS, 2002. without the -fast option" );
option.add( basic::options::OptionKeys::abinitio::skip_convergence_check, "this option turns off the convergence check in stage3 (score 2/5)" );
option.add( basic::options::OptionKeys::abinitio::stage1_patch, "Name of weights patch file (without extension .wts) to use during stage1 abinitio" );
option.add( basic::options::OptionKeys::abinitio::stage2_patch, "Name of weights patch file (without extension .wts) to use during stage2 abinitio" );
option.add( basic::options::OptionKeys::abinitio::stage3a_patch, "Name of weights patch file (without extension .wts) to use during stage3a abinitio" );
option.add( basic::options::OptionKeys::abinitio::stage3b_patch, "Name of weights patch file (without extension .wts) to use during stage3b abinitio" );
option.add( basic::options::OptionKeys::abinitio::stage4_patch, "Name of weights patch file (without extension .wts) to use during stage4 abinitio" );
option.add( basic::options::OptionKeys::abinitio::stage5_patch, "Name of weights patch file (without extension .wts) to use during stage5 abinitio" );
option.add( basic::options::OptionKeys::abinitio::exit_when_converged, "finish abinitio if mc_converged" ).def(false);
option.add( basic::options::OptionKeys::abinitio::steal_3mers, "stealing: use 3mers from native" ).def(false);
option.add( basic::options::OptionKeys::abinitio::steal_9mers, "stealing: use 9mers from native" ).def(false);
option.add( basic::options::OptionKeys::abinitio::no_write_failures, "dont write failed structures to silent-out" ).def(false);
option.add( basic::options::OptionKeys::abinitio::relax_failures, "relax failures anyway" ).def(false);
option.add( basic::options::OptionKeys::abinitio::relax_with_jumps, "switch to allow relax even if loops are not closed " ).def(false);
option.add( basic::options::OptionKeys::abinitio::process_store, "run process_decoy on each structure in the structure store" ).def(false);
option.add( basic::options::OptionKeys::abinitio::fix_residues_to_native, "these residues torsions are copied from native and fixed" ).def(0);
option.add( basic::options::OptionKeys::abinitio::return_full_atom, "return a full-atom structure even if no relax is done" ).def(false);
option.add( basic::options::OptionKeys::abinitio::detect_disulfide_before_relax, "run detect_disulfides() before relax" ).def(false);
option.add( basic::options::OptionKeys::abinitio::close_loops, "close loops" ).def(false);
option.add( basic::options::OptionKeys::abinitio::bGDT, "compute gdtmmm" ).def(true);
option.add( basic::options::OptionKeys::abinitio::dump_frags, "for control purposes... dump fragments" ).def(false);
option.add( basic::options::OptionKeys::abinitio::jdist_rerun, "go through intput structures and evaluate ( pca, rmsd, cst-energy )" ).def(false);
option.add( basic::options::OptionKeys::abinitio::perturb, "add some perturbation (gaussian) to phi/psi of native" ).def(0.0);
option.add( basic::options::OptionKeys::abinitio::rerun, "go through intput structures and evaluate ( pca, rmsd, cst-energy )" ).def(false);
option.add( basic::options::OptionKeys::abinitio::rmsd_residues, "give start and end residue for rmsd calcul." ).def(-1);
option.add( basic::options::OptionKeys::abinitio::start_native, "start from native structure (instead of extended)" ).def(false);
option.add( basic::options::OptionKeys::abinitio::debug_structures, "write structures to debug-out files" ).def(false);
option.add( basic::options::OptionKeys::abinitio::log_frags, "fragment insertions (each trial) will be logged to file" ).def("");
option.add( basic::options::OptionKeys::abinitio::only_stage1, "useful for benchmarks sets cycle of all higher stages to 0" ).def(false);
option.add( basic::options::OptionKeys::abinitio::end_bias, "set the endbias for Fragment moves" ).def(30.0);
option.add( basic::options::OptionKeys::abinitio::symmetry_residue, "hacky symmetry mode for dimers, fragments are inserted at i and i + SR - 1" ).def(-1);
option.add( basic::options::OptionKeys::abinitio::vdw_weight_stage1, "vdw weight in stage1" ).def(1.0);
option.add( basic::options::OptionKeys::abinitio::override_vdw_all_stages, "apply vdw_weight_stage1 for all stages" ).def(false);
option.add( basic::options::OptionKeys::abinitio::recover_low_in_stages, "say default: 2 3 4 recover_low happens in stages 2 3 4" ).def(0);
option.add( basic::options::OptionKeys::abinitio::skip_stages, "say: 2 3 4, and it will skip stages 2 3 4" ).def(0);
option.add( basic::options::OptionKeys::abinitio::close_chbrk, "Chain break closure during classic abinito " ).def(false);
option.add( basic::options::OptionKeys::abinitio::include_stage5, "stage5 contains small moves only" ).def(false);
option.add( basic::options::OptionKeys::abinitio::close_loops_by_idealizing, "close loops by idealizing the structure after stage 4" ).def(false);
option.add( basic::options::OptionKeys::abinitio::optimize_cutpoints_using_kic, "optimize around cutpoints using kinematic relax" ).def(false);
option.add( basic::options::OptionKeys::abinitio::optimize_cutpoints_margin, "" ).def(5);
option.add( basic::options::OptionKeys::abinitio::HD_EX_Info, "input list of residues with low amide protection " );
option.add( basic::options::OptionKeys::abinitio::HD_penalty, "penatlty for each inconsistent pairing with HD data " ).def(0.1);
option.add( basic::options::OptionKeys::abinitio::HD_fa_penalty, "penalty for each Hbond donor inconsistent with HD donor" ).def(0.1);
option.add( basic::options::OptionKeys::abinitio::sheet_edge_pred, "file with interior/exterior predictions for strands" );

}
inline void add_rosetta_options_1( utility::options::OptionCollection &option ) {option.add( basic::options::OptionKeys::abinitio::SEP_score_scalling, "scalling factor" ).def(1.0);
option.add( basic::options::OptionKeys::fold_cst::fold_cst, "fold_cst option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::fold_cst::constraint_skip_rate, "if e.g., 0.95 it will randomly select 5% if the constraints each round -- full-cst score in  extra column" ).def(0);
option.add( basic::options::OptionKeys::fold_cst::violation_skip_basis, "local skip_rate is viol/base" ).def(100);
option.add( basic::options::OptionKeys::fold_cst::violation_skip_ignore, "no skip for numbers below this level" ).def(10);
option.add( basic::options::OptionKeys::fold_cst::keep_skipped_csts, "final score only with active constraints" ).def(false);
option.add( basic::options::OptionKeys::fold_cst::no_minimize, "No minimization moves in fold_constraints protocol. Useful for testing wheather fragment moves alone can recapitulate a given structure." ).def(false);
option.add( basic::options::OptionKeys::fold_cst::force_minimize, "Minimization moves in fold_constraints protocol also if no constraints present" ).def(false);
option.add( basic::options::OptionKeys::fold_cst::seq_sep_stages, "give vector with sequence_separation after stage1, stage3 and stage4" ).def(0);
option.add( basic::options::OptionKeys::fold_cst::reramp_cst_cycles, "in stage2 do xxx cycles where atom_pair_constraint is ramped up" ).def(0);
option.add( basic::options::OptionKeys::fold_cst::reramp_start_cstweight, "drop cst_weight to this value and ramp to 1.0 in stage2 -- needs reramp_cst_cycles > 0" ).def(0.01);
option.add( basic::options::OptionKeys::fold_cst::reramp_iterations, "do X loops of annealing cycles" ).def(1);
option.add( basic::options::OptionKeys::fold_cst::skip_on_noviolation_in_stage1, "if constraints report no violations --- skip cycles" ).def(false);
option.add( basic::options::OptionKeys::fold_cst::stage1_ramp_cst_cycle_factor, "spend x*<standard cycles> on each step of sequence separation" ).def(0.25);
option.add( basic::options::OptionKeys::fold_cst::stage2_constraint_threshold, "stop runs that violate this threshold at end of stage2" ).def(0);
option.add( basic::options::OptionKeys::fold_cst::ignore_sequence_seperation, "usually constraints are switched on according to their separation in the fold-tree" ).def(false);
option.add( basic::options::OptionKeys::fold_cst::no_recover_low_at_constraint_switch, "dont recover low when max_seq_sep is increased" ).def(false);
option.add( basic::options::OptionKeys::fold_cst::ramp_coord_cst, "ramp coord csts just like chainbreak-weights during fold-cst" ).def(false);
option.add( basic::options::OptionKeys::resample::resample, "resample option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::resample::silent, "a silent file for decoys to restart sampling from " ).def("");
option.add( basic::options::OptionKeys::resample::tag, "which decoy to select from silent file " ).def("");
option.add( basic::options::OptionKeys::resample::stage1, "if true restart after stage1, otherwise after stage2 " ).def(false);
option.add( basic::options::OptionKeys::resample::stage2, "if true restart after stage1, otherwise after stage2 " ).def(false);
option.add( basic::options::OptionKeys::resample::jumps, "if true restart after stage1, otherwise after stage2 " ).def(false);
option.add( basic::options::OptionKeys::resample::min_max_start_seq_sep, "range of (random) start values for seq-separation" ).def(0);
option.add( basic::options::OptionKeys::loopfcst::loopfcst, "loopfcst option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::loopfcst::coord_cst_weight, "use coord constraints for template" ).def(0.0);
option.add( basic::options::OptionKeys::loopfcst::coord_cst_all_atom, "use coord constraints on all atoms and not just CA" ).def(false);
option.add( basic::options::OptionKeys::loopfcst::use_general_protocol, "use the new machinery around classes KinematicXXX" ).def(false);
option.add( basic::options::OptionKeys::loopfcst::coord_cst_weight_array, "use these weights (per seqpos) for coord cst in rigid regions" ).def("");
option.add( basic::options::OptionKeys::loopfcst::dump_coord_cst_weight_array, "dump these weights (per seqpos) for coord cst in rigid regions" ).def("");
option.add( basic::options::OptionKeys::jumps::jumps, "jumps option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::jumps::evaluate, "evaluate N-CA-C gemoetry for all jumps in the fold-tree" ).def(false);
option.add( basic::options::OptionKeys::jumps::extra_frags_for_ss, "use ss-def from this fragset" ).def("");
option.add( basic::options::OptionKeys::jumps::fix_chainbreak, "minimize to fix ccd in re-runs" ).def(false);
option.add( basic::options::OptionKeys::jumps::fix_jumps, "read jump_file" ).def("");
option.add( basic::options::OptionKeys::jumps::jump_lib, "read jump_library_file for automatic jumps" ).def("");
option.add( basic::options::OptionKeys::jumps::loop_definition_from_file, "use ss-def from this file" ).def("");
option.add( basic::options::OptionKeys::jumps::no_chainbreak_in_relax, "dont penalize chainbreak in relax" ).def(false);
option.add( basic::options::OptionKeys::jumps::pairing_file, "file with pairings" ).def("");
option.add( basic::options::OptionKeys::jumps::random_sheets, "random sheet topology--> replaces -sheet1 -sheet2 ... select randomly up to N sheets with up to -sheet_i pairgins for sheet i" ).def(1);
option.add( basic::options::OptionKeys::jumps::residue_pair_jump_file, "a file to define residue pair jump" ).def("");
option.add( basic::options::OptionKeys::jumps::sheets, "sheet topology--> replaces -sheet1 -sheet2 ... -sheetN" ).def(1);
option.add( basic::options::OptionKeys::jumps::topology_file, "read a file with topology info ( PairingStats )" ).def("");
option.add( basic::options::OptionKeys::jumps::bb_moves, "Apply bb_moves ( wobble, small, shear) during stage3 and stage 4." ).def(false);
option.add( basic::options::OptionKeys::jumps::no_wobble, "Don t apply the useless wobble during stage3 and stage 4." ).def(false);
option.add( basic::options::OptionKeys::jumps::no_shear, "Don t apply the useless shear during stage3 and stage 4." ).def(false);
option.add( basic::options::OptionKeys::jumps::no_sample_ss_jumps, "sample jump-frags during folding" ).def(false);
option.add( basic::options::OptionKeys::jumps::invrate_jump_move, "give 5 here to have 5 torsion moves for each jump move" ).def(10);
option.add( basic::options::OptionKeys::jumps::chainbreak_weight_stage1, "the weight on chainbreaks" ).def(1.0);
option.add( basic::options::OptionKeys::jumps::chainbreak_weight_stage2, "the weight on chainbreaks" ).def(1.0);
option.add( basic::options::OptionKeys::jumps::chainbreak_weight_stage3, "the weight on chainbreaks" ).def(1.0);
option.add( basic::options::OptionKeys::jumps::chainbreak_weight_stage4, "the weight on chainbreaks" ).def(1.0);
option.add( basic::options::OptionKeys::jumps::ramp_chainbreaks, "ramp up the chainbreak weight stage1-0, stage2 0.25, stage3 alternating 0.5..2.5, stage4 2.5..4" ).def(true);
option.add( basic::options::OptionKeys::jumps::increase_chainbreak, "multiply ramped chainbreak weight by this amount" ).def(1.0);
option.add( basic::options::OptionKeys::jumps::overlap_chainbreak, "use the overlap chainbrak term in stage4" ).def(false);
option.add( basic::options::OptionKeys::jumps::sep_switch_accelerate, "constraints and chainbreak depend on in-chain-separation. Accelerate their enforcement 1+num_cuts()*<this_factor>" ).def(0.4);
option.add( basic::options::OptionKeys::jumps::dump_frags, "dump jump_fragments " ).def(false);
option.add( basic::options::OptionKeys::jumps::njumps, "number_of_jumps to select from library for each trajectory (membrane mode)" ).def(1);
option.add( basic::options::OptionKeys::jumps::max_strand_gap_allowed, "merge strands if they less than X residues but same register" ).def(2);
option.add( basic::options::OptionKeys::jumps::contact_score, "the strand-weight will have a weight * contact_order component" ).def(0.0);
option.add( basic::options::OptionKeys::templates::templates, "templates option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::templates::config, "read a list of templates and alignments" ).def("templates.dat");
option.add( basic::options::OptionKeys::templates::fix_aligned_residues, "pick only from template fragments and then keep these residues fixed" ).def(false);
option.add( basic::options::OptionKeys::templates::fix_frag_file, " fragments from this file are picked once in beginning and then kept fixed" ).def("");
option.add( basic::options::OptionKeys::templates::fix_margin, "keep n residues at edges of fixed fragments moveable" ).def(1);
option.add( basic::options::OptionKeys::templates::min_nr_large_frags, "how many large fragments should be present" ).def(100000);
option.add( basic::options::OptionKeys::templates::min_nr_small_frags, "how many small fragments should be present" ).def(100000);
option.add( basic::options::OptionKeys::templates::no_pick_fragments, "no further fragment picking from templates" ).def(false);
option.add( basic::options::OptionKeys::templates::nr_large_copies, "make N copies of each picked template fragment -- a hacky way to weight them" ).def(4);
option.add( basic::options::OptionKeys::templates::nr_small_copies, "make N copies of each picked template fragment -- a hacky way to weight them" ).def(20);
option.add( basic::options::OptionKeys::templates::pairings, "use pairings from templates" ).def(false);
option.add( basic::options::OptionKeys::templates::pick_multiple_sizes, "pick 9mers, 18mers and 27mers" ).def(false);
option.add( basic::options::OptionKeys::templates::strand_constraint, "use the template-based strand-constraints" ).def(false);
option.add( basic::options::OptionKeys::templates::vary_frag_size, "pick fragments as long as aligned regions" ).def(false);
option.add( basic::options::OptionKeys::templates::no_culling, "dont throw out constraints that are violated by other templates" ).def(false);
option.add( basic::options::OptionKeys::templates::helix_pairings, "file with list of pairings that are enforced (pick jumps from templates with H)" ).def("");
option.add( basic::options::OptionKeys::templates::prefix, "path for config directory -- applied to all filenames in template_config_file" ).def("");
option.add( basic::options::OptionKeys::templates::change_movemap, "stage in which movemap is switched to allow all bb-residues to move, valid stages: 3..4 (HACK)" ).def(3);
option.add( basic::options::OptionKeys::templates::force_native_topology, "force the native toplogy (geometries from templates)" ).def(false);
option.add( basic::options::OptionKeys::templates::topology_rank_cutoff, "select jumps from all topologies with a higher relative score than if 1.0 take top 5" ).def(1.0);
option.add( basic::options::OptionKeys::templates::min_frag_size, "smallest fragment picked from aligned template regions" ).def(6);
option.add( basic::options::OptionKeys::templates::max_shrink, "pick fragments up to max_shrink smaller than aligned regions" ).def(0);
option.add( basic::options::OptionKeys::templates::shrink_step, "shrink_step 5 , eg., 27mer 22mer 17mer" ).def(5);
option.add( basic::options::OptionKeys::templates::shrink_pos_step, "distance between start pos in shrinked fragments" ).def(5);
option.add( basic::options::OptionKeys::templates::min_padding, "minimum space between fragment and gap" ).def(0);
option.add( basic::options::OptionKeys::templates::min_align_pos, "ignore aligned residues before this position" ).def(0);
option.add( basic::options::OptionKeys::templates::max_align_pos, "ignore aligned residues after this position" ).def(-1);
option.add( basic::options::OptionKeys::templates::cst::cst, "cst option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::templates::cst::topN, "topN ranking models are used for constraints ( culling and source )" ).def(0);
option.add( basic::options::OptionKeys::templates::cst::wTopol, "weight for beta-pairing topology score in ranking" ).def(0.5);
option.add( basic::options::OptionKeys::templates::cst::wExtern, "weight for external score ( column in template_config_file, e.g, svn-score" ).def(0.5);
option.add( basic::options::OptionKeys::templates::fragsteal::fragsteal, "fragsteal option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::templates::fragsteal::topN, "topN ranking models are used for fragment stealing" ).def(0);
option.add( basic::options::OptionKeys::templates::fragsteal::wTopol, "weight for beta-pairing topology score in ranking" ).def(0.5);
option.add( basic::options::OptionKeys::templates::fragsteal::wExtern, "weight for external score ( column in template_config_file, e.g, svn-score" ).def(0.5);
option.add( basic::options::OptionKeys::abrelax::abrelax, "ab initio relax mode" );
option.add( basic::options::OptionKeys::abrelax::filters, "" );
option.add( basic::options::OptionKeys::abrelax::fail_unclosed, "structures which don't close loops are reported as FAIL_DO_NOT_RETRY" ).def(false);
option.add( basic::options::OptionKeys::chemical::chemical, "chemical option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::chemical::exclude_patches, "Names of the residue-type-set patches which should not be applied; if you know which patches you do not need for a particular run, this flag can reduce your memory use" );
option.add( basic::options::OptionKeys::score::score_pose_cutpoint_variants, "Include cutpoint variants in the pose during linear chainbreak" ).def(false);
option.add( basic::options::OptionKeys::score::score, "scorefunction option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::score::weights, "Name of weights file (without extension .wts)" ).def("standard");
option.add( basic::options::OptionKeys::score::pack_weights, "Name of packing weights file (without extension .wts)" ).def("standard");
option.add( basic::options::OptionKeys::score::soft_wts, "Name of the 'soft' weights file, for protocols which use it." ).def("soft_rep");
option.add( basic::options::OptionKeys::score::docking_interface_score, "the score is computed as difference between bound and unbound pose" ).def(false);
option.add( basic::options::OptionKeys::score::custom_atom_pair, "filename for custom atom pair constraints" ).def("empty");
option.add( basic::options::OptionKeys::score::patch, "Name of patch file (without extension)" ).def("");
option.add( basic::options::OptionKeys::score::empty, "Make an empty score - i.e. NO scoring" );
option.add( basic::options::OptionKeys::score::fa_max_dis, "How far does the FA pair potential go out to ?" ).def(6.0);
option.add( basic::options::OptionKeys::score::fa_Hatr, "Turn on Lennard Jones attractive term for hydrogen atoms" );
option.add( basic::options::OptionKeys::score::no_smooth_etables, "Revert to old style etables" );
option.add( basic::options::OptionKeys::score::etable_lr, "lowers energy well at 6.5A" );
option.add( basic::options::OptionKeys::score::no_lk_polar_desolvation, "Disable the polar-desolvation component of the LK solvation model; effectively set dGfree for polar atoms to 0" );
option.add( basic::options::OptionKeys::score::input_etables, "Read etables from files with given prefix" );
option.add( basic::options::OptionKeys::score::output_etables, "Write out etables to files with given prefix" );
option.add( basic::options::OptionKeys::score::rms_target, "Target of RMS optimization for RMS_Energy EnergyMethod" ).def(0.0);
option.add( basic::options::OptionKeys::score::ramaneighbors, "Uses neighbor-dependent ramachandran maps" ).def(false);
option.add( basic::options::OptionKeys::score::optH_weights, "Name of weights file (without extension .wts) to use during optH" );
option.add( basic::options::OptionKeys::score::optH_patch, "Name of weights file (without extension .wts) to use during optH" );
option.add( basic::options::OptionKeys::score::hbond_params, "Directory name in the database for which hydrogen bond parameters to use." ).def("standard_params");
option.add( basic::options::OptionKeys::score::hbond_disable_bbsc_exclusion_rule, "Disable the rule that protein bb/sc hbonds are excluded if the backbone group is already forming a hydrogen bond to a backbone group; with this flag, no hbonds are excluded" ).def(false);
option.add( basic::options::OptionKeys::score::symE_units, "Number of symmetric Units in design for use with symE scoring" ).def(-1);
option.add( basic::options::OptionKeys::score::symE_bonus, "Energy bonus per match for use with symE scoring" ).def(0.0);
option.add( basic::options::OptionKeys::score::NV_lbound, "Lower Bound for neighbor Vector scoring" ).def(3.3);
option.add( basic::options::OptionKeys::score::NV_ubound, "Upper Bound for neighbor Vector scoring" ).def(11.1);
option.add( basic::options::OptionKeys::score::NV_table, "Location of path to potential lookup table" ).def("scoring/score_functions/NV/neighbor_vector_score.histogram");
option.add( basic::options::OptionKeys::score::disable_orientation_dependent_rna_ch_o_bonds, "Do not use orientation-dependent potential for RNA carbon hydrogen bonds" ).def(false);
option.add( basic::options::OptionKeys::score::rna_torsion_potential, "In RNA torsion calculation, directory containing 1D torsional potentials" ).def("BLAHBLAHBLAH");
option.add( basic::options::OptionKeys::score::rna_torsion_skip_chainbreak, "Don't score RNA torsions located at the chain_breaks (aside from the ones that will be closed)" ).def(true);
option.add( basic::options::OptionKeys::score::include_neighbor_base_stacks, "In RNA score calculation, include stacks between i,i+1" ).def(false);
option.add( basic::options::OptionKeys::score::find_neighbors_3dgrid, "Use a 3D lookup table for doing neighbor calculations.  For spherical, well-distributed conformations, O(N) neighbor detection instead of general O(NlgN)" ).def(false);
option.add( basic::options::OptionKeys::score::seqdep_refene_fname, "Filename for table containing sequence-dependent reference energies" );
option.add( basic::options::OptionKeys::score::secondary_seqdep_refene_fname, "Additional filename for table containing sequence-dependent reference energies" );
option.add( basic::options::OptionKeys::score::exact_occ_pairwise, "When using occ_sol_exact, compute energies subject to pairwise additivity (not recommended - intended for parameterization / evaluation purposes)" ).def(false);
option.add( basic::options::OptionKeys::score::exact_occ_skip_Hbonders, "When using occ_sol_exact, do not count contributions from occluding groups which form Hbonds to the polar group of interest" ).def(true);
option.add( basic::options::OptionKeys::score::exact_occ_include_Hbond_contribution, "When using occ_sol_exact, include Hbonds in the solvation energy" ).def(false);
option.add( basic::options::OptionKeys::score::exact_occ_pairwise_by_res, "When using occ_sol_exact, compute energies subject to by-residue pairwise additivity (not recommended - intended for parameterization / evaluation purposes)" ).def(false);
option.add( basic::options::OptionKeys::score::exact_occ_split_between_res, "When using occ_sol_exact with the exact_occ_pairwise flag, split the energies between both contributing residues instead of assigning it just to the polar residue (not recommended - intended for parameterization / evaluation purposes)" ).def(false);
option.add( basic::options::OptionKeys::score::exact_occ_self_res_no_occ, "Setting this to false means that the self-residue CAN occlude when using the exact ODO model, leading to potential double-counting with the Dunbrack energy but better results in loop discrimination." ).def(false);
option.add( basic::options::OptionKeys::score::exact_occ_radius_scaling, "When using occ_sol_exact, scale the radii of occluding atoms by this factor (intended for parameterization / evaluation purposes)" ).def(1.0);
option.add( basic::options::OptionKeys::score::ref_offsets, "offset reference energies using 3 character residue types (example: TRP 0.9 HIS 0.3)" );
option.add( basic::options::OptionKeys::score::output_residue_energies, "Output the energy for each residue" ).def(false);
option.add( basic::options::OptionKeys::score::fa_custom_pair_distance_file, "Name of custom pair distance energy file" ).def("");
option.add( basic::options::OptionKeys::score::disulf_matching_probe, "Size of probe to use in disulfide matching score" ).def(2.5);
option.add( basic::options::OptionKeys::score::bonded_params, "Spring constants for bonded parameters [length,angle,torsion,proton-torsion] (default 600,300,300,60)" );
option.add( basic::options::OptionKeys::score::pro_close_planar_constraint, "stdev of CD,N,CA,prevC trigonal planar constraint in pro_close energy method" ).def(0.1);
option.add( basic::options::OptionKeys::score::linear_bonded_potential, "use linear (instead of quadratic) bonded potential" ).def(false);
option.add( basic::options::OptionKeys::score::saxs::saxs, "saxs option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::score::saxs::min_score, "minimum value of saxs score; the parameter is used to flatten the energy funnel around its minimum" ).def(-5);
option.add( basic::options::OptionKeys::score::saxs::custom_ff, "Name of config file providing extra from factors" ).def("");
option.add( basic::options::OptionKeys::score::saxs::print_i_calc, "File to optionally write scaled computed spectra" ).def("");
option.add( basic::options::OptionKeys::score::saxs::ref_fa_spectrum, "reads reference full-atom spectrum from a file" );
option.add( basic::options::OptionKeys::score::saxs::ref_cen_spectrum, "reads reference centroid spectrum from a file" );
option.add( basic::options::OptionKeys::score::saxs::ref_spectrum, "reads reference spectrum from a file" );
option.add( basic::options::OptionKeys::score::saxs::ref_pddf, "reads reference pairwise distance distribution function" );
option.add( basic::options::OptionKeys::score::saxs::skip_hydrogens, "skip hydrogen atoms" ).def(false);
option.add( basic::options::OptionKeys::score::saxs::d_min, "minimum value of distance used in PDDF score evaluation (in [A])" ).def(5.0);
option.add( basic::options::OptionKeys::score::saxs::d_max, "maximum value of distance used in PDDF score evaluation (in [A])" ).def(100.0);
option.add( basic::options::OptionKeys::score::saxs::d_step, "step of distance used in PDDF score evaluation (in [A])" ).def(0.1);
option.add( basic::options::OptionKeys::score::saxs::q_min, "minimum value of q used in spectra calculations (in [A^-1])" ).def(0.01);
option.add( basic::options::OptionKeys::score::saxs::q_max, "maximum value of q used in spectra calculations (in [A^-1])" ).def(0.25);
option.add( basic::options::OptionKeys::score::saxs::q_step, "step of q used in spectra calculations (in [A^-1])" ).def(0.01);
option.add( basic::options::OptionKeys::score::saxs::fit_pddf_area, "PDDF curve for a scored pose will be normalized to match the area under the reference PDDF curve" ).def(false);
option.add( basic::options::OptionKeys::score::sidechain_buried, "count buried residues (rvernon pilot app)" ).def(-1);
option.add( basic::options::OptionKeys::score::sidechain_exposed, "count exposed residues (rvernon pilot app)" ).def(-1);
option.add( basic::options::OptionKeys::score::hackelec_min_dis, "changes the minimum distance cut-off for hack-elec energy" ).def(1.5);
option.add( basic::options::OptionKeys::score::hackelec_max_dis, "changes the maximum distance cut-off for hack-elec energy" ).def(5.5);
option.add( basic::options::OptionKeys::score::hackelec_die, "changes the dielectric constant for hack-elec energy" ).def(10.0);
option.add( basic::options::OptionKeys::score::hackelec_r_option, "changes the dielectric from distance dependent to distance independent" ).def(false);
option.add( basic::options::OptionKeys::corrections::corrections, "corrections option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::corrections::correct, "turn on default corrections:-corrections::chemical:icoor_05_2009-corrections::score:p_aa_pp scoring/score_functions/P_AA_pp/P_AA_pp_08.2009-corrections::score:p_aa_pp_nogridshift-corrections::score:p_aa_pp_nogridshift-corrections::score:rama_not_squared-corrections::score:rama_map scoring/score_functions/rama/Rama.10.2009.yfsong.dat-scoring::hbond_params helix_hb_06_2009-corrections::score:hbond_fade 1.9 2.3 2.3 2.6 0.3 0.7 0.0 0.05-corrections::score:ch_o_bond_potential scoring/score_functions/carbon_hbond/ch_o_bond_potential_near_min_yf.dat" ).def(false);
option.add( basic::options::OptionKeys::corrections::score::score, "score option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::corrections::score::no_his_his_pairE, "Set pair term for His-His to zero" );
option.add( basic::options::OptionKeys::corrections::score::hbond_His_Phil_fix, "Phil's fix on Histidine interaction angular dependence" );
option.add( basic::options::OptionKeys::corrections::score::helix_hb_06_2009, "Helix backbone-backbone hbond potential with a different angular dependence" );
option.add( basic::options::OptionKeys::corrections::score::use_incorrect_hbond_deriv, "Use deprecated hbond derivative calculation." ).def(false);
option.add( basic::options::OptionKeys::corrections::score::p_aa_pp, "Name of scoring/score_functions/P_AA_pp/P_AA_PP potential file (search in the local directory first, then look in the database)" ).def("scoring/score_functions/P_AA_pp/P_AA_pp");
option.add( basic::options::OptionKeys::corrections::score::p_aa_pp_nogridshift, "the format of p_aa_pp changed from using i*10+5 (5, 15, etc) to i*10 (0,10,etc.) as grid points" );
option.add( basic::options::OptionKeys::corrections::score::rama_not_squared, "Rama potential calculated as input for both rama and rama2b. By default, the potential is square for (rama+entropy) > 1.0" );
option.add( basic::options::OptionKeys::corrections::score::rama_map, "Ramachandran file used by rama" ).def("scoring/score_functions/rama/Rama_smooth_dyn.dat_ss_6.4");
option.add( basic::options::OptionKeys::corrections::score::dun10, "Use the 2010 Dunbrack library instead of either the 2008 or the 2002 libraries." );
option.add( basic::options::OptionKeys::corrections::score::dun10_dir, "Name of dun10 dir" ).def("rotamer/ExtendedOpt1-5");
option.add( basic::options::OptionKeys::corrections::score::dun08, "Use the 2008 Dunbrack library instead of the 2002 library." );
option.add( basic::options::OptionKeys::corrections::score::dun08_dir, "Name of dun08 dir" ).def("rotamer/dun08");
option.add( basic::options::OptionKeys::corrections::score::dun02_file, "Name of dun02 input file" ).def("rotamer/bbdep02.May.sortlib");
option.add( basic::options::OptionKeys::corrections::score::ch_o_bond_potential, "Name of ch_o_bond potential file (search in the local directory first, then look in the database)" ).def("scoring/score_functions/carbon_hbond/ch_o_bond_potential.dat");
option.add( basic::options::OptionKeys::corrections::score::hack_elec_co_only, "Using only CO-CO interactions in hack_elec_bb_bb" ).def(false);
option.add( basic::options::OptionKeys::corrections::score::lj_hbond_hdis, "Lennard Jones sigma value for hatms, classically it's been at 1.95 but the average A-H distance for hydrogen bonding is 1.75 from crystal structures. (momeara)" ).def(1.95);
option.add( basic::options::OptionKeys::corrections::score::PB_potential_file, "Poisson Boltzmann potential file pre-calculated with APBS." );
option.add( basic::options::OptionKeys::corrections::score::PB_sidechain_only, "Only calculate interactions to sidechain." ).def(true);
option.add( basic::options::OptionKeys::corrections::score::PB_score_residue_range, "start and end residue sequence numbers to be included in the PB calculation" );
option.add( basic::options::OptionKeys::corrections::score::PB_revamp_near_chain, "Scale down PB interactions if near the given chain. Use chain numbers as input." );
option.add( basic::options::OptionKeys::corrections::score::PB_potential_cap, "Cap for PB potential input" ).def(20.0);
option.add( basic::options::OptionKeys::corrections::score::lj_hbond_OH_donor_dis, "Lennard Jones sigma value for O in OH donor groups.  Classically it has been 3.0 but the average distances from crystal structurs is 2.6 (momeara)" ).def(3.0);
option.add( basic::options::OptionKeys::corrections::score::score12prime, "Whenever getScoreFunction() would have returned the ScoreFunction from standard.wts + score12.wts_patch, instead return a revised score12 (score12prime) with reference energies optimized with optE for sequence profile recovery" ).def(false);
option.add( basic::options::OptionKeys::corrections::score::hb_sp2_chipen, "Experimental term for hydrogen bonds to sp2 acceptors: penalizes out-of-plane geometry by 67%" ).def(false);
option.add( basic::options::OptionKeys::corrections::score::hb_sp2_amp, "Experimental term for hydrogen bonds to sp2 acceptors: sets the amplitude of the sp2 hydrogen bond (greater than 1 upweights sp2 hydrogen bonds)" ).def(2.0);
option.add( basic::options::OptionKeys::corrections::score::hb_sp2_peak_heigh_above_trough, "Experimental term for hydrogen bonds to sp2 acceptors: sets the dynamic range between the most potent sp2 hydrogen bonds and the least potent" ).def(3.0);
option.add( basic::options::OptionKeys::corrections::score::hbond_measure_sp3acc_BAH_from_hvy, "If true, then the BAH angle for sp3 (aka hydroxyl) acceptors is measured donor-hydrogen--acceptor-heavyatom--heavyatom-base instead of donor-hydrogen--accptor-heavyatom--hydroxyl-hydrogen" ).def(false);
option.add( basic::options::OptionKeys::corrections::chemical::chemical, "chemical option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::corrections::chemical::icoor_05_2009, "New set of idealized coordinates for full atom, 05-2009" );
option.add( basic::options::OptionKeys::corrections::chemical::parse_charge, "Use PARSE charge set." );
option.add( basic::options::OptionKeys::willmatch::willmatch, "willmatch option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::willmatch::arg_dun_th, "fa_dun thresh for ARG" ).def(16.0);
option.add( basic::options::OptionKeys::willmatch::asp_dun_th, "fa_dun thresh for ASP" ).def(8.0);
option.add( basic::options::OptionKeys::willmatch::glu_dun_th, "fa_dun thresh for GLU" ).def(12.0);
option.add( basic::options::OptionKeys::willmatch::lys_dun_th, "fa_dun thresh for LYS" ).def(16.0);
option.add( basic::options::OptionKeys::willmatch::usecache, "use cached stage 1 data" ).def(false);
option.add( basic::options::OptionKeys::willmatch::write_reduced_matchset, "<name> <pdb1> <pdb2> ..." );
option.add( basic::options::OptionKeys::willmatch::interface_size, "num CB-CB within 8A" ).def(30);
option.add( basic::options::OptionKeys::willmatch::max_dis_any, "" ).def(3.0);
option.add( basic::options::OptionKeys::willmatch::max_dis_all, "" ).def(2.6);
option.add( basic::options::OptionKeys::willmatch::max_dis_hb, "" ).def(3.2);
option.add( basic::options::OptionKeys::willmatch::min_dis_hb, "" ).def(2.2);
option.add( basic::options::OptionKeys::willmatch::max_dis_hb_colinear, "" ).def(0.7);
option.add( basic::options::OptionKeys::willmatch::max_dis_metal, "" ).def(1.0);
option.add( basic::options::OptionKeys::willmatch::max_ang_metal, "" ).def(5.0);
option.add( basic::options::OptionKeys::willmatch::clash_dis, "" ).def(3.5);
option.add( basic::options::OptionKeys::willmatch::c2_linker_dist, "" ).def(3.5);
option.add( basic::options::OptionKeys::willmatch::identical_match_dis, "" ).def(0.0001);
option.add( basic::options::OptionKeys::willmatch::chi1_increment, "" ).def(10.0);
option.add( basic::options::OptionKeys::willmatch::chi2_increment, "" ).def(20.0);
option.add( basic::options::OptionKeys::willmatch::c2_symm_increment, "" ).def(20.0);
option.add( basic::options::OptionKeys::willmatch::cb_sasa_thresh, "" ).def(20.0);
option.add( basic::options::OptionKeys::willmatch::design_interface, "" ).def(true);
option.add( basic::options::OptionKeys::willmatch::chilist, "" );
option.add( basic::options::OptionKeys::willmatch::fixed_res, "" );
option.add( basic::options::OptionKeys::willmatch::native1, "" );
option.add( basic::options::OptionKeys::willmatch::native2, "" );
option.add( basic::options::OptionKeys::willmatch::exclude_res1, "" ).def("");
option.add( basic::options::OptionKeys::willmatch::exclude_res2, "" ).def("");
option.add( basic::options::OptionKeys::willmatch::taglist, "" );
option.add( basic::options::OptionKeys::willmatch::residues, "" );
option.add( basic::options::OptionKeys::willmatch::symmetry_d2, "" ).def(false);
option.add( basic::options::OptionKeys::willmatch::symmetry_c2_dock, "" ).def(false);
option.add( basic::options::OptionKeys::willmatch::splitwork, "" );
option.add( basic::options::OptionKeys::willmatch::exclude_ala, "" ).def(false);
option.add( basic::options::OptionKeys::willmatch::match_overlap_dis, "distance under which to consider matches redundant" ).def(00.20);
option.add( basic::options::OptionKeys::willmatch::match_overlap_ang, "ang(deg) under which to consider matches redundant" ).def(10.00);
option.add( basic::options::OptionKeys::willmatch::forbid_residues, "disallow residues for matching" );
option.add( basic::options::OptionKeys::willmatch::poi, "xyz coords of some site of interest" );
option.add( basic::options::OptionKeys::willmatch::poidis, "poi distance threshold" );
option.add( basic::options::OptionKeys::willmatch::homodimer, "examine only homodimer configs" ).def(false);
option.add( basic::options::OptionKeys::willmatch::fa_dun_thresh, "" ).def(6.0);
option.add( basic::options::OptionKeys::holes::holes, "holes option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::holes::dalphaball, "The DAlaphaBall_surf program" );
option.add( basic::options::OptionKeys::holes::params, "File containing score parameters" ).def("holes_params.dat");
option.add( basic::options::OptionKeys::holes::h_mode, "include H's or no... see PoseBalls.cc" ).def(0);
option.add( basic::options::OptionKeys::holes::water, "include water or no" ).def(false);
option.add( basic::options::OptionKeys::holes::make_pdb, "make pdb with scores" ).def(false);
option.add( basic::options::OptionKeys::holes::make_voids, "do separate SLOW void calculation" ).def(false);
option.add( basic::options::OptionKeys::holes::atom_scores, "output scores for all atoms" ).def(false);
option.add( basic::options::OptionKeys::holes::residue_scores, "output scores for all residues (avg over atoms)" ).def(false);
option.add( basic::options::OptionKeys::holes::cav_shrink, "Cavity ball radii reduced by this amount" ).def(0.7);
option.add( basic::options::OptionKeys::holes::minimize, "RosettaHoles params to use: decoy15, decoy25 or resl" ).def("decoy15");
option.add( basic::options::OptionKeys::packstat::packstat, "packstat option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::packstat::include_water, "Revert to old style etables" ).def(false);
option.add( basic::options::OptionKeys::packstat::oversample, "Precision of SASA measurements" ).def(0);
option.add( basic::options::OptionKeys::packstat::packstat_pdb, "Output a pdb with packing visualizations" ).def(false);
option.add( basic::options::OptionKeys::packstat::surface_accessibility, "Compute extra cavity burial information" ).def(false);
option.add( basic::options::OptionKeys::packstat::residue_scores, "Output the score for each resdiue" ).def(false);
option.add( basic::options::OptionKeys::packstat::cavity_burial_probe_radius, "Radius probe to consider a cavity buried" ).def(1.4);
option.add( basic::options::OptionKeys::packstat::raw_stats, "Output the raw stats per-residue (for training, etc...)" ).def(false);
option.add( basic::options::OptionKeys::packstat::threads, "Number of threads to use (0 for no threading)" ).def(0);
option.add( basic::options::OptionKeys::packstat::cluster_min_volume, "voids smaller than this will not be shown." ).def(30);
option.add( basic::options::OptionKeys::packstat::min_surface_accessibility, "voids must be at least this exposed" ).def(-1.0);
option.add( basic::options::OptionKeys::packstat::min_cluster_overlap, "void-balls must overlap by this much to be clustered" ).def(0.1);
option.add( basic::options::OptionKeys::packstat::min_cav_ball_radius, "radius of smallest void-ball to consider" ).def(0.7);
option.add( basic::options::OptionKeys::packstat::max_cav_ball_radius, "radius of largest void-ball to consider" ).def(3.0);
option.add( basic::options::OptionKeys::crossmatch::crossmatch, "crossmatch option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::crossmatch::write_reduced_matchset, "<name> <pdb1> <pdb2> ..." );
option.add( basic::options::OptionKeys::crossmatch::interface_size, "num CB-CB within 8A" ).def(30);
option.add( basic::options::OptionKeys::crossmatch::max_dis_any, "" ).def(3.0);
option.add( basic::options::OptionKeys::crossmatch::max_dis_all, "" ).def(2.6);
option.add( basic::options::OptionKeys::crossmatch::max_dis_metal, "" ).def(1.0);
option.add( basic::options::OptionKeys::crossmatch::clash_dis, "" ).def(3.0);
option.add( basic::options::OptionKeys::crossmatch::identical_match_dis, "" ).def(0.0001);
option.add( basic::options::OptionKeys::smhybrid::smhybrid, "smhybrid option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::smhybrid::add_cavities, "output cavities in result pdbs" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::abinitio_design, "do a design run in centroid mode" ).def(true);
option.add( basic::options::OptionKeys::smhybrid::fa_refine, "Do nobu's flxbb" ).def(true);
option.add( basic::options::OptionKeys::smhybrid::virtual_nterm, "remove Nterm" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::debug, "debug" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::refine, "don't do bit centroid moves" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::filter, "filter centroid results as you go" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::floating_scs_rep, "should floating scs repel those in other subunits?" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::flxbb, "allow bb moves in minimization" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::centroid_all_val, "mutate all to VAL in centroid mode" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::subsubs_attract, "attract subsubs togeher" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::linker_cst, "attract N/C termini for linker" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::pseudosym, "HACK pseudosymmetry" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::design_linker, "allow design on added 'linker' residues" ).def(true);
option.add( basic::options::OptionKeys::smhybrid::design, "allow design on added 'linker' residues" ).def(true);
option.add( basic::options::OptionKeys::smhybrid::restrict_design_to_interface, "allow design on added 'linker' residues" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::restrict_design_to_subsub_interface, "allow design on added 'linker' residues" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::design_hydrophobic, "design all hydrophobic" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::add_metal_at_0, "DEPRECATED" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::nres_mono, "target number of residues per monomer" ).def(20);
option.add( basic::options::OptionKeys::smhybrid::abinitio_cycles, "number of abinitio cycles" ).def(10000);
option.add( basic::options::OptionKeys::smhybrid::primary_subsubunit, "primary subunut" ).def(1);
option.add( basic::options::OptionKeys::smhybrid::minbb, "level of bb min 0=None 1=little 2=all" ).def(1);
option.add( basic::options::OptionKeys::smhybrid::switch_concert_sub, "assume prmary subsub is on this subunit for concerted RB moves" ).def(1);
option.add( basic::options::OptionKeys::smhybrid::temperature, "MC temp for cen fold" ).def(2.0);
option.add( basic::options::OptionKeys::smhybrid::inter_subsub_cst, "add dis csts inter-subsub" ).def(false);
option.add( basic::options::OptionKeys::smhybrid::rb_mag, "magnitude of rb moves" ).def(1.0);
option.add( basic::options::OptionKeys::smhybrid::ss, "secondary structure" ).def("");
option.add( basic::options::OptionKeys::smhybrid::symm_def_template, "template for symmetry definition file" );
option.add( basic::options::OptionKeys::smhybrid::symm_def_template_reduced, "template for reduced symmetry definition file" );
option.add( basic::options::OptionKeys::smhybrid::attach_as_sc, "attach the group via side chain" );
option.add( basic::options::OptionKeys::smhybrid::attach_as_sc_sub, "attach the group via side chain in this sub" );
option.add( basic::options::OptionKeys::smhybrid::inversion_subs, "subunits to be inverted, if any" );
option.add( basic::options::OptionKeys::smhybrid::chainbreaks, "close chainbreak from this subsub to the next" );
option.add( basic::options::OptionKeys::smhybrid::design_res_files, "files containing designable residues for each component pose" ).def("");
option.add( basic::options::OptionKeys::smhybrid::fixed_res_files, "files containing fixed residues (no repack even) for each component pose" ).def("");
option.add( basic::options::OptionKeys::smhybrid::frag_res_files, "files containing residues ok to insert frags into. will have starting ss" ).def("");
option.add( basic::options::OptionKeys::smhybrid::scattach_res_files, "files containing residues ok to scattach to." ).def("");
option.add( basic::options::OptionKeys::smhybrid::rep_edge_files, "files containing residues which are edge strands." ).def("");
option.add( basic::options::OptionKeys::smhybrid::virtual_res_files, "files containing residues that should be virtual" ).def("");
option.add( basic::options::OptionKeys::smhybrid::jumpcut_files, "file specifying jumps and cuts for subsubunits" ).def("");
option.add( basic::options::OptionKeys::smhybrid::cst_sub_files, "file specifying which subunits are part of a structural unit and shoudl be constrained" ).def("");
option.add( basic::options::OptionKeys::smhybrid::symm_file_tag, "label for each subunit" ).def("");
option.add( basic::options::OptionKeys::smhybrid::attach_atom, "attach atom on each subunit" ).def("");
option.add( basic::options::OptionKeys::smhybrid::add_res_before, "SS to add before each subunit region" ).def("");
option.add( basic::options::OptionKeys::smhybrid::add_res_after, "SS to add after each subunit region" ).def("");
option.add( basic::options::OptionKeys::smhybrid::add_ss_before, "residues to add" ).def("");
option.add( basic::options::OptionKeys::smhybrid::add_ss_after, "SS to add after each subunit region" ).def("");
option.add( basic::options::OptionKeys::smhybrid::add_atom_at_cen, "SS to add after each subunit region" ).def("");
option.add( basic::options::OptionKeys::smhybrid::attach_rsd, "attach rsd on each subunit" ).def("");
option.add( basic::options::OptionKeys::evolution::evolution, "evolution option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::evolution::parentlist, "File(s) containing list(s) of Parent PDB files to process" );
option.add( basic::options::OptionKeys::evolution::childlist, "File(s) containing list(s) of Parent PDB files to process" );
option.add( basic::options::OptionKeys::evolution::action, "One of the following:  diversify, intensify " ).def("diversify");
option.add( basic::options::OptionKeys::evolution::rms_threshold, "RMS Clustering threshold" ).def(3.5);
option.add( basic::options::OptionKeys::evolution::rms_topmargin, "RMS Clustering threshold" ).def(5.0);
option.add( basic::options::OptionKeys::evolution::targetdir, "Write target new parent polulation to this directory ! " ).def("./");
option.add( basic::options::OptionKeys::evolution::padding_score_filter, "RMS Clustering threshold" ).def(5.0);
option.add( basic::options::OptionKeys::evolution::padding_stage2_filter, "RMS Clustering threshold" ).def(15.0);
option.add( basic::options::OptionKeys::cluster::cluster, "cluster option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::cluster::lite, "uses light-weight method of outputting cluster-centers, useful for when there's a HUGE amount of data!" ).def(false);
option.add( basic::options::OptionKeys::cluster::input_score_filter, "Only read in structures below a certain energy" ).def(1000000.0);
option.add( basic::options::OptionKeys::cluster::output_score_filter, "Only read in structures below a certain energy" ).def(1000000.0);
option.add( basic::options::OptionKeys::cluster::exclude_res, "Residue numbers to be excluded from cluster RMS calculation" ).def(-1);
option.add( basic::options::OptionKeys::cluster::thinout_factor, "Ignore this fraction of decoys in the first round !" ).def(-1);
option.add( basic::options::OptionKeys::cluster::max_cluster_seeds, "Do not calculate initial cluster centers for more then this many structuers" ).def(500);
option.add( basic::options::OptionKeys::cluster::radius, "Cluster radius" ).def(3.0);
option.add( basic::options::OptionKeys::cluster::limit_cluster_size, "For each cluster only retain top N " ).def(-1);
option.add( basic::options::OptionKeys::cluster::limit_clusters, "Only retain largest N clusters" ).def(100);
option.add( basic::options::OptionKeys::cluster::limit_total_structures, "Only retain the first N structures (ordered by cluster number)" ).def(-1);
option.add( basic::options::OptionKeys::cluster::max_total_cluster, "Only ever make N clusters or less" ).def(1000);
option.add( basic::options::OptionKeys::cluster::gdtmm, "Cluster by gdtmm instead of RMS" ).def(false);
option.add( basic::options::OptionKeys::cluster::sort_groups_by_energy, "Sort clusters by energy" ).def(false);
option.add( basic::options::OptionKeys::cluster::sort_groups_by_size, "Sort clusters by energy" ).def(false);
option.add( basic::options::OptionKeys::cluster::remove_singletons, "Get rid of single-member clusters" ).def(false);
option.add( basic::options::OptionKeys::cluster::export_only_low, "Print only the lowest energy member" ).def(false);
option.add( basic::options::OptionKeys::cluster::remove_highest_energy_member, "Remove highest energy member from each cluster" ).def(false);
option.add( basic::options::OptionKeys::cluster::idealize_final_structures, "Run an idealization over the resulting structures" ).def(false);
option.add( basic::options::OptionKeys::cluster::limit_dist_matrix, "Only calculate full matrix for a subset of structres. Then simply assign structures to nearest cluster" ).def(-1);
option.add( basic::options::OptionKeys::cluster::make_ensemble_cst, "Create a set of constraints describing the variablity in each cluster of each residue." ).def(false);
option.add( basic::options::OptionKeys::cluster::hotspot_hash, "Cluster hotspot hashing results. Each input PDB must contain both the target and the newly docked hotspot (which should be the last residue in the pose)." ).def(false);
option.add( basic::options::OptionKeys::cluster::loops, "Cluster this loop" ).def(false);
option.add( basic::options::OptionKeys::cluster::population_weight, "Order Clusters by (1-p)*score - p*size whpere p = population_weight " ).def(0.09);
option.add( basic::options::OptionKeys::cluster::template_scores, "imple textfile containing template names (in caps) and scores." );
option.add( basic::options::OptionKeys::cluster::K_level, "Hierarchical cluster level number" ).def(1);
option.add( basic::options::OptionKeys::cluster::K_radius, "Radius list of different level of cluster" ).def(utility::vector1<float>(1, 2.0));
option.add( basic::options::OptionKeys::cluster::K_n_cluster, "How many clusters in each level" ).def(utility::vector1<int>(1, 10000));
option.add( basic::options::OptionKeys::cluster::K_style, "Which K-cluster engine to use" ).def(utility::vector1<std::string>(9, "GKC"));
option.add( basic::options::OptionKeys::cluster::K_threshold, "Threshold for test the convergence of iteration" ).def(0.01);
option.add( basic::options::OptionKeys::cluster::K_n_sub, "Number of clusters in subdir" ).def(100);
option.add( basic::options::OptionKeys::cluster::K_deque_size, "Size of subcluster deque" ).def(20);
option.add( basic::options::OptionKeys::cluster::K_deque_level, "Provide deque in top level" ).def(1);
option.add( basic::options::OptionKeys::cluster::K_redundant, "Keep all the higher level center structure in sub-pools" ).def(true);
option.add( basic::options::OptionKeys::cluster::K_not_fit_xyz, "Do not rotate xyz when calculate rmsd" ).def(false);
option.add( basic::options::OptionKeys::cluster::K_save_headers, "Save headers in silent file" ).def(false);
option.add( basic::options::OptionKeys::rescore::rescore, "rescore option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::rescore::pose_metrics, "Do pose metrics calc" );
option.add( basic::options::OptionKeys::rescore::skip, "Dont actually call scoring function (i.e. get evaluators only)" );
option.add( basic::options::OptionKeys::rescore::verbose, "Full break down of weights, raw scores and weighted scores ?" );
option.add( basic::options::OptionKeys::rescore::msms_analysis, "Run MSMS on the structure and determine surface properties. " );
option.add( basic::options::OptionKeys::mc::mc, "mc option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::mc::hierarchical_pool, "specify prefix in order to look for hierarchical pool" );
option.add( basic::options::OptionKeys::mc::read_structures_into_pool, "specify the silent-structs to create a hierarchy for lazy users" );
option.add( basic::options::OptionKeys::mc::convergence_check_frequency, "how often check for convergences in MC object?" ).def(100);
option.add( basic::options::OptionKeys::mc::known_structures, "specify a filename of a silent-file containing known structures" ).def("known_structs.in");
option.add( basic::options::OptionKeys::mc::max_rmsd_against_known_structures, "stop sampling if rmsd to a known-structure is lower than X" ).def(1.5);
option.add( basic::options::OptionKeys::mc::heat_convergence_check, "jump out of current abinitio run if X unsuccesful mc-trials reached" ).def(0);
option.add( basic::options::OptionKeys::batch_relax::batch_relax, "batch_relax option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::batch_relax::batch_size, "Size of batches - note that thsie affects memory usage significantly" ).def(100);
option.add( basic::options::OptionKeys::relax::relax, "relax option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::relax::fast, "Do a preset, small cycle number FastRelax" );
option.add( basic::options::OptionKeys::relax::thorough, "Do a preset, large cycle number FastRelax" );
option.add( basic::options::OptionKeys::relax::membrane, "Do membrane relax" ).def(false);
option.add( basic::options::OptionKeys::relax::default_repeats, "Default number of repeats done by FastRelax. Has no effect if a custom script is used!" ).def(5);
option.add( basic::options::OptionKeys::relax::ramady, "Run ramady code which aleviates stuck bad ramachandran energies" ).def(false);
option.add( basic::options::OptionKeys::relax::ramady_rms_limit, "(ramady-only) Reject rama changes which perturb structure by more than this" ).def(0.5);
option.add( basic::options::OptionKeys::relax::ramady_cutoff, "(ramady-only) Cutoff at which a rama is considered bad" ).def(2.0);
option.add( basic::options::OptionKeys::relax::ramady_max_rebuild, "(ramady-only) The maximum number of bad ramas to fix per repack-min cycle" ).def(1);
option.add( basic::options::OptionKeys::relax::ramady_force, "(ramady-only) Force rebuilding of bad ramas (normal skip-rate = 10%)" ).def(false);
option.add( basic::options::OptionKeys::relax::script, "Relax script file" ).def("");
option.add( basic::options::OptionKeys::relax::script_max_accept, "Limit number of best accepts" ).def(10000000);
option.add( basic::options::OptionKeys::relax::superimpose_to_native, "Superimpose input structure to native" ).def(false);
option.add( basic::options::OptionKeys::relax::superimpose_to_file, "Superimpose input structure to file" ).def("false");
option.add( basic::options::OptionKeys::relax::constrain_relax_to_native_coords, "For relax and fastrelax, tether backbone coordinates of the pdbs being relaxed to the coordinates in the xtal native" ).def(false);
option.add( basic::options::OptionKeys::relax::constrain_relax_to_start_coords, "For relax and fastrelax, tether backbone coordinates of the pdbs being relaxed to the coordinates in the xtal native" ).def(false);
option.add( basic::options::OptionKeys::relax::coord_constrain_sidechains, "For relax and fastrelax, also tether sidechain heavy atom coordinates (requires either -constrain_relax_to_native_coords or -constrain_relax_to_start_coords)" ).def(false);
option.add( basic::options::OptionKeys::relax::sc_cst_maxdist, "Use distance constraints between pairs of input side-chains atoms which are closer than the given upper distance cutoff (0 => no sc-sc restraints)" ).def(0.0);
option.add( basic::options::OptionKeys::relax::limit_aroma_chi2, "limit chi2 rotamer of PHE,TYR, and HIS around 90 " ).def(false);
option.add( basic::options::OptionKeys::relax::bb_move, "allow backbone to move during relax" ).def(true);
option.add( basic::options::OptionKeys::relax::chi_move, "allow sidechain to move during relax" ).def(true);
option.add( basic::options::OptionKeys::relax::jump_move, "allow jump to move during relax" ).def(false);
option.add( basic::options::OptionKeys::relax::minimize_bond_lengths, "Free bond length DOFs during relax for all atoms" ).def(false);
option.add( basic::options::OptionKeys::relax::minimize_bond_angles, "Free bond angle DOFs during relax for all atoms" ).def(false);
option.add( basic::options::OptionKeys::relax::minimize_mainchain_bond_lengths, "Free bond length DOFs for mainchain heavy atoms" ).def(false);
option.add( basic::options::OptionKeys::relax::minimize_mainchain_bond_angles, "Free bond angle DOFs for mainchain heavy atoms" ).def(false);
option.add( basic::options::OptionKeys::relax::min_type, "minimizer to use during relax." ).def("dfpmin_armijo_nonmonotone");
option.add( basic::options::OptionKeys::relax::cartesian, "Use Cartesian minimizer" ).def(false);
option.add( basic::options::OptionKeys::relax::chainbreak_weight, "chainbreak weight" ).def(0.0);
option.add( basic::options::OptionKeys::relax::linear_chainbreak_weight, "linear chainbreak weight" ).def(0.0);
option.add( basic::options::OptionKeys::relax::overlap_chainbreak_weight, "overlap chainbreak weight" ).def(0.0);
option.add( basic::options::OptionKeys::relax::classic, "Do very old classic relax ! This is a poor protocol - don't use it !" );
option.add( basic::options::OptionKeys::relax::sequence_file, "Relax script file" ).def("");
option.add( basic::options::OptionKeys::relax::quick, "Do a preset, small cycle number FastRelax" );
option.add( basic::options::OptionKeys::relax::sequence, "Do a preset, small cycle number FastRelax" );
option.add( basic::options::OptionKeys::relax::minirelax_repeats, "" ).def(2);
option.add( basic::options::OptionKeys::relax::minirelax_sdev, "tether on coordinate constraints for minirelax" ).def(0.5);
option.add( basic::options::OptionKeys::relax::wobblemoves, "Do Wobble moves ?" ).def(false);
option.add( basic::options::OptionKeys::relax::constrain_relax_segments, "loop definition file" ).def("");
option.add( basic::options::OptionKeys::relax::coord_cst_width, "Width on coordinate constraints from constrain_relax_* options" ).def(0.0);
option.add( basic::options::OptionKeys::relax::coord_cst_stdev, "Stdev on coordinate constraints from constrain_relax_* options" ).def(0.5);
option.add( basic::options::OptionKeys::relax::ramp_constraints, "Ramp constraints during phase1 of relax from full to zero" ).def(false);
option.add( basic::options::OptionKeys::relax::energycut, "Rottrial energycut (per residue!)" ).def(0.01);
option.add( basic::options::OptionKeys::relax::mini, "perform a relax that is only a minimization and repack." ).def(false);
option.add( basic::options::OptionKeys::relax::stage1_ramp_cycles, "Ramp cyclesin stage 1 " ).def(8);
option.add( basic::options::OptionKeys::relax::stage1_ramp_inner_cycles, "Inner cycles means how many small shear moves + rottrials" ).def(1);
option.add( basic::options::OptionKeys::relax::stage2_repack_period, "Full repack after how many cycles in stage 2" ).def(100);
option.add( basic::options::OptionKeys::relax::stage2_cycles, "How many stage 2 cycles ? (by default its -1 means Nresidues*4 )" ).def(-1);
option.add( basic::options::OptionKeys::relax::min_tolerance, "Minimizer tolerance" ).def(0.00025);
option.add( basic::options::OptionKeys::relax::stage3_cycles, "How many stage 3 cycles ? (by default its -1 means Nresidues )" ).def(-1);
option.add( basic::options::OptionKeys::relax::cycle_ratio, "Post-multiplier for cycle numbers" ).def(1.0);
option.add( basic::options::OptionKeys::relax::filter_stage2_beginning, "FArelax score filter" ).def(99999999.00);
option.add( basic::options::OptionKeys::relax::filter_stage2_quarter, "FArelax score filter" ).def(99999999.00);
option.add( basic::options::OptionKeys::relax::filter_stage2_half, "FArelax score filter" ).def(99999999.00);
option.add( basic::options::OptionKeys::relax::filter_stage2_end, "FArelax score filter" ).def(99999999.00);
option.add( basic::options::OptionKeys::enzdes::enzdes, "enzdes option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::enzdes::checkpoint, "write/read checkpoint files to the desired filename." ).def("");
option.add( basic::options::OptionKeys::enzdes::enz_score, "prevent repacking in enzyme design calculation" ).def(false);
option.add( basic::options::OptionKeys::enzdes::enz_repack, "prevent redesign in enzyme design calculation" ).def(false);
option.add( basic::options::OptionKeys::enzdes::cst_opt, "pre design constraint minimization" ).def(false);
option.add( basic::options::OptionKeys::enzdes::cst_predock, "docks a ligand relative the catalytic residue" ).def(false);
option.add( basic::options::OptionKeys::enzdes::trans_magnitude, "rigid body translation in Angstrom" ).def(0.1);
option.add( basic::options::OptionKeys::enzdes::rot_magnitude, "rigid body rotation in deg" ).def(2);
option.add( basic::options::OptionKeys::enzdes::dock_trials, "number of docking trials" ).def(100);
option.add( basic::options::OptionKeys::enzdes::cst_min, "after design minimization, constraints turned off" ).def(false);
option.add( basic::options::OptionKeys::enzdes::cst_design, "invokes actual design" ).def(false);
option.add( basic::options::OptionKeys::enzdes::design_min_cycles, "determines how many iterations of designing/minimizing are done during a design run" ).def(1);
option.add( basic::options::OptionKeys::enzdes::make_consensus_mutations, "Invokes mutations back to sequence profile consensus throughout whole protein in EnzdesFixBB protocol. sequence profile file must be specified through -in:pssm option." ).def(false);
option.add( basic::options::OptionKeys::enzdes::bb_min, "allows backbone of active site residues to move during cst_opt and cst_min. In the cst_opt stage, residue Cas will be constrained to their original positions." ).def(false);
option.add( basic::options::OptionKeys::enzdes::bb_min_allowed_dev, "distance by which Cas are allowed to move during backbone minimization before a penalty is assigned." ).def(0.5);
option.add( basic::options::OptionKeys::enzdes::loop_bb_min_allowed_dev, "distance by which Cas are allowed to move during backbone minimization before a penalty is assigned. Applied only for loops as determined by DSSP." ).def(0.5);
option.add( basic::options::OptionKeys::enzdes::minimize_ligand_torsions, "degrees by which ligand torsions are allowed to rotate before a penalty is assigned. Only those torsions which have diversity in the conformational ensemble are allowed this std dev. rest are constrained to 0.1" ).def(10.0);
option.add( basic::options::OptionKeys::enzdes::minimize_all_ligand_torsions, "allows constrained minimization of all ligand torsions using stddev." ).def(10.0);
option.add( basic::options::OptionKeys::enzdes::chi_min, "allows chi values of active site residues to move during cst_opt and cst_min." ).def(false);
option.add( basic::options::OptionKeys::enzdes::min_all_jumps, "allows all jumps in the pose to minimize  during cst_opt and cst_min. By default only ligand-associated jumps minimize" ).def(false);
option.add( basic::options::OptionKeys::enzdes::cst_dock, "ligand docking after design. By default, constraints (except covalent connections will be turned off for this stage." ).def(false);
option.add( basic::options::OptionKeys::enzdes::run_ligand_motifs, "run ligand motif search and add motif rotamers to packer" ).def(false);
option.add( basic::options::OptionKeys::enzdes::enz_debug, "invokes various debug routines around the enzdes code" ).def(false);
option.add( basic::options::OptionKeys::enzdes::cstfile, "file that contains all necessary constraints for an enzyme design calculation" ).def("constraints.cst");
option.add( basic::options::OptionKeys::enzdes::enz_loops_file, "file that contains definitions of loop regions" ).def("eloops.els");
option.add( basic::options::OptionKeys::enzdes::flexbb_protocol, "triggers flexible backbone design" ).def(false);
option.add( basic::options::OptionKeys::enzdes::remodel_protocol, "triggers remodel protocol design" ).def(false);
option.add( basic::options::OptionKeys::enzdes::kic_loop_sampling, "Generate alternate loop conformations using KIC loop closure instead of backrub" ).def(false);
option.add( basic::options::OptionKeys::enzdes::dump_loop_samples, "yes/no? Create loop pdb files named loopreg_[regionid]_[whichsample].pdb for the chosen loop samples; if 'quit_afterwards' is given, then the program exits after all loops have been generated" ).legal("no").legal("yes").legal("quit_afterwards").def("no");
option.add( basic::options::OptionKeys::enzdes::fix_catalytic_aa, "preventing catalytic aa from repacking" ).def(false);
option.add( basic::options::OptionKeys::enzdes::additional_packing_ligand_rb_confs, "Ligand Rotamers will be built at additional random rigid body positions during packing" ).def(0);
option.add( basic::options::OptionKeys::enzdes::ex_catalytic_rot, "convenience option to use higher number of rotamers for catalytic residues. The chosen level will be applied to all chis of every catalytic residue." ).legal(0).legal(1).legal(2).legal(3).legal(4).legal(5).legal(6).legal(7).def(1);
option.add( basic::options::OptionKeys::enzdes::single_loop_ensemble_size, "number of conformations generated for each of the independent loops in a flexbb calculation" ).def(100);
option.add( basic::options::OptionKeys::enzdes::loop_generator_trials, "number of trials of that the respective loop generator(backrub/kinematic kic) does in enzdes flexbb" ).def(200);
option.add( basic::options::OptionKeys::enzdes::no_catres_min_in_loopgen, "prevents minimization of catalytic residues when generating loop ensembles" ).def(false);
option.add( basic::options::OptionKeys::enzdes::mc_kt_low, "low monte carlo limit for ensemble generation using backrub" ).def(0.6);
option.add( basic::options::OptionKeys::enzdes::mc_kt_high, "high monte carlo limit for ensemble generation using backrub" ).def(0.9);
option.add( basic::options::OptionKeys::enzdes::min_cacb_deviation, "Fragment uniqueness filter. On by default.  Minimum CA/CB average deviation that at least one residue must have from all other already-included fragments for a new fragment to be included" ).def(0.3);
option.add( basic::options::OptionKeys::enzdes::max_bb_deviation, "Fragment smoothness filter.  Off by default. Upper limit on the backbone average deviation a new fragment may have to its most-similar fragment that has already been included in the fragment set." ).def(0.1);
option.add( basic::options::OptionKeys::enzdes::max_bb_deviation_from_startstruct, "Fragment native-proximity Filter. Always on. Maximum tolerated backbone average deviation from the starting backbone for a fragment that to be included in the fragment set." ).def(1.5);
option.add( basic::options::OptionKeys::enzdes::flexbb_outstructs, "doesn't do much anymore in the current implementation of the flexbb protocol" ).def(10);
option.add( basic::options::OptionKeys::enzdes::remodel_trials, "how often each loop is being remodeled in the enzdes_remodel mover" ).def(100);
option.add( basic::options::OptionKeys::enzdes::remodel_secmatch, "if constrained interactions are missing in the pose during remodel, the SecondaryMatcher will be used to try to find them in the remodeled region. very experimental at this point" ).def(false);
option.add( basic::options::OptionKeys::enzdes::dump_inverse_rotamers, "in case of remodel secmatching against inverse rotamers, these rotamers will be dumped before the protocol starts for visual inspection by the user" ).def(false);
option.add( basic::options::OptionKeys::enzdes::remodel_aggressiveness, "determines the aggressiveness with which a given loop is remodeled. legal values between 0 and 1, where 1 is aggressive and 0 conservative." ).def(0.1);
option.add( basic::options::OptionKeys::enzdes::favor_native_res, "a bonus energy assigned to the native res during a design calculation" ).def(0.5);
option.add( basic::options::OptionKeys::enzdes::detect_design_interface, "automatically detect design/repack region around ligand(s)" ).def(false);
option.add( basic::options::OptionKeys::enzdes::include_catres_in_interface_detection, "if option -detect_design_interface is active, invoking this option causes all residues that are within the specified cuts of any catalytic residue are also set to designing/repacking" ).def(false);
option.add( basic::options::OptionKeys::enzdes::arg_sweep_interface, "Use protein-DNA design-like interface detection, involving generation of arginine rotamers at each position, checking to see if argininte can make interaction with ligand." ).def(false);
option.add( basic::options::OptionKeys::enzdes::arg_sweep_cutoff, "Interaction cutoff distance from arginine to ligand when performing arginine sweep interface detection." ).def(3.7);
option.add( basic::options::OptionKeys::enzdes::cut1, "option to specify redesign cutoff 1 in enzdes calculation" ).def(0.0);
option.add( basic::options::OptionKeys::enzdes::cut2, "option to specify redesign cutoff 2 in enzdes calculation" ).def(0.0);
option.add( basic::options::OptionKeys::enzdes::cut3, "option to specify repack cutoff 1 in enzdes calculation" ).def(10.0);
option.add( basic::options::OptionKeys::enzdes::cut4, "option to specify repack cutoff 2 in enzdes calculation" ).def(10.0);
option.add( basic::options::OptionKeys::enzdes::lig_packer_weight, "specifies the weights for protein ligand interaction during packing (and only packing!! )" ).def(1.0);
option.add( basic::options::OptionKeys::enzdes::no_unconstrained_repack, "no unconstrained repacking after the design stage" ).def(false);
option.add( basic::options::OptionKeys::enzdes::secmatch_Ecutoff, "the maximum constraint energy at which a residue is accepted in the secondary matcher" ).def(1.0);
option.add( basic::options::OptionKeys::enzdes::change_lig, "Can be used with the secondary matching protocol if different incarnations of the ligand are used for design and primary matching. The file needs to contain information on what atoms to superimpose." ).def("ligchange_file.txt");
option.add( basic::options::OptionKeys::enzdes::process_ligrot_separately, "In the EnzdesFixBB protocol, causes the protocol to be executed separately for all non_bb clashing ligand rotamers." ).def("default_lig");
option.add( basic::options::OptionKeys::enzdes::start_from_random_rb_conf, "In the EnzdesFixBB protocol, if there are additional ligand rigid body conformations available (from a multimodel pdb), a random one of these will be the starting point for the protocol." ).def(false);
option.add( basic::options::OptionKeys::enzdes::bb_bump_cutoff, "option to specify the maximum allowed backbone energie when replacing a new residue type" ).def(2.0);
option.add( basic::options::OptionKeys::enzdes::sc_sc_bump_cutoff, "option to specify the maximum allowed energy between two newly placed sidechains in the secondary matcher" ).def(2.0);
option.add( basic::options::OptionKeys::enzdes::no_packstat_calculation, "will determine whether the computationally intensive packstat calculation will be done at the end of a run" ).def(false);
option.add( basic::options::OptionKeys::enzdes::compare_native, "triggers comparison of every designed structure to its respective native pdb. the value of the option needs to be a directory path that contains all the native pdb files" ).def("./");
option.add( basic::options::OptionKeys::enzdes::final_repack_without_ligand, "if a scorefile is requested, this option triggers every structure to be repacked without the ligand. the resulting structure will be output in a multimodel pdb, and differences in energy and rmsd are added to the scorefile." ).def(false);
option.add( basic::options::OptionKeys::enzdes::dump_final_repack_without_ligand_pdb, "If option -final_repack_without_ligand is active, this option will cause the repacked structure to be separately dumped." ).def(false);
option.add( basic::options::OptionKeys::enzdes::parser_read_cloud_pdb, "read cloud format PDB for enzdes in rosetta scripts" ).def(false);
option.add( basic::options::OptionKeys::packing::packing, "Packing option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::packing::repack_only, "Disable design at all positions" ).def(false);
option.add( basic::options::OptionKeys::packing::prevent_repacking, "Disable repacking (or design) at all positions" ).def(false);
option.add( basic::options::OptionKeys::packing::ndruns, "Number of fixbb packing iterations.  Each time packing occurs, it will pack this many times and return only the best result.  Implemented at level of PackRotamersMover." ).lower(1).def(1);
option.add( basic::options::OptionKeys::packing::soft_rep_design, "Use larger LJ radii for softer potential" );
option.add( basic::options::OptionKeys::packing::use_electrostatic_repulsion, "Use electrostatic repulsion" );
option.add( basic::options::OptionKeys::packing::dump_rotamer_sets, "Output NMR-style PDB's with the rotamer sets used during packing" );
option.add( basic::options::OptionKeys::packing::dunbrack_prob_buried, "fraction of possible dunbrack rotamers to include in each single residue rotamer set, for 'buried' residues" ).lower(0).upper(1).def(0.98);
option.add( basic::options::OptionKeys::packing::dunbrack_prob_nonburied, "fraction of possible dunbrack rotamers to include in each single residue rotamer set, for 'nonburied' residues" ).lower(0).upper(1).def(0.95);
option.add( basic::options::OptionKeys::packing::dunbrack_prob_nonburied_semirotameric, "fraction of possible dunbrack rotamers to include in each single residue rotamer set, for 'nonburied', semi-rotameric residues" ).lower(0).upper(1).def(0.95);
option.add( basic::options::OptionKeys::packing::no_optH, "Do not optimize hydrogen placement at the time of a PDB load" ).def(true);
option.add( basic::options::OptionKeys::packing::optH_MCA, "If running optH, use the Multi-Cool Annealer (more consistent, but slower)" ).def(false);
option.add( basic::options::OptionKeys::packing::pack_missing_sidechains, "Run packer to fix residues with missing sidechain density at PDB load" ).def(true);
option.add( basic::options::OptionKeys::packing::preserve_c_beta, "Preserve c-beta positions during rotamer construction" );
option.add( basic::options::OptionKeys::packing::flip_HNQ, "Consider flipping HIS, ASN, and GLN during hydrogen placement optimization" );
option.add( basic::options::OptionKeys::packing::fix_his_tautomer, "seqpos numbers of his residus whose tautomer should be fixed during repacking" );
option.add( basic::options::OptionKeys::packing::print_pymol_selection, "include pymol-style selections when printing a PackerTask" ).def(false);
option.add( basic::options::OptionKeys::packing::ex1::ex1, "use extra chi1 sub-rotamers for all residues that pass the extrachi_cutoff" );
option.add( basic::options::OptionKeys::packing::ex1::level, "use extra chi1 sub-rotamers for all residues that pass the extrachi_cutoff The integers that follow the ex flags specify the pattern for chi dihedral angle sampling There are currently 8 options; they all include the original chi dihedral angle. NO_EXTRA_CHI_SAMPLES          0          original dihedral only; same as using no flag at all EX_ONE_STDDEV                 1 Default  +/- one standard deviation (sd); 3 samples EX_ONE_HALF_STEP_STDDEV       2          +/- 0.5 sd; 3 samples EX_TWO_FULL_STEP_STDDEVS      3          +/- 1 & 2 sd; 5 samples EX_TWO_HALF_STEP_STDDEVS      4          +/- 0.5 & 1 sd; 5 samples EX_FOUR_HALF_STEP_STDDEVS     5          +/- 0.5, 1, 1.5 & 2 sd; 9 samples EX_THREE_THIRD_STEP_STDDEVS   6          +/- 0.33, 0.67, 1 sd; 7 samples EX_SIX_QUARTER_STEP_STDDEVS   7          +/- 0.25, 0.5, 0.75, 1, 1.25 & 1.5 sd; 13 samples" ).legal(0).legal(1).legal(2).legal(3).legal(4).legal(5).legal(6).legal(7).def(1);
option.add( basic::options::OptionKeys::packing::ex1::operate, "apply special operations (see RotamerOperation class) on ex1 rotamers" );
option.add( basic::options::OptionKeys::packing::ex2::ex2, "use extra chi2 sub-rotamers for all residues that pass the extrachi_cutoff" );
option.add( basic::options::OptionKeys::packing::ex2::level, "use extra chi2 sub-rotamers for all residues that pass the extrachi_cutoff The integers that follow the ex flags specify the pattern for chi dihedral angle sampling There are currently 8 options; they all include the original chi dihedral angle. NO_EXTRA_CHI_SAMPLES          0          original dihedral only; same as using no flag at all EX_ONE_STDDEV                 1 Default  +/- one standard deviation (sd); 3 samples EX_ONE_HALF_STEP_STDDEV       2          +/- 0.5 sd; 3 samples EX_TWO_FULL_STEP_STDDEVS      3          +/- 1 & 2 sd; 5 samples EX_TWO_HALF_STEP_STDDEVS      4          +/- 0.5 & 1 sd; 5 samples EX_FOUR_HALF_STEP_STDDEVS     5          +/- 0.5, 1, 1.5 & 2 sd; 9 samples EX_THREE_THIRD_STEP_STDDEVS   6          +/- 0.33, 0.67, 1 sd; 7 samples EX_SIX_QUARTER_STEP_STDDEVS   7          +/- 0.25, 0.5, 0.75, 1, 1.25 & 1.5 sd; 13 samples" ).legal(0).legal(1).legal(2).legal(3).legal(4).legal(5).legal(6).legal(7).def(1);
option.add( basic::options::OptionKeys::packing::ex2::operate, "apply special operations (see RotamerOperation class) on ex2 rotamers" );
option.add( basic::options::OptionKeys::packing::ex3::ex3, "use extra chi1 sub-rotamers for all residues that pass the extrachi_cutoff" );
option.add( basic::options::OptionKeys::packing::ex3::level, "use extra chi3 sub-rotamers for all residues that pass the extrachi_cutoff The integers that follow the ex flags specify the pattern for chi dihedral angle sampling There are currently 8 options; they all include the original chi dihedral angle. NO_EXTRA_CHI_SAMPLES          0          original dihedral only; same as using no flag at all EX_ONE_STDDEV                 1 Default  +/- one standard deviation (sd); 3 samples EX_ONE_HALF_STEP_STDDEV       2          +/- 0.5 sd; 3 samples EX_TWO_FULL_STEP_STDDEVS      3          +/- 1 & 2 sd; 5 samples EX_TWO_HALF_STEP_STDDEVS      4          +/- 0.5 & 1 sd; 5 samples EX_FOUR_HALF_STEP_STDDEVS     5          +/- 0.5, 1, 1.5 & 2 sd; 9 samples EX_THREE_THIRD_STEP_STDDEVS   6          +/- 0.33, 0.67, 1 sd; 7 samples EX_SIX_QUARTER_STEP_STDDEVS   7          +/- 0.25, 0.5, 0.75, 1, 1.25 & 1.5 sd; 13 samples" ).legal(0).legal(1).legal(2).legal(3).legal(4).legal(5).legal(6).legal(7).def(1);
option.add( basic::options::OptionKeys::packing::ex3::operate, "apply special operations (see RotamerOperation class) on ex3 rotamers" );
option.add( basic::options::OptionKeys::packing::ex4::ex4, "use extra chi1 sub-rotamers for all residues that pass the extrachi_cutoff" );
option.add( basic::options::OptionKeys::packing::ex4::level, "use extra chi4 sub-rotamers for all residues that pass the extrachi_cutoff The integers that follow the ex flags specify the pattern for chi dihedral angle sampling There are currently 8 options; they all include the original chi dihedral angle. NO_EXTRA_CHI_SAMPLES          0          original dihedral only; same as using no flag at all EX_ONE_STDDEV                 1 Default  +/- one standard deviation (sd); 3 samples EX_ONE_HALF_STEP_STDDEV       2          +/- 0.5 sd; 3 samples EX_TWO_FULL_STEP_STDDEVS      3          +/- 1 & 2 sd; 5 samples EX_TWO_HALF_STEP_STDDEVS      4          +/- 0.5 & 1 sd; 5 samples EX_FOUR_HALF_STEP_STDDEVS     5          +/- 0.5, 1, 1.5 & 2 sd; 9 samples EX_THREE_THIRD_STEP_STDDEVS   6          +/- 0.33, 0.67, 1 sd; 7 samples EX_SIX_QUARTER_STEP_STDDEVS   7          +/- 0.25, 0.5, 0.75, 1, 1.25 & 1.5 sd; 13 samples" ).legal(0).legal(1).legal(2).legal(3).legal(4).legal(5).legal(6).legal(7).def(1);
option.add( basic::options::OptionKeys::packing::ex4::operate, "apply special operations (see RotamerOperation class) on ex4 rotamers" );
option.add( basic::options::OptionKeys::packing::ex1aro::ex1aro, "use extra chi1 sub-rotamers for aromatic residues that pass the extrachi_cutoff" );
option.add( basic::options::OptionKeys::packing::ex1aro::level, "use extra chi1 sub-rotamers for all residues that pass the extrachi_cutoff The integers that follow the ex flags specify the pattern for chi dihedral angle sampling There are currently 8 options; they all include the original chi dihedral angle. NO_EXTRA_CHI_SAMPLES          0          original dihedral only; same as using no flag at all EX_ONE_STDDEV                 1 Default  +/- one standard deviation (sd); 3 samples EX_ONE_HALF_STEP_STDDEV       2          +/- 0.5 sd; 3 samples EX_TWO_FULL_STEP_STDDEVS      3          +/- 1 & 2 sd; 5 samples EX_TWO_HALF_STEP_STDDEVS      4          +/- 0.5 & 1 sd; 5 samples EX_FOUR_HALF_STEP_STDDEVS     5          +/- 0.5, 1, 1.5 & 2 sd; 9 samples EX_THREE_THIRD_STEP_STDDEVS   6          +/- 0.33, 0.67, 1 sd; 7 samples EX_SIX_QUARTER_STEP_STDDEVS   7          +/- 0.25, 0.5, 0.75, 1, 1.25 & 1.5 sd; 13 samples" ).legal(0).legal(1).legal(2).legal(3).legal(4).legal(5).legal(6).legal(7).def(1);
option.add( basic::options::OptionKeys::packing::ex2aro::ex2aro, "use extra chi1 sub-rotamers for aromatic residues that pass the extrachi_cutoff" );
option.add( basic::options::OptionKeys::packing::ex2aro::level, "use extra chi2 sub-rotamers for all residues that pass the extrachi_cutoff The integers that follow the ex flags specify the pattern for chi dihedral angle sampling There are currently 8 options; they all include the original chi dihedral angle. NO_EXTRA_CHI_SAMPLES          0          original dihedral only; same as using no flag at all EX_ONE_STDDEV                 1 Default  +/- one standard deviation (sd); 3 samples EX_ONE_HALF_STEP_STDDEV       2          +/- 0.5 sd; 3 samples EX_TWO_FULL_STEP_STDDEVS      3          +/- 1 & 2 sd; 5 samples EX_TWO_HALF_STEP_STDDEVS      4          +/- 0.5 & 1 sd; 5 samples EX_FOUR_HALF_STEP_STDDEVS     5          +/- 0.5, 1, 1.5 & 2 sd; 9 samples EX_THREE_THIRD_STEP_STDDEVS   6          +/- 0.33, 0.67, 1 sd; 7 samples EX_SIX_QUARTER_STEP_STDDEVS   7          +/- 0.25, 0.5, 0.75, 1, 1.25 & 1.5 sd; 13 samples" ).legal(0).legal(1).legal(2).legal(3).legal(4).legal(5).legal(6).legal(7).def(1);
option.add( basic::options::OptionKeys::packing::ex1aro_exposed::ex1aro_exposed, "use extra chi1 sub-rotamers for all aromatic residues" );
option.add( basic::options::OptionKeys::packing::ex1aro_exposed::level, "use extra chi1 sub-rotamers for all aromatic residues The integers that follow the ex flags specify the pattern for chi dihedral angle sampling There are currently 8 options; they all include the original chi dihedral angle. NO_EXTRA_CHI_SAMPLES          0          original dihedral only; same as using no flag at all EX_ONE_STDDEV                 1 Default  +/- one standard deviation (sd); 3 samples EX_ONE_HALF_STEP_STDDEV       2          +/- 0.5 sd; 3 samples EX_TWO_FULL_STEP_STDDEVS      3          +/- 1 & 2 sd; 5 samples EX_TWO_HALF_STEP_STDDEVS      4          +/- 0.5 & 1 sd; 5 samples EX_FOUR_HALF_STEP_STDDEVS     5          +/- 0.5, 1, 1.5 & 2 sd; 9 samples EX_THREE_THIRD_STEP_STDDEVS   6          +/- 0.33, 0.67, 1 sd; 7 samples EX_SIX_QUARTER_STEP_STDDEVS   7          +/- 0.25, 0.5, 0.75, 1, 1.25 & 1.5 sd; 13 samples" ).legal(0).legal(1).legal(2).legal(3).legal(4).legal(5).legal(6).legal(7).def(1);
option.add( basic::options::OptionKeys::packing::ex2aro_exposed::ex2aro_exposed, "use extra chi2 sub-rotamers for all aromatic residues" );
option.add( basic::options::OptionKeys::packing::ex2aro_exposed::level, "use extra chi2 sub-rotamers for all aromatic residues The integers that follow the ex flags specify the pattern for chi dihedral angle sampling There are currently 8 options; they all include the original chi dihedral angle. NO_EXTRA_CHI_SAMPLES          0          original dihedral only; same as using no flag at all EX_ONE_STDDEV                 1 Default  +/- one standard deviation (sd); 3 samples EX_ONE_HALF_STEP_STDDEV       2          +/- 0.5 sd; 3 samples EX_TWO_FULL_STEP_STDDEVS      3          +/- 1 & 2 sd; 5 samples EX_TWO_HALF_STEP_STDDEVS      4          +/- 0.5 & 1 sd; 5 samples EX_FOUR_HALF_STEP_STDDEVS     5          +/- 0.5, 1, 1.5 & 2 sd; 9 samples EX_THREE_THIRD_STEP_STDDEVS   6          +/- 0.33, 0.67, 1 sd; 7 samples EX_SIX_QUARTER_STEP_STDDEVS   7          +/- 0.25, 0.5, 0.75, 1, 1.25 & 1.5 sd; 13 samples" ).legal(0).legal(1).legal(2).legal(3).legal(4).legal(5).legal(6).legal(7).def(1);
option.add( basic::options::OptionKeys::packing::exdna::exdna, "use extra dna rotamers" );
option.add( basic::options::OptionKeys::packing::exdna::level, "extra dna rotamer sample level -- rotbuilder converts from 0-7 to number" ).legal(0).legal(1).legal(2).legal(3).legal(4).legal(5).legal(6).legal(7).def(1);
option.add( basic::options::OptionKeys::packing::extrachi_cutoff, "number of neighbors a residue must have before extra rotamers are used. default: 18" ).def(18);
option.add( basic::options::OptionKeys::packing::resfile, "resfile filename(s).  Most protocols use only the first and will ignore the rest; it does not track against -s or -l automatically." ).def("resfile");
option.add( basic::options::OptionKeys::packing::outeriterations_scaling, "Multiplier for number of outer iterations" ).def(1.0);
option.add( basic::options::OptionKeys::packing::inneriterations_scaling, "Multiplier for number of inner iterations" ).def(1.0);
option.add( basic::options::OptionKeys::packing::explicit_h2o, "Use rotamers with explicit waters" );
option.add( basic::options::OptionKeys::packing::adducts, "Gives list of adduct names to generate for residue 			definitions.  Each adduct name may be followed by an 			optional integer, which gives a maximum number of adducts 			of that type which will be generated." );
option.add( basic::options::OptionKeys::packing::solvate, "Add explicit water, but don't try to place water 			such that it bridges Hbonds, just put it on every 			available Hbond donor/acceptor where there's no 			clash (implies explicit_h2o)" );
option.add( basic::options::OptionKeys::packing::use_input_sc, "Use rotamers from input structure in packing 			By default, input sidechain coords are NOT 			included in rotamer set but are discarded 			before the initial pack; with this flag, the 			the input rotamers will NOT be discarded. 			Note that once the starting rotamers are 			replaced by any mechanism, they are no longer 			included in the rotamer set 			(rotamers included by coordinates)" );
option.add( basic::options::OptionKeys::packing::unboundrot, "Read 'native' rotamers from supplied PDB(s).  			Unlike -use_input_sc, these rotamers will not be lost during repacks.  			This option requires specific support from the protocol;  			it is NOT built in to PackerTask.initialize_from_command_line()" );
option.add( basic::options::OptionKeys::packing::max_rotbump_energy, "discard rotamers with poor interactions with the background using  					the specified cutoff.  Values must be in the range of 0 to 5.0." ).def(5.0);
option.add( basic::options::OptionKeys::packing::lazy_ig, "Force the packer to always allocate pair energy storage but procrastinate 		             energy caclulation until each RPE is needed; each RPE is 		             computed at most once. Memory use is quadratic in rotamers per residue. 						 The InteractionGraphFactory will prefer the linear-memory interaction graph 						 to the Lazy Interaction graph, so specifying both linmem_ig and lazy_ig results 						 in the use of the linear-memory interaction graph.  The Surface-series IGs (surface weight in scorefunction is nonzero) also overrides this IG." ).def(false);
option.add( basic::options::OptionKeys::packing::double_lazy_ig, "Force the packer to always procrastinate allocation AND energy caclulation                  until each RPE is needed; each RPE is computed at most once. 						 The InteractionGraphFactory will prefer the linear-memory interaction graph 						 to the DoubleLazy Interaction graph, so specifying both linmem_ig and lazy_ig results 						 in the use of the linear-memory interaction graph.  The Surface-series IGs (surface weight in scorefunction is nonzero) also overrides this IG." ).def(false);
option.add( basic::options::OptionKeys::packing::double_lazy_ig_mem_limit, "The amount of memory, in MB, that each double-lazy interaction graph should be allowed 				to allocate toward rotamer pair energies.  Using this flag will not trigger the 				use of the double-lazy interaction graph, and this flag is not read in the PackerTask's 				initialize_from_command_line routine.  For use in multistate design" ).def(0);
option.add( basic::options::OptionKeys::packing::linmem_ig, "Force the packer to use the linear memory interaction graph; each 			RPE may be computed more than once, but recently-computed RPEs 			are reused.  The integer parameter specifies the number 			of recent rotamers to store RPEs for.  10 is the recommended size. 			Memory use scales linearly with the number of 			rotamers at about 200 bytes per rotamer per recent rotamers to 			store RPEs for (~4 KB per rotamer by default)" ).def(10);
option.add( basic::options::OptionKeys::packing::multi_cool_annealer, "Alternate annealer for packing.  Runs multiple quence cycles in a first cooling stage, and tracks 			the N best network states it observes.  It then runs low-temperature rotamer substitutions with repeated 			quenching starting from each of these N best network states.  10 is recommended." );
option.add( basic::options::OptionKeys::packing::minpack_temp_schedule, "Alternate annealing schedule for min_pack." );
option.add( basic::options::OptionKeys::packing::minpack_inner_iteration_scale, "The number of inner iterations per rotamer to run at each temperature in min pack." );
option.add( basic::options::OptionKeys::packing::minpack_disable_bumpcheck, "Disable bump check in min pack (i.e. include rotamers that collide with the background." );
option.add( basic::options::OptionKeys::phil::phil, "phil option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::phil::nloop, "No description" ).def(10);
option.add( basic::options::OptionKeys::phil::vall_file, "No description" );
option.add( basic::options::OptionKeys::phil::align_file, "No description" );
option.add( basic::options::OptionKeys::wum::wum, "wum option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::wum::n_slaves_per_master, "A value between 32 and 128 is usually recommended" ).def(64);
option.add( basic::options::OptionKeys::wum::n_masters, "Manual override for -n_slaves_per_master. How many master nodes should be spawned ? 1 by default. generall 1 for eery 256-512 cores is recommended depending on master workload" ).def(1);
option.add( basic::options::OptionKeys::wum::memory_limit, "Memory limit for queues (in kB) " ).def(0);
option.add( basic::options::OptionKeys::wum::extra_scorefxn, "Extra score function for post-batchrelax-rescoring" );
option.add( basic::options::OptionKeys::wum::extra_scorefxn_ref_structure, "Extra score function for post-batchrelax-rescoring reference structure for superimposition (for scorefunctions that depend on absolute coordinates such as electron denisty)" );
option.add( basic::options::OptionKeys::wum::extra_scorefxn_relax, "After doing batch relax and adding any extra_scorefunction terms do another N fast relax rounds (defaut=0)" ).def(0);
option.add( basic::options::OptionKeys::wum::trim_proportion, "No description" ).def(0.0);
option.add( basic::options::OptionKeys::lh::lh, "lh option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::lh::db_prefix, "stem for loop database" ).def("loopdb");
option.add( basic::options::OptionKeys::lh::loopsizes, "Which loopsizes to use" ).def(10).def(15).def(20);
option.add( basic::options::OptionKeys::lh::num_partitions, "Number of partitions to split the database into" ).def(1);
option.add( basic::options::OptionKeys::lh::db_path, "Path to database" ).def("");
option.add( basic::options::OptionKeys::lh::exclude_homo, "Use a homolog exclusion filter" ).def(false);
option.add( basic::options::OptionKeys::lh::refstruct, "File with a target reference structure" ).def("");
option.add( basic::options::OptionKeys::lh::homo_file, "File containing homologs to exclude" ).def("");
option.add( basic::options::OptionKeys::lh::createdb_rms_cutoff, "RMS cutoff used for throwing out similar fragments." ).def(0).def(0).def(0);
option.add( basic::options::OptionKeys::lh::min_bbrms, "No description" ).def(0.0);
option.add( basic::options::OptionKeys::lh::max_bbrms, "No description" ).def(100000.0);
option.add( basic::options::OptionKeys::lh::min_rms, "No description" ).def(0.0);
option.add( basic::options::OptionKeys::lh::max_rms, "No description" ).def(100.0);
option.add( basic::options::OptionKeys::lh::filter_by_phipsi, "No description" ).def(true);
option.add( basic::options::OptionKeys::lh::max_radius, "No description" ).def(4);
option.add( basic::options::OptionKeys::lh::max_struct, "No description" ).def(10);
option.add( basic::options::OptionKeys::lh::max_struct_per_radius, "No description" ).def(10);
option.add( basic::options::OptionKeys::lh::grid_space_multiplier, "No description" ).def(1);
option.add( basic::options::OptionKeys::lh::grid_angle_multiplier, "No description" ).def(2.5);
option.add( basic::options::OptionKeys::lh::skim_size, "No description" ).def(100);
option.add( basic::options::OptionKeys::lh::rounds, "No description" ).def(100);
option.add( basic::options::OptionKeys::lh::jobname, "Prefix (Ident string) !" ).def("default");
option.add( basic::options::OptionKeys::lh::max_lib_size, "No description" ).def(2);

}
inline void add_rosetta_options_2( utility::options::OptionCollection &option ) {option.add( basic::options::OptionKeys::lh::max_emperor_lib_size, "No description" ).def(25);
option.add( basic::options::OptionKeys::lh::max_emperor_lib_round, "No description" ).def(0);
option.add( basic::options::OptionKeys::lh::library_expiry_time, "No description" ).def(2400);
option.add( basic::options::OptionKeys::lh::objective_function, "What to use as the objective function" ).def("score");
option.add( basic::options::OptionKeys::lh::expire_after_rounds, "If set to > 0 this causes the Master to expire a structure after it has gone through this many cycles" ).def(0);
option.add( basic::options::OptionKeys::lh::mpi_resume, "Prefix (Ident string) for resuming a previous job!" );
option.add( basic::options::OptionKeys::lh::mpi_feedback, "No description" ).legal("no").legal("add_n_limit").legal("add_n_replace").legal("single_replace").legal("single_replace_rounds").def("no");
option.add( basic::options::OptionKeys::lh::mpi_batch_relax_chunks, "No description" ).def(100);
option.add( basic::options::OptionKeys::lh::mpi_batch_relax_absolute_max, "No description" ).def(300);
option.add( basic::options::OptionKeys::lh::mpi_outbound_wu_buffer_size, "No description" ).def(60);
option.add( basic::options::OptionKeys::lh::mpi_loophash_split_size    , "No description" ).def(50);
option.add( basic::options::OptionKeys::lh::mpi_metropolis_temp, "No description" ).def(1000000.0);
option.add( basic::options::OptionKeys::lh::mpi_save_state_interval, "No description" ).def(1200);
option.add( basic::options::OptionKeys::lh::mpi_master_save_score_only, "No description" ).def(true);
option.add( basic::options::OptionKeys::lh::max_loophash_per_structure, "No description" ).def(1);
option.add( basic::options::OptionKeys::lh::rms_limit, "How to deal with returned relaxed structures" ).def(2.0);
option.add( basic::options::OptionKeys::lh::centroid_only, "false" ).def(false);
option.add( basic::options::OptionKeys::lh::write_centroid_structs, "Output raw loophashed decoys as well as relaxed ones" ).def(false);
option.add( basic::options::OptionKeys::lh::sandbox, "Sand box mode" ).def(false);
option.add( basic::options::OptionKeys::lh::create_db, "Make database with this loopsize" ).def(false);
option.add( basic::options::OptionKeys::lh::sample_weight_file, "Holds the initial per residue sample weights" );
option.add( basic::options::OptionKeys::lh::fragpdb::fragpdb, "fragpdb option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::lh::fragpdb::out_path, "Path where pdbs are saved" ).def("");
option.add( basic::options::OptionKeys::lh::fragpdb::indexoffset, "list of index offset pairs" ).def(-1);
option.add( basic::options::OptionKeys::lh::fragpdb::bin, "list of bin keys" ).def(utility::vector1<std::string>());
option.add( basic::options::OptionKeys::lh::symfragrm::symfragrm, "symfragrm option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::lh::symfragrm::pdblist, "list of pdbs to be processed" );
option.add( basic::options::OptionKeys::blivens::blivens, "blivens option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::blivens::disulfide_scorer::disulfide_scorer, "disulfide_scorer option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::blivens::disulfide_scorer::nds_prob, "The probability of scoring a non-disulfide pair" ).def(0.0);
option.add( basic::options::OptionKeys::blivens::disulfide_scorer::cys_prob, "The probability of outputing a pair of non-disulf cysteines. Default to nds_prob" ).def(-1.0);
option.add( basic::options::OptionKeys::blivens::score_type, "The scoring type to use, eg for a filter." ).def("total_score");
option.add( basic::options::OptionKeys::krassk::krassk, "krassk option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::krassk::left_tail, "No description" ).def(0);
option.add( basic::options::OptionKeys::krassk::right_tail, "No description" ).def(0);
option.add( basic::options::OptionKeys::krassk::tail_mode, "No description" ).def(false);
option.add( basic::options::OptionKeys::krassk::tail_mode_name, "No description" ).def(1);
option.add( basic::options::OptionKeys::krassk::tail_output_file_name, "No description" ).def("tail_output");
option.add( basic::options::OptionKeys::rotamerdump::rotamerdump, "rotamerdump option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::rotamerdump::xyz, "when using the RotamerDump application, output the xyz coords of every rotamer" ).def(false);
option.add( basic::options::OptionKeys::rotamerdump::one_body, "when using the RotamerDump application, output the one_body energies of every rotamer" ).def(false);
option.add( basic::options::OptionKeys::rotamerdump::two_body, "when using the RotamerDump application, output the two_body energies of every rotamer" ).def(false);
option.add( basic::options::OptionKeys::rotamerdump::annealer, "Run the annealer and output the rotamers it chose" ).def(false);
option.add( basic::options::OptionKeys::robert::robert, "robert option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::robert::pairdata_input_pdb_list, "Takes in a file containing a list of pdb locations paired with protocol specific data (eg: one disulfide pair)" ).def("");
option.add( basic::options::OptionKeys::robert::pcs_maxsub_filter, "minimum normalized maxsub for PCS clustering protocol" ).def(0.9);
option.add( basic::options::OptionKeys::robert::pcs_maxsub_rmsd, "maxsub calculation's rmsd threshold" ).def(4.0);
option.add( basic::options::OptionKeys::robert::pcs_dump_cluster, "No description" ).def(false);
option.add( basic::options::OptionKeys::robert::pcs_cluster_coverage, "cluster coverage required" ).def(0.3);
option.add( basic::options::OptionKeys::robert::pcs_cluster_lowscoring, "cluster lowest 20% against lowest 50%" ).def(true);
option.add( basic::options::OptionKeys::cmiles::cmiles, "cmiles option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::cmiles::kcluster::kcluster, "kcluster option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::cmiles::kcluster::num_clusters, "Number of clusters to use during k clustering" );
option.add( basic::options::OptionKeys::james::james, "james option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::james::min_seqsep, "No description" ).def(0);
option.add( basic::options::OptionKeys::james::atom_names, "No description" ).def(utility::vector1<std::string>());
option.add( basic::options::OptionKeys::james::dist_thresholds, "No description" ).def(utility::vector1<float>(1, 1.0));
option.add( basic::options::OptionKeys::james::torsion_thresholds, "No description" ).def(utility::vector1<float>(1, 30.0));
option.add( basic::options::OptionKeys::james::sog_cutoff, "No description" ).def(5.0);
option.add( basic::options::OptionKeys::james::shift_sog_func, "No description" ).def(true);
option.add( basic::options::OptionKeys::james::min_type, "No description" ).def("dfpmin_armijo_nonmonotone");
option.add( basic::options::OptionKeys::james::min_tol, "No description" ).def(0.0001);
option.add( basic::options::OptionKeys::james::debug, "No description" ).def(false);
option.add( basic::options::OptionKeys::james::real, "Option for keeping things real." ).def(7.0);
option.add( basic::options::OptionKeys::james::n_designs, "total number of designs that James should make." ).def(1);
option.add( basic::options::OptionKeys::james::awesome_mode, "activates or deactivates awesome_mode." ).def(true);
option.add( basic::options::OptionKeys::james::n_clusters, "number of clusters for k-means clustering." ).def(10);
option.add( basic::options::OptionKeys::james::thread_unaligned, "basic_threading without performing an alignment" ).def(false);
option.add( basic::options::OptionKeys::membrane::membrane, "membrane option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::membrane::normal_cycles, "number of membrane normal cycles" ).def(100);
option.add( basic::options::OptionKeys::membrane::normal_mag, "magnitude of membrane normal angle search (degrees)" ).def(5);
option.add( basic::options::OptionKeys::membrane::center_mag, "magnitude of membrane normal center search (Angstroms)" ).def(1);
option.add( basic::options::OptionKeys::membrane::smooth_move_frac, "No description" ).def(0.5);
option.add( basic::options::OptionKeys::membrane::no_interpolate_Mpair, "No description" ).def(false);
option.add( basic::options::OptionKeys::membrane::Menv_penalties, "No description" ).def(false);
option.add( basic::options::OptionKeys::membrane::Membed_init, "No description" ).def(false);
option.add( basic::options::OptionKeys::membrane::Fa_Membed_update, "No description" ).def(false);
option.add( basic::options::OptionKeys::membrane::center_search, "perform membrane center search" ).def(false);
option.add( basic::options::OptionKeys::membrane::normal_search, "perform membrane normal search" ).def(false);
option.add( basic::options::OptionKeys::membrane::center_max_delta, "magnitude of maximum membrane width deviation during membrane center search (Angstroms)" ).def(5);
option.add( basic::options::OptionKeys::membrane::normal_start_angle, "magnitude of starting angle during membrane normal search (degrees)" ).def(10);
option.add( basic::options::OptionKeys::membrane::normal_delta_angle, "magnitude of angle deviation during membrane normal search (degrees)" ).def(10);
option.add( basic::options::OptionKeys::membrane::normal_max_angle, "magnitude of maximum angle deviation during membrane normal search (degrees)" ).def(40);
option.add( basic::options::OptionKeys::membrane::debug, "No description" ).def(false);
option.add( basic::options::OptionKeys::membrane::fixed_membrane, "fix membrane position, by default the center is at [0,0,0] and membrane normal is the z-axis" ).def(false);
option.add( basic::options::OptionKeys::membrane::membrane_center, "membrane center x,y,z" );
option.add( basic::options::OptionKeys::membrane::membrane_normal, "membrane normal x,y,z" );
option.add( basic::options::OptionKeys::membrane::view, "viewing pose during protocol" ).def(false);
option.add( basic::options::OptionKeys::membrane::Mhbond_depth, "membrane depth dependent correction to the hbond potential" ).def(false);
option.add( basic::options::OptionKeys::casp::casp, "casp option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::casp::decoy, "No description" );
option.add( basic::options::OptionKeys::casp::wt, "No description" );
option.add( basic::options::OptionKeys::casp::rots, "No description" );
option.add( basic::options::OptionKeys::casp::opt_radius, "optimization radius for repacking and minimization" );
option.add( basic::options::OptionKeys::casp::repack, "should we repack the structure?" );
option.add( basic::options::OptionKeys::casp::sc_min, "should we sidechain minimize the structure?" );
option.add( basic::options::OptionKeys::casp::sequential, "should mutations be considered in sequence or all together?" );
option.add( basic::options::OptionKeys::casp::num_iterations, "number of iterations to perform" );
option.add( basic::options::OptionKeys::casp::weight_file, "what weight-file to use?" );
option.add( basic::options::OptionKeys::casp::refine_res, "specifies file that contains which residues to refine" );
option.add( basic::options::OptionKeys::pose_metrics::pose_metrics, "pose_metrics option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::pose_metrics::atomic_burial_cutoff, " maximum SASA that is allowed for an atom to count as buried for the BuriedUnsatisfiedPolarsCalculator" ).def(0.3);
option.add( basic::options::OptionKeys::pose_metrics::sasa_calculator_probe_radius, " the probe radius used in the SASA calculator (and thus implicitly in the BuriedUnsatisfiedPolarsCalculator" ).def(1.4);
option.add( basic::options::OptionKeys::pose_metrics::interface_cutoff, "distance in angstroms (def. 10.0) for calculating what residues are at an interface via InterfaceNeighborDefinitionCalculator" ).def(10.0);
option.add( basic::options::OptionKeys::pose_metrics::min_sequence_separation, " minimum number of sequence positions that two residues need to be apart to count as nonlocal in the NonlocalContactsCalculator" ).def(6);
option.add( basic::options::OptionKeys::pose_metrics::contact_cutoffE, " maximum interaction energy allowed between two residues to count as a contact in the NonlocalContactsCalculator" ).def(-1.0);
option.add( basic::options::OptionKeys::pose_metrics::neighbor_by_distance_cutoff, "distance in angstroms (def. 10.0) for calculating neighbors of a residue via NeighborByDistanceCalculator" ).def(10.0);
option.add( basic::options::OptionKeys::pose_metrics::inter_group_neighbors_cutoff, "distance in angstroms (def. 10.0) for calculating interfaces between domains with InterGroupNeighborsCalculator" ).def(10.0);
option.add( basic::options::OptionKeys::pose_metrics::semiex_water_burial_cutoff, "water hbond states fraction cutiff for SemiExplicitWaterUnsatisfiedPolarsCalculator (0.0,1.0)" ).def(0.25);
option.add( basic::options::OptionKeys::ddg::ddg, "ddg option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::ddg::avg_rot_cst_enrg, "No description" ).def(false);
option.add( basic::options::OptionKeys::ddg::use_bound_cst, "No description" ).def(false);
option.add( basic::options::OptionKeys::ddg::cap_rot_cst_enrg, "No description" ).def(false);
option.add( basic::options::OptionKeys::ddg::opt_input_structure, "No description" ).def(false);
option.add( basic::options::OptionKeys::ddg::pack_until_converge, "No description" ).def(false);
option.add( basic::options::OptionKeys::ddg::no_constraints, "No description" ).def(false);
option.add( basic::options::OptionKeys::ddg::apply_rot_cst_to_mutation_region_only, "No description" );
option.add( basic::options::OptionKeys::ddg::rot_cst_enrg_cutoff, "No description" );
option.add( basic::options::OptionKeys::ddg::use_rotamer_constraints_to_native, "No description" ).def(false);
option.add( basic::options::OptionKeys::ddg::single_res_scoring, "No description" );
option.add( basic::options::OptionKeys::ddg::downweight_by_sasa, "No description" );
option.add( basic::options::OptionKeys::ddg::global, "No description" );
option.add( basic::options::OptionKeys::ddg::exclude_solvent_exposed_res, "No description" );
option.add( basic::options::OptionKeys::ddg::radius, "No description" );
option.add( basic::options::OptionKeys::ddg::wt, "No description" );
option.add( basic::options::OptionKeys::ddg::mut, "No description" );
option.add( basic::options::OptionKeys::ddg::suppress_checkpointing, "boinc specific options to suppress checkpointing behavior" ).def(false);
option.add( basic::options::OptionKeys::ddg::wt_only, "option added to minirosetta app in order to produce only refinement in wt structures" );
option.add( basic::options::OptionKeys::ddg::mut_only, "options added to minirosetta app in order to produce refinement in only mutant structure" );
option.add( basic::options::OptionKeys::ddg::output_silent, "No description" );
option.add( basic::options::OptionKeys::ddg::minimization_scorefunction, "No description" );
option.add( basic::options::OptionKeys::ddg::minimization_patch, "No description" );
option.add( basic::options::OptionKeys::ddg::min_cst, "Following sidechain optimization in the packer, should we then proceed to minimize the backbone at all.  Constraints will be used to keep the structure from moving too far." ).def(true);
option.add( basic::options::OptionKeys::ddg::lowest_x_decoys, "No description" );
option.add( basic::options::OptionKeys::ddg::local_opt_only, "No description" ).def(false);
option.add( basic::options::OptionKeys::ddg::print_per_res_diff, "No description" ).def(false);
option.add( basic::options::OptionKeys::ddg::mean, "No description" );
option.add( basic::options::OptionKeys::ddg::min, "No description" );
option.add( basic::options::OptionKeys::ddg::rb_restrict_to_mutsite_nbrs, "No description" ).def(false);
option.add( basic::options::OptionKeys::ddg::no_bb_movement, "No description" ).def(false);
option.add( basic::options::OptionKeys::ddg::initial_repack, "No description" ).def(false);
option.add( basic::options::OptionKeys::ddg::rb_file, "No description" );
option.add( basic::options::OptionKeys::ddg::interface_ddg, "Calculate ddGs across an interface? Uses jump # specified for determining interface." ).def(0);
option.add( basic::options::OptionKeys::ddg::ens_variation, "No description" ).def(0.5);
option.add( basic::options::OptionKeys::ddg::sc_min_only, "No description" ).def(true);
option.add( basic::options::OptionKeys::ddg::min_cst_weights, "No description" ).def("standard");
option.add( basic::options::OptionKeys::ddg::opt_radius, "No description" ).def(8.0);
option.add( basic::options::OptionKeys::ddg::output_dir, "No description" ).def("./");
option.add( basic::options::OptionKeys::ddg::last_accepted_pose_dir, "No description" ).def("./");
option.add( basic::options::OptionKeys::ddg::min_with_cst, "Used in ensemble generation" ).def(false);
option.add( basic::options::OptionKeys::ddg::temperature, "because I really dont know what the monte carlo temperature should be set to" ).def(10);
option.add( basic::options::OptionKeys::ddg::ramp_repulsive, "set fa_rep to 0.1, 0.33 of original value when minimizing in the minimization phase following packing" ).def(false);
option.add( basic::options::OptionKeys::ddg::mut_file, "alternate specification for mutations.  File format described in fix_bb_monomer_ddg.cc above the read_in_mutations function" );
option.add( basic::options::OptionKeys::ddg::out_pdb_prefix, "specifies the prefix assigned to output so that no overwriting happens" );
option.add( basic::options::OptionKeys::ddg::constraint_weight, "because that other option isnt working" ).def(1.0);
option.add( basic::options::OptionKeys::ddg::harmonic_ca_tether, "default CA tether for harmonic constraints" ).def(2.0);
option.add( basic::options::OptionKeys::ddg::iterations, "specifies the number of iterations of refinement" ).def(20);
option.add( basic::options::OptionKeys::ddg::out, "create output file of predicted ddgs" ).def("ddg_predictions.out");
option.add( basic::options::OptionKeys::ddg::debug_output, "specify whether or not to write a whole bunch of debug statements to standard out" ).def(false);
option.add( basic::options::OptionKeys::ddg::dump_pdbs, "specify whether or not to dump repacked wild-type and mutant pdbs" ).def(true);
option.add( basic::options::OptionKeys::ddg::weight_file, "specifies the weight-files to be used in calculations" ).def("ddg.wts");
option.add( basic::options::OptionKeys::murphp::murphp, "murphp option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::murphp::inv_kin_lig_loop_design_filename, "input filename to be used for inv_kin_lig_loop_design" );
option.add( basic::options::OptionKeys::motifs::motifs, "motifs option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::motifs::close_enough, "4-atom rmsd cutoff beyond which you don't bother trying an inverse rotamer" ).def(1.0);
option.add( basic::options::OptionKeys::motifs::max_depth, "Maximum recursion depth - i.e., maximum number of motifs to incorporate" ).def(1);
option.add( basic::options::OptionKeys::motifs::keep_motif_xtal_location, "used to dna_motif_collector - controls whether motifs are moved away from original PDB location (comparison is easier if they are moved, so that's default)" ).def(false);
option.add( basic::options::OptionKeys::motifs::pack_score_cutoff, "used in dna_motif_collector - fa_atr + fa_rep energy threshold for a two-residue interaction to determine if it is a motif" ).def(-0.5);
option.add( basic::options::OptionKeys::motifs::hb_score_cutoff, "used in dna_motif_collector - hbond_sc energy threshold for a two-residue interaction to determine if it is a motif" ).def(-0.3);
option.add( basic::options::OptionKeys::motifs::water_score_cutoff, "used in dna_motif_collector - h2o_hbond energy threshold for a two-residue interaction to determine if it is a motif" ).def(-0.3);
option.add( basic::options::OptionKeys::motifs::motif_output_directory, "used in dna_motif_collector - path for the directory where all the collected motifs are dumped as 2-residue pdbs" );
option.add( basic::options::OptionKeys::motifs::eliminate_weak_motifs, "used to dna_motif_collector - controls whether only the top 1-2 motifs are counted for every protein position in a protein-DNA interface" ).def(true);
option.add( basic::options::OptionKeys::motifs::duplicate_motif_cutoff, "used in dna_motif_collector - RMSD cutoff for an identical base placed via a motif to see if that motif already exists in a motif library" ).def(0.2);
option.add( basic::options::OptionKeys::motifs::preminimize_motif_pdbs, "used to dna_motif_collector - controls whether the input PDB structure sidechains and bb are minimized before motifs are collected" ).def(false);
option.add( basic::options::OptionKeys::motifs::preminimize_motif_pdbs_sconly, "used to dna_motif_collector - controls whether the input PDB structure sidechains are minimized before motifs are collected" ).def(false);
option.add( basic::options::OptionKeys::motifs::place_adduct_waters, "used to dna_motif_collector - whether or not adduct waters are placed before motifs are collected, there will be no water interaction calculated if this is false" ).def(true);
option.add( basic::options::OptionKeys::motifs::list_motifs, "File(s) containing list(s) of PDB files to process" );
option.add( basic::options::OptionKeys::motifs::motif_filename, "File containing motifs" );
option.add( basic::options::OptionKeys::motifs::BPData, "File containing BuildPosition specific motifs and/or rotamers" );
option.add( basic::options::OptionKeys::motifs::list_dnaconformers, "File(s) containing list(s) of PDB files to process" );
option.add( basic::options::OptionKeys::motifs::target_dna_defs, "" ).def("");
option.add( basic::options::OptionKeys::motifs::motif_build_defs, "" ).def("");
option.add( basic::options::OptionKeys::motifs::motif_build_position_chain, "" ).def("");
option.add( basic::options::OptionKeys::motifs::motif_build_positions, "" );
option.add( basic::options::OptionKeys::motifs::r1, "RMSD cutoff between motif anchor position and motif target position for allowing a particular motif rotamer to continue on to expand with DNA conformers" ).lower(0).def(4.5);
option.add( basic::options::OptionKeys::motifs::r2, "RMSD cutoff between motif anchor position and motif target position for accepting the motif" ).lower(0).def(1.1);
option.add( basic::options::OptionKeys::motifs::z1, "DNA motif specific: cutoff between motif target DNA position and standardized base for allowing a particular motif to continue on to expand with DNA conformers" ).lower(0).def(0.75);
option.add( basic::options::OptionKeys::motifs::z2, "DNA motif specific: cutoff between motif target DNA position and DNA conformer placed according to motif for accepting the pair of residues" ).lower(0).def(0.95);
option.add( basic::options::OptionKeys::motifs::dtest, "DNA motif specific: cutoff between motif target DNA position and DNA conformer placed according to motif for accepting the pair of residues" ).lower(0).def(5.5);
option.add( basic::options::OptionKeys::motifs::rotlevel, "level of rotamer sampling for motif search" ).lower(1).def(5);
option.add( basic::options::OptionKeys::motifs::num_repacks, "number of cycles of dropping special_rot weight and design" ).lower(0).def(5);
option.add( basic::options::OptionKeys::motifs::minimize, "whether or not to minimize the motifs toward the xtal structure DNA" ).def(true);
option.add( basic::options::OptionKeys::motifs::minimize_dna, "whether or not to minimize DNA after every round of design with special_rot weight dropping" ).def(true);
option.add( basic::options::OptionKeys::motifs::run_motifs, "whether or not to use motifs in DnaPackerMotif" ).def(true);
option.add( basic::options::OptionKeys::motifs::expand_motifs, "whether or not to use expand (use all types) motifs in DnaPackerMotif" ).def(true);
option.add( basic::options::OptionKeys::motifs::aromatic_motifs, "whether or not to use expand (use aromatic only types) motifs in DnaPackerMotif" ).def(true);
option.add( basic::options::OptionKeys::motifs::dump_motifs, "whether or not to output pdbs with the best rotamer/conformer for each motifs" ).def(true);
option.add( basic::options::OptionKeys::motifs::quick_and_dirty, "quick motif run to get a list of all possible motifs before doing a real run" ).def(true);
option.add( basic::options::OptionKeys::motifs::special_rotweight, "starting weight for the weight on motif rotamers" ).def(-40.0);
option.add( basic::options::OptionKeys::motifs::output_file, "name of output file for all the best motifs and rotamers or for the dna_motif_collector it is the file where all the motifs are dumped" );
option.add( basic::options::OptionKeys::motifs::data_file, "name of output file for any data about how many rotamers and motifs pass what tests, etc" );
option.add( basic::options::OptionKeys::motifs::constraint_max, "highest value for constraint score (before and after minimization) that results in the rotamer being dropped" ).lower(0).def(20.0);
option.add( basic::options::OptionKeys::motifs::flex_sugar, "whether or not to add the flexible sugar, not using PB way of adding options" ).def(true);
option.add( basic::options::OptionKeys::motifs::clear_bprots, "whether or not to clear the rotamers that were read in from a previous run and restart with only the motifs that were read in and the specified rotlevel" ).def(true);
option.add( basic::options::OptionKeys::motifs::rots2add, "number of rotamers to add to design from the MotifSearch for each amino acid type" ).lower(1).def(100);
option.add( basic::options::OptionKeys::motifs::restrict_to_wt, "restrict the motif search to finding motifs of the same amino acid as the starting pose, for homology modeling" ).def(true);
option.add( basic::options::OptionKeys::motifs::rerun_motifsearch, "setting the MotifSearch to run again, using the rotamers in the build position, most likely to change stringency or amino acid type on a second run" ).def(true);
option.add( basic::options::OptionKeys::motifs::ligand_motif_sphere, "option to specify radius of motif search around ligand" ).def(6.0);
option.add( basic::options::OptionKeys::constraints::constraints, "constraints option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::constraints::CA_tether, "default CA tether for harmonic constraints" ).def(2.0);
option.add( basic::options::OptionKeys::constraints::exit_on_bad_read, "exit if error is encountered reading constraints" ).def(false);
option.add( basic::options::OptionKeys::constraints::cst_file, "constraints filename(s) for centoroid. When multiple files are given a *random* one will be picked." );
option.add( basic::options::OptionKeys::constraints::cst_weight, "No description" ).def(1.0);
option.add( basic::options::OptionKeys::constraints::max_cst_dist, "No description" ).def(12.0);
option.add( basic::options::OptionKeys::constraints::cst_fa_file, "constraints filename(s) for fullatom. When multiple files are given a *random* one will be picked." );
option.add( basic::options::OptionKeys::constraints::cst_fa_weight, "No description" ).def(1.0);
option.add( basic::options::OptionKeys::constraints::normalize_mixture_func, "No description" ).def(false);
option.add( basic::options::OptionKeys::constraints::penalize_mixture_func, "No description" ).def(true);
option.add( basic::options::OptionKeys::constraints::forest_file, "file with constraintforest" ).def("");
option.add( basic::options::OptionKeys::constraints::compute_total_dist_cst, "only relevant for debug: atom_pair_constraints during abinito depends on seq_sep, this computes also the score without regarding seq_sep" ).def(false);
option.add( basic::options::OptionKeys::constraints::cull_with_native, "if option is set all constraints that violate the native structure with more than X are thrown out! " ).def(1);
option.add( basic::options::OptionKeys::constraints::dump_cst_set, "dump the cstset_ to file " ).def("");
option.add( basic::options::OptionKeys::constraints::evaluate_max_seq_sep, "evaluate constraints to this seq-sep [vector]" ).def(0);
option.add( basic::options::OptionKeys::constraints::named, "enable named constraints to avoid problems with changing residue-types e.g., cutpoint-variants" ).def(false);
option.add( basic::options::OptionKeys::constraints::no_cst_in_relax, "remove constraints for relax" ).def(false);
option.add( basic::options::OptionKeys::constraints::no_linearize_bounded, "dont switch to linearized in BOUNDED func" ).def(false);
option.add( basic::options::OptionKeys::constraints::pocket_constraint_weight, "Weight of the Pocket Constraint" ).def(0);
option.add( basic::options::OptionKeys::constraints::pocket_zero_derivatives, "Return zero for PocketConstaint derivatives" ).def(false);
option.add( basic::options::OptionKeys::constraints::viol, "show violations" ).def(false);
option.add( basic::options::OptionKeys::constraints::viol_level, "how much detail for violation output" ).def(1);
option.add( basic::options::OptionKeys::constraints::viol_type, "work only on these types of constraints" ).def("");
option.add( basic::options::OptionKeys::constraints::sog_cst_param, "weight parameter for SOGFunc constraints" ).def(0.0);
option.add( basic::options::OptionKeys::constraints::sog_upper_bound, "Upper cutoff for SOGFunc constraints" ).def(10.0);
option.add( basic::options::OptionKeys::constraints::epr_distance, "use epr distance potential" ).def(false);
option.add( basic::options::OptionKeys::constraints::combine, "combine constraints randomly into OR connected groups (Ambiguous). N->1" ).def(1);
option.add( basic::options::OptionKeys::constraints::combine_exclude_region, "core-defintion file do not combine constraints that are core-core" );
option.add( basic::options::OptionKeys::constraints::skip_redundant, "skip redundant constraints" ).def(false);
option.add( basic::options::OptionKeys::constraints::skip_redundant_width, "radius of influence for redundant constraints" ).def(2);
option.add( basic::options::OptionKeys::constraints::increase_constraints, "Multiplicative factor applied to constraints. Not widely supported yet." ).def(1.0);
option.add( basic::options::OptionKeys::dna::dna, "dna option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::dna::specificity::specificity, "specificity option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::dna::specificity::params, "vector of real-valued params" );
option.add( basic::options::OptionKeys::dna::specificity::frag_files, "files to collect frags from" );
option.add( basic::options::OptionKeys::dna::specificity::exclude_bb_sc_hbonds, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::specificity::only_repack, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::specificity::design_DNA, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::specificity::run_test, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::specificity::soft_rep, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::specificity::dump_pdbs, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::specificity::fast, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::specificity::randomize_motif, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::specificity::Whack_elec, "No description" ).def(0);
option.add( basic::options::OptionKeys::dna::specificity::Wdna_bs, "No description" ).def(0);
option.add( basic::options::OptionKeys::dna::specificity::Wdna_bp, "No description" ).def(0);
option.add( basic::options::OptionKeys::dna::specificity::minimize_tolerance, "No description" ).def(0.001);
option.add( basic::options::OptionKeys::dna::specificity::weights_tag, "No description" );
option.add( basic::options::OptionKeys::dna::specificity::weights_tag_list, "No description" );
option.add( basic::options::OptionKeys::dna::specificity::min_type, "No description" ).def("dfpmin");
option.add( basic::options::OptionKeys::dna::specificity::tf, "No description" );
option.add( basic::options::OptionKeys::dna::specificity::mode, "No description" );
option.add( basic::options::OptionKeys::dna::specificity::score_function, "No description" );
option.add( basic::options::OptionKeys::dna::specificity::pre_minimize, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::specificity::post_minimize, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::specificity::pre_pack, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::specificity::nloop, "No description" ).def(20);
option.add( basic::options::OptionKeys::dna::specificity::n_inner, "No description" );
option.add( basic::options::OptionKeys::dna::specificity::n_outer, "No description" );
option.add( basic::options::OptionKeys::dna::specificity::nstep_water, "No description" ).def(0);
option.add( basic::options::OptionKeys::dna::specificity::moving_jump, "No description" ).def(0);
option.add( basic::options::OptionKeys::dna::specificity::motif_begin, "No description" ).def(0);
option.add( basic::options::OptionKeys::dna::specificity::motif_size, "No description" ).def(0);
option.add( basic::options::OptionKeys::dna::specificity::pdb_pos, "list of one or more positions in the input pdb, eg: -pdb_pos 125:A 127:A 4:C" ).def("");
option.add( basic::options::OptionKeys::dna::specificity::methylate, "list of one or more positions in the input pdb to be methylated, eg: -methylate 125:A 127:A 4:C" ).def("");
option.add( basic::options::OptionKeys::dna::design::design, "design option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::dna::design::output_initial_pdb, "write pdb file for loaded and scored input structure" ).def(false);
option.add( basic::options::OptionKeys::dna::design::output_unbound_pdb, "write out an unbound pdb if doing binding score calculations" ).def(false);
option.add( basic::options::OptionKeys::dna::design::z_cutoff, "distance along DNA-axis from designing DNA bases to allow amino acids to design" ).lower(0).def(3.5);
option.add( basic::options::OptionKeys::dna::design::protein_scan, "single-residue scanning of protein residue types for binding and specificity scores" ).def("ACDEFGHIKLMNPQRSTVWY");
option.add( basic::options::OptionKeys::dna::design::checkpoint, "write/read checkpoint files for higher-level protocols that proceed linearly for long periods of time.  Provide a checkpoint filename after this option." ).def("");
option.add( basic::options::OptionKeys::dna::design::minimize, "Perform minimization in DNA design mode." ).def(false);
option.add( basic::options::OptionKeys::dna::design::iterations, "" ).lower(1).def(1);
option.add( basic::options::OptionKeys::dna::design::bb_moves, "" ).legal("ccd").legal("backrub").def("ccd");
option.add( basic::options::OptionKeys::dna::design::dna_defs, "" ).def("");
option.add( basic::options::OptionKeys::dna::design::dna_defs_file, "" ).def("");
option.add( basic::options::OptionKeys::dna::design::preminimize_interface, "" ).def(false);
option.add( basic::options::OptionKeys::dna::design::prepack_interface, "" ).def(false);
option.add( basic::options::OptionKeys::dna::design::flush, "enable some tracer flushes in order to see more frequent output" ).def(false);
option.add( basic::options::OptionKeys::dna::design::nopdb, "use this flag to disable pdb output" ).def(false);
option.add( basic::options::OptionKeys::dna::design::nopack, "don't actually repack structures" ).def(false);
option.add( basic::options::OptionKeys::dna::design::more_stats, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::design::pdb_each_iteration, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::design::designable_second_shell, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::design::base_contacts_only, "No description" ).def(false);
option.add( basic::options::OptionKeys::dna::design::probe_specificity, "Rapidly estimate the explicit specificity of DNA designs during fixed-backbone repacking" ).def(1);
option.add( basic::options::OptionKeys::dna::design::specificity::specificity, "specificity option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::dna::design::specificity::output_structures, "output structures for each sequence combination" ).def(false);
option.add( basic::options::OptionKeys::dna::design::specificity::include_dna_potentials, "include DNA potentials in calculations of DNA sequence specificity" ).def(false);
option.add( basic::options::OptionKeys::dna::design::reversion_scan, "Try to revert spurious mutations after designing" ).def(false);
option.add( basic::options::OptionKeys::dna::design::reversion::reversion, "reversion option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::dna::design::reversion::dscore_cutoff, "limit for acceptable loss in energy" ).def(1.5);
option.add( basic::options::OptionKeys::dna::design::reversion::dspec_cutoff, "limit for acceptable loss in specificity" ).def(-0.05);
option.add( basic::options::OptionKeys::dna::design::binding, "compute a protein-DNA binding energy" ).def(false);
option.add( basic::options::OptionKeys::dna::design::Boltz_temp, "temperature for Boltzmann calculations" ).def(0.6);
option.add( basic::options::OptionKeys::dna::design::repack_only, "Do not allow protein sequences to mutate arbitrarily" ).def(false);
option.add( basic::options::OptionKeys::dna::design::sparse_pdb_output, "Output only coordinates that change relative to the input structure" ).def(false);
option.add( basic::options::OptionKeys::flxbb::flxbb, "flxbb option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::flxbb::view, "viewing pose during protocol" );
option.add( basic::options::OptionKeys::flxbb::ncycle, "number of cycles of design and relax" );
option.add( basic::options::OptionKeys::flxbb::constraints_sheet, "weight constraints between Ca atoms in beta sheet" );
option.add( basic::options::OptionKeys::flxbb::constraints_NtoC, "weight constraints between N- and C- terminal CA atoms" );
option.add( basic::options::OptionKeys::flxbb::filter_trial, "number of filtering trial " );
option.add( basic::options::OptionKeys::flxbb::filter_type, "filter type name, currently only packstat is available" );
option.add( basic::options::OptionKeys::flxbb::exclude_Met, "do not use Met for design" );
option.add( basic::options::OptionKeys::flxbb::exclude_Ala, "do not use Ala for design" );
option.add( basic::options::OptionKeys::flxbb::blueprint, "blueprint file " );
option.add( basic::options::OptionKeys::flxbb::movemap_from_blueprint, "viewing pose during protocol" );
option.add( basic::options::OptionKeys::flxbb::layer::layer, "design core, boundary, and surface with different aa types" ).def("normal");
option.add( basic::options::OptionKeys::flxbb::layer::pore_radius, "sphere radius for sasa calculation" );
option.add( basic::options::OptionKeys::flxbb::layer::burial, "surface area when residues regarded as core " );
option.add( basic::options::OptionKeys::flxbb::layer::surface, "surface area when residues regarded as surface " );
option.add( basic::options::OptionKeys::fldsgn::fldsgn, "fldsgn option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::fldsgn::view, "viewing pose during protocol" );
option.add( basic::options::OptionKeys::fldsgn::blueprint, "blueprint filename(s). " ).def("blueprint");
option.add( basic::options::OptionKeys::fldsgn::dr_cycles, "design-refine cycles" ).def(3);
option.add( basic::options::OptionKeys::fldsgn::centroid_sfx, "filename of the centroid score function to use," );
option.add( basic::options::OptionKeys::fldsgn::centroid_sfx_patch, "filename of the centroid score function patch to use," );
option.add( basic::options::OptionKeys::fldsgn::fullatom_sfx, "filename of the full-atom score function to use" );
option.add( basic::options::OptionKeys::fldsgn::fullatom_sfx_patch, "filename of the full-atom score function patch to use" );
option.add( basic::options::OptionKeys::fldsgn::run_flxbb, "run flxbb at the given stage" );
option.add( basic::options::OptionKeys::rna::rna, "rna option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::rna::minimize_rounds, "The number of rounds of minimization." ).def(2);
option.add( basic::options::OptionKeys::cm::cm, "cm option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::cm::sanitize::sanitize, "sanitize option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::cm::sanitize::bound_delta, "Distance in Angstroms from aligned position before a penalty is incurred" ).def(0.5);
option.add( basic::options::OptionKeys::cm::sanitize::bound_sd, "Value of standard deviation in bound func" ).def(1.0);
option.add( basic::options::OptionKeys::cm::sanitize::num_fragments, "Use the top k fragments at each position during sanitization" ).def(25);
option.add( basic::options::OptionKeys::cm::sanitize::cst_weight_pair, "atom_pair_constraint weight" ).def(1.0);
option.add( basic::options::OptionKeys::cm::sanitize::cst_weight_coord, "coordinate_constraint weight" ).def(1.0);
option.add( basic::options::OptionKeys::cm::start_models_only, "Make starting models only!" ).def(false);
option.add( basic::options::OptionKeys::cm::aln_format, "No description" ).legal("grishin").legal("general").def("grishin");
option.add( basic::options::OptionKeys::cm::recover_side_chains, "recover side-chains" ).def(false);
option.add( basic::options::OptionKeys::cm::steal_extra_residues, "list of template extra residues (ie ligands) to add to query pose in comparative modeling" );
option.add( basic::options::OptionKeys::cm::loop_mover, "No description" ).legal("quick_ccd").legal("quick_ccd_moves").legal("perturb_ccd").legal("perturb_kic").legal("sdwindow").def("quick_ccd");
option.add( basic::options::OptionKeys::cm::loop_close_level, "level of aggressiveness to use in closing loops. 					The integers that follow flags specify how aggressively 					loops are rebuilt. Each option implies all non-zero levels below it,					so that loop_close_level 2 implies level 1 as well. Meaning of 					the options are: 					NO_REBUILD              0     don't rebuild loops at all 					REBUILD_UNALIGNED       1     rebuild loops around unaligned regions 					REBUILD_CHAINBREAK      2     rebuild loops around chainbreaks 					REBUILD_EXHAUSTIVE      3     rebuild loops around regions with a chainbreak until no chainbreaks remain" ).legal(0).legal(1).legal(2).legal(3).def(0);
option.add( basic::options::OptionKeys::cm::min_loop_size, "Minimum size of loops to remodel when building threading models." ).def(5);
option.add( basic::options::OptionKeys::cm::max_loop_rebuild, "Maximum number of times to try to rebuild a loop before giving up." ).def(10);
option.add( basic::options::OptionKeys::cm::loop_rebuild_filter, "Maximum score a structure must have after loop rebuilding." ).def(0);
option.add( basic::options::OptionKeys::cm::aln_length_filter_quantile, "Only use alignment lengths longer than the Xth quantile. e.g. setting this to 0.75 will only use the 25% longest alignments" ).def(0.0);
option.add( basic::options::OptionKeys::cm::aln_length_filter, "Only use alignment longer or equal to this length" ).def(-1);
option.add( basic::options::OptionKeys::cm::template_ids, "List of template identifiers to use in comparative modeling" );
option.add( basic::options::OptionKeys::cm::ligand_pdb, "Add a ligand to the system" );
option.add( basic::options::OptionKeys::cm::seq_score, "sequence-based scoring scheme used for generating alignments" ).legal("L1").legal("ProfSim").legal("DP").legal("Matrix").legal("Simple").legal("ChemicalShift").def(utility::vector1<std::string>(1,"Simple"));
option.add( basic::options::OptionKeys::cm::aligner, "algorithm for making sequence alignments" ).legal("local").legal("global").legal("mc");
option.add( basic::options::OptionKeys::cm::min_gap_open, "gap opening penalty for sequence alignments (usually negative)" ).def(-2.0);
option.add( basic::options::OptionKeys::cm::max_gap_open, "gap opening penalty for sequence alignments (usually negative)" ).def(-2.0);
option.add( basic::options::OptionKeys::cm::min_gap_extend, "gap extension penalty for sequence alignments (usually negative)" ).def(-0.2);
option.add( basic::options::OptionKeys::cm::max_gap_extend, "gap extension penalty for sequence alignments (usually negative)" ).def(-0.2);
option.add( basic::options::OptionKeys::cm::nn, "number of neighbors to include in constraint derivation" ).def(500);
option.add( basic::options::OptionKeys::cm::fr_temperature, "temperature to use during fragment-based refinement of structures" ).def(2.0);
option.add( basic::options::OptionKeys::cm::ev_map, "Input file that maps pdbChains to blast e-values" );
option.add( basic::options::OptionKeys::cm::hh_map, "Input file that maps pdbChains to hhsearch probabilities" );
option.add( basic::options::OptionKeys::cm::hybridize::hybridize, "hybridize option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::cm::hybridize::templates, "Input list of template files" );
option.add( basic::options::OptionKeys::cm::hybridize::template_list, "Input list of templates, constaints, cluster, and weights" );
option.add( basic::options::OptionKeys::cm::hybridize::starting_template, "Define starting templates" );
option.add( basic::options::OptionKeys::cm::hybridize::add_non_init_chunks, "non chunks from templates other than the initial one" ).def(false);
option.add( basic::options::OptionKeys::cm::hybridize::ss, "secondary structure elements used to split the pose" ).def("HE");
option.add( basic::options::OptionKeys::cm::hybridize::stage1_increase_cycles, "Scale stage 1 cycles" ).def(1.0);
option.add( basic::options::OptionKeys::cm::hybridize::stage2_increase_cycles, "Scale stage 2 cycles" ).def(1.0);
option.add( basic::options::OptionKeys::cm::hybridize::stage1_probability, "Probability of running stage 1, 0=never, 1=always" ).def(1.0);
option.add( basic::options::OptionKeys::cm::hybridize::stage1_weights, "weight for fold tree hybridize stage" ).def("score3");
option.add( basic::options::OptionKeys::cm::hybridize::stage1_patch, "weight patch for fold tree hybridize stage" ).def("");
option.add( basic::options::OptionKeys::cm::hybridize::skip_stage2, "skip cartesian fragment hybridize stage" ).def(false);
option.add( basic::options::OptionKeys::cm::hybridize::no_global_frame, "no global-frame fragment insertions" ).def(false);
option.add( basic::options::OptionKeys::cm::hybridize::linmin_only, "linmin only in stage 2" ).def(false);
option.add( basic::options::OptionKeys::cm::hybridize::stage2_weights, "weight for cartesian fragment hybridize stage" ).def("score4_smooth_cart");
option.add( basic::options::OptionKeys::cm::hybridize::stage2_patch, "weight patch for cartesian fragment hybridize stage" ).def("");
option.add( basic::options::OptionKeys::cm::hybridize::relax, "if n==1, perform relax at end; if n>1 perform batch relax over n centroids" ).def(0);
option.add( basic::options::OptionKeys::cm::hybridize::frag_weight_aligned, "Probability of fragment insertion in the aligned region" ).def(0.);
option.add( basic::options::OptionKeys::cm::hybridize::move_anchor, "move anchor residue when copying xyz in stage 1" ).def(false);
option.add( basic::options::OptionKeys::cm::hybridize::max_registry_shift, "maximum registry shift" ).def(0);
option.add( basic::options::OptionKeys::cm::hybridize::alignment_from_template_seqpos, "alignment from template resSeq" ).def(true);
option.add( basic::options::OptionKeys::cm::hybridize::alignment_from_chunk_mapping, "alignment from secondary structure mapping" );
option.add( basic::options::OptionKeys::cm::hybridize::virtual_loops, "use virtual loops" ).def(false);
option.add( basic::options::OptionKeys::cm::hybridize::revert_real_loops, "revert back to non-virtual loops" ).def(false);
option.add( basic::options::OptionKeys::ms::ms, "ms option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::ms::share_data, "share rotamers and energies between states -- valid only if state variability is defined rotamerically" ).def(false);
option.add( basic::options::OptionKeys::ms::verbose, "" ).def(false);
option.add( basic::options::OptionKeys::ms::restrict_to_canonical, "design only canonical residue types" ).def(false);
option.add( basic::options::OptionKeys::ms::pop_from_ss, "generate starting sequence population based on single-state design results" ).def(0);
option.add( basic::options::OptionKeys::ms::pop_size, "genetic algorithm population size" ).def(100);
option.add( basic::options::OptionKeys::ms::generations, "number of genetic algorithm generations" ).def(20);
option.add( basic::options::OptionKeys::ms::num_packs, "number of repack trials per sequence/state combination" ).def(1);
option.add( basic::options::OptionKeys::ms::numresults, "number of top-fitness results to save for explicit reference at the end of multistate design" ).def(1);
option.add( basic::options::OptionKeys::ms::anchor_offset, "energy offset from the energy of single-state design toward the target state -- used to generate an affinity anchor for fitness calculations" ).def(5.0);
option.add( basic::options::OptionKeys::ms::Boltz_temp, "thermodynamic temperature to use for specificity calculations" ).def(0.6);
option.add( basic::options::OptionKeys::ms::mutate_rate, "rate of mutation per position" ).def(0.5);
option.add( basic::options::OptionKeys::ms::fraction_by_recombination, "fraction of the population that should be generated by recombination during the evolution stage" ).def(0.5);
option.add( basic::options::OptionKeys::ms::checkpoint::checkpoint, "checkpoint option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::ms::checkpoint::prefix, "prefix to add to the beginning of checkpoint file names" ).def("");
option.add( basic::options::OptionKeys::ms::checkpoint::interval, "frequency with which the entity checkpoint is written" ).def(0);
option.add( basic::options::OptionKeys::ms::checkpoint::gz, "compress checkpoing files with gzip" ).def(false);
option.add( basic::options::OptionKeys::ms::checkpoint::rename, "rename checkpoint files after genetic algorithm completes" ).def(false);
option.add( basic::options::OptionKeys::loops::loops, "loop modeling option group" ).legal(true).legal(false).def(true);
option.add( basic::options::OptionKeys::loops::cen_weights, "ScoreFunction weights file for centroid phase of loop-modeling" ).def("cen_std");
option.add( basic::options::OptionKeys::loops::cen_patch, "ScoreFunction patch for for centroid phase of loop-modeling" ).def("score4L");
option.add( basic::options::OptionKeys::loops::input_pdb, "template pdb file" ).def("input_pdb");
option.add( basic::options::OptionKeys::loops::loop_file, "Loop definition file(s). When multiple files are given a *random* one will be picked each time when this parameter is requested." );
option.add( basic::options::OptionKeys::loops::extended_loop_file, "loop definition file for loops to be extended (used in abrelax)" ).def("loop_file");
option.add( basic::options::OptionKeys::loops::mm_loop_file, "loop definition file" ).def("loop_file");
option.add( basic::options::OptionKeys::loops::fix_natsc, "fix sidechains in template region in loop modeling" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::refine_only, "perform full atom refinement only on loops" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::fa_input, "input structures are in full atom format" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::fast, "reduce number of simulation cycles in loop modeling" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::vall_file, "vall database file" ).def("vall_file");
option.add( basic::options::OptionKeys::loops::frag_sizes, "lengths of fragments to be used in loop modeling" ).def(9).def(3).def(1);
option.add( basic::options::OptionKeys::loops::frag_files, "fragment libraries files" ).def("frag9").def("frag3").def("frag1");
option.add( basic::options::OptionKeys::loops::output_pdb, "output model pdb file" ).def("output.pdb");
option.add( basic::options::OptionKeys::loops::debug, "No description" ).def(false);
option.add( basic::options::OptionKeys::loops::build_initial, "Precede loop-modeling with an initial round of just removing the missing densities and building simple loops" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::extended, "Force extended on loops, independent of loop input file" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::remove_extended_loops, "Before building any loops, remove all loops marked as extended" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::idealize_after_loop_close, "Run structure through idealizer after loop_closing" ).def(false);
option.add( basic::options::OptionKeys::loops::idealize_before_loop_close, "Run structure through idealizer before loop_closing" ).def(false);
option.add( basic::options::OptionKeys::loops::select_best_loop_from, "Keep building loops until N and choose best (by score)" ).def(1);
option.add( basic::options::OptionKeys::loops::build_attempts, "Build attempts per growth attempt" ).def(3);
option.add( basic::options::OptionKeys::loops::grow_attempts, "Total loop growth attempts" ).def(7);
option.add( basic::options::OptionKeys::loops::random_grow_loops_by, "Randomly grow loops by up to this number of residues on either side." ).def(0.0);
option.add( basic::options::OptionKeys::loops::accept_aborted_loops, "accept aborted loops      " ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::strict_loops, "Do not allow growing of loops" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::superimpose_native, "Superimpose the native over the core before calculating looprms" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::build_specific_loops, "Numbers of the loops to be built" );
option.add( basic::options::OptionKeys::loops::random_order, "build in random order     " ).legal(true).legal(false).def(true);
option.add( basic::options::OptionKeys::loops::build_all_loops, "build all loops(no skip)  " ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::fa_closure_protocol, "Abrelax uses FASlidingWindowLoopClosure... " ).def(false);
option.add( basic::options::OptionKeys::loops::combine_rate, "Combine successive loops at this rate" ).def(0.0);
option.add( basic::options::OptionKeys::loops::remodel, "" ).legal("no").legal("perturb_ccd").legal("perturb_kic").legal("quick_ccd").legal("quick_ccd_moves").legal("old_loop_relax").legal("sdwindow").def("no");
option.add( basic::options::OptionKeys::loops::intermedrelax, "" ).legal("no").legal("relax").legal("fastrelax").legal("seqrelax").def("no");
option.add( basic::options::OptionKeys::loops::refine, "method for performing full-atom refinement on loops" ).legal("no").legal("refine_ccd").legal("refine_kic").def("no");
option.add( basic::options::OptionKeys::loops::relax, "" ).legal("no").legal("relax").legal("fastrelax").legal("seqrelax").legal("minirelax").def("no");
option.add( basic::options::OptionKeys::loops::n_rebuild_tries, "number of times to retry loop-rebuilding" ).def(1);
option.add( basic::options::OptionKeys::loops::final_clean_fastrelax, "Add a final fastrelax without constraints" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::relax_with_foldtree, "keep foldtree during relax" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::constrain_rigid_segments, "Use Coordinate constraints on the non-loop regions" ).def(0.0);
option.add( basic::options::OptionKeys::loops::loopscores, "Calculate loopscores individually" );
option.add( basic::options::OptionKeys::loops::timer, "Output time spent in seconds for each loop modeling job" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::vicinity_sampling, "only sample within a certain region of the current torsion values" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::vicinity_degree, "number of degrees to sample within current torsion values for vicinity sampling" ).def(1.0);
option.add( basic::options::OptionKeys::loops::neighbor_dist, "CB distance cutoff for repacking, rotamer trails, and side-chain minimization during loop modeling. NOTE: values over 10.0 are effectively reduced to 10.0" ).def(10.0);
option.add( basic::options::OptionKeys::loops::kic_max_seglen, "maximum size of residue segments used in kinematic closure calculations" ).def(12);
option.add( basic::options::OptionKeys::loops::kic_recover_last, "If true, do not recover lowest scoring pose after each outer cycle and at end of protocol in kic remodel and refine" ).def(false);
option.add( basic::options::OptionKeys::loops::kic_min_after_repack, "Should the kinematic closure refine protocol minimize after repacking steps" ).def(false);
option.add( basic::options::OptionKeys::loops::optimize_only_kic_region_sidechains_after_move, "Should we perform rotamer trials and minimization after every KIC move but only within the loops:neighbor_dist of the residues in the moved KIC segment. Useful to speed up when using very large loop definitions (like when whole chains are used for ensemble generation)." ).def(false);
option.add( basic::options::OptionKeys::loops::max_kic_build_attempts, "Number of attempts at initial kinematic closure loop building" ).def(100);
option.add( basic::options::OptionKeys::loops::remodel_kic_attempts, "Number of kic attempts per inner cycle during perturb_kic protocol" ).def(300);
option.add( basic::options::OptionKeys::loops::max_kic_perturber_samples, "Maximum number of kinematic perturber samples" ).def(2000);
option.add( basic::options::OptionKeys::loops::nonpivot_torsion_sampling, "enables sampling of non-pivot residue torsions when the kinematic loop closure segment length is > 3" ).legal(true).legal(false).def(true);
option.add( basic::options::OptionKeys::loops::fix_ca_bond_angles, "Freezes N-CA-C bond angles in KIC loop sampling" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::kic_use_linear_chainbreak, "Use linear_chainbreak instead of (harmonic) chainbreak in KIC loop sampling" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::sample_omega_at_pre_prolines, "Sample omega in KIC loop sampling" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::allow_omega_move, "Allow loop omega to minimize during loop modeling" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::allow_takeoff_torsion_move, "Allow takeoff phi/psi to move during loop modeling" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::extend_length, "Number of alanine residues to append after cutpoint in loopextend app" ).lower(0).def(0);
option.add( basic::options::OptionKeys::loops::outer_cycles, "outer cycles in fullatom loop refinement" ).lower(1).def(3);
option.add( basic::options::OptionKeys::loops::max_inner_cycles, "maxium number of inner cycles in fullatom loop refinement" ).lower(1).def(1);
option.add( basic::options::OptionKeys::loops::repack_period, "repack period during fullatom loop refinement" ).lower(1).def(20);
option.add( basic::options::OptionKeys::loops::repack_never, "option to disable repacking during loop movement" ).def(false);
option.add( basic::options::OptionKeys::loops::remodel_init_temp, "Initial temperature for loop rebuiding. Currently only supported in kinematic (KIC) mode" ).def(2.0);
option.add( basic::options::OptionKeys::loops::remodel_final_temp, "Final temperature for loop rebuilding. Currently only supported in kinematic (KIC) mode" ).def(1.0);
option.add( basic::options::OptionKeys::loops::refine_init_temp, "Initial temperature for loop refinement. Currently only supported in kinematic (KIC) mode" ).def(1.5);
option.add( basic::options::OptionKeys::loops::refine_final_temp, "Final temperature for loop refinement. Currently only supported in kinematic (KIC) mode" ).def(0.5);
option.add( basic::options::OptionKeys::loops::gapspan, "when automatically identifying loop regions, this is the maximum gap length for a single loop" ).lower(1).def(6);
option.add( basic::options::OptionKeys::loops::spread, "when automatically identifying loop regions, this is the number of neighboring residues by which to extend out loop regions" ).lower(1).def(2);
option.add( basic::options::OptionKeys::loops::kinematic_wrapper_cycles, "maximum number of KinematicMover apply() tries per KinematicWrapper apply()" ).def(20);
option.add( basic::options::OptionKeys::loops::alternative_closure_protocol, "use WidthFirstSliding..." ).def(false);
option.add( basic::options::OptionKeys::loops::chainbreak_max_accept, "accept all loops that have a lower cumulative chainbreak score (linear,quadratic(if present), and overlap)" ).def(2.0);
option.add( basic::options::OptionKeys::loops::debug_loop_closure, "dump structures before and after loop closing" ).def(false);
option.add( basic::options::OptionKeys::loops::non_ideal_loop_closing, "allow small non-idealities at the chainbreak residue after loop-closing -- requires binary silent out" ).def(false);
option.add( basic::options::OptionKeys::loops::scored_frag_cycles, "cycle-ratio for scored_frag_cycles ( loop_size<10 ) after jumping-abinitio" ).def(0.1);
option.add( basic::options::OptionKeys::loops::short_frag_cycles, "cycle-ratio for short_frag_cycles ( loop_size<10 ) after jumping-abinitio" ).def(0.2);
option.add( basic::options::OptionKeys::loops::rmsd_tol, "rmsd tolerance to deviate from original pose" ).def(10000.0);
option.add( basic::options::OptionKeys::loops::chain_break_tol, "acceptable tolerance for chain break score" ).def(0.2);
option.add( basic::options::OptionKeys::loops::random_loop, "randomize loop stub positions" ).def(false);
option.add( basic::options::OptionKeys::loops::stealfrags, "StealFragPDBS" );
option.add( basic::options::OptionKeys::loops::stealfrags_times, "StealFragPDBS how many times ?" ).def(1);
option.add( basic::options::OptionKeys::loops::coord_cst, "restraintweight" ).def(0.0);
option.add( basic::options::OptionKeys::loops::skip_1mers, "rate at which you should skip a 1 mer insertion" ).def(0.0);
option.add( basic::options::OptionKeys::loops::skip_3mers, "rate at which you should skip a 3 mer insertion" ).def(0.0);
option.add( basic::options::OptionKeys::loops::skip_9mers, "rate at which you should skip a 9 mer insertion" ).def(0.0);
option.add( basic::options::OptionKeys::loops::loop_model, "loop modeling option" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::score_filter_cutoff, "value for score filter" ).def(1.0);
option.add( basic::options::OptionKeys::loops::loop_farlx, "do fullatom loop refinement" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::ccd_closure, "apply ccd closure" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::skip_ccd_moves, "when running in ccd_moves mode, dont actually do ccd_moves.. just do fragment insertions" ).def(false);
option.add( basic::options::OptionKeys::loops::no_randomize_loop, "Leave loop as it is" ).def(false);
option.add( basic::options::OptionKeys::loops::loops_subset, "pick subset of desired loops" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::num_desired_loops, "number of desired loops" ).def(1);
option.add( basic::options::OptionKeys::loops::loop_combine_rate, "skip rate for not combining a chosen loop" ).def(0.0);
option.add( basic::options::OptionKeys::loops::final_score_filter, "Only output structures that score bette rthan that" ).def(1000000.0);
option.add( basic::options::OptionKeys::loops::no_combine_if_fail, "combine loops if loop modeling fails" ).legal(true).legal(false).def(true);
option.add( basic::options::OptionKeys::loops::shorten_long_terminal_loop, "shorten long loops" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::backrub_trials, "number of backrub steps to do in loop relax" ).def(10);
option.add( basic::options::OptionKeys::loops::looprlx_cycle_ratio, "fraction of the total looprlx cycles" ).def(1.0);
option.add( basic::options::OptionKeys::loops::extended_beta, "Extended tempfactor: stochastic extendedness: p_ext = exp( - beta * length ) " ).def(-1.0);
option.add( basic::options::OptionKeys::loops::shortrelax, "do a short fullatom relax after loop remodeling" ).def(false);
option.add( basic::options::OptionKeys::loops::fastrelax, "do a fast fullatom relax after loop remodeling" ).def(false);
option.add( basic::options::OptionKeys::loops::no_looprebuild, "do not rebuild loops" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::allow_lig_move, "allow ligands to move during loop modeling" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::loops::keep_natro, "list of residues where the rotamers are kept fixed" ).def("keep_natro");
option.add( basic::options::OptionKeys::loops::refine_design_iterations, "iterations of refine and design" ).def(1);
option.add( basic::options::OptionKeys::assembly::assembly, "assembly option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::assembly::pdb1, "pdb1 file" );
option.add( basic::options::OptionKeys::assembly::pdb2, "pdb2 file" );
option.add( basic::options::OptionKeys::assembly::nterm_seq, "extra sequence at Nterminus" ).def("");
option.add( basic::options::OptionKeys::assembly::cterm_seq, "extra sequence at Cterminus" ).def("");
option.add( basic::options::OptionKeys::assembly::linkers_pdb1, "Residue numbers to be built as linkers " );
option.add( basic::options::OptionKeys::assembly::linkers_pdb2, "Residue numbers to be built as linkers " );
option.add( basic::options::OptionKeys::assembly::preserve_sidechains_pdb1, "Residue numbers to be sidchain-preserved " );
option.add( basic::options::OptionKeys::assembly::preserve_sidechains_pdb2, "Residue numbers to be sidchain-preserved " );
option.add( basic::options::OptionKeys::fast_loops::fast_loops, "fast_loops option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::fast_loops::window_accept_ratio, "windows with more than x percent of good loops in fast-loop sampling are used for scored-sampling" ).def(0.0);
option.add( basic::options::OptionKeys::fast_loops::nr_scored_sampling_passes, "good windows go into scored-sampling N times" ).def(4);
option.add( basic::options::OptionKeys::fast_loops::nr_scored_fragments, "scored loops sampled per good window each pass" ).def(10);
option.add( basic::options::OptionKeys::fast_loops::min_breakout_good_loops, "stop doing scored sampling if N or more good loops have been found" ).def(5);
option.add( basic::options::OptionKeys::fast_loops::min_breakout_fast_loops, "stop doing fast sampling if N or more good loops have been found" ).def(40);
option.add( basic::options::OptionKeys::fast_loops::min_good_loops, "treat as failure if less good-loops than" ).def(0);
option.add( basic::options::OptionKeys::fast_loops::min_fast_loops, "treat as failure if less fast-loops than" ).def(3);
option.add( basic::options::OptionKeys::fast_loops::vdw_delta, "accept as good loop if vdw-score < vdw-score-start+vdw-delta" ).def(0);
option.add( basic::options::OptionKeys::fast_loops::give_up, "if N scored_frag_attemps didnt give any good loop -- jump out" ).def(50);
option.add( basic::options::OptionKeys::fast_loops::chainbreak_max, "accept only loops that have a maximum chainbreak score of... (sum of linear_chainbreak / chainbreak and overlap_chainbreak" ).def(0.2);
option.add( basic::options::OptionKeys::fast_loops::fragsample_score, "Scorefunction used durgin scored-frag sampling" ).def("loop_fragsample.wts");
option.add( basic::options::OptionKeys::fast_loops::fragsample_patch, "Patch weights for scorefunction used during scored-frag sampling" );
option.add( basic::options::OptionKeys::fast_loops::overwrite_filter_scorefxn, "force Scorefunction to be used during filter stage (instead last score of sampling protocol)" );
option.add( basic::options::OptionKeys::fast_loops::patch_filter_scorefxn, "apply patch to Scorefunction used during filter stage" );
option.add( basic::options::OptionKeys::fast_loops::filter_cst_file, "use these constraints to filter loops --- additional to whatever is in pose already" );
option.add( basic::options::OptionKeys::fast_loops::filter_cst_weight, "weight for constraints versus normal score (might contain additional constraints)" ).def(1.0);
option.add( basic::options::OptionKeys::fast_loops::fast_relax_sequence_file, "use this FastRelax protocol for loop-selection" );
option.add( basic::options::OptionKeys::SSrbrelax::SSrbrelax, "SSrbrelax option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::SSrbrelax::input_pdb, "input pdb file" ).def("input_pdb");
option.add( basic::options::OptionKeys::SSrbrelax::rb_file, "rb definition file" ).def("rb_file");
option.add( basic::options::OptionKeys::SSrbrelax::rb_param_file, "rb param file" ).def("rb_param_file");
option.add( basic::options::OptionKeys::SSrbrelax::frag_sizes, "lengths of fragments to be used in loop modeling" ).def(9).def(3).def(1);
option.add( basic::options::OptionKeys::SSrbrelax::frag_files, "fragment libraries files" ).def("FragFile9").def("FragFile3").def("FragFile1");
option.add( basic::options::OptionKeys::boinc::boinc, "boinc option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::boinc::graphics, "The boinc client uses this option for the windowed graphics" ).def(false);
option.add( basic::options::OptionKeys::boinc::fullscreen, "The boinc client uses this option for the screensaver full screen graphics" ).def(false);
option.add( basic::options::OptionKeys::boinc::max_fps, "Maximum frames per second, overrides user preference." ).def(0);
option.add( basic::options::OptionKeys::boinc::max_cpu, "Maximum cpu percentage, overrides user preferecne." ).def(0);
option.add( basic::options::OptionKeys::boinc::noshmem, "for testing graphics without shared memory." ).def(false);
option.add( basic::options::OptionKeys::boinc::cpu_run_time, "Target cpu run time in seconds" ).def(10800);
option.add( basic::options::OptionKeys::boinc::max_nstruct, "Maximum number of output models (failed or successful) for a given client" ).def(99);
option.add( basic::options::OptionKeys::boinc::cpu_frac, "Percentage of CPU time used for graphics" ).def(10.0);
option.add( basic::options::OptionKeys::boinc::frame_rate, "Number of frames per second for graphics" ).def(10.0);
option.add( basic::options::OptionKeys::boinc::watchdog, "Turn watchdog on" ).def(false);
option.add( basic::options::OptionKeys::boinc::watchdog_time, "Time interval in seconds used by watchdog to check if run is stuck or going too long (default every 5 minutes)" ).def(300);
option.add( basic::options::OptionKeys::boinc::cpu_run_timeout, "Maximum time the WU may exceed the users WU time settings. Default is 4 hours.  Used by watchdog." ).def(14400);
option.add( basic::options::OptionKeys::boinc::description_file, "work unit description file" ).def("rosetta_description.txt");
option.add( basic::options::OptionKeys::LoopModel::LoopModel, "LoopModel option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::LoopModel::input_pdb, "input pdb file" ).def("LoopModel::input_pdb");
option.add( basic::options::OptionKeys::LoopModel::loop_file, "input loops list file" ).def("LoopModel::loop_file");
option.add( basic::options::OptionKeys::AnchoredDesign::AnchoredDesign, "AnchoredDesign option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::AnchoredDesign::anchor, "anchor specification file" ).def("anchor");
option.add( basic::options::OptionKeys::AnchoredDesign::allow_anchor_repack, "allow repacking of anchor (default is to prevent)" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::vary_cutpoints, "vary loop cutpoints.  Picks new cutpoints at start of each nstruct" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::no_frags, "use no fragments.  Overrides passing an old-style fragment file.  Skips new-style fragment generation." ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::debug, "debug mode (extra checks and pdb dumps)" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::show_extended, "dump pre-perturb PDB to check if loop torsions are extended" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::refine_only, "refine only mode (skip perturbation step)" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::perturb_show, "dump perturbed centroid pdbs as well as final results" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::perturb_cycles, "perturbation phase runs for <input> cycles" ).def(5);
option.add( basic::options::OptionKeys::AnchoredDesign::perturb_temp, "perturbation phase temperature for monte carlo" ).def(0.8);
option.add( basic::options::OptionKeys::AnchoredDesign::perturb_CCD_off, "CCD-style loop remodeling off in perturb phase (meaning, KIC only)" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::perturb_KIC_off, "KIC-style loop remodeling off in perturb phase (meaning, CCD only)" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::refine_CCD_off, "CCD-style loop remodeling off in refine phase (meaning, KIC only)" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::refine_KIC_off, "KIC-style loop remodeling off in refine phase (meaning, CCD only)" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::refine_cycles, "refinement phase runs for <input> cycles" ).def(5);
option.add( basic::options::OptionKeys::AnchoredDesign::refine_temp, "refinement phase temperature for monte carlo" ).def(0.8);
option.add( basic::options::OptionKeys::AnchoredDesign::refine_repack_cycles, "refinement phase runs repack every <input> cycles" ).lower(2).def(20);
option.add( basic::options::OptionKeys::AnchoredDesign::rmsd, "Calculate result structure CA RMSD from starting structure" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::unbound_mode, "Ignore the anchor, as if this were loop modeling" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::chainbreak_weight, "Chainbreak term weight" ).def(2.0);
option.add( basic::options::OptionKeys::AnchoredDesign::filters::filters, "filters option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::AnchoredDesign::filters::score, "do not print trajectories with scores greater than this total scorefunction value" ).def(0);
option.add( basic::options::OptionKeys::AnchoredDesign::filters::sasa, "do not print trajectories with sasas less than this interface delta sasa value" ).def(500);
option.add( basic::options::OptionKeys::AnchoredDesign::filters::omega, "filter out non-trans omegas" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::akash::akash, "akash option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::AnchoredDesign::akash::dyepos, "dye position" ).def(0);
option.add( basic::options::OptionKeys::AnchoredDesign::testing::testing, "testing option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::AnchoredDesign::testing::VDW_weight, "centroid VDW weight; testing if 2 better than 1" ).lower(0).def(1.0);
option.add( basic::options::OptionKeys::AnchoredDesign::testing::anchor_via_constraints, "allow anchor&jump to move; anchor held in place via constraints - you must specify constraints!" ).def(false);
option.add( basic::options::OptionKeys::AnchoredDesign::testing::delete_interface_native_sidechains, "benchmarking option.  delete input sidechains as prepacking step before running centroid or fullatom phases.  use if also using use_input_sc and doing benchmarking.  use_input_sc is used because of sidechain minimization, not to maintain input sidechains." );
option.add( basic::options::OptionKeys::AnchoredDesign::testing::RMSD_only_this, "Perform only RMSD calculations without modifying input.  Only used for re-running metrics during benchmarking/debugging." );
option.add( basic::options::OptionKeys::AnchoredDesign::testing::anchor_noise_constraints_mode, "Hold the anchor loosely (via constraints), not rigidly.  Automatically generate the constraints from the starting pose.  Mildly randomize the anchor's placement before modeling (up to 1 angstrom in x,y,z from initial placement.)  Only compatible with single-residue anchors.  Used to meet a reviewer's commentary." ).def(false);
option.add( basic::options::OptionKeys::DenovoProteinDesign::DenovoProteinDesign, "DenovoProteinDesign option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::DenovoProteinDesign::redesign_core, "redesign core of pdb" ).def(false);
option.add( basic::options::OptionKeys::DenovoProteinDesign::redesign_loops, "redesign loops of pdb" ).def(false);
option.add( basic::options::OptionKeys::DenovoProteinDesign::redesign_surface, "redesign surface of pdb" ).def(false);
option.add( basic::options::OptionKeys::DenovoProteinDesign::redesign_complete, "complete redesign of pdb" ).def(false);
option.add( basic::options::OptionKeys::DenovoProteinDesign::disallow_native_aa, "do not allow native aa in design" ).def(false);
option.add( basic::options::OptionKeys::DenovoProteinDesign::optimize_loops, "do serious loop modeling at the end of designrelax mover" );
option.add( basic::options::OptionKeys::DenovoProteinDesign::secondary_structure_file, "has fasta file format - describes secondary structure of desired target with H/C/E" );
option.add( basic::options::OptionKeys::DenovoProteinDesign::hydrophobic_polar_pattern, "has fasta file format - describes hydrophobic(B) polar(P) pattern" );
option.add( basic::options::OptionKeys::DenovoProteinDesign::use_template_sequence, "use the template pdbs sequence when creating starting structures" ).def(false);

}
inline void add_rosetta_options_3( utility::options::OptionCollection &option ) {option.add( basic::options::OptionKeys::DenovoProteinDesign::use_template_topology, "use templates phi/psi in loops and begin/end helix/sheet generate only template like starting structures" ).def(false);
option.add( basic::options::OptionKeys::DenovoProteinDesign::create_from_template_pdb, "create starting structure from a template pdb, follow with pdb name" );
option.add( basic::options::OptionKeys::DenovoProteinDesign::create_from_secondary_structure, "create starting structure from a file that contains H/C/E to describe topology or B/P pattern, has fasta file format" ).def(false);
option.add( basic::options::OptionKeys::RBSegmentRelax::RBSegmentRelax, "RBSegmentRelax option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::RBSegmentRelax::input_pdb, "input pdb file" ).def("--");
option.add( basic::options::OptionKeys::RBSegmentRelax::rb_file, "input rb segment file" ).def("--");
option.add( basic::options::OptionKeys::RBSegmentRelax::cst_wt, "Weight on constraint term in scoring function" ).def(0.1);
option.add( basic::options::OptionKeys::RBSegmentRelax::cst_width, "Width of harmonic constraints on csts" ).def(1.0);
option.add( basic::options::OptionKeys::RBSegmentRelax::cst_pdb, "PDB file from which to draw constraints" ).def("--");
option.add( basic::options::OptionKeys::RBSegmentRelax::nrbmoves, "number of rigid-body moves" ).def(100);
option.add( basic::options::OptionKeys::RBSegmentRelax::nrboutercycles, "number of rigid-body moves" ).def(5);
option.add( basic::options::OptionKeys::RBSegmentRelax::rb_scorefxn, "number of rigid-body moves" ).def("score5");
option.add( basic::options::OptionKeys::RBSegmentRelax::skip_fragment_moves, "omit fragment insertions (in SS elements)" ).def(false);
option.add( basic::options::OptionKeys::RBSegmentRelax::skip_seqshift_moves, "omit sequence shifting moves" ).def(false);
option.add( basic::options::OptionKeys::RBSegmentRelax::skip_rb_moves, "omit rigid-body moves" ).def(false);
option.add( basic::options::OptionKeys::RBSegmentRelax::helical_movement_params, "helical-axis-rotation, helical-axis-translation, off-axis-rotation, off-axis-translation" ).def(utility::vector1<float>(4,0.0));
option.add( basic::options::OptionKeys::RBSegmentRelax::strand_movement_params, "strand-in-plane-rotation, strand-in-plane-translation, out-of-plane-rotation, out-of-plane-translationn" ).def(utility::vector1<float>(4,0.0));
option.add( basic::options::OptionKeys::RBSegmentRelax::default_movement_params, "default-rotation, default-translation" ).def(utility::vector1<float>(2,0.0));
option.add( basic::options::OptionKeys::RBSegmentRelax::cst_seqwidth, "sequence width on constraints" ).def(0);
option.add( basic::options::OptionKeys::edensity::edensity, "edensity option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::edensity::debug, "No description" ).def(false);
option.add( basic::options::OptionKeys::edensity::mapfile, "No description" );
option.add( basic::options::OptionKeys::edensity::mapreso, "No description" ).def(3.0);
option.add( basic::options::OptionKeys::edensity::grid_spacing, "No description" ).def(0.0);
option.add( basic::options::OptionKeys::edensity::centroid_density_mass, "No description" ).def(0.0);
option.add( basic::options::OptionKeys::edensity::sliding_window, "No description" ).def(1);
option.add( basic::options::OptionKeys::edensity::fastdens_wt, "wt of fast edens score" ).def(0.0);
option.add( basic::options::OptionKeys::edensity::sliding_window_wt, "wt of edens sliding-window score" ).def(0.0);
option.add( basic::options::OptionKeys::edensity::score_sliding_window_context, "when using sl. win. density fit, include neighbor atoms (slows trajectory)" ).def(false);
option.add( basic::options::OptionKeys::edensity::whole_structure_ca_wt, "wt of edens centroid (CA-only) scoring" ).def(0.0);
option.add( basic::options::OptionKeys::edensity::whole_structure_allatom_wt, "wt of edens centroid (allatom) scoring" ).def(0.0);
option.add( basic::options::OptionKeys::edensity::no_edens_in_minimizer, "exclude density score from minimizer" ).def(false);
option.add( basic::options::OptionKeys::edensity::debug_derivatives, "calculate numeric derivatives for density terms and compare with analytical" ).def(false);
option.add( basic::options::OptionKeys::edensity::realign, "how to initially align the pose to density" ).legal("no").legal("min").legal("random").legal("membrane").legal("membrane_min").def("no");
option.add( basic::options::OptionKeys::edensity::membrane_axis, "the membrane normal axis" ).def("Z");
option.add( basic::options::OptionKeys::edensity::atom_mask, "override default (=3.2A) atom mask radius to this value (hi-res scoring)" ).def(3.2);
option.add( basic::options::OptionKeys::edensity::ca_mask, "override default (=6A) CA mask radius to this value (low-res scoring)" ).def(6.0);
option.add( basic::options::OptionKeys::edensity::score_symm_complex, "If set, scores the structure over the entire symmetric complex; otherwise just use controlling monomer" ).def(false);
option.add( basic::options::OptionKeys::edensity::sc_scaling, "Scale sidechain density by this amount (default same as mainchain density)" ).def(1.0);
option.add( basic::options::OptionKeys::edensity::render_sigma, "initially render at this sigma level (extras=graphics build only)" ).def(2);
option.add( basic::options::OptionKeys::edensity::missing_density_to_jump, "Place jumps where missing density is found" ).def(false);
option.add( basic::options::OptionKeys::patterson::patterson, "patterson option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::patterson::debug, "No description" ).def(false);
option.add( basic::options::OptionKeys::patterson::weight, "wt of patterson correlation" ).def(0.0);
option.add( basic::options::OptionKeys::patterson::sc_scaling, "Scale sidechain density by this amount (default = same as mainchain density)" ).def(1.0);
option.add( basic::options::OptionKeys::patterson::radius_cutoffs, "patterson-space radius cuttoffs" );
option.add( basic::options::OptionKeys::patterson::resolution_cutoffs, "reciprocal space F^2 cuttoffs" );
option.add( basic::options::OptionKeys::patterson::Bsol, "solvent B" ).def(300.0);
option.add( basic::options::OptionKeys::patterson::Fsol, "solvent fraction" ).def(0.95);
option.add( basic::options::OptionKeys::patterson::model_B, "B factor computing patterson CC" ).def(0.0);
option.add( basic::options::OptionKeys::patterson::rmsd, "Expected RMS error for sigma-A calculation" ).def(2.0);
option.add( basic::options::OptionKeys::patterson::no_ecalc, "Do not normalize p_o with ecalc" ).def(false);
option.add( basic::options::OptionKeys::patterson::nshells, "Number of resolution shells for patterson normalization" ).def(50);
option.add( basic::options::OptionKeys::patterson::use_spline_interpolation, "use spline interpolation for derivative evaluation? (default trilinear)" ).def(false);
option.add( basic::options::OptionKeys::patterson::use_on_repack, "SLOW - use patterson correlation on repacks (default no)" ).def(false);
option.add( basic::options::OptionKeys::patterson::dont_use_symm_in_pcalc, "perform Pcalc in P1 (default no)" ).def(false);
option.add( basic::options::OptionKeys::optE::optE, "optE option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::optE::load_from_silent, "load from silent instead of pdb - uses path of requested pdb to find silent file, each PDB needs to have all of its structures in its own folder (ie: 1agy/pdb_set.silent) - only works in optimize_decoy_discrimination" ).def("pdb_set.silent");
option.add( basic::options::OptionKeys::optE::data_in, "file from which to read in optE data" ).def("optE.data");
option.add( basic::options::OptionKeys::optE::data_out, "file to which to write optE data" ).def("optE.data.out");
option.add( basic::options::OptionKeys::optE::weights, "a conventional weightfile that optE will use to determine which weights will be counted.  All non-zero weights in the file will contribute to rotamer energies and be fit; use the -optE::fix option to fix any of these weights.  Weight values will also be used as starting values for optimization." );
option.add( basic::options::OptionKeys::optE::fix, "weights to be fixed (must also appear in the weightfile given by the -optE::weights option)" );
option.add( basic::options::OptionKeys::optE::free, "IterativeOptEDriver flag: specify a file to read score types that are free -- optionally include a starting weight for each score type" );
option.add( basic::options::OptionKeys::optE::fixed, "IterativeOptEDriver flag: specify a file to read score types and weights for score types that are on but fixed" );
option.add( basic::options::OptionKeys::optE::parse_tagfile, "a file in utility::tag format that optE may parse to customize its operation" );
option.add( basic::options::OptionKeys::optE::constant_logic_taskops_file, "a file in utility::tag format that optE uses to build a task that will not change with the context of the pose after design" );
option.add( basic::options::OptionKeys::optE::optE_soft_rep, "Instruct the IterativeOptEDriver to use the soft-repulsion etable" );
option.add( basic::options::OptionKeys::optE::no_hb_env_dependence, "Disable environmental dependent weighting of hydrogen bond terms" );
option.add( basic::options::OptionKeys::optE::no_hb_env_dependence_DNA, "Disable environmental dependent weighting of hydrogen bonds involving DNA" );
option.add( basic::options::OptionKeys::optE::optE_no_protein_hack_elec, "Instruct the IterativeOptEDriver to use the soft-repulsion etable" ).def(false);
option.add( basic::options::OptionKeys::optE::design_first, "Do not optimize the weights in the context of the native structure, but rather, start by designing the protein with the input weight set.  Requires that all score types listed in -optE::free have specificed weights." );
option.add( basic::options::OptionKeys::optE::n_design_cycles, "The number of outer-loop design cycles to complete; default of 10 after which convergence has usually occurred" ).def(10);
option.add( basic::options::OptionKeys::optE::recover_nat_rot, "With the iterative optE driver, repack to recover the native rotamers" );
option.add( basic::options::OptionKeys::optE::component_weights, "With the iterative optE driver, weight the individual components according to the input file -- default weight of 1 for all components.  Weight file consists of component-name/weight pairs on separate lines: e.g. prob_native_structure 100.0" );
option.add( basic::options::OptionKeys::optE::optimize_nat_aa, "With the iterative optE driver, optimize weights to maximize the probability of the native rotamer" );
option.add( basic::options::OptionKeys::optE::optimize_nat_rot, "With the iterative optE driver, optimize weights to maximize the probability of the native rotamer in the native context" );
option.add( basic::options::OptionKeys::optE::optimize_ligand_rot, "With the iterative optE driver, optimize weights to maximize the probability of the native rotamer around the ligand" );
option.add( basic::options::OptionKeys::optE::optimize_pssm, "With the iterative optE driver, optimize weights to maximize the match between a BLAST generated pssm probabillity distribution" );
option.add( basic::options::OptionKeys::optE::optimize_dGbinding, "With the iterative optE driver, optimize weights to minimize squared error between the predicted dG of binding and the experimental dG; provide a file listing 1. bound PDB structure, 2. unbound PDB structure, and 3. measured dG" );
option.add( basic::options::OptionKeys::optE::optimize_ddG_bind_correlation, "With the iterative optE driver, optimize weights to minimize squared error between the predicted ddG of binding for a mutation to the experimental ddG; provide a file listing 1. list file containing wt complexes, 2. list file containing mut complexes, 3. list file containing wt unbounds structures, 4. list file containing mut unbounds structures, and 5. measured ddG of binding" );
option.add( basic::options::OptionKeys::optE::optimize_ddGmutation, "With the iterative optE driver, optimize weights to minimize the predicted ddG of mutation and the measured ddG; provide a file listing 1. repacked wt pdb list, 2. repacked mut pdb list, and 3. measured ddG triples" );
option.add( basic::options::OptionKeys::optE::optimize_ddGmutation_straight_mean, "With the iterative optE driver, predict the the ddGmut to be the difference between the straight mean (1/n Sum(E_i)) of the WT and MUT structures provided.  Requires the -optimize_ddGmutation flag be set." );
option.add( basic::options::OptionKeys::optE::optimize_ddGmutation_boltzman_average, "With the iterative optE driver, predict the the ddGmut to be the difference between the boltzman average energies ( Sum( E_i * e**-E_i/kT)/Sum( e**-E_i/kT) ) of the WT and MUT structures provided.  Requires the -optimize_ddGmutation flag be set." );
option.add( basic::options::OptionKeys::optE::exclude_badrep_ddGs, "With the iterative optE driver, consider only ddG data where the unweighted repulsive energy delta mut-wt < given value" );
option.add( basic::options::OptionKeys::optE::pretend_no_ddG_repulsion, "With the iterative optE driver, set all repulsive scores to zero when looking for ddG correlations" );
option.add( basic::options::OptionKeys::optE::optimize_decoy_discrimination, "With the iterative optE driver, optimize weights to maximize the partition between relaxed natives and low-scoring decoys.  File is a list of file-list pairs and a single pdb file < native_pdb_list, decoy_pdb_list, crystal_native_pdb >." );
option.add( basic::options::OptionKeys::optE::normalize_decoy_score_spread, "In decoy discrimination optimization, normalize both the native and decoy energies generated by a set of weights by sigma_curr /sigma_start where sigma_start is computed as the standard deviation of the decoy energies given an input weight set" );
option.add( basic::options::OptionKeys::optE::ramp_nativeness, "In decoy discrimination optimization, give structures in the range between max_rms_from_native and min_decoy_rms_to_native a nativeness score (which ramps linearly from 1 to 0 in that range) and include scores from structures in the numerator of the partition." );
option.add( basic::options::OptionKeys::optE::n_top_natives_to_optimize, "For use with the -optimize_decoy_discrimination flag.  Objective function considers top N natives in partition function" ).def(1);
option.add( basic::options::OptionKeys::optE::approximate_decoy_entropy, "Alpha expansion of conformation space size as a function of nres: size ~ alpha ^ nres; entropy ~ nres ln alpha." );
option.add( basic::options::OptionKeys::optE::repack_and_minimize_decoys, "Generate new structures in each round of iterative optE by repacking and minimizing the input decoys & natives using the weights obtained in the last round" );
option.add( basic::options::OptionKeys::optE::repack_and_minimize_input_structures, "Minimizing the input decoys & natives using the starting weights -- allows structures a chance to see the energy function before decoy discrimination begins without the memory overhead of the repack_and_minimize_decoys flag" );
option.add( basic::options::OptionKeys::optE::output_top_n_new_decoys, "For use with repack_and_minimize_decoys flag: Write out the top N decoys generated each round in this iterative refinement" ).def(0);
option.add( basic::options::OptionKeys::optE::optimize_ligand_discrimination, "With the iterative optE driver, optimize weights to maximize the partition between relaxed natives and low-scoring decoys.  File is a list of file-list pairs and a single pdb file < native_pdb_list, decoy_pdb_list, crystal_native_pdb >." );
option.add( basic::options::OptionKeys::optE::no_design, "Don't bother loading pdbs and doing design; just optimize weights for decoy-discrim and or native rotamer recovery" );
option.add( basic::options::OptionKeys::optE::sqrt_pssm, "Turn the pssm probability vectors into unit vectors so that dot product is a true similarity measure" );
option.add( basic::options::OptionKeys::optE::min_decoy_rms_to_native, "For use with the optimize_decoy_discrimination flag: exclude decoys that are within a certain RMS of the native structure" );
option.add( basic::options::OptionKeys::optE::max_rms_from_native, "For use with the optimize_decoy_discrimination flag: exclude natives that are more than a certain RMS of the crystal structure.  max_rms_from_native of 1.5, min_decoy_rms_from_native 2.0 would throw out structures in the range of 1.5 and 2.0 RMS from consideration" );
option.add( basic::options::OptionKeys::optE::optimize_starting_free_weights, "With the iterative optE driver, try many different starting points for the minimization" ).def(false);
option.add( basic::options::OptionKeys::optE::wrap_dof_optimization, "Create new dofs and setup arithmetic dependencies for free dofs." );
option.add( basic::options::OptionKeys::optE::randomly_perturb_starting_free_weights, "With the iterative optE driver, perturb the weights by +/- <input value> for those weights listed as free" );
option.add( basic::options::OptionKeys::optE::inv_kT_natrot, "1 / kT for the pNativeRotamer fitness function" ).def(1);
option.add( basic::options::OptionKeys::optE::inv_kT_nataa, "1 / kT for the pNatAA and PSSM fitness function" ).def(1);
option.add( basic::options::OptionKeys::optE::inv_kT_natstruct, "1 / kT for the pNativeStructure fitness function" ).def(1);
option.add( basic::options::OptionKeys::optE::mpi_weight_minimization, "Distribute OptEMultifunc func/dfunc evaluations across nodes" );
option.add( basic::options::OptionKeys::optE::dont_use_reference_energies, "Do not use reference energies anywhere during the protocol." ).def(false);
option.add( basic::options::OptionKeys::optE::number_of_swarm_particles, "The number of particles to use during particle swarm weight optimization." ).def(100);
option.add( basic::options::OptionKeys::optE::number_of_swarm_cycles, "The number of cycles to run the swarm minimizer for." ).def(20);
option.add( basic::options::OptionKeys::optE::constrain_weights, "When minimizing the fitness objective function, also include weight constraints in the objective function" );
option.add( basic::options::OptionKeys::optE::fit_reference_energies_to_aa_profile_recovery, "In the inner-loop sequence recovery/weight tweaking stage, accept/reject weight sets based on both the sequence recovery rate, and the mutual information between the expected and observed amino acid frequency distributions" );
option.add( basic::options::OptionKeys::optE::starting_refEs, "IterativeOptEDriver flag: specify a weights file to read reference energies from; do not optimize reference energies in the first round of weight fitting" );
option.add( basic::options::OptionKeys::optE::repeat_swarm_optimization_until_fitness_improves, "After the first time though the particle swarm optimization phase, if the end fitness is not better than the start fitness, recreate the swarm around the start dofs and repeat the swarm optimization." ).def(false);
option.add( basic::options::OptionKeys::optE::design_with_minpack, "Use the min-packer to design in the sequence recovery stages." ).def(false);
option.add( basic::options::OptionKeys::optE::rescore::rescore, "rescore option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::optE::rescore::weights, "Weight set to use when rescoring optE partition functions" );
option.add( basic::options::OptionKeys::optE::rescore::context_round, "Integer of the context PDBs generated during design to use to measure the pNatAA" );
option.add( basic::options::OptionKeys::optE::rescore::outlog, "File to which the OptEPosition data should be written" );
option.add( basic::options::OptionKeys::optE::rescore::measure_sequence_recovery, "When rescoring a weight set, run design with that weight set and measure the sequence recovery." ).def(false);
option.add( basic::options::OptionKeys::optE::no_design_pdb_output, "Do not write out the designed pdbs to the workdir_ directories over the course of the optE run" );
option.add( basic::options::OptionKeys::backrub::backrub, "backrub option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::backrub::pivot_residues, "residues for which contiguous stretches can contain segments (internal residue numbers, defaults to all residues)" ).def(utility::vector1<int>());
option.add( basic::options::OptionKeys::backrub::pivot_atoms, "main chain atoms usable as pivots" ).def(utility::vector1<std::string>(1, "CA"));
option.add( basic::options::OptionKeys::backrub::min_atoms, "minimum backrub segment size (atoms)" ).def(3);
option.add( basic::options::OptionKeys::backrub::max_atoms, "maximum backrub segment size (atoms)" ).def(34);
option.add( basic::options::OptionKeys::bbg::bbg, "bbg option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::bbg::factorA, "Control how big the move would be(acceptance rate), default 1.0" ).def(1.0);
option.add( basic::options::OptionKeys::bbg::factorB, "Control how local the move would be(folded 10.0, unfolded 0.1), default 10.0" ).def(10.0);
option.add( basic::options::OptionKeys::bbg::ignore_improper_res, "Skip improper residues (proline)" ).def(false);
option.add( basic::options::OptionKeys::bbg::fix_short_segment, "Do not apply small mover to short segments, for loop" ).def(false);
option.add( basic::options::OptionKeys::flexpack::flexpack, "flexpack option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::flexpack::annealer::annealer, "annealer option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::flexpack::annealer::inner_iteration_scale, "Scale up or down the number of inner iterations in the flexpack annealer" );
option.add( basic::options::OptionKeys::flexpack::annealer::outer_iteration_scale, "Scale up or down the number of outer iterations in the flexpack annealer" );
option.add( basic::options::OptionKeys::flexpack::annealer::fixbb_substitutions_scale, "Scale up or down the number of fixed-backbone rotamer substitutions in the flexpack annealer" );
option.add( basic::options::OptionKeys::flexpack::annealer::pure_movebb_substitutions_scale, "Scale up or down the number of backbone moves" );
option.add( basic::options::OptionKeys::flexpack::annealer::rotsub_movebb_substitutions_scale, "Scale up or down the number of rotamer substitions with backbone moves" );
option.add( basic::options::OptionKeys::hotspot::hotspot, "hotspot option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::hotspot::allow_gly, "Allow glycines in hotspot hashing constraints?" ).def(false);
option.add( basic::options::OptionKeys::hotspot::allow_proline, "Allow prolines in hotspot hashing constraints?" ).def(false);
option.add( basic::options::OptionKeys::hotspot::benchmark, "Score existing interface?" ).def(false);
option.add( basic::options::OptionKeys::hotspot::residue, "mini residue name3 to use for hotspot hashing" ).def(utility::vector1<std::string>(1,"ALL"));
option.add( basic::options::OptionKeys::hotspot::hashfile, "Existing hotspot hash file." );
option.add( basic::options::OptionKeys::hotspot::target, "Target PDB of the hotspot hash. Used for both de novo hashing and making hash density maps." );
option.add( basic::options::OptionKeys::hotspot::target_res, "Rosetta residue number of interest on the target PDB. Used for targeted hashing" );
option.add( basic::options::OptionKeys::hotspot::target_dist, "Tolerated distance from the target residue. Used for targeted hashing" ).def(20);
option.add( basic::options::OptionKeys::hotspot::density, "Filename to write *unweighted* hotspot density (compared to -target PDB)." );
option.add( basic::options::OptionKeys::hotspot::weighted_density, "Filename to write *score weighted* hotspot density (compared to -target PDB)." );
option.add( basic::options::OptionKeys::hotspot::rms_target, "Filename to write best rms of hotspot to target complex. Suitable for pymol data2b_res" );
option.add( basic::options::OptionKeys::hotspot::rms_hotspot, "Filename to write best rms of hotspot to target complex. Suitable for rms vs E scatter plots." );
option.add( basic::options::OptionKeys::hotspot::rms_hotspot_res, "Rosetta residue # to use for calculating rms_hotspot." );
option.add( basic::options::OptionKeys::hotspot::rescore, "Rescore hotspots from -hashfile based on the supplied -target PDB." ).def(false);
option.add( basic::options::OptionKeys::hotspot::threshold, "Score threshold for hotspot accepts. Found hotspots must be better than or equal to threshold" ).def(-1.0);
option.add( basic::options::OptionKeys::hotspot::sc_only, "Make backbone atoms virtual to find sidechain-only hotspots?" ).def(true);
option.add( basic::options::OptionKeys::hotspot::fxnal_group, "Only use a stubs functional group for rmsd calculations." ).def(true);
option.add( basic::options::OptionKeys::hotspot::cluster, "Cluster stubset. Will take place before colonyE." ).def(false);
option.add( basic::options::OptionKeys::hotspot::colonyE, "Rescore hotspots from -hashfile based on colony energy." ).def(false);
option.add( basic::options::OptionKeys::hotspot::length, "Length of hotspot peptide to use for hashing. Sidechain-containing group will be in the center." ).def(1);
option.add( basic::options::OptionKeys::hotspot::envhb, "Use environment dependent Hbonds when scoring hotspots." ).def(false);
option.add( basic::options::OptionKeys::hotspot::angle, "Maximum allowed angle between stubCA, target CoM, and stubCB. Used to determine if stub is pointing towards target. Negative numbers deactivates this check (default)" ).def(-1);
option.add( basic::options::OptionKeys::hotspot::angle_res, "Residue to use for angle calculation from stubCA, <this option>, and stubCB. Used to determine if stub is pointing towards target. 0 uses the default, which is the targets center of mass" ).def(0);
option.add( basic::options::OptionKeys::parser::parser, "parser option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::parser::protocol, "File name for the xml parser protocol" );
option.add( basic::options::OptionKeys::parser::script_vars, "Variable substitutions for xml parser, in the form of name=value" );
option.add( basic::options::OptionKeys::parser::view, "Use the viewer?" );
option.add( basic::options::OptionKeys::parser::patchdock, "Patchdock output file name." );
option.add( basic::options::OptionKeys::parser::patchdock_random_entry, "Pick a random patchdock entry between two entry numbers. inclusive" ).n(2);
option.add( basic::options::OptionKeys::DomainAssembly::DomainAssembly, "DomainAssembly option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::DomainAssembly::da_setup, "run DomainAssembly setup routine" ).legal(true).legal(false).def(false);
option.add( basic::options::OptionKeys::DomainAssembly::da_setup_option_file, "input list of pdbs and linker sequences" ).def("--");
option.add( basic::options::OptionKeys::DomainAssembly::da_setup_output_pdb, "PDB file output by DomainAssemblySetup" ).def("--");
option.add( basic::options::OptionKeys::DomainAssembly::da_linker_file, "input file with linker definitions" ).def("--");
option.add( basic::options::OptionKeys::DomainAssembly::da_start_pdb, "input pdb for linker optimization" ).def("--");
option.add( basic::options::OptionKeys::DomainAssembly::da_nruns, "number of runs" ).def(1);
option.add( basic::options::OptionKeys::DomainAssembly::da_start_pdb_num, "starting number for output pdb files" ).def(1);
option.add( basic::options::OptionKeys::DomainAssembly::da_linker_file_rna, "input file with moveable RNA definitions" ).def("--");
option.add( basic::options::OptionKeys::remodel::remodel, "remodel option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::remodel::help, "help menu." );
option.add( basic::options::OptionKeys::remodel::autopilot, "autopilot" );
option.add( basic::options::OptionKeys::remodel::blueprint, "blueprint file name" );
option.add( basic::options::OptionKeys::remodel::cstfile, "description" );
option.add( basic::options::OptionKeys::remodel::cstfilter, "filter cst energy" ).def(10);
option.add( basic::options::OptionKeys::remodel::cen_sfxn, "centroid score function to be used for building" ).def("remodel_cen");
option.add( basic::options::OptionKeys::remodel::num_trajectory, "Number of remodel trajectories." ).def(10);
option.add( basic::options::OptionKeys::remodel::save_top, "the number of final low scoring pdbs to keep." ).def(5);
option.add( basic::options::OptionKeys::remodel::swap_refine_confirm_protocols, "swapping the protocols used refinement and confirmation" ).def(false);
option.add( basic::options::OptionKeys::remodel::num_frag_moves, "number of fragment moves to try in the centroid stage." );
option.add( basic::options::OptionKeys::remodel::bypass_fragments, "only works on input PDB, so no extensions or deletions are honored in the blueprint.  Blueprint (H,L,E,D) becomes allow_move definitionsi." );
option.add( basic::options::OptionKeys::remodel::use_same_length_fragments, "harvest fragments that matches the length to rebuild" ).def(true);
option.add( basic::options::OptionKeys::remodel::enable_ligand_aa, "handles ligand attachment and clash check after centroid build." );
option.add( basic::options::OptionKeys::remodel::no_jumps, "will setup simple foldtree and fold through it during centroid build." );
option.add( basic::options::OptionKeys::remodel::backrub, "run backrub MC trajectory after every completed loop building attempt" );
option.add( basic::options::OptionKeys::remodel::use_blueprint_sequence , " picks fragments based on both secondary structure and the second column (sequence) in blueprint file" );
option.add( basic::options::OptionKeys::remodel::randomize_equivalent_fragments , " will randomize identical scoring fragments; without either this flag or" );
option.add( basic::options::OptionKeys::remodel::quick_and_dirty , " only do fragment insertion" );
option.add( basic::options::OptionKeys::remodel::checkpoint , " this writes out the best pdbs collected so far after each design step." );
option.add( basic::options::OptionKeys::remodel::use_ccd_refine , " maintain a default chainbreak position (loop start+1) and try using CCD for refinement.  try 20 times for 5 closed loops." );
option.add( basic::options::OptionKeys::remodel::use_pose_relax , " an alternative to the default minimization step, but use constraints in a similar way." );
option.add( basic::options::OptionKeys::remodel::use_dssp_assignment, " use dssp assignment." );
option.add( basic::options::OptionKeys::remodel::keep_jumps_in_minimizer , " no constraint is setup for minimization, only rebuilt regions allow bbmove." );
option.add( basic::options::OptionKeys::remodel::output_fragfiles, "output fragment file [filename ,e.g. aafr01]." );
option.add( basic::options::OptionKeys::remodel::read_fragfile, "read fragment file." );
option.add( basic::options::OptionKeys::remodel::generic_aa, "the type of AA for centroid building" ).def("V");
option.add( basic::options::OptionKeys::remodel::cluster_radius, "cluster radius for accumulator, default to auto set value" ).def(-1.0);
option.add( basic::options::OptionKeys::remodel::use_clusters, "use clustering in accumulator" ).def(false);
option.add( basic::options::OptionKeys::remodel::run_confirmation, "use KIC rms confirmation" ).def(false);
option.add( basic::options::OptionKeys::remodel::cluster_on_entire_pose, "cluster use all pose, not just loops" ).def(false);
option.add( basic::options::OptionKeys::remodel::collect_clustered_top, "take the best N from each cluster" ).def(1);
option.add( basic::options::OptionKeys::remodel::dr_cycles, "number of design-refine cycles to use" ).def(3);
option.add( basic::options::OptionKeys::remodel::two_chain_tree, "label the start of the second chain" );
option.add( basic::options::OptionKeys::remodel::repeat_structure, "build identical repeats this many times" ).def(1);
option.add( basic::options::OptionKeys::remodel::cen_minimize, "centroid minimization after fragment building" ).def(false);
option.add( basic::options::OptionKeys::remodel::domainFusion::domainFusion, "domainFusion option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::remodel::domainFusion::insert_segment_from_pdb, "segment pdb file to be inserted [insert pdb file name]." ).def("");
option.add( basic::options::OptionKeys::remodel::vdw, "set vdw weight" ).def(1.0);
option.add( basic::options::OptionKeys::remodel::rama, "set rama weight" ).def(0.1);
option.add( basic::options::OptionKeys::remodel::cbeta, "set cbeta weight" ).def(0.0);
option.add( basic::options::OptionKeys::remodel::cenpack, "set cenpack weight" ).def(0.0);
option.add( basic::options::OptionKeys::remodel::hb_lrbb, "set hbond_lrbb weight" ).def(0.0);
option.add( basic::options::OptionKeys::remodel::hb_srbb, "set hbond_srbb weight" ).def(0.0);
option.add( basic::options::OptionKeys::remodel::rg, "set rg weight" );
option.add( basic::options::OptionKeys::remodel::rsigma, "set rsigma weight" ).def(0.0);
option.add( basic::options::OptionKeys::remodel::ss_pair, "set sspair weight" ).def(0.0);
option.add( basic::options::OptionKeys::remodel::build_disulf, "build disulfides" ).def(false);
option.add( basic::options::OptionKeys::remodel::max_disulf_allowed, "number of disulf pairs can be generated at a time" ).def(1);
option.add( basic::options::OptionKeys::remodel::match_rt_limit, "match RT score cutoff" ).def(0.4);
option.add( basic::options::OptionKeys::remodel::disulf_landing_range, "residue range for disulf landing sites" ).n(2);
option.add( basic::options::OptionKeys::remodel::design::design, "design option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::remodel::design::no_design , " skips all design steps. WARNING: will only output centroid level structures and dump all fragment tries." );
option.add( basic::options::OptionKeys::remodel::design::allow_rare_aro_chi, "allow all aromatic rotamers, not issuing AroChi2 filter" ).def(false);
option.add( basic::options::OptionKeys::remodel::design::silent, " dumps all structures by silent-mode WARNING: will work only during no_design protocol (see -no_design)." );
option.add( basic::options::OptionKeys::remodel::design::skip_partial, " skip design stage that operate only on burial positions" ).def(false);
option.add( basic::options::OptionKeys::remodel::design::design_neighbors, "design neighbors." ).def(false);
option.add( basic::options::OptionKeys::remodel::design::find_neighbors, "find neighbors for design/repack" ).def(false);
option.add( basic::options::OptionKeys::remodel::rank_by_bsasa, "rank results by bsasa." );
option.add( basic::options::OptionKeys::remodel::RemodelLoopMover::RemodelLoopMover, "RemodelLoopMover option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::remodel::RemodelLoopMover::max_linear_chainbreak, "linear chainbreak is <= this value, loop is considered closed (default 0.07) " );
option.add( basic::options::OptionKeys::remodel::RemodelLoopMover::randomize_loops, "randomize loops prior to running main protocol (default false)" );
option.add( basic::options::OptionKeys::remodel::RemodelLoopMover::allowed_closure_attempts, "the allowed number of overall closure attempts (default 1)" );
option.add( basic::options::OptionKeys::remodel::RemodelLoopMover::simultaneous_cycles, "the number of simultaneous closure cycles to perform (default 2)" );
option.add( basic::options::OptionKeys::remodel::RemodelLoopMover::independent_cycles, "the number of independent closure cycles to perform (default 8)" );
option.add( basic::options::OptionKeys::remodel::RemodelLoopMover::boost_closure_cycles, "the maximum number of possible lockdown closure cycles to perform (default 30)" );
option.add( basic::options::OptionKeys::remodel::RemodelLoopMover::force_cutting_N, "force a cutpoint at N-term side of blueprint assignment" );
option.add( basic::options::OptionKeys::remodel::RemodelLoopMover::bypass_closure, "turning off CCD closure in the mover for tethered docking purpose" );
option.add( basic::options::OptionKeys::remodel::RemodelLoopMover::cyclic_peptide, "circularize structure joining N and C-term." );
option.add( basic::options::OptionKeys::remodel::RemodelLoopMover::temperature, "temperature for monte carlo ( default 2.0)" );
option.add( basic::options::OptionKeys::fold_from_loops::fold_from_loops, "fold_from_loops option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::fold_from_loops::native_ca_cst, "derive constraints from the native topology" ).def(false);
option.add( basic::options::OptionKeys::fold_from_loops::swap_loops, "pdb of the target loops " ).def("--");
option.add( basic::options::OptionKeys::fold_from_loops::checkpoint, "write/read checkpoint files for nstruct. Provide a checkpoint filename after this option." ).def("");
option.add( basic::options::OptionKeys::fold_from_loops::ca_csts_dev, "standard deviation allowed to each constraint" ).def(0.5);
option.add( basic::options::OptionKeys::fold_from_loops::add_relax_cycles, "additional relax cycles" ).def(2);
option.add( basic::options::OptionKeys::fold_from_loops::loop_mov_nterm, "Movable region inside the provided loop(nterm)" ).def(0);
option.add( basic::options::OptionKeys::fold_from_loops::loop_mov_cterm, "Moveable region inside the provided loop(cterm)" ).def(0);
option.add( basic::options::OptionKeys::fold_from_loops::ca_rmsd_cutoff, "Filter the decoys to pass the relax-design stage " ).def(5.0);
option.add( basic::options::OptionKeys::fold_from_loops::res_design_bs, "enumerate the residues to be designed within the fixed binding site" );
option.add( basic::options::OptionKeys::fold_from_loops::clear_csts, "input loops file with ranges free of CA csts" ).def("--");
option.add( basic::options::OptionKeys::fold_from_loops::output_centroid, "output centroid structures befor the design stage" ).def(false);
option.add( basic::options::OptionKeys::fold_from_loops::add_cst_loop, "add CA csts of motif to constraint set" ).def(false);
option.add( basic::options::OptionKeys::symmetry::symmetry, "symmetry option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::symmetry::symmetry_definition, "Text file describing symmetry setup" );
option.add( basic::options::OptionKeys::symmetry::initialize_rigid_body_dofs, "Initialize the RB dofs from the symmetry definition file?" ).def(false);
option.add( basic::options::OptionKeys::symmetry::perturb_rigid_body_dofs, "(As in docking) Do a small perturbation of the symmetric DOFs: -perturb_rigid_body_dofs ANGSTROMS DEGREES" ).n(2);
option.add( basic::options::OptionKeys::symmetry::symmetric_rmsd, "calculate the rmsd symmetrically by checking all chain orderings" );
option.add( basic::options::OptionKeys::fold_and_dock::fold_and_dock, "fold_and_dock option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::fold_and_dock::move_anchor_points, "move the anchor points that define symmetric coordinate system during symmetry fragment insertion" ).def(false);
option.add( basic::options::OptionKeys::fold_and_dock::set_anchor_at_closest_point, "set the anchor points that define symmetric coordinate system to the nearest point between two consecutive chains during fragment insertion" ).def(false);
option.add( basic::options::OptionKeys::fold_and_dock::rotate_anchor_to_x, "rotate the anchor residue to the x-axis before applying rigid body transformations" ).def(true);
option.add( basic::options::OptionKeys::fold_and_dock::trans_mag_smooth, "translation perturbation size for smooth refinement" ).def(0.1);
option.add( basic::options::OptionKeys::fold_and_dock::rot_mag_smooth, "rotational perturbation size for smooth refinement" ).def(1.0);
option.add( basic::options::OptionKeys::fold_and_dock::rb_rot_magnitude, "rotational perturbation size for rigid body pertubations" ).def(8.0);
option.add( basic::options::OptionKeys::fold_and_dock::rb_trans_magnitude, "translational perturbation size rigid body pertubations" ).def(3.0);
option.add( basic::options::OptionKeys::fold_and_dock::rigid_body_cycles, "number of rigid bosy cycles during fold and dock fragment insertion" ).def(50);
option.add( basic::options::OptionKeys::fold_and_dock::move_anchor_frequency, "Frequency of slide-anchor moves" ).def(1.0);
option.add( basic::options::OptionKeys::fold_and_dock::rigid_body_frequency, "The fraction of times rigid body cycles are applied during fragment assembly moves" ).def(0.2);
option.add( basic::options::OptionKeys::fold_and_dock::rigid_body_disable_mc, "Dissallow moves to be accepted locally by MC criteria within the rigid body mover " ).def(false);
option.add( basic::options::OptionKeys::fold_and_dock::slide_contact_frequency, "The fraction of times subunits are slided together during fragment assembly moves" ).def(0.1);
option.add( basic::options::OptionKeys::match::match, "match option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::match::lig_name, "Name of the ligand to be matched.  This should be the same as the NAME field of the ligand's parameter file (the .params file)" );
option.add( basic::options::OptionKeys::match::bump_tolerance, "The permitted level of spherical overlap betweeen any two atoms.  Used to detect collisions between the upstream atoms and the background, the upstream atoms and the downstream atoms, and the downstream atoms and the background" ).def(0.0);
option.add( basic::options::OptionKeys::match::active_site_definition_by_residue, "File describing the active site of the scaffold as a set of resid/radius pairs" );
option.add( basic::options::OptionKeys::match::active_site_definition_by_gridlig, "File containing 1s and Os describing the volume of space for the active site.  .gridlig file format from Rosetta++" );
option.add( basic::options::OptionKeys::match::required_active_site_atom_names, "File listing the downstream-residue-atom names which must reside in the defined active site.  Requires either the flag active_site_definition_by_residue or the flag active_site_definition_by_gridlig to be specified." );
option.add( basic::options::OptionKeys::match::grid_boundary, "File describing the volume in space in which the third orientation atom must lie" ).def("");
option.add( basic::options::OptionKeys::match::geometric_constraint_file, "File describing the geometry of the downstream object relative to the upstream object" );
option.add( basic::options::OptionKeys::match::scaffold_active_site_residues, "File with the residue indices on the scaffold that should be 			considered as potential launch points for the scaffold's active site.  File format described in MatcherTask.cc 			in the details section of the initialize_scaffold_active_site_residue_list_from_command_line() method." ).def("");
option.add( basic::options::OptionKeys::match::scaffold_active_site_residues_for_geomcsts, "File which lists the residue indices on the 			scaffold to consider as potential launch points for the scaffold's active site for each geometric constraint; 			each constraint may have a separate set of residue ids. File format described in MatcherTask.cc in the details 			section of the initialize_scaffold_active_site_residue_list_from_command_line() method." ).def("");
option.add( basic::options::OptionKeys::match::euclid_bin_size, "The bin width for the 3-dimensional coordinate hasher, in Angstroms" ).def(1.0);
option.add( basic::options::OptionKeys::match::euler_bin_size, "The bin width for the euler angle hasher, in degrees" ).def(10.0);
option.add( basic::options::OptionKeys::match::consolidate_matches, "Instead of outputting all matches, group matches and then write only the top -match::output_matches_per_group from each group." ).def(false);
option.add( basic::options::OptionKeys::match::output_matches_per_group, "The number of matches to output per group. Requires the -match::consolidate_matches flag is active." ).def(10);
option.add( basic::options::OptionKeys::match::orientation_atoms, "The three atoms, by name, on the downstream partner 			to use to describe its 6 dimensional coordinate; its position and orientation. 			Only usable when the downstream partner is a single residue. Exactly 3 atom names must be given. 			If these atoms are unspecified, the matcher will use the residues neighbor atom and two atoms 			bonded to the neighbor atom to define the orientation.  The euclidean coordinate of the third 			orientation atom is used as the first the dimensions of the downstream residues 6D coordinate; the 			other three dimensions are the three euler angles described by creating a coordinate frame at orientation 			atom 3, with the z axis along the vector from orientation atom 2 to orientation atom 3, and the y axis 			lying in the plane with orientation atoms 1,2&3." );
option.add( basic::options::OptionKeys::match::output_format, "The format in which the matches are output" ).legal("PDB").legal("KinWriter").legal("CloudPDB").def("CloudPDB");
option.add( basic::options::OptionKeys::match::match_grouper, "The parameters that matches are grouped according to by the MatchConsolidator or the CloudPDBWriter" ).legal("SameChiBinComboGrouper").legal("SameSequenceGrouper").legal("SameSequenceAndDSPositionGrouper").legal("SameRotamerComboGrouper").def("SameSequenceAndDSPositionGrouper");
option.add( basic::options::OptionKeys::match::grouper_downstream_rmsd, "Maximum allowed rmsd between two orientations of the downstream pose to be considered part of the same group " ).def(1.5);
option.add( basic::options::OptionKeys::match::output_matchres_only, "Whether to output the matched residues only or the whole pose for every match" ).def(false);
option.add( basic::options::OptionKeys::match::geom_csts_downstream_output, "For which of the geometric constraints the downstream residue/ligand will be output" ).def(1);
option.add( basic::options::OptionKeys::match::filter_colliding_upstream_residues, "Filter the output matches if the hits induce a collision between the upstream residues" ).def(true);
option.add( basic::options::OptionKeys::match::upstream_residue_collision_tolerance, "The amount of atom overlap allowed between upstream residues in a match.  If this is unspecified on the command line, then the value in the bump_tolerance option is used" ).def(0.0);
option.add( basic::options::OptionKeys::match::upstream_residue_collision_score_cutoff, "The score cutoff for upstream residue pairs to use in the collision filter.  Activating this cutoff uses the etable atr/rep/sol terms to evaluate residue-pair interactions instead of hard-sphere overlap detection" ).def(10.0);
option.add( basic::options::OptionKeys::match::upstream_residue_collision_Wfa_atr, "The fa_atr weight to use in the upstream-collision filter; use in tandem with upstream_residue_collision_score_cutoff" ).def(0.8);
option.add( basic::options::OptionKeys::match::upstream_residue_collision_Wfa_rep, "The fa_rep weight to use in the upstream-collision filter; use in tandem with upstream_residue_collision_score_cutoff" ).def(0.44);
option.add( basic::options::OptionKeys::match::upstream_residue_collision_Wfa_sol, "The fa_sol weight to use in the upstream-collision filter; use in tandem with upstream_residue_collision_score_cutoff" ).def(0.0);
option.add( basic::options::OptionKeys::match::filter_upstream_downstream_collisions, "Filter the output matches if the hits induce a collision between the upstream residues and the downstream pose" ).def(true);
option.add( basic::options::OptionKeys::match::updown_collision_tolerance, "The amount of atom overlap allowed between upstream and downstream atoms in a match.  If this is unspecified on the command line, then the value in the bump_tolerance option is used" ).def(0.0);
option.add( basic::options::OptionKeys::match::updown_residue_collision_score_cutoff, "The score cutoff for upstream/downstream residue pairs to use in the collision filter.  Activating this cutoff uses the etable atr/rep/sol terms to evaluate residue-pair interactions instead of hard-sphere overlap detection" ).def(10.0);
option.add( basic::options::OptionKeys::match::updown_residue_collision_Wfa_atr, "The fa_atr weight to use in the upstream-downstream-collision filter; use in tandem with updown_residue_collision_score_cutoff" ).def(0.8);
option.add( basic::options::OptionKeys::match::updown_residue_collision_Wfa_rep, "The fa_rep weight to use in the upstream-downstream-collision filter; use in tandem with updown_residue_collision_score_cutoff" ).def(0.44);
option.add( basic::options::OptionKeys::match::updown_residue_collision_Wfa_sol, "The fa_sol weight to use in the upstream-downstream-collision filter; use in tandem with updown_residue_collision_score_cutoff" ).def(0.0);
option.add( basic::options::OptionKeys::match::define_match_by_single_downstream_positioning, "Enumerate combinations of matches where a 			single positioning of the downstream partner as well as the conformations of the upstream residues defines the 			match; it is significantly faster to enumerate unique matches when they are defined this way instead of enumerating the 			(combinatorially many) matches when a match is defined by n-geometric-constraint locations of the downstream partner. 			This faster technique for outputting matches is automatically chosen when the flag -match::output_format is PDB." );
option.add( basic::options::OptionKeys::match::ligand_rotamer_index, "Match with a particular conformation of the ligand; the index 			represents which conformation in the multi-model .pdb file specified in the ligand's .params file by the 			PDB_ROTAMERS field.  The index of the first conformation in that file is 1; valid indices range from 1 to 			the number of entries in the multi-model .pdb file.  If this command-line flag is not used, then the conformation 			of the ligand described by the ICOOR_INTERNAL lines of the ligand's .params file is used instead." );
option.add( basic::options::OptionKeys::match::enumerate_ligand_rotamers, "Match with all ligand rotamers specified in the multi-model 			.pdb file specified in the ligand's .params file by the PDB_ROTAMERS field.  This flag may not be used in 			combination with the match::ligand_rotamer_index flag.  Geometry of the ligand rotamers in the .pdb file will 			be idealized to the .params file bond angles and lengths." ).def(true);
option.add( basic::options::OptionKeys::match::only_enumerate_non_match_redundant_ligand_rotamers, "Only defined if enumerate_ligand_rotamers is true              this option causes the matcher to determine which rotamers in the ligand rotamer library are redundant in terms of matching,              meaning the atoms they're matched through are superimposable. after having subdivided the ligand rotamer library into match-redundant              subgroups, the matcher will then only place the first nonclashing rotamer from each subgroup. " ).def(true);
option.add( basic::options::OptionKeys::match::dynamic_grid_refinement, "When too many hits land in the same 'connected component', requiring the 				enumeration of twoo many matches, refine the grid size to be smaller so that fewer matches have to be enumerated. 				This process works on individual connected components and is not applied to all regions of 6D.  This is significantly 				more efficient than enumerating all matches, while allowing the grid size to remain large and the rotamer and external 				geometry to remain dense. (*A connected component refers to " );
option.add( basic::options::OptionKeys::canonical_sampling::canonical_sampling, "canonical_sampling option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::probabilities, "probabilities option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::sc, "probability of making a side chain move" ).def(0.25);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::localbb, "probability of making a small move" ).def(0.75);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::sc_prob_uniform, "probability of uniformly sampling chi angles" ).def(0.1);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::sc_prob_withinrot, "probability of sampling within the current rotamer" ).def(0.9);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::sc_prob_perturbcurrent, "probability of perturbing the current rotamer" ).def(0.0);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::MPI_sync_pools, "use MPI to synchronize pools and communicate between nodes" ).def(false);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::MPI_bcast, "use broadcasting in syncing" ).def(false);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::fast_sc_moves, "use the fast SidechainMCMover" ).def(false);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::fast_sc_moves_ntrials, "specify the number of ntrials for each call of scmover apply" ).def(1000);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::no_jd2_output, "do not write to silent-file specified by -out:file:silent" ).def(false);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::use_hierarchical_clustering, "use the HierarchicalLevel class" ).def(false);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::hierarchical_max_cache_size, "set the max-cache size of the hierarchy" ).def(1000);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::backrub, "set the probability of executing a backrub move when making a backbone move" ).def(0.5);
option.add( basic::options::OptionKeys::canonical_sampling::probabilities::conrot, "set relative probability of executing a conrot move when making a backbone move" ).def(0.0);
option.add( basic::options::OptionKeys::canonical_sampling::sampling::sampling, "sampling option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::canonical_sampling::sampling::no_detailed_balance, "preserve detailed balance" ).def(false);
option.add( basic::options::OptionKeys::canonical_sampling::sampling::ntrials, "number of Monte Carlo trials to run" ).def(1000);
option.add( basic::options::OptionKeys::canonical_sampling::sampling::mc_kt, "value of kT for Monte Carlo" ).def(0.6);
option.add( basic::options::OptionKeys::canonical_sampling::sampling::interval_pose_dump, "dump a pose out every x steps" ).def(1000);
option.add( basic::options::OptionKeys::canonical_sampling::sampling::interval_data_dump, "dump data out every x steps" ).def(100);
option.add( basic::options::OptionKeys::canonical_sampling::sampling::output_only_cluster_transitions, "output only cluster transitions" ).def(false);
option.add( basic::options::OptionKeys::canonical_sampling::sampling::transition_threshold, "if rmsd to known_structures larger than X, add a new structure to pool" ).def(2.0);
option.add( basic::options::OptionKeys::canonical_sampling::sampling::max_files_per_dir, "distribute traj and transition files into subdirectories with max N entries" ).def(1000);
option.add( basic::options::OptionKeys::canonical_sampling::sampling::save_loops_only, "save only loop conformation to pool" ).def(false);
option.add( basic::options::OptionKeys::canonical_sampling::sampling::dump_loops_only, "dump only loop conformation in silent-files" ).def(false);
option.add( basic::options::OptionKeys::canonical_sampling::out::out, "out option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::canonical_sampling::out::new_structures, "" ).def("discovered_decoys.out");
option.add( basic::options::OptionKeys::rdc::rdc, "rdc option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::rdc::correct_NH_length, "fix N-H bond-vector to 1.04 as measured in ottiger&bax 98" );
option.add( basic::options::OptionKeys::rdc::reduced_couplings, "gives more equal weights to different bond-vectors" );
option.add( basic::options::OptionKeys::rdc::weights, "specify weights for individual residues ( works for all couplings at this reside)" );
option.add( basic::options::OptionKeys::rdc::iterate_weights, "do a wRDC computation, i.e., iterate tensor calculation until weights are ~exp ( -dev2/sigma )" ).def(1);
option.add( basic::options::OptionKeys::rdc::segment_file, "Definition of rigid segments for alignment tensor optimization" );
option.add( basic::options::OptionKeys::rdc::segment_scoring_mode, "Type of treatment of alignment tensor-based scoring : pairwise or fixed_axis_z (e.g. for homo-dimers) " ).legal("pairwise").legal("fixed_axis_z").legal("fixed_sum");
option.add( basic::options::OptionKeys::rdc::total_weight, "Weight for RDC scores of individual al. tensors" ).def(1.0);
option.add( basic::options::OptionKeys::rdc::tensor_weight, "Weight for pairwise scoring of al. tensors" ).def(1.0);
option.add( basic::options::OptionKeys::rdc::print_rdc_values, "print computed vs experimental RDC values" );
option.add( basic::options::OptionKeys::rdc::iterate_tol, "tolerance for tensor iterations" ).def(0.01);
option.add( basic::options::OptionKeys::rdc::iterate_reset, "reset weights to 1.0 when optimizing for new structure" ).def(false);
option.add( basic::options::OptionKeys::rdc::dump_weight_trajectory, "if yes, write weights to file for each scoring event" );
option.add( basic::options::OptionKeys::rdc::fix_normAzz, "divide by this axial tensor component" );
option.add( basic::options::OptionKeys::rdc::select_residues_file, "loop/rigid-file with RIGID entries that define the set of residues active for RDC score" );
option.add( basic::options::OptionKeys::rdc::fit_method, "No description" ).legal("svd").legal("nls").def("svd");
option.add( basic::options::OptionKeys::rdc::fixDa, "No description" );
option.add( basic::options::OptionKeys::rdc::fixR, "No description" );
option.add( basic::options::OptionKeys::antibody::antibody, "Antibody option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::antibody::graft_l1, "Graft CDR L1 from template" ).def(false);
option.add( basic::options::OptionKeys::antibody::l1_template, "Choose specified template for CDR L1 grafting" ).def("l1.pdb");
option.add( basic::options::OptionKeys::antibody::graft_l2, "Graft CDR L2 from template" ).def(false);
option.add( basic::options::OptionKeys::antibody::l2_template, "Choose specified template for CDR L2 grafting" ).def("l2.pdb");
option.add( basic::options::OptionKeys::antibody::graft_l3, "Graft CDR L3 from template" ).def(false);
option.add( basic::options::OptionKeys::antibody::l3_template, "Choose specified template for CDR L3 grafting" ).def("l3.pdb");
option.add( basic::options::OptionKeys::antibody::graft_h1, "Graft CDR H1 from template" ).def(false);
option.add( basic::options::OptionKeys::antibody::h1_template, "Choose specified template for CDR H1 grafting" ).def("h1.pdb");
option.add( basic::options::OptionKeys::antibody::graft_h2, "Graft CDR H2 from template" ).def(false);
option.add( basic::options::OptionKeys::antibody::h2_template, "Choose specified template for CDR H2 grafting" ).def("h2.pdb");
option.add( basic::options::OptionKeys::antibody::graft_h3, "Graft CDR H3 from template" ).def(false);
option.add( basic::options::OptionKeys::antibody::h3_template, "Choose specified template for CDR H3 grafting" ).def("h3.pdb");
option.add( basic::options::OptionKeys::antibody::model_h3, "Model CDR H3 from scratch using fragments" ).def(false);
option.add( basic::options::OptionKeys::antibody::snugfit, "Adjust relative orientation of VL-VH" ).def(false);
option.add( basic::options::OptionKeys::antibody::snug_loops, "Allow CDR loop backbone flexibility during minimization" ).def(false);
option.add( basic::options::OptionKeys::antibody::input_fv, "input antibody variable (Fv) region" ).def("FR02.pdb");
option.add( basic::options::OptionKeys::antibody::camelid, "Camelid input with only heavy (VH) chain" ).def(false);
option.add( basic::options::OptionKeys::antibody::camelid_constraints, "Display constraints file for use with camelid H3 modeler" ).def(false);
option.add( basic::options::OptionKeys::antibody::numbering_scheme, "the numbering scheme such as chothia or aho" ).def("chothia");
option.add( basic::options::OptionKeys::flexPepDocking::flexPepDocking, "flexPepDocking option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::flexPepDocking::params_file, "parameters file that describe the complex details, like anchor residues, etc." );
option.add( basic::options::OptionKeys::flexPepDocking::peptide_anchor, "Set the peptide anchor residue mannualy (instead of using the center of mass" ).lower(1).def(1);
option.add( basic::options::OptionKeys::flexPepDocking::receptor_chain, "chain-id of receptor protein" );
option.add( basic::options::OptionKeys::flexPepDocking::peptide_chain, "chain-id of peptide protein" );
option.add( basic::options::OptionKeys::flexPepDocking::pep_fold_only, "Only fold a peptide, without docking (no input receptor is expected in this case)." ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::lowres_abinitio, "Do a preemptive ab-initio low-resolution peptide docking" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::lowres_preoptimize, "Do a preemptive optimization in low resolution" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::flexPepDockingMinimizeOnly, "Just do simple minimization on input structure" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::extend_peptide, "start the protocol with the peptide in extended conformation" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::pep_refine, "High-resolution peptide refinement over receptor surface, equivalent to the obsolete -rbMCM -torsionsMCM flags" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::rbMCM, "Do rigid body mcm in the main loop of the protocol (obsolete)" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::torsionsMCM, "Do torsions (small/shear mcm in the main loop of the protocol (obsolete)" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::peptide_loop_model, "Do cycles of random loop modeling to peptide backbone" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::backrub_peptide, "Adds a backrub stage to the protocol" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::boost_fa_atr, "while ramping up the fa_rep, start from high atr and lower to normal" ).def(true);
option.add( basic::options::OptionKeys::flexPepDocking::ramp_fa_rep, "Whether to ramp the full-atom repulsive score during the protocol" ).def(true);
option.add( basic::options::OptionKeys::flexPepDocking::ramp_rama, "Whether to ramp the Ramachandran score during the protocol" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::flexpep_score_only, "just reads in the pose and scores it" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::ref_startstruct, "Alternative start structure for scoring statistics, instead of the original start structure (useful as reference for rescoring previous runs)" );
option.add( basic::options::OptionKeys::flexPepDocking::use_cen_score, "when in score_only mode, uses centroid weights to score" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::design_peptide, "Add a desing stage to each cycle of the RB-torsions perturbations" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::rep_ramp_cycles, "Number of cycles for the ramping up of repulsion term" ).lower(0).def(10);
option.add( basic::options::OptionKeys::flexPepDocking::mcm_cycles, "Number of cycles for the mcm procedures (rb/torsions)" ).lower(0).def(8);
option.add( basic::options::OptionKeys::flexPepDocking::random_phi_psi_preturbation, "Size of random perturbation of peptide's phi/psi" ).lower(0.0).def(0.0);
option.add( basic::options::OptionKeys::flexPepDocking::smove_angle_range, "Defines the perturbations size of small/sheer moves" ).lower(0.0).def(6.0);
option.add( basic::options::OptionKeys::flexPepDocking::min_receptor_bb, "Whether to include protein backbone in minimization" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::random_trans_start, "Size of random perturbation of peptide's rigid body translation" ).lower(0.0).def(0.0);
option.add( basic::options::OptionKeys::flexPepDocking::random_rot_start, "Size of random perturbation of peptide's rigid body rotation" ).lower(0.0).def(0.0);
option.add( basic::options::OptionKeys::flexPepDocking::flexpep_prepack, "Prepack an initial structure and exit" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::flexpep_noprepack1, "Do not repack the side-chains of partner 1 ( = globular protein)." ).shortd( "Do not prepack the side-chains of partner 1 ( = globular protein )." ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::flexpep_noprepack2, "Do not repack the side-chains of partner 2 ( = peptide)." ).shortd( "Do not prepack the side-chains of partner 2 ( = peptide)." ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::score_filter, "Only output decoys with scores lower than this filter." ).shortd( "Only output decoys with scores lower than this filter." ).def(10000.0);
option.add( basic::options::OptionKeys::flexPepDocking::hb_filter, "Only output decoys with more h-bonds than this filter." ).shortd( "Only output decoys with more h-bonds than this filter." ).lower(0).def(0);
option.add( basic::options::OptionKeys::flexPepDocking::hotspot_filter, "Only output decoys with more hotspots than this filter." ).shortd( "Only output decoys with more hotspots than this filter." ).lower(0).def(0);
option.add( basic::options::OptionKeys::flexPepDocking::frag5, "5-mer fragments for ab-initio flexPepDock" );
option.add( basic::options::OptionKeys::flexPepDocking::frag9_weight, "Relative weight of 9-mers in ab-initio" ).lower(0).def(0.1);
option.add( basic::options::OptionKeys::flexPepDocking::frag5_weight, "relative weight of 5-mers in ab-initio" ).lower(0).def(0.25);
option.add( basic::options::OptionKeys::flexPepDocking::frag3_weight, "Relative weight of 3-mers in ab-initio" ).lower(0).def(1.0);
option.add( basic::options::OptionKeys::flexPepDocking::pSer2Asp_centroid, "convert pSer to Asp during centroid mode" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::pSer2Glu_centroid, "convert pSer to Glu during centroid mode" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::dumpPDB_abinitio, "dump PDB during Monte-Carlo ab-initio" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::dumpPDB_lowres, "dump PDB during Monte-Carlo low-res" ).def(false);
option.add( basic::options::OptionKeys::flexPepDocking::dumpPDB_hires, "dump PDB during Monte-Carlo hi-res" ).def(false);
option.add( basic::options::OptionKeys::threadsc::threadsc, "threadsc option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::threadsc::src_chain, "Chain of source pdb" ).shortd( "Chain of source pdb" );
option.add( basic::options::OptionKeys::threadsc::trg_chain, "Chain of target pdb" ).shortd( "Chain of target pdb" );
option.add( basic::options::OptionKeys::threadsc::src_first_resid, "Residue id of first residue in source pdb range" ).shortd( "Residue id of first residue in source pdb range" );
option.add( basic::options::OptionKeys::threadsc::trg_first_resid, "Residue id of first residue in source pdb range" ).shortd( "Residue id of first residue in source pdb range" );
option.add( basic::options::OptionKeys::threadsc::nres, "Number of residues to be threaded" ).shortd( "Number of residues to be threaded" );
option.add( basic::options::OptionKeys::threadsc::trg_anchor, "anchor residue for backbone threading" ).shortd( "anchor residue for backbone threading" );
option.add( basic::options::OptionKeys::cp::cp, "cp option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::cp::cutoff, "designable neighbor cutoff" ).def(16);
option.add( basic::options::OptionKeys::cp::minimizer, "minimizer to use for initial minimization" ).def("score12_full");
option.add( basic::options::OptionKeys::cp::relax_sfxn, "score function for final relaxation step" ).def("score12_full");
option.add( basic::options::OptionKeys::cp::pack_sfxn, "score function for mutational trials" ).def("soft_rep_design");
option.add( basic::options::OptionKeys::cp::minimizer_tol, "tolerance for minimization" ).def(.0001);
option.add( basic::options::OptionKeys::cp::minimizer_score_fxn, "score function for initial minimization" ).def("score12_full");
option.add( basic::options::OptionKeys::cp::output, "file where we want to dump the final pose" ).def("final_mutant.pdb");
option.add( basic::options::OptionKeys::cp::ncycles, "how many cycles to run refinement for" ).def(0);
option.add( basic::options::OptionKeys::cp::print_reports, "print reports to text file?" ).def(false);
option.add( basic::options::OptionKeys::cp::vipReportFile, "File to print reports to" ).def("reports.txt");
option.add( basic::options::OptionKeys::cp::relax_mover, "relax w/o constraints=relax, w constraints=cst_relax" ).def("relax");
option.add( basic::options::OptionKeys::cp::skip_relax, "Skip relax step... may reduce accurate identification of mutations" ).def(false);
option.add( basic::options::OptionKeys::cp::local_relax, "Limit relax step to neighbors" ).def(false);
option.add( basic::options::OptionKeys::cp::print_intermediate_pdbs, "Output a pdb file for each consecutive mutation" ).def(false);
option.add( basic::options::OptionKeys::archive::archive, "archive option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::archive::reread_all_structures, "ignore pool file... reread from batches" ).def(false);
option.add( basic::options::OptionKeys::archive::completion_notify_frequency, "tell Archive every X completed decoys" ).def(100);
option.add( basic::options::OptionKeys::optimization::optimization, "optimization option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::optimization::default_max_cycles, "max cycles for MinimizerOptions" ).def(2000);
option.add( basic::options::OptionKeys::optimization::armijo_min_stepsize, "min stepsize in armijo minimizer" ).def(1e-8);
option.add( basic::options::OptionKeys::optimization::lbfgs_M, "number of corrections to approximate the inverse hessian matrix." ).def(64);
option.add( basic::options::OptionKeys::swa::swa, "swa option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::swa::s1, "input file(s)" );
option.add( basic::options::OptionKeys::swa::s2, "input file(s)" );
option.add( basic::options::OptionKeys::swa::silent1, "input file" );
option.add( basic::options::OptionKeys::swa::silent2, "input file" );
option.add( basic::options::OptionKeys::swa::tags1, "input tag(s)" );
option.add( basic::options::OptionKeys::swa::tags2, "input tag(s)" );
option.add( basic::options::OptionKeys::swa::slice_res1, "Residues to slice out of starting file" );
option.add( basic::options::OptionKeys::swa::slice_res2, "Residues to slice out of starting file" );
option.add( basic::options::OptionKeys::swa::input_res1, "Residues already present in starting file" );
option.add( basic::options::OptionKeys::swa::input_res2, "Residues already present in starting file2" );
option.add( basic::options::OptionKeys::swa::input_res, "Residues already present in starting file" );
option.add( basic::options::OptionKeys::swa::backbone_only1, "just copy protein backbone DOFS, useful for homology modeling" );
option.add( basic::options::OptionKeys::swa::backbone_only2, "just copy protein backbone DOFS, useful for homology modeling" );
option.add( basic::options::OptionKeys::ufv::ufv, "ufv option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::ufv::left, "left endpoint" );
option.add( basic::options::OptionKeys::ufv::right, "right endpoint" );
option.add( basic::options::OptionKeys::ufv::ss, "secondary structure string" );
option.add( basic::options::OptionKeys::ufv::aa_during_build, "amino acid string during centroid build" );
option.add( basic::options::OptionKeys::ufv::aa_during_design_refine, "amino acid string during design-refine" );
option.add( basic::options::OptionKeys::ufv::keep_junction_torsions, "when rebuilding loops, keep (approx) the original torsions at the junctions of the loop endpoints" ).def(false);
option.add( basic::options::OptionKeys::ufv::ufv_loops, "use this multiple loop file in place of specifying single loop options on command line" );
option.add( basic::options::OptionKeys::ufv::use_fullmer, "use full-mer fragments when building loop" ).def(false);
option.add( basic::options::OptionKeys::ufv::centroid_loop_mover, "the centroid loop mover to use" ).def("RemodelLoopMover");
option.add( basic::options::OptionKeys::ufv::no_neighborhood_design, "only repack the neighborhood of the loop, don't design" ).def(false);
option.add( basic::options::OptionKeys::ufv::dr_cycles, "design-refine cycles" ).def(3);
option.add( basic::options::OptionKeys::ufv::centroid_sfx, "filename of the centroid score function to use," );
option.add( basic::options::OptionKeys::ufv::centroid_sfx_patch, "filename of the centroid score function patch to use," );
option.add( basic::options::OptionKeys::ufv::fullatom_sfx, "filename of the full-atom score function to use" );
option.add( basic::options::OptionKeys::ufv::fullatom_sfx_patch, "filename of the full-atom score function patch to use" );
option.add( basic::options::OptionKeys::ufv::insert::insert, "insert option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::ufv::insert::insert_pdb, "pdb of insert structure" );
option.add( basic::options::OptionKeys::ufv::insert::attached_pdb, "pdb of structure in rigid body relationship with insert structure" );
option.add( basic::options::OptionKeys::ufv::insert::connection_scheme, "enforce type of insertion: choose either n2c or c2n" );
option.add( basic::options::OptionKeys::chrisk::chrisk, "chrisk option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::chrisk::hb_elec, "turn on hb-elec switch function" ).def(false);
option.add( basic::options::OptionKeys::rot_anl::rot_anl, "rot_anl option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::rot_anl::tag, "nametag" ).def(".");
option.add( basic::options::OptionKeys::rot_anl::premin, "do all sc min and dump pdb" ).def(false);
option.add( basic::options::OptionKeys::rot_anl::min, "do sc min" ).def(false);
option.add( basic::options::OptionKeys::rot_anl::diff_to_min, "native pose is post-min" ).def(false);
option.add( basic::options::OptionKeys::rot_anl::repack, "" ).def(false);
option.add( basic::options::OptionKeys::rot_anl::rtmin, "" ).def(false);
option.add( basic::options::OptionKeys::rot_anl::scmove, "" ).def(false);
option.add( basic::options::OptionKeys::rot_anl::design, "" ).def(false);
option.add( basic::options::OptionKeys::rot_anl::score_tol, "score filter for dump_pdb" ).def(1.0);
option.add( basic::options::OptionKeys::rot_anl::rmsd_tol, "rmsd filter for dump_pdb" ).def(1.0);
option.add( basic::options::OptionKeys::rot_anl::dump_pdb, "dump_pdb when pass thresh" ).def(false);
option.add( basic::options::OptionKeys::rot_anl::nloop_scmove, "base of scmover loop (total=nloop^n_chi)" ).def(9);
option.add( basic::options::OptionKeys::helixAssembly::helixAssembly, "helixAssembly option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::helixAssembly::query_structure_path, "" );
option.add( basic::options::OptionKeys::helixAssembly::frag1_start, "" );
option.add( basic::options::OptionKeys::helixAssembly::frag1_end, "" );
option.add( basic::options::OptionKeys::helixAssembly::frag2_start, "" );
option.add( basic::options::OptionKeys::helixAssembly::frag2_end, "" );
option.add( basic::options::OptionKeys::helixAssembly::minimum_helix_contacts, "" );
option.add( basic::options::OptionKeys::helixAssembly::helices_to_add, "" );
option.add( basic::options::OptionKeys::helixAssembly::single_helix_rmsd_cutoff, "" );
option.add( basic::options::OptionKeys::helixAssembly::helix_pair_rmsd_cutoff, "" );
option.add( basic::options::OptionKeys::helixAssembly::helix_cap_dist_cutoff, "Maximum distance between c-alpha residues at the end of two helices in order to call them part of the same bundle" );
option.add( basic::options::OptionKeys::helixAssembly::helix_contact_dist_cutoff, "Maximum distance between c-alpha residues in two helices in order to call them interacting" );
option.add( basic::options::OptionKeys::helixAssembly::min_helix_size, "Minimum size of a helix in a bundle" );
option.add( basic::options::OptionKeys::pepspec::pepspec, "pepspec option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::pepspec::soft_wts, "No description" ).def("soft_rep.wts");
option.add( basic::options::OptionKeys::pepspec::cen_wts, "No description" ).def("cen_ghost.wts");
option.add( basic::options::OptionKeys::pepspec::binding_score, "No description" ).def(true);
option.add( basic::options::OptionKeys::pepspec::no_cen, "No description" ).def(true);
option.add( basic::options::OptionKeys::pepspec::no_cen_rottrials, "No description" ).def(true);
option.add( basic::options::OptionKeys::pepspec::run_sequential, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::pep_anchor, "No description" );
option.add( basic::options::OptionKeys::pepspec::pep_chain, "No description" ).def(" ");
option.add( basic::options::OptionKeys::pepspec::n_peptides, "No description" ).def(8);
option.add( basic::options::OptionKeys::pepspec::n_build_loop, "No description" ).def(1000);
option.add( basic::options::OptionKeys::pepspec::n_cgrelax_loop, "No description" ).def(1);
option.add( basic::options::OptionKeys::pepspec::n_dock_loop, "No description" ).def(4);
option.add( basic::options::OptionKeys::pepspec::interface_cutoff, "No description" ).def(5.0);
option.add( basic::options::OptionKeys::pepspec::use_input_bb, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::remove_input_bb, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::homol_csts, "No description" ).def("prep.csts");
option.add( basic::options::OptionKeys::pepspec::p_homol_csts, "No description" ).def(1.0);
option.add( basic::options::OptionKeys::pepspec::frag_file, "No description" ).def("sampling/filtered.vall.dat.2006-05-05.gz");
option.add( basic::options::OptionKeys::pepspec::gen_pep_bb_sequential, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::input_seq, "No description" );
option.add( basic::options::OptionKeys::pepspec::ss_type, "No description" );
option.add( basic::options::OptionKeys::pepspec::upweight_interface, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::calc_sasa, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::diversify_pep_seqs, "No description" ).def(true);
option.add( basic::options::OptionKeys::pepspec::diversify_lvl, "No description" ).def(10);
option.add( basic::options::OptionKeys::pepspec::dump_cg_bb, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::save_low_pdbs, "No description" ).def(true);
option.add( basic::options::OptionKeys::pepspec::save_all_pdbs, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::no_design, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::pdb_list, "No description" );
option.add( basic::options::OptionKeys::pepspec::ref_pdb_list, "No description" );
option.add( basic::options::OptionKeys::pepspec::add_buffer_res, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::cg_res_type, "No description" ).def("ALA");
option.add( basic::options::OptionKeys::pepspec::native_pep_anchor, "No description" );
option.add( basic::options::OptionKeys::pepspec::native_pep_chain, "No description" ).def("");
option.add( basic::options::OptionKeys::pepspec::native_align, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::rmsd_analysis, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::phipsi_analysis, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::anchor_type, "No description" ).def("ALA");
option.add( basic::options::OptionKeys::pepspec::no_prepack_prot, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::prep_use_ref_rotamers, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::n_prepend, "No description" ).def(0);
option.add( basic::options::OptionKeys::pepspec::n_append, "No description" ).def(0);
option.add( basic::options::OptionKeys::pepspec::clash_cutoff, "No description" ).def(5);
option.add( basic::options::OptionKeys::pepspec::n_anchor_dock_std_devs, "No description" ).def(1.0);
option.add( basic::options::OptionKeys::pepspec::prep_trans_std_dev, "No description" ).def(0.5);
option.add( basic::options::OptionKeys::pepspec::prep_rot_std_dev, "No description" ).def(10.0);
option.add( basic::options::OptionKeys::pepspec::seq_align, "No description" ).def(false);
option.add( basic::options::OptionKeys::pepspec::prep_align_prot_to, "No description" );
option.add( basic::options::OptionKeys::orbitals::orbitals, "orbitals option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::orbitals::Hpol, "look at only polar hydrogen interactions" ).def(false);
option.add( basic::options::OptionKeys::orbitals::Haro, "look at only aromatic hydrogen interactions" ).def(false);
option.add( basic::options::OptionKeys::orbitals::bb_stats, "look at orbital backbone stats" ).def(false);
option.add( basic::options::OptionKeys::orbitals::sc_stats, "look at orbital sc stats" ).def(false);
option.add( basic::options::OptionKeys::orbitals::orb_orb_stats, "look at orbital orbital stats" ).def(false);
option.add( basic::options::OptionKeys::orbitals::sc_bb, "score the backbone" ).def(false);
option.add( basic::options::OptionKeys::dwkulp::dwkulp, "dwkulp option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::dwkulp::forcePolyAAfragments, "a single amino acid that will be used for fragment picking,default is blank which means taking actual sequence from pose" ).def("");
option.add( basic::options::OptionKeys::matdes::matdes, "matdes option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::matdes::num_subs_building_block, "The number of subunits in the oligomeric building block" ).def(1);
option.add( basic::options::OptionKeys::matdes::num_subs_total, "The number of subunits in the target assembly" ).def(1);
option.add( basic::options::OptionKeys::matdes::pdbID, "The PDB ID" ).def("0xxx");
option.add( basic::options::OptionKeys::matdes::prefix, "Prefix appended to output PDB files. Perhaps useful to describe the architecture, e.g., 532_3_..." ).def("pre_");
option.add( basic::options::OptionKeys::matdes::radial_disp, "Specify the radial displacement from the center of a closed point group assembly. Use with -in::olig_search::dump_pdb" );
option.add( basic::options::OptionKeys::matdes::angle, "Specify the angle by which a building block is rotated in a symmetrical assembly. Use with -in::olig_search::dump_pdb" );
option.add( basic::options::OptionKeys::matdes::tag, "Four digit ID tag attached to a design model during design" );
option.add( basic::options::OptionKeys::matdes::dock::dock, "dock option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::matdes::dock::neg_r, "Specify whether radial displacement is positive or negative. 1 for negative, 0 for positive." ).def(0);
option.add( basic::options::OptionKeys::matdes::dock::dump_pdb, "Dump a pdb of a particular docked configuration" ).def(false);
option.add( basic::options::OptionKeys::matdes::dock::dump_chainA_only, "Only output chain A (the asymmetric unit) of the symmetrical assembly. Use with -in::olig_search::dump_pdb" ).def(false);
option.add( basic::options::OptionKeys::matdes::design::design, "design option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::matdes::design::contact_dist, "CA-CA distance for defining interface residues" ).def(10.0);
option.add( basic::options::OptionKeys::matdes::design::grid_size_angle, "The width of angle space to start design/minimize runs from, centered on the starting angle" ).def(1.0);
option.add( basic::options::OptionKeys::matdes::design::grid_size_radius, "The width of radius space to start design/minimize runs from, centered on the starting radius" ).def(1.0);
option.add( basic::options::OptionKeys::matdes::design::grid_nsamp_angle, "The number of samples the rigid body grid is divided into in angle space" ).def(9);
option.add( basic::options::OptionKeys::matdes::design::grid_nsamp_radius, "The number of samples the rigid body grid is divided into in radius space" ).def(9);
option.add( basic::options::OptionKeys::matdes::design::fav_nat_bonus, "Bonus to be awarded to native residues" ).def(0.0);
option.add( basic::options::OptionKeys::matdes::mutalyze::mutalyze, "mutalyze option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::matdes::mutalyze::calc_rot_boltz, "Specify whether to calculate RotamerBoltzmann probabilities or not" ).def(0);
option.add( basic::options::OptionKeys::matdes::mutalyze::ala_scan, "Specify whether to calculate ddGs for alanine-scanning mutants at the designed interface" ).def(1);
option.add( basic::options::OptionKeys::matdes::mutalyze::revert_scan, "Specify whether to calculate ddGs for reversion mutants at the designed interface" ).def(1);
option.add( basic::options::OptionKeys::matdes::mutalyze::min_rb, "Specify whether to minimize the rigid body DOFs" ).def(1);
option.add( basic::options::OptionKeys::gpu::gpu, "gpu option group" ).legal(true).def(true);
option.add( basic::options::OptionKeys::gpu::kernel, "kernel src" );

}

inline void add_all_rosetta_options( utility::options::OptionCollection &option ) { add_rosetta_options_0(option); add_rosetta_options_1(option); add_rosetta_options_2(option); add_rosetta_options_3(option); }
#endif
