// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @author Oliver Lange

#ifndef INCLUDED_core_coarse_Translator_fwd_hh
#define INCLUDED_core_coarse_Translator_fwd_hh

// Package headers
#include <utility/pointer/owning_ptr.hh>
#include <utility/pointer/access_ptr.hh>

//Auto Headers


namespace core {
namespace coarse {

class Translator;
typedef utility::pointer::owning_ptr< Translator > TranslatorOP;
typedef utility::pointer::owning_ptr< Translator const > TranslatorCOP;
typedef utility::pointer::access_ptr< Translator const > TranslatorCAP;

class TranslatorSet;
typedef utility::pointer::owning_ptr< TranslatorSet > TranslatorSetOP;
typedef utility::pointer::owning_ptr< TranslatorSet const > TranslatorSetCOP;

}
}

#endif

