// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/packstat/compute_sasa.hh
///
/// @brief
/// @author will sheffler

#include "core/scoring/packstat/PackingScore.hh"

namespace core {
namespace scoring {
namespace packstat {

void init_packing_score_respred( PackingScore & p ) {
	p.compprob() = false;
  p.weight(1,1) = -0.0205350853090964; p.center(1,1) = 0.0346425746754636;
  p.weight(1,2) = -0.0568130413313418; p.center(1,2) = 0.0642312366176096;
  p.weight(1,3) = 0.0772295158965721; p.center(1,3) = 0.105223063220729;
  p.weight(1,4) = 0.00476531876870035; p.center(1,4) = 0.141376571318337;
  p.weight(1,5) = 0.0875587112499142; p.center(1,5) = 0.191997914358503;
  p.weight(1,6) = 0.0967848145145932; p.center(1,6) = 0.238054467934148;
  p.weight(1,7) = -0.0426472364637204; p.center(1,7) = 0.290051052304443;
  p.weight(1,8) = -0.114897462521805; p.center(1,8) = 0.338038141426501;
  p.weight(1,9) = -0.00846031347865159; p.center(1,9) = 0.390987049569835;
  p.weight(1,10) = 0.0435208593934505; p.center(1,10) = 0.462134139745088;
  p.weight(1,11) = 0.0225657462176644; p.center(1,11) = 0.53639914212427;
  p.weight(1,12) = -0.0146380870725785; p.center(1,12) = 0.6230269703983;
  p.weight(1,13) = 0.00252055064602503; p.center(1,13) = 0.709532760594796;
  p.weight(1,14) = -0.0481905961023548; p.center(1,14) = 0.815104542857143;
  p.weight(1,15) = -0.0197252064327465; p.center(1,15) = 0.91331254370685;
  p.weight(1,16) = 0.0328245555565883; p.center(1,16) = 1.11140363972384;
  p.weight(1,17) = -0.0276654903378683; p.center(1,17) = 1.24487394912374;
  p.weight(1,18) = 0.0602636724783941; p.center(1,18) = 1.40074440169942;
  p.weight(1,19) = -0.0130092130976903; p.center(1,19) = 1.6180723637812;
  p.weight(1,20) = -0.0168063272846134; p.center(1,20) = 1.84971006818906;
  p.weight(1,21) = 0.00674554433698151; p.center(1,21) = 2.20463712958046;
  p.weight(1,22) = -0.0100659216055898; p.center(1,22) = 2.64251461465746;
  p.weight(1,23) = -0.00723770034705824; p.center(1,23) = 3.14094836962294;
  p.weight(1,24) = 0.00357290124070290; p.center(1,24) = 3.73503193340414;
  p.weight(1,25) = 0.0173836588383956; p.center(1,25) = 4.56912720679766;
  p.weight(1,26) = -7.84019090797033e-05; p.center(1,26) = 5.54667488465215;
  p.weight(1,27) = 0.0063483103563975; p.center(1,27) = 6.77124725735528;
  p.weight(1,28) = 0.0159107717370337; p.center(1,28) = 8.04892101380775;
  p.weight(1,29) = -0.0258938221390993; p.center(1,29) = 9.58177690047796;
  p.weight(1,30) = -0.0164662410803039; p.center(1,30) = 10.9728966889007;
  p.weight(2,1) = -0.0461904269579675; p.center(2,1) = 0.111986190494635;
  p.weight(2,2) = 0.0309358788524633; p.center(2,2) = 0.247238297046592;
  p.weight(2,3) = -0.0171214012562708; p.center(2,3) = 0.369434315219822;
  p.weight(2,4) = 0.00105336782548451; p.center(2,4) = 0.510416453004177;
  p.weight(2,5) = -0.00414897698935789; p.center(2,5) = 0.702848980320715;
  p.weight(2,6) = 0.00537469221755291; p.center(2,6) = 0.859319539934983;
  p.weight(2,7) = 0.00505473504546837; p.center(2,7) = 1.03645172152658;
  p.weight(2,8) = 0.0231503247885576; p.center(2,8) = 1.22623956666954;
  p.weight(2,9) = 0.00491977604033907; p.center(2,9) = 1.41721148230507;
  p.weight(2,10) = -0.0312544440705087; p.center(2,10) = 1.64564199281997;
  p.weight(2,11) = 0.0109550660235326; p.center(2,11) = 1.89653517511418;
  p.weight(2,12) = -0.00282810389288761; p.center(2,12) = 2.209390802045;
  p.weight(2,13) = 0.0331439784753431; p.center(2,13) = 2.50718090603293;
  p.weight(2,14) = 0.0342584401056391; p.center(2,14) = 2.84872390281466;
  p.weight(2,15) = -0.0349079962777661; p.center(2,15) = 3.21614611906532;
  p.weight(2,16) = 0.00364978423815465; p.center(2,16) = 3.81533914009559;
  p.weight(2,17) = -0.0118471694728953; p.center(2,17) = 4.31243033659055;
  p.weight(2,18) = 0.0114389038304917; p.center(2,18) = 4.85870053165162;
  p.weight(2,19) = 0.0115990696652575; p.center(2,19) = 5.56207055878917;
  p.weight(2,20) = 0.00410659661212522; p.center(2,20) = 6.36351592707382;
  p.weight(2,21) = -0.0221391149746385; p.center(2,21) = 7.43936634476899;
  p.weight(2,22) = -0.00107963419639649; p.center(2,22) = 8.85438458635157;
  p.weight(2,23) = 0.00379395103556337; p.center(2,23) = 10.4102114486458;
  p.weight(2,24) = 0.00478783616183086; p.center(2,24) = 12.3331713010090;
  p.weight(2,25) = -0.00257716915535124; p.center(2,25) = 14.9896582689326;
  p.weight(2,26) = -0.00104576331141849; p.center(2,26) = 18.1770918269782;
  p.weight(2,27) = 0.0154106511849653; p.center(2,27) = 21.9542758827403;
  p.weight(2,28) = -0.0078113041460221; p.center(2,28) = 26.2427164316516;
  p.weight(2,29) = -0.00356114456848374; p.center(2,29) = 31.2837185395645;
  p.weight(2,30) = -0.01545174162679; p.center(2,30) = 36.2150084724376;
  p.weight(3,1) = 0.0216923616680708; p.center(3,1) = 0.148847119545876;
  p.weight(3,2) = 0.0128563169397628; p.center(3,2) = 0.266877044839059;
  p.weight(3,3) = -0.04002997442929; p.center(3,3) = 0.425315758065331;
  p.weight(3,4) = -0.00363418789558793; p.center(3,4) = 0.60226787790841;
  p.weight(3,5) = -0.0099406387305009; p.center(3,5) = 0.78266527175332;
  p.weight(3,6) = -0.0207734582370000; p.center(3,6) = 0.960145940573967;
  p.weight(3,7) = 0.049501422304366; p.center(3,7) = 1.16618011460808;
  p.weight(3,8) = 0.00256971642695844; p.center(3,8) = 1.39309388635359;
  p.weight(3,9) = 0.00598720160154388; p.center(3,9) = 1.62850729560466;
  p.weight(3,10) = -0.0100941979606583; p.center(3,10) = 1.89299317839193;
  p.weight(3,11) = -0.0118343947153879; p.center(3,11) = 2.19311819305364;
  p.weight(3,12) = 0.0335955146908684; p.center(3,12) = 2.50337970727244;
  p.weight(3,13) = -0.0176775317465374; p.center(3,13) = 2.86430308775358;
  p.weight(3,14) = -0.0196363330351686; p.center(3,14) = 3.26770722062454;
  p.weight(3,15) = 0.0234013134545708; p.center(3,15) = 3.70969171817313;
  p.weight(3,16) = 0.00201813613146955; p.center(3,16) = 4.29483585416888;
  p.weight(3,17) = 0.0114848523654107; p.center(3,17) = 4.88055202577801;
  p.weight(3,18) = 0.0098801099289819; p.center(3,18) = 5.54198026128518;
  p.weight(3,19) = -0.0165773942243868; p.center(3,19) = 6.33382928921933;
  p.weight(3,20) = 0.0101698833264242; p.center(3,20) = 7.339004837812;
  p.weight(3,21) = -0.00941003625997696; p.center(3,21) = 8.5804214703027;
  p.weight(3,22) = 0.0051714199960632; p.center(3,22) = 10.1711650061604;
  p.weight(3,23) = -0.00545715514759326; p.center(3,23) = 12.0568466429102;
  p.weight(3,24) = -0.00218832373126487; p.center(3,24) = 14.3958215072756;
  p.weight(3,25) = -0.0137422311296301; p.center(3,25) = 17.5974539329793;
  p.weight(3,26) = -0.007309167801733; p.center(3,26) = 21.3622475104620;
  p.weight(3,27) = 0.0215788449259795; p.center(3,27) = 25.9128067922464;
  p.weight(3,28) = 0.00284369587788238; p.center(3,28) = 31.3235863871482;
  p.weight(3,29) = -0.00421815305981177; p.center(3,29) = 37.347821013914;
  p.weight(3,30) = -0.0097875358968026; p.center(3,30) = 43.921075501009;
  p.weight(4,1) = -0.0642107694262119; p.center(4,1) = 0.097607291884047;
  p.weight(4,2) = 0.0332734165343255; p.center(4,2) = 0.207159649856548;
  p.weight(4,3) = -0.00549440055493261; p.center(4,3) = 0.316900621260645;
  p.weight(4,4) = 0.0307106026602042; p.center(4,4) = 0.478998171890672;
  p.weight(4,5) = 0.00681305558119545; p.center(4,5) = 0.612726453763319;
  p.weight(4,6) = -0.033884450368115; p.center(4,6) = 0.765017507028147;
  p.weight(4,7) = 0.0384584954948849; p.center(4,7) = 0.928435002736559;
  p.weight(4,8) = -0.00364378031442256; p.center(4,8) = 1.12969130595634;
  p.weight(4,9) = 0.0154461035682996; p.center(4,9) = 1.32945556381189;
  p.weight(4,10) = -0.0344255552098591; p.center(4,10) = 1.55953420854163;
  p.weight(4,11) = 0.045919930827108; p.center(4,11) = 1.79418204108550;
  p.weight(4,12) = -0.0293379909845186; p.center(4,12) = 2.04829818812958;
  p.weight(4,13) = 0.0337159493250635; p.center(4,13) = 2.34344194405736;
  p.weight(4,14) = 0.00942695542315156; p.center(4,14) = 2.67575131154541;
  p.weight(4,15) = -0.0164236910140914; p.center(4,15) = 3.03145988875199;
  p.weight(4,16) = -0.0134873112349606; p.center(4,16) = 3.51826841943707;
  p.weight(4,17) = -0.0268916362416787; p.center(4,17) = 4.01449744208178;
  p.weight(4,18) = -0.0123220518613573; p.center(4,18) = 4.56639844588423;
  p.weight(4,19) = -0.0038960816092392; p.center(4,19) = 5.22879918746681;
  p.weight(4,20) = -0.0122920679807827; p.center(4,20) = 6.11867738757302;
  p.weight(4,21) = -0.00711674271035674; p.center(4,21) = 7.17439747073818;
  p.weight(4,22) = 0.0121214896086449; p.center(4,22) = 8.57069334774296;
  p.weight(4,23) = 0.0146572565640258; p.center(4,23) = 10.2859563684546;
  p.weight(4,24) = -0.000308142790555118; p.center(4,24) = 12.4683017267127;
  p.weight(4,25) = 0.00387171814190663; p.center(4,25) = 15.559416037812;
  p.weight(4,26) = 0.00485541454921585; p.center(4,26) = 19.3368100695698;
  p.weight(4,27) = 0.0197921535601784; p.center(4,27) = 24.2798566900690;
  p.weight(4,28) = 0.00202577065486056; p.center(4,28) = 30.2295788493893;
  p.weight(4,29) = -0.00638077555729929; p.center(4,29) = 37.1666186793415;
  p.weight(4,30) = -0.0136586610559694; p.center(4,30) = 45.0916587457249;
  p.weight(5,1) = -0.0210214072235853; p.center(5,1) = 0.253831949430215;
  p.weight(5,2) = -0.00869009474371829; p.center(5,2) = 0.551811847945486;
  p.weight(5,3) = 0.0109517813233247; p.center(5,3) = 0.829777411159545;
  p.weight(5,4) = -0.00381447756533726; p.center(5,4) = 1.19189502748701;
  p.weight(5,5) = 0.0441785340505078; p.center(5,5) = 1.58885492386386;
  p.weight(5,6) = 0.000271369681501530; p.center(5,6) = 1.97924385276769;
  p.weight(5,7) = 0.0283972675919617; p.center(5,7) = 2.39867937469033;
  p.weight(5,8) = -0.0161358227270039; p.center(5,8) = 2.87894196029564;
  p.weight(5,9) = 0.00570472381464053; p.center(5,9) = 3.36580081600181;
  p.weight(5,10) = 0.00355699973107907; p.center(5,10) = 3.95152937507902;
  p.weight(5,11) = -0.00741005888668559; p.center(5,11) = 4.61033168190122;
  p.weight(5,12) = 0.0128257351091021; p.center(5,12) = 5.30642417258384;
  p.weight(5,13) = -0.000307202068164756; p.center(5,13) = 6.1131141517897;
  p.weight(5,14) = -0.00809764630530148; p.center(5,14) = 7.02187588890069;
  p.weight(5,15) = -0.0117399035459325; p.center(5,15) = 8.00599133414764;
  p.weight(5,16) = 8.87366244123271e-05; p.center(5,16) = 9.49800337907594;
  p.weight(5,17) = -0.00357062974083948; p.center(5,17) = 10.8836336592671;
  p.weight(5,18) = 0.00239483759286841; p.center(5,18) = 12.4405028225173;
  p.weight(5,19) = -0.0198857568607802; p.center(5,19) = 14.4492024441848;
  p.weight(5,20) = -0.00809076412954378; p.center(5,20) = 16.9581590275093;
  p.weight(5,21) = -0.00138232069192421; p.center(5,21) = 20.3322850169942;
  p.weight(5,22) = 0.0126641519786451; p.center(5,22) = 24.8266007456187;
  p.weight(5,23) = 0.00727252611806893; p.center(5,23) = 30.1975158082847;
  p.weight(5,24) = 0.00583314245925166; p.center(5,24) = 37.2035221819437;
  p.weight(5,25) = 0.00656294428376847; p.center(5,25) = 47.0255790783856;
  p.weight(5,26) = -0.00258968772129212; p.center(5,26) = 59.0495730568242;
  p.weight(5,27) = 0.0115805851444163; p.center(5,27) = 73.7643519768455;
  p.weight(5,28) = -0.00227774174352426; p.center(5,28) = 90.3686304693574;
  p.weight(5,29) = -0.0080617700875174; p.center(5,29) = 109.246840616144;
  p.weight(5,30) = -0.000360993297210105; p.center(5,30) = 128.421134758364;
  p.weight(6,1) = -0.00601151201036689; p.center(6,1) = 0.463741861310393;
  p.weight(6,2) = -0.0238985359783085; p.center(6,2) = 0.964432095270142;
  p.weight(6,3) = 0.0190796375460681; p.center(6,3) = 1.44046699865274;
  p.weight(6,4) = -0.0103169091142014; p.center(6,4) = 2.04727957289932;
  p.weight(6,5) = 0.00362539478752022; p.center(6,5) = 2.70631310127056;
  p.weight(6,6) = 0.00586955331987545; p.center(6,6) = 3.37433495891309;
  p.weight(6,7) = 0.0104639396890289; p.center(6,7) = 4.08201538054481;
  p.weight(6,8) = -0.00203447480062628; p.center(6,8) = 4.90381732815914;
  p.weight(6,9) = 0.0222833409863394; p.center(6,9) = 5.73870283690537;
  p.weight(6,10) = -0.00811561650938854; p.center(6,10) = 6.68087933593521;
  p.weight(6,11) = 0.00352661894676020; p.center(6,11) = 7.8026112264684;
  p.weight(6,12) = -0.0129734577259982; p.center(6,12) = 8.99093465381837;
  p.weight(6,13) = 0.00260122987560852; p.center(6,13) = 10.3450675431152;
  p.weight(6,14) = -0.00697374354132526; p.center(6,14) = 11.8537604725438;
  p.weight(6,15) = -0.0138186236823479; p.center(6,15) = 13.5191060295274;
  p.weight(6,16) = 0.00296681922317524; p.center(6,16) = 15.9686841387148;
  p.weight(6,17) = -0.0114561135439026; p.center(6,17) = 18.2588353683484;
  p.weight(6,18) = 0.0071678224149737; p.center(6,18) = 20.8840801859798;
  p.weight(6,19) = -0.0114628260763035; p.center(6,19) = 24.3518273773765;
  p.weight(6,20) = -0.0072915352150025; p.center(6,20) = 28.5207211074881;
  p.weight(6,21) = 0.000479435649559112; p.center(6,21) = 34.2327602848646;
  p.weight(6,22) = 0.00500205576835128; p.center(6,22) = 41.848005195008;
  p.weight(6,23) = 0.00932061463832225; p.center(6,23) = 50.9103259093999;
  p.weight(6,24) = 0.00983749378168578; p.center(6,24) = 62.2564698737122;
  p.weight(6,25) = 0.00415206446548306; p.center(6,25) = 77.7366019381838;
  p.weight(6,26) = -0.00257131432406963; p.center(6,26) = 96.1957365756771;
  p.weight(6,27) = 0.00966093842459331; p.center(6,27) = 118.175018187679;
  p.weight(6,28) = 0.000322353530958577; p.center(6,28) = 142.511480984599;
  p.weight(6,29) = -0.00472827966596358; p.center(6,29) = 170.221703158789;
  p.weight(6,30) = -0.00378617938182206; p.center(6,30) = 197.607103539033;
  p.weight(7,1) = -0.0245940387588079; p.center(7,1) = 0.55355680164876;
  p.weight(7,2) = -0.0177151244769077; p.center(7,2) = 1.18621277696587;
  p.weight(7,3) = 0.0113696297583339; p.center(7,3) = 1.78349998299513;
  p.weight(7,4) = 0.0324448292351698; p.center(7,4) = 2.56753349369612;
  p.weight(7,5) = 0.0101130324529947; p.center(7,5) = 3.36994275974485;
  p.weight(7,6) = -0.0093870287898322; p.center(7,6) = 4.15341614517611;
  p.weight(7,7) = 0.0157028808812226; p.center(7,7) = 5.06031378736038;
  p.weight(7,8) = 0.00646856146965499; p.center(7,8) = 6.06729594835447;
  p.weight(7,9) = 0.0207559835961230; p.center(7,9) = 7.09667572642022;
  p.weight(7,10) = -0.0122503967583893; p.center(7,10) = 8.30752778494526;
  p.weight(7,11) = -0.0157124365910149; p.center(7,11) = 9.64413516557833;
  p.weight(7,12) = -0.0157724037736404; p.center(7,12) = 11.1502688091981;
  p.weight(7,13) = 0.00326962310498114; p.center(7,13) = 12.7655071187467;
  p.weight(7,14) = 0.0059587224174852; p.center(7,14) = 14.6118472720127;
  p.weight(7,15) = -0.0116116260997525; p.center(7,15) = 16.5933967000531;
  p.weight(7,16) = -0.0122141298088698; p.center(7,16) = 19.5792595451938;
  p.weight(7,17) = -0.00417078500727161; p.center(7,17) = 22.3659458783856;
  p.weight(7,18) = -0.00354420747607325; p.center(7,18) = 25.5371543371216;
  p.weight(7,19) = 0.00171121298694268; p.center(7,19) = 29.6757992228359;
  p.weight(7,20) = -0.0117711294681937; p.center(7,20) = 34.6145841653744;
  p.weight(7,21) = -0.00162672243331867; p.center(7,21) = 41.3525404983537;
  p.weight(7,22) = 0.0190533240812826; p.center(7,22) = 50.0796854479023;
  p.weight(7,23) = 0.00502979983690116; p.center(7,23) = 60.4704954606479;
  p.weight(7,24) = 0.00697641831123135; p.center(7,24) = 73.3028566356877;
  p.weight(7,25) = 0.00464645772080152; p.center(7,25) = 90.6083496382369;
  p.weight(7,26) = 0.000110850454570522; p.center(7,26) = 111.155902490600;
  p.weight(7,27) = 0.00643723892156589; p.center(7,27) = 135.408733785767;
  p.weight(7,28) = -0.00220797948516739; p.center(7,28) = 161.862207820499;
  p.weight(7,29) = -0.00572167843562703; p.center(7,29) = 191.870137971535;
  p.weight(7,30) = -0.00159512824789008; p.center(7,30) = 221.256027488051;
  p.rho() = 0.0140673607831624;

	p.probA() = 1.007288;
	p.probB() = 2.040815;
}

void init_packing_score_discrim( PackingScore & p ) {
	p.compprob() = true;
  p.weight(1,1) = -0.087291423449629; p.center(1,1) = 0.0389039534663405;
  p.weight(1,2) = -0.103669472768846; p.center(1,2) = 0.0899715583627291;
  p.weight(1,3) = 0.0956577140976008; p.center(1,3) = 0.136877468527231;
  p.weight(1,4) = 0.174709005854082; p.center(1,4) = 0.194666531701134;
  p.weight(1,5) = 0.0104046049485668; p.center(1,5) = 0.234040786333392;
  p.weight(1,6) = -0.104409788159902; p.center(1,6) = 0.309773468087904;
  p.weight(1,7) = 0.0788758884640946; p.center(1,7) = 0.357713734259955;
  p.weight(1,8) = -0.0214237302947243; p.center(1,8) = 0.441992963204358;
  p.weight(1,9) = -0.0423378098221035; p.center(1,9) = 0.519815186739294;
  p.weight(1,10) = -0.0171514521410377; p.center(1,10) = 0.582627667505635;
  p.weight(1,11) = 0.0165490166609910; p.center(1,11) = 0.680206425582269;
  p.weight(1,12) = -0.103874338313117; p.center(1,12) = 0.779765814350113;
  p.weight(1,13) = -0.0777278200118299; p.center(1,13) = 0.889450449192337;
  p.weight(1,14) = -0.0450453274827926; p.center(1,14) = 1.01845239706987;
  p.weight(1,15) = -0.0225725976482894; p.center(1,15) = 1.16134922314050;
  p.weight(1,16) = 0.099117760448016; p.center(1,16) = 1.41546116228400;
  p.weight(1,17) = -0.0236841156017453; p.center(1,17) = 1.56507456160781;
  p.weight(1,18) = -0.143901824335328; p.center(1,18) = 1.78615589500376;
  p.weight(1,19) = 0.0534934746209668; p.center(1,19) = 2.08351694646882;
  p.weight(1,20) = 0.0411539889171709; p.center(1,20) = 2.3763989973704;
  p.weight(1,21) = 0.00175115556502397; p.center(1,21) = 2.87925648441022;
  p.weight(1,22) = 0.0733686196538193; p.center(1,22) = 3.46948099361382;
  p.weight(1,23) = -0.00222099291142864; p.center(1,23) = 4.09735376389932;
  p.weight(1,24) = -0.0109890286426793; p.center(1,24) = 4.82971741979715;
  p.weight(1,25) = -0.00152222971829121; p.center(1,25) = 5.87802323966942;
  p.weight(1,26) = 0.020822882199806; p.center(1,26) = 6.97970829827198;
  p.weight(1,27) = 0.0118532948170428; p.center(1,27) = 8.34068354338843;
  p.weight(1,28) = -0.0148295315184253; p.center(1,28) = 9.73254536025545;
  p.weight(1,29) = -0.00778317496279655; p.center(1,29) = 11.4289206183321;
  p.weight(1,30) = -0.00455491233863827; p.center(1,30) = 12.810612527423;
  p.weight(2,1) = 0.119903720450494; p.center(2,1) = 0.0885957563145919;
  p.weight(2,2) = 0.111168455716461; p.center(2,2) = 0.232820876074497;
  p.weight(2,3) = -0.00943290173265303; p.center(2,3) = 0.360861267822873;
  p.weight(2,4) = -0.0389027645864570; p.center(2,4) = 0.499091340086497;
  p.weight(2,5) = 0.00261464485162758; p.center(2,5) = 0.670745078775357;
  p.weight(2,6) = 0.0124706689382828; p.center(2,6) = 0.829570620774545;
  p.weight(2,7) = -0.040168871912922; p.center(2,7) = 0.996238905461465;
  p.weight(2,8) = -0.0821163866577605; p.center(2,8) = 1.18984100304201;
  p.weight(2,9) = 0.0301058858173572; p.center(2,9) = 1.37224776330579;
  p.weight(2,10) = 0.0238963282788775; p.center(2,10) = 1.56941054078769;
  p.weight(2,11) = -0.00796970312184383; p.center(2,11) = 1.84540709971826;
  p.weight(2,12) = -0.00152169786513013; p.center(2,12) = 2.08548082468504;
  p.weight(2,13) = -0.074600127471289; p.center(2,13) = 2.4062995073441;
  p.weight(2,14) = 0.0235118270300133; p.center(2,14) = 2.73768279611195;
  p.weight(2,15) = -0.0513418389471852; p.center(2,15) = 3.09729264822295;
  p.weight(2,16) = 0.0145167602257996; p.center(2,16) = 3.70686741280992;
  p.weight(2,17) = -0.00726675325948962; p.center(2,17) = 4.19032574906086;
  p.weight(2,18) = -0.0123572081120729; p.center(2,18) = 4.76782016810669;
  p.weight(2,19) = -0.0392504702153425; p.center(2,19) = 5.53411044778362;
  p.weight(2,20) = 0.0515215413844134; p.center(2,20) = 6.37396451258452;
  p.weight(2,21) = 0.00221829740672553; p.center(2,21) = 7.54682783677686;
  p.weight(2,22) = -0.0308416555918915; p.center(2,22) = 9.01052148178062;
  p.weight(2,23) = -0.0424730058673411; p.center(2,23) = 10.6733947638993;
  p.weight(2,24) = 0.0316674016929672; p.center(2,24) = 12.7285519483471;
  p.weight(2,25) = 0.0102264687440108; p.center(2,25) = 15.4776276611570;
  p.weight(2,26) = 0.00416686069966421; p.center(2,26) = 18.5701894532307;
  p.weight(2,27) = 0.049126399986889; p.center(2,27) = 22.2675985227273;
  p.weight(2,28) = 0.0615089588648521; p.center(2,28) = 26.3379113641999;
  p.weight(2,29) = 0.0049034329055783; p.center(2,29) = 30.9546733225019;
  p.weight(2,30) = -0.0863655564134028; p.center(2,30) = 35.1248644182945;
  p.weight(3,1) = 0.149608063774147; p.center(3,1) = 0.127213029259688;
  p.weight(3,2) = -0.0193164630082715; p.center(3,2) = 0.291167260748939;
  p.weight(3,3) = -0.0939015618433615; p.center(3,3) = 0.443518111277361;
  p.weight(3,4) = 0.116890626885625; p.center(3,4) = 0.608728048327687;
  p.weight(3,5) = -0.0118914453596611; p.center(3,5) = 0.813930204476072;
  p.weight(3,6) = 0.0147974025335520; p.center(3,6) = 0.981946726354838;
  p.weight(3,7) = -0.0991958720501176; p.center(3,7) = 1.19131078230297;
  p.weight(3,8) = 0.0331914948871107; p.center(3,8) = 1.44770829732028;
  p.weight(3,9) = -0.00190262500097773; p.center(3,9) = 1.68323324827504;
  p.weight(3,10) = 0.0458080217680494; p.center(3,10) = 1.96867798933133;
  p.weight(3,11) = 0.0116706396296108; p.center(3,11) = 2.25716870594685;
  p.weight(3,12) = -0.0215243802152768; p.center(3,12) = 2.55595092186326;
  p.weight(3,13) = 0.00199410282252443; p.center(3,13) = 2.911279583253;
  p.weight(3,14) = -0.0447621380390968; p.center(3,14) = 3.33266807438017;
  p.weight(3,15) = -0.0308054550754495; p.center(3,15) = 3.775689446713;
  p.weight(3,16) = 0.0284180723498516; p.center(3,16) = 4.33742970760706;
  p.weight(3,17) = -0.0279414397032362; p.center(3,17) = 4.93029453418482;
  p.weight(3,18) = 0.0153166362993958; p.center(3,18) = 5.58666487227648;
  p.weight(3,19) = 0.0148396368644485; p.center(3,19) = 6.43255708677686;
  p.weight(3,20) = 0.00230237711501049; p.center(3,20) = 7.41517304489106;
  p.weight(3,21) = 0.00668173391763417; p.center(3,21) = 8.70573557757325;
  p.weight(3,22) = 0.0219305801227054; p.center(3,22) = 10.3320808809166;
  p.weight(3,23) = -0.00563201390232959; p.center(3,23) = 12.1324169611195;
  p.weight(3,24) = 0.00258063657436468; p.center(3,24) = 14.3528962667168;
  p.weight(3,25) = -0.0452767663807646; p.center(3,25) = 17.3791250439519;
  p.weight(3,26) = -0.00924959812367247; p.center(3,26) = 20.8049499887303;
  p.weight(3,27) = -0.00371332833004227; p.center(3,27) = 24.8192584776484;
  p.weight(3,28) = 0.0350395126320318; p.center(3,28) = 29.6662792402329;
  p.weight(3,29) = 0.0182143165855934; p.center(3,29) = 35.1888240255447;
  p.weight(3,30) = -0.0492179972791834; p.center(3,30) = 41.0466893082269;
  p.weight(4,1) = -0.0331785847132777; p.center(4,1) = 0.112712712988372;
  p.weight(4,2) = 0.111824264905041; p.center(4,2) = 0.226088078245628;
  p.weight(4,3) = -0.0340215104463712; p.center(4,3) = 0.369781398227684;
  p.weight(4,4) = -0.0102473518299741; p.center(4,4) = 0.532397370918832;
  p.weight(4,5) = 0.0221019907883519; p.center(4,5) = 0.696147227336894;
  p.weight(4,6) = 0.114980194001040; p.center(4,6) = 0.8373984763812;
  p.weight(4,7) = 0.0845774206411779; p.center(4,7) = 1.00842577983584;
  p.weight(4,8) = -0.0175745639493128; p.center(4,8) = 1.22695563694591;
  p.weight(4,9) = -0.161350809126542; p.center(4,9) = 1.44509282083020;
  p.weight(4,10) = -0.016891369584624; p.center(4,10) = 1.69668432833959;
  p.weight(4,11) = 0.0646301970583586; p.center(4,11) = 1.94060743322690;
  p.weight(4,12) = -0.0571056174459502; p.center(4,12) = 2.19470516771225;
  p.weight(4,13) = -0.0323140021452519; p.center(4,13) = 2.49908043382795;
  p.weight(4,14) = 0.0544161647358304; p.center(4,14) = 2.84150221374906;
  p.weight(4,15) = 0.0125974831373485; p.center(4,15) = 3.23738520343726;
  p.weight(4,16) = -0.0349421440601213; p.center(4,16) = 3.72910849564237;
  p.weight(4,17) = -0.0543455591339154; p.center(4,17) = 4.26173824943651;
  p.weight(4,18) = 0.05837511328612; p.center(4,18) = 4.85570648797896;
  p.weight(4,19) = -0.0345644556767941; p.center(4,19) = 5.56580538974455;
  p.weight(4,20) = 0.00963993828013545; p.center(4,20) = 6.45705195567243;
  p.weight(4,21) = -0.00467942423844487; p.center(4,21) = 7.59530465852742;
  p.weight(4,22) = 0.0114806594797470; p.center(4,22) = 9.01179733170548;
  p.weight(4,23) = 0.0246902239987398; p.center(4,23) = 10.7563801485725;
  p.weight(4,24) = -0.0450242589430835; p.center(4,24) = 12.9785588416604;
  p.weight(4,25) = -0.0162524176545044; p.center(4,25) = 16.0520889737040;
  p.weight(4,26) = 0.0197463471900981; p.center(4,26) = 19.7682573551841;
  p.weight(4,27) = -0.0226189659742351; p.center(4,27) = 24.5756463886176;
  p.weight(4,28) = 0.0689382669094295; p.center(4,28) = 30.4492542345980;
  p.weight(4,29) = -0.0194804886928916; p.center(4,29) = 37.432035161157;
  p.weight(4,30) = -0.0212868934327188; p.center(4,30) = 45.1294387329076;
  p.weight(5,1) = 0.00146649286912319; p.center(5,1) = 0.215716363423462;
  p.weight(5,2) = 0.0386822560607923; p.center(5,2) = 0.498170964960989;
  p.weight(5,3) = 0.0333827325800067; p.center(5,3) = 0.767616499337318;
  p.weight(5,4) = 0.0393266118904775; p.center(5,4) = 1.10745177139368;
  p.weight(5,5) = -0.0546550253319436; p.center(5,5) = 1.41388157992622;
  p.weight(5,6) = -0.00289098715078124; p.center(5,6) = 1.78991064472436;
  p.weight(5,7) = -0.032652531561496; p.center(5,7) = 2.14645940501581;
  p.weight(5,8) = -0.00389298190649676; p.center(5,8) = 2.60414449250292;
  p.weight(5,9) = -0.00536578628463557; p.center(5,9) = 3.05273993636211;
  p.weight(5,10) = 0.0103044684806081; p.center(5,10) = 3.54685609573629;
  p.weight(5,11) = 0.00803518837041865; p.center(5,11) = 4.12730620694966;
  p.weight(5,12) = -0.0116940285130662; p.center(5,12) = 4.7262861768595;
  p.weight(5,13) = 0.0113390799763157; p.center(5,13) = 5.46387107868144;
  p.weight(5,14) = -0.0415344609314615; p.center(5,14) = 6.23661396617205;
  p.weight(5,15) = -0.0187397229516954; p.center(5,15) = 7.176148412284;
  p.weight(5,16) = 0.0234077850930250; p.center(5,16) = 8.52884705879038;
  p.weight(5,17) = -0.0486998917024317; p.center(5,17) = 9.77595022201352;
  p.weight(5,18) = 0.00478763852742411; p.center(5,18) = 11.3227868822314;
  p.weight(5,19) = -0.0425045430768362; p.center(5,19) = 13.3316467868144;
  p.weight(5,20) = 0.00491662548180224; p.center(5,20) = 15.7136916515778;
  p.weight(5,21) = -0.00255116690876599; p.center(5,21) = 19.0941436818182;
  p.weight(5,22) = 0.0651875444865682; p.center(5,22) = 23.5263386061232;
  p.weight(5,23) = 0.00441802485434744; p.center(5,23) = 28.7999108846732;
  p.weight(5,24) = 0.00784391031935686; p.center(5,24) = 35.6398553660781;
  p.weight(5,25) = -0.0229567778477255; p.center(5,25) = 45.1453800886551;
  p.weight(5,26) = 0.0104905768428507; p.center(5,26) = 56.2125188700225;
  p.weight(5,27) = -0.00951686459364568; p.center(5,27) = 69.5653422261458;
  p.weight(5,28) = 0.0137644983755210; p.center(5,28) = 84.89590634861;
  p.weight(5,29) = 0.013831225305854; p.center(5,29) = 102.250813377536;
  p.weight(5,30) = -0.0215717881552955; p.center(5,30) = 118.849563247558;
  p.weight(6,1) = -0.0315997144761596; p.center(6,1) = 0.440687478563694;
  p.weight(6,2) = 0.0586229356873679; p.center(6,2) = 0.996201047964807;
  p.weight(6,3) = 0.0106862642910468; p.center(6,3) = 1.51799973204623;
  p.weight(6,4) = 0.0138972620129917; p.center(6,4) = 2.14708881521477;
  p.weight(6,5) = 0.0228863989578296; p.center(6,5) = 2.79390851392334;
  p.weight(6,6) = -0.0521770295756789; p.center(6,6) = 3.50537619177267;
  p.weight(6,7) = 0.00479111863981399; p.center(6,7) = 4.22316347406518;
  p.weight(6,8) = 0.0143014844295748; p.center(6,8) = 5.08000687256595;
  p.weight(6,9) = 0.0314529902057466; p.center(6,9) = 5.90666591496995;
  p.weight(6,10) = -0.00262079519052664; p.center(6,10) = 6.90243640398197;
  p.weight(6,11) = 0.0135720332838870; p.center(6,11) = 8.00022035835838;
  p.weight(6,12) = -0.0248240366078623; p.center(6,12) = 9.21529161551465;
  p.weight(6,13) = -0.0193446598897998; p.center(6,13) = 10.5949557511270;
  p.weight(6,14) = -0.0437622688722857; p.center(6,14) = 12.1871860856499;
  p.weight(6,15) = -0.0377620884723665; p.center(6,15) = 13.9387404222389;
  p.weight(6,16) = -0.0159450323244293; p.center(6,16) = 16.6090887747934;
  p.weight(6,17) = -0.0432896621602305; p.center(6,17) = 18.9867375634861;
  p.weight(6,18) = -0.0061290295620058; p.center(6,18) = 21.9294100482720;
  p.weight(6,19) = 0.0307681989530886; p.center(6,19) = 25.8629593935011;
  p.weight(6,20) = 0.0261349628034076; p.center(6,20) = 30.3712431408715;
  p.weight(6,21) = 4.09990578203553e-05; p.center(6,21) = 36.8917675869647;
  p.weight(6,22) = 0.0175721915498764; p.center(6,22) = 45.2077872674681;
  p.weight(6,23) = 0.0149793330604685; p.center(6,23) = 54.8356931716754;
  p.weight(6,24) = 0.0170971198972041; p.center(6,24) = 67.0393886018032;
  p.weight(6,25) = -0.0101915313500849; p.center(6,25) = 83.3167431542074;
  p.weight(6,26) = 0.0154546537703155; p.center(6,26) = 101.849690758077;
  p.weight(6,27) = -0.0088831012052684; p.center(6,27) = 123.123158064425;
  p.weight(6,28) = 0.000886057088345707; p.center(6,28) = 147.214453652329;
  p.weight(6,29) = -0.0078058220862887; p.center(6,29) = 174.620697784936;
  p.weight(6,30) = -0.00327166719661832; p.center(6,30) = 200.477714243050;
  p.weight(7,1) = -0.021059123161574; p.center(7,1) = 0.57012188457691;
  p.weight(7,2) = 0.00482192797972319; p.center(7,2) = 1.24076595992245;
  p.weight(7,3) = 0.0426183228609406; p.center(7,3) = 1.89415213539095;
  p.weight(7,4) = -0.0165830908553718; p.center(7,4) = 2.72022571341176;
  p.weight(7,5) = -0.0152630299808813; p.center(7,5) = 3.52150684162878;
  p.weight(7,6) = -0.0293722056145659; p.center(7,6) = 4.37458264360809;
  p.weight(7,7) = 0.0292606296210293; p.center(7,7) = 5.33566371563674;
  p.weight(7,8) = -0.00333320275317019; p.center(7,8) = 6.40649296470975;
  p.weight(7,9) = 0.0235242153980704; p.center(7,9) = 7.45980498719512;
  p.weight(7,10) = -0.0361909967288744; p.center(7,10) = 8.64294212997746;
  p.weight(7,11) = -0.0107299087018900; p.center(7,11) = 10.0530181341097;
  p.weight(7,12) = -0.0415873884856096; p.center(7,12) = 11.4609296421488;
  p.weight(7,13) = -0.0587403174738457; p.center(7,13) = 13.1755305251690;
  p.weight(7,14) = -0.00508244300715933; p.center(7,14) = 15.030882966003;
  p.weight(7,15) = 0.00268987973058922; p.center(7,15) = 17.2529142915101;
  p.weight(7,16) = -0.00583852198932374; p.center(7,16) = 20.3774041205860;
  p.weight(7,17) = -0.0233090643952086; p.center(7,17) = 23.2158919077761;
  p.weight(7,18) = -0.00799385034835478; p.center(7,18) = 26.6817887751690;
  p.weight(7,19) = 0.00911065122130065; p.center(7,19) = 31.3617223929376;
  p.weight(7,20) = 0.038536600417957; p.center(7,20) = 36.6415774410218;
  p.weight(7,21) = 0.0348210114407393; p.center(7,21) = 44.0694981235913;
  p.weight(7,22) = 0.0166400673723888; p.center(7,22) = 53.4885057858753;
  p.weight(7,23) = -0.00729725592559465; p.center(7,23) = 64.2711796682945;
  p.weight(7,24) = 0.0188534811732146; p.center(7,24) = 77.6393756835086;
  p.weight(7,25) = -0.00210718392613743; p.center(7,25) = 95.355219511082;
  p.weight(7,26) = 0.0110808993644642; p.center(7,26) = 115.488836589594;
  p.weight(7,27) = -0.0134028501206606; p.center(7,27) = 138.803569368520;
  p.weight(7,28) = -0.0165660586378803; p.center(7,28) = 164.571557299023;
  p.weight(7,29) = 0.00190363704428198; p.center(7,29) = 193.924418215627;
  p.weight(7,30) = 0.00071037537317955; p.center(7,30) = 221.567099408340;
  p.rho() = -0.0333513312638952;
  p.probA() = -0.866678867514068;
  p.probB() = -0.00345929525338531;
}

} // namesapce packstat
} // namespace scoring
} // namespace core

