// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/features/ResidueTypesFeatures.hh
/// @brief  report ResidueTypes features Statistics Scientific Benchmark
/// @author Matthew O'Meara

#ifndef INCLUDED_protocols_features_ResidueTypesFeatures_hh
#define INCLUDED_protocols_features_ResidueTypesFeatures_hh

// Unit Headers
#include <protocols/features/FeaturesReporter.hh>
#include <protocols/features/ResidueTypesFeatures.fwd.hh>
#include <core/chemical/ResidueDatabaseIO.hh>

// Project Headers
#include <core/types.hh>

// Utility Headers
#include <utility/vector1.hh>

// C++ Headers
#include <string>

#include <core/chemical/ResidueType.fwd.hh>


namespace protocols{
namespace features{

class ResidueTypesFeatures : public protocols::features::FeaturesReporter {
public:
	ResidueTypesFeatures();

	/// Undefined, commenting out to fix PyRosetta build  ResidueTypesFeatures(core::scoring::ScoreFunctionOP scfxn);

	/// Undefined, commenting out to fix PyRosetta build  ResidueTypesFeatures( ResidueTypesFeatures const & src );

	virtual ~ResidueTypesFeatures();

	///@brief return string with class name
	std::string
	type_name() const;

	///@brief return sql statements that setup the right tables
	std::string
	schema() const;

	///@brief return the set of features reporters that are required to
	///also already be extracted by the time this one is used.
	utility::vector1<std::string>
	features_reporter_dependencies() const;

	///@brief collect all the feature data for the pose
	core::Size
	report_features(
		core::pose::Pose const & pose,
		utility::vector1< bool > const & relevant_residues,
		core::Size struct_id,
		utility::sql_database::sessionOP db_session);


private:

	// should match version string in residue type parameter sets
	core::Real version_;
	core::chemical::ResidueDatabaseIO residue_dbio_;

};

} // namespace
} // namespace

#endif // include guard
