// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file Mike Tyka
/// @brief

// Must place this on top because of an ambiguous symbol issue with byte
#ifdef BOINC
	#include <protocols/boinc/boinc.hh>  // REQUIRED FOR WINDOWS
#endif

// libRosetta headers
#include <protocols/loophash/Mover_LoopHashRefine.hh>

// AUTO-REMOVED #include <core/chemical/ResidueTypeSet.hh>

// AUTO-REMOVED #include <core/chemical/ChemicalManager.hh>
// AUTO-REMOVED #include <core/kinematics/FoldTree.hh>
#include <core/pose/util.hh>
#include <core/kinematics/Jump.hh>
#include <core/kinematics/RT.hh>
#include <basic/options/option.hh>
// AUTO-REMOVED #include <core/import_pose/pose_stream/util.hh>
// AUTO-REMOVED #include <core/io/pdb/pose_io.hh>
#include <core/pose/Pose.hh>
#include <core/conformation/Residue.hh>
// AUTO-REMOVED #include <core/conformation/ResidueFactory.hh>
// AUTO-REMOVED #include <core/scoring/constraints/util.hh>
// AUTO-REMOVED #include <core/scoring/constraints/CoordinateConstraint.hh>
// AUTO-REMOVED #include <core/scoring/Energies.hh>
#include <core/scoring/ScoreFunctionFactory.hh>
#include <core/scoring/ScoreFunction.hh>
#include <basic/Tracer.hh>
#include <core/scoring/rms_util.hh>
#include <core/io/silent/SilentFileData.hh>
#include <core/io/silent/SilentStruct.hh>
// AUTO-REMOVED #include <core/io/silent/BinaryProteinSilentStruct.hh>
// AUTO-REMOVED #include <core/io/silent/ProteinSilentStruct.hh>
// AUTO-REMOVED #include <core/io/silent/SilentStructFactory.hh>

// AUTO-REMOVED #include <core/init.hh>
// AUTO-REMOVED #include <numeric/HomogeneousTransform.hh>
// AUTO-REMOVED #include <protocols/loops/Loop.hh>
// AUTO-REMOVED #include <protocols/wum/SilentStructStore.hh>
#include <protocols/relax/FastRelax.hh>
// AUTO-REMOVED #include <protocols/loops/Loops.hh>
// #include <protocols/match/Hit.fwd.hh>
// AUTO-REMOVED #include <protocols/match/Hit.hh>
#include <numeric/geometry/hashing/SixDHasher.hh>
#include <protocols/moves/Mover.hh>
// AUTO-REMOVED #include <protocols/topology_broker/TopologyBroker.hh>
// AUTO-REMOVED #include <protocols/topology_broker/util.hh>
// AUTO-REMOVED #include <protocols/frag_picker/VallProvider.hh>
// AUTO-REMOVED #include <utility/excn/Exceptions.hh>
#include <utility/exit.hh>
#include <utility/fixedsizearray1.hh>
#include <utility/pointer/owning_ptr.hh>
// AUTO-REMOVED #include <core/kinematics/MoveMap.hh>

// AUTO-REMOVED #include <core/optimization/AtomTreeMinimizer.hh>
#include <core/optimization/MinimizerOptions.hh>

#include <protocols/loophash/LoopHashLibrary.fwd.hh>
#include <protocols/loophash/LoopHashLibrary.hh>
#include <protocols/loophash/LoopHashMap.hh>
#include <protocols/loophash/LoopHashSampler.hh>
#include <protocols/loophash/LocalInserter.hh>
#include <protocols/loophash/BackboneDB.hh>

// C++ headers
//#include <cstdlib>

#include <iostream>
#include <string>
// AUTO-REMOVED #include <cstdio>

// option key includes
// AUTO-REMOVED #include <basic/options/keys/broker.OptionKeys.gen.hh>
#include <basic/options/keys/in.OptionKeys.gen.hh>
#include <basic/options/keys/out.OptionKeys.gen.hh>
#include <basic/options/keys/lh.OptionKeys.gen.hh>
#include <basic/options/keys/relax.OptionKeys.gen.hh>

#include <core/chemical/ChemicalManager.fwd.hh>
#include <core/import_pose/import_pose.hh>
#include <core/util/SwitchResidueTypeSet.hh>
#include <protocols/jd2/JobDistributor.hh>
#include <utility/vector1.hh>
#include <utility/excn/EXCN_Base.hh>

#ifdef WIN32
	#include <ctime>
#endif


static basic::Tracer TR("main");

using namespace protocols::moves;
using namespace core::scoring;
using namespace core;
using namespace core::pose;
using namespace conformation;
using namespace kinematics;
using namespace numeric::geometry::hashing;
using namespace protocols::frag_picker;
using namespace protocols::loophash;


namespace protocols {
namespace loophash {


void
Mover_LoopHashRefine::apply( core::pose::Pose& pose )
{
  if( !library_ ) return;

  using namespace basic::options;
  using namespace basic::options::OptionKeys;

  std::string prefix = option[ out::prefix ]();
  core::Size skim_size = option[ lh::skim_size ]();

	LocalInserter_SimpleMinOP simple_inserter( new LocalInserter_SimpleMin() );
  LoopHashSampler  lsampler( library_, simple_inserter );


	ScoreFunctionOP fascorefxn = core::scoring::getScoreFunction();
	protocols::relax::FastRelax relax( fascorefxn,  option[ OptionKeys::relax::sequence_file ]() );
  core::pose::PoseOP native_pose;
	if(  option[ in::file::native ].user() ){
		native_pose = new Pose;
		core::import_pose::pose_from_pdb( *native_pose, option[ in::file::native ]() );
		relax.set_native_pose( native_pose );
	}

  for(int round = 0; round < option[ OptionKeys::lh::rounds ]; round ++ ){
		std::string checkpoint_id = "chk" + string_of( round );
		if (!checkpoints_.recover_checkpoint( pose, get_current_tag(), checkpoint_id, true, true )){
			core::pose::Pose opose = pose;
			std::vector< core::io::silent::SilentStructOP > lib_structs;

			// convert pose to centroid pose and apply loophasher
			core::util::switch_to_residue_type_set( pose, core::chemical::CENTROID);
			core::pose::set_ss_from_phipsi( pose );
			core::Size starttime2 = time(NULL);

			core::Size lcount = 0;
			while( lib_structs.size() < skim_size ){
				core::Size resnum = (rand() % (pose.total_residue()-2)) + 1 ;
  			lsampler.set_start_res ( resnum );
  			lsampler.set_stop_res ( resnum );
				lsampler.build_structures( pose, lib_structs );
				lcount++;
				TR.Info << "Lcount: " << lcount << std::endl;
			}
			core::Size endtime2 = time(NULL);
			TR.Info << "FOUND " << lib_structs.size() << " alternative states in time: " << endtime2 - starttime2 << std::endl;

			// write out the centroid structures if desired
			if((  option[ OptionKeys::lh::write_centroid_structs ]() ) ||
				 (  option[ OptionKeys::lh::centroid_only ]() )){
				core::io::silent::SilentFileData sfd;
				std::string silent_file_ = option[ OptionKeys::out::file::silent ]();
				silent_file_ += ".centroid.out" ;
				for( core::Size h = 0; h < lib_structs.size(); h++){
						core::pose::Pose rpose;
						lib_structs[h]->fill_pose( rpose );
						lib_structs[h]->add_energy( "round", round, 1.0 );
						if( native_pose ){
							core::Real rms = scoring::CA_rmsd( *native_pose, rpose );
							core::Real gdtmm = scoring::CA_gdtmm( *native_pose, rpose );
							lib_structs[h]->add_energy( "rms", rms, 1.0 );
							lib_structs[h]->add_energy( "gdtmm", gdtmm, 1.0 );
						}
						lib_structs[h]->set_decoy_tag( "S_" + string_of( round ) + "_" + string_of(  h )  );
						lib_structs[h]->sort_silent_scores();
						sfd.write_silent_struct( *(lib_structs[h]) , silent_file_ );
				}
			}

			// abort if centroid is all we're doing
			if( option[ OptionKeys::lh::centroid_only ]() ) break;

			// Choose a set of structures to refine/relax
			std::random_shuffle( lib_structs.begin(), lib_structs.end());
			std::vector< core::io::silent::SilentStructOP > select_lib_structs;
			for( core::Size k=0;k< std::min(skim_size, lib_structs.size() ) ;k++){
				select_lib_structs.push_back( lib_structs[k] );
			}


			// Batch relax the result:
			core::Real bestscore = MAXIMAL_FLOAT;
			core::Size bestindex = 0;
			core::Size starttime = time(NULL);
			relax.batch_apply( select_lib_structs );
			core::Size endtime = time(NULL);
			TR.Info << "Batchrelax time: " << endtime - starttime << " for " << select_lib_structs.size() << " structures " << std::endl;


			for( core::Size h = 0; h < select_lib_structs.size(); h++){
				TR.Info << "DOING: " << h << " / " << select_lib_structs.size() << std::endl;
				core::pose::Pose rpose;
				select_lib_structs[h]->fill_pose( rpose );
				core::Real score = (*fascorefxn)(rpose);
				TR.Info << "score: " << h << "  " << score << std::endl;
				if( score < bestscore ){
					bestscore = score;
					bestindex = h;
					pose = rpose;
				}
			}

			core::io::silent::SilentFileData sfd;
			std::string silent_file_ = option[ OptionKeys::out::file::silent ]();
			for( core::Size h = 0; h < select_lib_structs.size(); h++){
				if( h == bestindex ) {
					core::pose::Pose rpose;
					select_lib_structs[h]->fill_pose( rpose );
					#ifdef BOINC_GRAPHICS
							//mjo moving 'score' into ifdef to remove unused variable warning
							core::Real score = select_lib_structs[h]->get_energy("score");
							boinc::Boinc::update_graphics_low_energy( pose, score );
							boinc::Boinc::update_graphics_last_accepted( pose, score );
					#endif
					select_lib_structs[h]->add_energy( "round", round, 1.0 );
					select_lib_structs[h]->set_decoy_tag( "S_" + string_of( round ) + "_" + string_of(  h )  );
					select_lib_structs[h]->sort_silent_scores();

					sfd.write_silent_struct( *(select_lib_structs[h]) , silent_file_ );
				}
			}
			checkpoints_.checkpoint( pose, get_current_tag(), checkpoint_id,  true );
		}

		// if in boinc mode let boinc break out prematurely! This will make user's runtimes near perfect and users happy
		#ifdef BOINC
			if (protocols::boinc::Boinc::worker_is_finished( round + 1 )){
				std::cerr << "BOINC Finishing normally." << std::endl;
				break; // we're done no matter what nstruct syays
			}
		#endif
  }

	TR << "Finished serial loophash." << std::endl;

}


// this is in protocols so that it can be caled from the boinc main function
int loophash_main(){
  using namespace basic::options;
  using namespace basic::options::OptionKeys;
	using namespace protocols::loophash;

	utility::vector1 < core::Size > loop_sizes = option[lh::loopsizes]();
	LoopHashLibraryOP loop_hash_library = new LoopHashLibrary( loop_sizes );

	// Run simple sampling run test or create the db ?
	if ( option[lh::create_db]() ){;
		loop_hash_library->create_db();
		loop_hash_library->save_db();
		return 0;
	}

	Mover_LoopHashRefineOP lh_sampler = new Mover_LoopHashRefine( loop_hash_library );

	// Normal mode with external loophash library
	loop_hash_library->load_db();
	try{
		protocols::jd2::JobDistributor::get_instance()->go( lh_sampler );
	} catch ( utility::excn::EXCN_Base& excn ) {
		std::cerr << "Exception: " << std::endl;
		excn.show( std::cerr );
		std::cout << "Exception: " << std::endl;
		excn.show( std::cout ); //so its also seen in a >LOG file
	}

	return 0;
}



}
}


