// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file ./protocols/moves/DsspMover.hh
/// @brief  header file of DsspMover.cc
/// @author Nobuyasu Koga ( nobuyasau@uw.edu )

#ifndef INCLUDED_protocols_moves_DsspMover_hh
#define INCLUDED_protocols_moves_DsspMover_hh

// Project headers
#include <core/pose/Pose.fwd.hh>
#include <protocols/moves/Mover.hh>

#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/moves/Mover.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>
#include <utility/tag/Tag.fwd.hh>

#include <utility/vector1.hh>

#ifdef WIN32
	#include <utility/tag/Tag.hh>
#endif


namespace protocols {
namespace moves {


class DsspMover : public Mover {
public:

	typedef protocols::moves::MoverOP MoverOP;
	typedef utility::tag::TagPtr TagPtr;
	typedef protocols::filters::Filters_map Filters_map;
	typedef protocols::moves::DataMap DataMap;
	typedef protocols::moves::Movers_map Movers_map;

public:

	// default constructor
	DsspMover();

	// @brief destructor
	~DsspMover();

	/// @brief clone this object
	virtual	MoverOP clone() const;

	/// @brief create this type of object
	virtual	MoverOP fresh_instance() const;

	// @brief virtual main operation
	virtual void apply( core::pose::Pose & pose );
	virtual std::string get_name() const;

	void parse_my_tag( TagPtr const, DataMap &, Filters_map const &, Movers_map const &, Pose const & );


};


} // moves
} // protocols


#endif
