// This file has been generated by Py++.
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

#include "boost/python.hpp"

#include <basic/options/option.hh>
#include <core/types.hh>

#include <utility/keys/KeyLookup.hh>
#include <utility/options/keys/BooleanOptionKey.hh>

#include <string>

//#define PYROSETTA
#include <utility/exit.hh>

namespace bp = boost::python;

//using namespace core::io::pdb;

#include <basic/options/keys/in.OptionKeys.gen.hh>
#include <iostream>


template< typename T, typename K >
T get_option(std::string const & id)
{
	if( !utility::options::OptionKeys::has( id ) ) utility_exit_with_message( "get_option: OptionKey with id " + id + " not found!" );

	return basic::options::option[ dynamic_cast<K const &>( utility::options::OptionKeys::key( id ) ) ].value();
}

template< typename T, typename K >
void set_option(std::string const & id, T const & value)
{
	if( !utility::options::OptionKeys::has( id ) ) 	utility_exit_with_message( "set_option: OptionKey with id " + id + " not found!" );

	basic::options::option[ dynamic_cast<K const &>( utility::options::OptionKeys::key( id ) ) ].value( value );
}


// Special case: FileVectorOption (we want to convert it to string vector on the fly)
utility::vector1<std::string> get_file_vector_option(std::string const & id)
{
	//if( !utility::options::OptionKeys::has( id ) )
	//	throw "get_option: OptionKey with id " + id + " not found!";
	if( !utility::options::OptionKeys::has( id ) ) 	utility_exit_with_message( "get_option: OptionKey with id " + id + " not found!" );

	return basic::options::option[ dynamic_cast<utility::options::FileVectorOptionKey const &>( utility::options::OptionKeys::key( id ) ) ].value();
}


void __core_by_hand_beginning__()
{
	bp::def("get_boolean_option", &get_option< bool,        utility::options::BooleanOptionKey> );
	bp::def("get_integer_option", &get_option< int,         utility::options::IntegerOptionKey> );
	bp::def("get_real_option",    &get_option< core::Real,  utility::options::RealOptionKey> );
	bp::def("get_string_option",  &get_option< std::string, utility::options::StringOptionKey> );
	bp::def("get_file_option",    &get_option< std::string, utility::options::FileOptionKey> );

	bp::def("get_boolean_vector_option", &get_option< utility::vector1<bool>,        utility::options::BooleanVectorOptionKey> );
	bp::def("get_integer_vector_option", &get_option< utility::vector1<int>,         utility::options::IntegerVectorOptionKey> );
	bp::def("get_real_option",           &get_option< utility::vector1<core::Real>,  utility::options::RealVectorOptionKey> );
	bp::def("get_string_vector_option",  &get_option< utility::vector1<std::string>, utility::options::StringVectorOptionKey> );
	bp::def("get_file_vector_option",    &get_option< utility::vector1<std::string>, utility::options::FileVectorOptionKey> );

	bp::def("set_boolean_option", &set_option< bool,        utility::options::BooleanOptionKey> );
	bp::def("set_integer_option", &set_option< int,         utility::options::IntegerOptionKey> );
	bp::def("set_real_option",    &set_option< core::Real,  utility::options::RealOptionKey> );
	bp::def("set_string_option",  &set_option< std::string, utility::options::StringOptionKey> );
	bp::def("set_file_option",    &set_option< std::string, utility::options::FileOptionKey> );

	bp::def("set_boolean_vector_option", &set_option< utility::vector1<bool>,        utility::options::BooleanVectorOptionKey> );
	bp::def("set_integer_vector_option", &set_option< utility::vector1<int>,         utility::options::IntegerVectorOptionKey> );
	bp::def("set_real_option",           &set_option< utility::vector1<core::Real>,  utility::options::RealVectorOptionKey> );
	bp::def("set_string_vector_option",  &set_option< utility::vector1<std::string>, utility::options::StringVectorOptionKey> );
	bp::def("set_file_vector_option",    &set_option< utility::vector1<std::string>, utility::options::FileVectorOptionKey> );
}
