#!/usr/bin/env python
# :noTabs=true:
# (c) Copyright Rosetta Commons Member Institutions.
# (c) This file is part of the Rosetta software suite and is made available under license.
# (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
# (c) For more information, see http://www.rosettacommons.org. Questions about this can be
# (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

## @author Sergey Lyskov
## @brief  Demo for PyRosetta sub classing 2


# RosettaCon 2011 demo
from rosetta import *
from rosetta.core.scoring.methods import *

init()

pose = pose_from_pdb("test/data/test_in.pdb")


@rosetta.EnergyMethod()
class CI1B_Method(ContextIndependentOneBodyEnergy):
    def __init__(self):
        ContextIndependentOneBodyEnergy.__init__(self, self.creator() )

    def residue_energy(self, rsd, pose, emap):
        emap.get().set( self.scoreType, 2.0)

    # you can define this functions by hand. And if you don't @EnergyMethod will do that for you
    #def clone(self): return MyNewCI1B();
    #def version(self): return 141
    #def indicate_required_context_graphs(self, v): pass


sf_new = ScoreFunction()
sf_new.set_weight(CI1B_Method.scoreType, 1)
print '---------------------------------------------'
print 'CI1B_Method Score:', sf_new.score(pose)




@rosetta.EnergyMethod()
class CI2B_Method(ContextIndependentTwoBodyEnergy):
    def __init__(self):
        ContextIndependentTwoBodyEnergy.__init__(self, self.creator() )

    def residue_pair_energy(self, rsd1, rsd2, pose, sfxn, emap):
        emap.get().set( self.scoreType, 1.0)

    def atomic_interaction_cutoff(self): return 0.0

    def defines_intrares_energy(self, weights): return True;

    def eval_intrares_energy(self, rsd, pose, sfxn, emap): pass



sf_new = ScoreFunction()
sf_new.set_weight(CI2B_Method.scoreType, 1)
print '---------------------------------------------'
print 'CI2B_Method Score:', sf_new.score(pose)



@rosetta.EnergyMethod()
class CD2B_Method(ContextDependentTwoBodyEnergy):
    def __init__(self):
        ContextDependentTwoBodyEnergy.__init__(self, self.creator() )

    def residue_pair_energy(self, rsd1, rsd2, pose, sfxn, emap):
        emap.get().set( self.scoreType, 1.0)

    def atomic_interaction_cutoff(self): return 0.0

    def defines_intrares_energy(self, weights): return True;

    def eval_intrares_energy(self, rsd, pose, sfxn, emap): pass


sf_new = ScoreFunction()
sf_new.set_weight(CD2B_Method.scoreType, 1)
print '---------------------------------------------'
print 'CD2B_Method Score:', sf_new.score(pose)


print ; print
