#!/usr/bin/python

# (c) Copyright Rosetta Commons Member Institutions.
# (c) This file is part of the Rosetta software suite and is made available under license.
# (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
# (c) For more information, see http://www.rosettacommons.org. Questions about this can be
# (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

## @file   /GUIs/pyrosetta_toolkit/window_main/input.py
## @brief  Handles the Regional input of the main GUI window
## @author Jared Adolf-Bryfogle (jadolfbr@gmail.com)

#Rosetta Imports
from rosetta import *

#Python Imports
import os

#Tkinter Imports
from Tkinter import *
import tkFileDialog
import tkMessageBox
import tkSimpleDialog

#Toolkit Imports
from modules.Region import Region
from modules.tools import sequence as sequence_tools
from modules.tools import input as input_tools
#from pyrosetta_toolkit import main_window
from window_main.IO.GUIInput import GUIInput

class InputFrame(Frame):
    
    def __init__(self, main, toolkit, input_class, **options):
        Frame.__init__(self, main, **options)
        self.toolkit = toolkit
        self.input_class = input_class

        self.pwd= self.location()[0]
        
        self.create_GUI_objects()
        self.grid_GUI_objects()

        #Ignore this.  It is for Komodo Autocomplete.
        if 0:
            self.main = Tk()
            #self.toolkit = main_window()
            self.input_class = GUIInput()
            
    def create_GUI_objects(self):
        
        ############## LOOPS ##############
        #self.label_Loop = Label(self, text="Region Selection", font=("Arial"))
        self.AddLoopButton = Button(self, text = "Add Region", command=lambda: self.addLoop())
        self.RmLoopButton = Button(self, text = "Remove Region", command = lambda:self.remLoop())
        self.StartLoopLabel=Label(self, text="Start of Region:")
        self.EndLoopLabel=Label(self, text="End of Region:")
        self.ChainIDLabel=Label(self, text="Chain ID:")
        self.loops_listbox = Listbox(self)
        self.loops_scroll = Scrollbar(self)
        self.loops_listbox.config(yscrollcommand = self.loops_scroll.set); self.loops_scroll.config(command = self.loops_listbox.yview)
        self.StartLoopEntry=Entry(self, textvariable=self.input_class.region_start)
        self.EndLoopEntry=Entry(self, textvariable=self.input_class.region_end)
        self.ChainIDEntry=Entry(self, textvariable=self.input_class.region_chain)
        ##################################
        
        
        ############ SEQUENCE ############
        
        self.ShoSeqButton = Button(self, text="Show Sequence", command=lambda: self.show_sequence())

        ##################################
        
        
           ### Photo ###
      
        DesignPhoto =PhotoImage(file = (self.pwd+ "/media/RosettaLogo.gif"))
        self.Photo = Label(master=self, image=DesignPhoto)
        self.Photo.image = DesignPhoto
        

            
    def grid_GUI_objects(self):

        ############# LOOPS #############
        #self.label_Loop.grid(row=11, column=0, columnspan=2, pady=15)
        
        self.loops_listbox.bind("<Double-Button-1>", lambda event: self.remLoop())
        self.loops_listbox.bind('<ButtonRelease-1>', lambda event: self.insert_region())
        self.StartLoopLabel.grid(row=16, column=0); self.StartLoopEntry.grid(row=16, column=2)
        self.EndLoopLabel.grid(row=17, column=0); self.EndLoopEntry.grid(row=17, column=2)
        self.ChainIDLabel.grid(row=18, column=0); self.ChainIDEntry.grid(row=18, column=2)
        self.AddLoopButton.grid(row=20, column=2, sticky = W+E)
        self.RmLoopButton.grid(row=21, column=2, sticky=W+E)
        self.loops_listbox.grid(row=22, column=0, rowspan=6, columnspan = 1, sticky = W+E, padx=3);
        self.loops_scroll.grid(row=22, column=1, rowspan=6, sticky=E+N+S)
        ################################
        
        
        ########### SEQUENCE ###########
        self.ShoSeqButton.grid(row=19, column=2, sticky=E+W)
        ################################
        
        self.Photo.grid(row=22, column=2, rowspan=6, columnspan=1, sticky=W+E, padx=3)
        


#### LOOPS ####
    def insert_region(self):
        try:
            region_string = self.loops_listbox.get(self.loops_listbox.curselection())
            regionSP = region_string.split(":")
            self.input_class.region_start.set(regionSP[0])
            self.input_class.region_end.set(regionSP[1])
            self.input_class.region_chain.set(regionSP[2])
        except TclError:
            pass
        
    def load_loop(self):
        loops_as_strings = self.input_class.load_loop()
        if not loops_as_string:return
        for loop_string in loops_as_strings:
            loop_stringSP = loop_string.split(":")
            self.input_class.region_start.set(loop_stringSP[0])
            self.input_class.region_end.set(loop_stringSP[1])
            self.input_class.region_chain.set(loop_stringSP[2])
            self.addLoop()
    

    
    def addLoop(self):
        """
        Adds region to loop_string and regions.
        Sets GUIInput to have a region variable to indicate last added/current region.
        """
        
        #Current
        if not self.input_class.region_chain.get():return
        
        looFull = self.input_class.region_start.get()+ ":"+ self.input_class.region_end.get()+":"+self.input_class.region_chain.get().upper()

        self.input_class.loops_as_strings.append(looFull)
        self.loops_listbox.insert(END, looFull)
        
        region = self.input_class.return_region_from_entry()
        if not self.toolkit.pose.total_residue()==0:
            self.input_class.region_sequence.set(region.get_sequence(self.input_class.pose))
        self.input_class.region = region    
        self.input_class.regions.add_region(region)
    
    def show_sequence(self):
        if self.input_class.pose.total_residue()==0:return
        
        if not self.input_class.region_chain.get():
            self.input_class.region_sequence.set(self.input_class.pose.sequence())
        else:
            region = self.input_class.return_region_from_entry()
            self.input_class.region_sequence.set(region.get_sequence(self.input_class.pose))
            
    def remLoop(self):
        try:
            #Current
            self.input_class.loops_as_strings.remove(self.loops_listbox.get(self.loops_listbox.curselection()))
        
            #Replacement of loops_as_string
            region_string = self.loops_listbox.get(self.loops_listbox.curselection())

            self.input_class.regions.remove_region(region_string)
        
            self.loops_listbox.delete(self.loops_listbox.curselection())
        except TclError:
            print "Please select a region to remove."
            return
        
    def location(self):
        """
        Allows the script to be self-aware of it's path.
        So that it can be imported/ran from anywhere.
        """
            
        p = os.path.abspath(__file__)
        pathSP = os.path.split(p)
        return pathSP