// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/kinematics/types.hh
/// @brief  core::kinematics package type declarations
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_core_kinematics_types_hh
#define INCLUDED_core_kinematics_types_hh


// Package headers
#include <core/types.hh>
#include <core/id/types.hh>


namespace core {
namespace kinematics {

	using id::PHI;
	using id::THETA;
	using id::D;

	using id::BB;
	using id::CHI;
	using id::JUMP;

} // namespace kinematics
} // namespace core


#endif // INCLUDED_core_kinematics_types_HH
