// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file src/core/pack/rotamer_set/WaterPackingInfo.hh
/// @brief
/// @author


#ifndef INCLUDED_core_pack_rotamer_set_WaterPackingInfo_hh
#define INCLUDED_core_pack_rotamer_set_WaterPackingInfo_hh

// AUTO-REMOVED #include <core/types.hh>

#include <basic/datacache/CacheableData.hh>
#include <core/pack/rotamer_set/WaterAnchorInfo.fwd.hh>
#include <core/pack/rotamer_set/WaterPackingInfo.fwd.hh>

// utility headers
// AUTO-REMOVED #include <utility/vector1.hh>

// C++
// AUTO-REMOVED #include <string>

#include <utility/vector1_bool.hh>

#ifdef WIN32
	#include <core/pack/rotamer_set/WaterAnchorInfo.hh>
#endif


namespace core {
namespace pack {
namespace rotamer_set {

class WaterPackingInfo : public basic::datacache::CacheableData {

public:

	WaterPackingInfo();

	WaterPackingInfo( WaterPackingInfo const & src );

	basic::datacache::CacheableDataOP
	clone() const;

	WaterAnchorInfo &
	operator[] ( Size const seqpos );

	WaterAnchorInfo const &
	operator[] ( Size const seqpos ) const;


	void
	clear();

private:
	utility::vector1< WaterAnchorInfoOP > data_;
};

} // namespace rotamer_set
} // namespace pack
} // namespace core


#endif
