// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/mm/MMLJEnergyTable.fwd.hh
/// @brief  core::scoring::mm::MMLJEnergyTable forward declarations
/// @author P. Douglas Renfrew (renfrew@unc.edu)


#ifndef INCLUDED_core_scoring_mm_MMLJEnergyTable_fwd_hh
#define INCLUDED_core_scoring_mm_MMLJEnergyTable_fwd_hh

#include <utility/pointer/access_ptr.fwd.hh>
#include <utility/pointer/owning_ptr.fwd.hh>

namespace core {
namespace scoring {
namespace mm {


// Forward
class MMLJEnergyTable;

typedef  utility::pointer::access_ptr< MMLJEnergyTable > MMLJEnergyTableAP;
typedef  utility::pointer::access_ptr< MMLJEnergyTable const > MMLJEnergyTableCAP;
typedef  utility::pointer::owning_ptr< MMLJEnergyTable > MMLJEnergyTableOP;
typedef  utility::pointer::owning_ptr< MMLJEnergyTable const > MMLJEnergyTableCOP;

} // namespace mm
} // namespace scoring
} // namespace core


#endif // INCLUDED_core_mm_mm_lj_score_FWD_HH
