// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   basic/datacache/CacheableSequenceProfile.fwd.hh
/// @brief
/// @author Andrew Leaver-Fay


#ifndef INCLUDED_core_sequence_CacheableSequenceProfile_fwd_hh
#define INCLUDED_core_sequence_CacheableSequenceProfile_fwd_hh

// utility headers
#include <utility/pointer/access_ptr.hh>
#include <utility/pointer/owning_ptr.hh>

namespace core {
namespace sequence {


class CacheableSequenceProfile;
typedef utility::pointer::owning_ptr< CacheableSequenceProfile > CacheableSequenceProfileOP;
typedef utility::pointer::owning_ptr< CacheableSequenceProfile const > CacheableSequenceProfileCOP;
typedef utility::pointer::access_ptr< CacheableSequenceProfile > CacheableSequenceProfileAP;
typedef utility::pointer::access_ptr< CacheableSequenceProfile const > CacheableSequenceProfileCAP;


} // namespace sequence
} // namespace core


#endif /* INCLUDED_core_sequence_CacheableSequenceProfile_FWD_HH */
