// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   numeric/all.hh
/// @brief  numeric package declarations
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_numeric_all_hh
#define INCLUDED_numeric_all_hh


// Classes
#include <numeric/BodyPosition.hh>
#include <numeric/Quaternion.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzTriple.hh>
#include <numeric/xyzVector.hh>

// Functions
#include <numeric/angle.functions.hh>
#include <numeric/conversions.hh>
#include <numeric/numeric.functions.hh>
#include <numeric/trig.functions.hh>
#include <numeric/xyz.functions.hh>

// Interpolation
#include <numeric/interpolation/all.hh>

// I/O
#include <numeric/io.hh>

// Constants
#include <numeric/constants.hh>


#endif // INCLUDED_numeric_all_HH
