// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available
// (c) under license. The Rosetta software is developed by the contributing
// (c) members of the Rosetta Commons. For more information, see
// (c) http://www.rosettacommons.org. Questions about this can be addressed to
// (c) University of Washington UW TechTransfer, email:license@u.washington.edu

/// @file protocols/antibody2/RefineOneCDRLoopCentroid.hh
/// @brief Build a homology model of an antibody2
/// @detailed
///
///
/// @author Jianqing Xu (xubest@gmail.com)



#ifndef INCLUDED_protocols_antibody2_RefineOneCDRLoopCentroid_hh
#define INCLUDED_protocols_antibody2_RefineOneCDRLoopCentroid_hh


#include <core/pose/Pose.hh>
#include <core/scoring/ScoreFunction.fwd.hh>
#include <core/kinematics/MoveMap.fwd.hh>
#include <protocols/loops/Loops.hh>
#include <protocols/simple_moves/MinMover.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/MoverContainer.fwd.hh>
#include <protocols/moves/MonteCarlo.fwd.hh>
#include <protocols/antibody2/AntibodyInfo.hh>
#include <protocols/antibody2/RefineOneCDRLoopCentroid.fwd.hh>



using namespace core;
namespace protocols {
namespace antibody2 {

class RefineOneCDRLoopCentroid: public moves::Mover {


public:

    /// @brief constructor with arguments
    RefineOneCDRLoopCentroid(AntibodyInfoCOP antibody_info,
							 AntibodyCDRNameEnum const & loop_name);
	
	RefineOneCDRLoopCentroid(AntibodyInfoCOP antibody_info,
							 AntibodyCDRNameEnum const & loop_name,
					 		core::scoring::ScoreFunctionCOP scorefxn );
	
    /// @brief constructor with arguments
    RefineOneCDRLoopCentroid( loops::Loop const & a_cdr_loop);
	
	RefineOneCDRLoopCentroid( loops::Loop const & a_cdr_loop,
							 core::scoring::ScoreFunctionCOP scorefxn );

    /// @brief default destructor
	~RefineOneCDRLoopCentroid();
    

	virtual void apply( pose::Pose & pose );
	
    virtual std::string get_name() const;
	

	void set_benchmark(bool const & setting){
        benchmark_ = setting;
    }
	void set_snugfit(bool const & setting){
        snug_fit_ = setting;
    }
	void set_refine_input_loop(bool const & setting){
        refine_input_loop_ = setting;
    }
	
	void set_score_function(core::scoring::ScoreFunctionCOP scorefxn);

	
private:
	void set_default();
    void finalize_setup( core::pose::Pose const & pose );
	void loop_centroid_relax(
                             pose::Pose & pose,
                             Size const loop_begin,
                             Size const loop_end );
	
private:
    loops::Loop the_cdr_loop_;
    
    bool benchmark_;
	bool snug_fit_;
	bool refine_input_loop_;
	scoring::ScoreFunctionOP lowres_scorefxn_;

};





} // namespace antibody2
} // namespace protocols

#endif


