// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief Add constraints to the current pose conformation.
/// @author Yifan Song

#ifndef INCLUDED_protocols_simple_moves_ClearConstraintsMover_hh
#define INCLUDED_protocols_simple_moves_ClearConstraintsMover_hh

#include <protocols/moves/Mover.hh>

namespace protocols {
namespace simple_moves {

class ClearConstraintsMover : public moves::Mover {
public:
	ClearConstraintsMover();
	virtual ~ClearConstraintsMover();

	virtual void apply( Pose & );
	virtual std::string get_name() const;

	virtual moves::MoverOP clone() const;
	virtual moves::MoverOP fresh_instance() const;

	virtual void
	parse_my_tag( TagPtr const, moves::DataMap &, Filters_map const &, moves::Movers_map const &, Pose const & );
};

} // moves
} // protocols

#endif
