// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file    RingConformationMover.fwd.hh
/// @brief   Forward declarations for RingConformationMover.
/// @author  labonte

#ifndef INCLUDED_protocols_simple_moves_carbohydrates_RingConformationMover_FWD_HH
#define INCLUDED_protocols_simple_moves_carbohydrates_RingConformationMover_FWD_HH

// Utility header
#include <utility/pointer/owning_ptr.hh>

namespace protocols {
namespace simple_moves {
namespace carbohydrates {

/// @brief  A Mover class for switching among various ring conformations.
class RingConformationMover;

typedef utility::pointer::owning_ptr<RingConformationMover> RingConformationMoverOP;
typedef utility::pointer::owning_ptr<RingConformationMover const> RingConformationMoverCOP;

}  // namespace carbohydrates
}  // namespace simple_moves
}  // namespace protocols

#endif  // INCLUDED_protocols_simple_moves_carbohydrates_RingConformationMover_FWD_HH
