// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   utility/options/all.hh
/// @brief  utility::options package declarations
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_utility_options_all_hh
#define INCLUDED_utility_options_all_hh


// Options
#include <utility/options/Option.hh>
#include <utility/options/ScalarOption.hh>
#include <utility/options/BooleanOption.hh>
#include <utility/options/IntegerOption.hh>
#include <utility/options/RealOption.hh>
#include <utility/options/StringOption.hh>
#include <utility/options/FileOption.hh>
#include <utility/options/PathOption.hh>
#include <utility/options/AnyOption.hh>
#include <utility/options/VectorOption.hh>
#include <utility/options/BooleanVectorOption.hh>
#include <utility/options/IntegerVectorOption.hh>
#include <utility/options/RealVectorOption.hh>
#include <utility/options/StringVectorOption.hh>
#include <utility/options/FileVectorOption.hh>
#include <utility/options/PathVectorOption.hh>
#include <utility/options/AnyVectorOption.hh>
#include <utility/options/VariantOption.hh>
#include <utility/options/OptionCollection.hh>

// Keys
#include <utility/options/keys/all.hh>


#endif // INCLUDED_utility_options_all_HH
