// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7361 $
//  $Date: 2006-01-27 04:21:48 +0200 (Fri, 27 Jan 2006) $
//  $Author: kosta $
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/...
// (C) 199x-2005 University of Washington
// (C) 199x-2005 University of California Santa Cruz
// (C) 199x-2005 University of California San Francisco
// (C) 199x-2005 Johns Hopkins University
// (C) 199x-2005 University of North Carolina, Chapel Hill
// (C) 199x-2005 Vanderbilt University

/// @file   Dunbrack5D.cc
///
/// @brief  dun_group_rotno_to_rotno array wrapper
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


// Rosetta Headers
#include "Dunbrack5D.h"


namespace dunbrack_pack {


/// @brief Dunbrack5D static field definitions


	/// @brief Number of positive chi angles for each amino acid in Dunbrack library
	Dunbrack5D::ubyte const Dunbrack5D::nchi_pos[ 22 ] = {//KMa phospho_ser
		static_cast< ubyte >( 0 ), // Filler to get indices matching aa indices
		static_cast< ubyte >( 0 ), // ala
		static_cast< ubyte >( 1 ), // cys
		static_cast< ubyte >( 2 ), // asp
		static_cast< ubyte >( 3 ), // glu
		static_cast< ubyte >( 2 ), // phe
		static_cast< ubyte >( 0 ), // gly
		static_cast< ubyte >( 2 ), // his
		static_cast< ubyte >( 2 ), // ile
		static_cast< ubyte >( 4 ), // lys
		static_cast< ubyte >( 2 ), // leu
		static_cast< ubyte >( 3 ), // met
		static_cast< ubyte >( 2 ), // asn
		static_cast< ubyte >( 1 ), // pro
		static_cast< ubyte >( 3 ), // gln
		static_cast< ubyte >( 4 ), // arg
		static_cast< ubyte >( 1 ), // ser
		static_cast< ubyte >( 1 ), // thr
		static_cast< ubyte >( 1 ), // val
		static_cast< ubyte >( 2 ), // trp
		static_cast< ubyte >( 2 ),  // tyr
		static_cast< ubyte >( 3 )  // sep
	};

	/// @brief Masks to select the chi angles' 2 bits
	Dunbrack5D::ubyte const Dunbrack5D::chi_mask[ 5 ] = {
		static_cast< ubyte >( 0 ), // Filler to get 1-based indexing
		static_cast< ubyte >( 3 ),
		static_cast< ubyte >( 12 ),
		static_cast< ubyte >( 48 ),
		static_cast< ubyte >( 192 )
	};

	/// @brief ASN masks to select the chi angles' 4 bits
	Dunbrack5D::ubyte const Dunbrack5D::asn_chi_mask[ 3 ] = {
		static_cast< ubyte >( 0 ), // Filler to get 1-based indexing
		static_cast< ubyte >( 15 ),
		static_cast< ubyte >( 240 )
	};

	/// @brief Shifts to extract the chi angles' values
	Dunbrack5D::ubyte const Dunbrack5D::chi_shift[ 5 ] = {
		static_cast< ubyte >( 0 ), // Filler to get 1-based indexing
		static_cast< ubyte >( 0 ),
		static_cast< ubyte >( 2 ),
		static_cast< ubyte >( 4 ),
		static_cast< ubyte >( 6 )
	};

	/// @brief ASN shifts to extract the chi angles' values
	Dunbrack5D::ubyte const Dunbrack5D::asn_chi_shift[ 3 ] = {
		static_cast< ubyte >( 0 ), // Filler to get 1-based indexing
		static_cast< ubyte >( 0 ),
		static_cast< ubyte >( 4 )
	};


} // namespace dunbrack_pack
