// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 08:39:36 +0200 (Sun, 18 Mar 2007) $
//  $Author: stuartm $

#ifndef INCLUDED_FArray_xyz_functions_H
#define INCLUDED_FArray_xyz_functions_H


// FArray and xyzVector/xyzMatrix Interoperation Functions
//
// Project: Rosetta
//
// Language: C++
//
// Author: Stuart G. Mentzer (Objexx Engineering, Inc.)


// Numeric Headers
#include <numeric/xyzVector.hh>
#include <numeric/xyzMatrix.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1DB.hh>

// Standard library headers
#include <cassert>


// xyzVector and FArray1D functions


/// @brief Copy an xyzVector into an FArray1D
/// @note To copy to a slice of an FArray create and pass an FArray1Da
template< typename T, typename U >
inline
void
copy_to_FArray(
	numeric::xyzVector< T > const & v,
	FArray1DB< U > & a
)
{
	assert( ( a.l() == 1 ) && ( a.u() == 3 ) );

	a( 1 ) = U( v.x() );
	a( 2 ) = U( v.y() );
	a( 3 ) = U( v.z() );
}


/// @brief xyzVector == FArray1D
template< typename T >
inline
bool
operator ==(
	numeric::xyzVector< T > const & v,
	FArray1DB< T > const & a
)
{
	return (
		( ( a.l() == 1 ) && ( a.u() == 3 ) ) &&
		( a( 1 ) == v.x() ) &&
		( a( 2 ) == v.y() ) &&
		( a( 3 ) == v.z() )
	);
}


/// @brief FArray1D == xyzVector
template< typename T >
inline
bool
operator ==(
	FArray1DB< T > const & a,
	numeric::xyzVector< T > const & v
)
{
	return ( v == a );
}


/// @brief xyzVector != FArray1D
template< typename T >
inline
bool
operator !=(
	numeric::xyzVector< T > const & v,
	FArray1DB< T > const & a
)
{
	return !( v == a );
}


/// @brief FArray1D != xyzVector
template< typename T >
inline
bool
operator !=(
	FArray1DB< T > const & a,
	numeric::xyzVector< T > const & v
)
{
	return !( a == v );
}


// xyzMatrix and FArray2D functions


/// @brief Copy an xyzMatrix into an FArray2D
/// @note To copy to a slice of an FArray create and pass an FArray2Da
template< typename T, typename U >
inline
void
copy_to_FArray(
	numeric::xyzMatrix< T > const & m,
	FArray2DB< U > & a
)
{
	assert( ( a.l1() == 1 ) && ( a.u1() == 3 ) );
	assert( ( a.l2() == 1 ) && ( a.u2() == 3 ) );

	a( 1, 1 ) = U( m.xx() ); a( 1, 2 ) = U( m.xy() ); a( 1, 3 ) = U( m.xz() );
	a( 2, 1 ) = U( m.yx() ); a( 2, 2 ) = U( m.yy() ); a( 2, 3 ) = U( m.yz() );
	a( 3, 1 ) = U( m.zx() ); a( 3, 2 ) = U( m.zy() ); a( 3, 3 ) = U( m.zz() );
}


/// @brief xyzMatrix == FArray2D
template< typename T >
inline
bool
operator ==(
	numeric::xyzMatrix< T > const & m,
	FArray2DB< T > const & a
)
{
	return (
		( ( a.l1() == 1 ) && ( a.u1() == 3 ) ) &&
		( ( a.l2() == 1 ) && ( a.u2() == 3 ) ) &&
		( a( 1, 1 ) == m.xx() ) && ( a( 1, 2 ) == m.xy() ) && ( a( 1, 3 ) == m.xz() ) &&
		( a( 2, 1 ) == m.yx() ) && ( a( 2, 2 ) == m.yy() ) && ( a( 2, 3 ) == m.yz() ) &&
		( a( 3, 1 ) == m.zx() ) && ( a( 3, 2 ) == m.zy() ) && ( a( 3, 3 ) == m.zz() )
	);
}


/// @brief FArray2D == xyzMatrix
template< typename T >
inline
bool
operator ==(
	FArray2DB< T > const & a,
	numeric::xyzMatrix< T > const & m
)
{
	return ( m == a );
}


/// @brief xyzMatrix != FArray2D
template< typename T >
inline
bool
operator !=(
	numeric::xyzMatrix< T > const & m,
	FArray2DB< T > const & a
)
{
	return !( m == a );
}


/// @brief FArray2D != xyzMatrix
template< typename T >
inline
bool
operator !=(
	FArray2DB< T > const & a,
	numeric::xyzMatrix< T > const & m
)
{
	return !( a == m );
}


#endif // INCLUDED_FArray_xyz_functions_H
