// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

// Rosetta Headers
#include "HBondSet.h"
#include "current_pose.h"
#include "hbonds_ns.h"
#include "param.h"
#include "pose.h"
#include "pose_ligand.h"

// Numeric Headers
//#include <numeric/constants.hh>
//#include <numeric/conversions.hh>
//#include <numeric/trig.functions.hh>

// Utility Headers
//#include <utility/basic_sys_util.hh>
//#include <utility/io/izstream.hh>
//#include <utility/io/ozstream.hh>

// ObjexxFCL Headers
//#include <ObjexxFCL/byte.hh>
//#include <ObjexxFCL/ChunkVector.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2Da.hh>

// C++ Headers
//#include <fstream>
//#include <iostream>



////////////////////////////////////////////////////////////////////////////////
/// @begin HBondSet::reset
///
/// @brief
/// reset an HBondSet object (dimension the arrays, clear stored rotamers)
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors jss
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void HBondSet::reset(int const nres) {

	using namespace hbonds;
	using namespace param;
  set_nhbonds(0);
	hbenergies.dimension( MAX_HB, 0.0 );
	hbderiv.dimension( 3, 2, MAX_HB ); // xyz,f1/f2   deriv increments
	hbdonh_atm.dimension( MAX_HB );
	hbdon_res.dimension( MAX_HB );
	hbact_atm.dimension( MAX_HB );
	hbact_res.dimension( MAX_HB );
	hbtype_.dimension( MAX_HB ); // types defined in hbond_ns.h

	hbond_allowed_.dimension( MAX_HB );

	global_atm_to_hbpair_id.dimension( MAX_ATOM(), MAX_RES() );
	hbpair_id_to_hb_id.dimension( MAX_HB_PER_ATM, MAX_HB_ATM );

//car initialize hbchk
	hbchk_.dimension( 2, nres);
	for ( int res1 = 1; res1 <= nres; ++res1 ) {
		hbchk_(1,res1) = false;
		hbchk_(2,res1) = false;
	}
  return;
}

///////////////////////////////////////////////////////////////////////////////
// pose symmetry:
void
HBondSet::symmetrize_hbchk()
{

	// check for current pose:
	if ( !score_check_current_pose() &&
			 !minimize_check_current_pose() &&
			 !pack_check_current_pose() ) return;

	pose_ns::Pose const * pose( 0 );
	if ( score_check_current_pose() ) {
		pose = &score_get_current_pose();
	} else if ( minimize_check_current_pose() ) {
		pose = &minimize_get_current_pose();
	} else if ( pack_check_current_pose() ) {
		pose = &pack_get_current_pose();
	}
	if ( !pose->symmetric() ) return;

	pose_ns::Symmetry_info const & s( pose->symmetry_info() );

	int const nres( pose->total_residue_for_scoring() );
	for ( int i=1; i<= nres; ++i ) {
		if ( s.chi_independent( i ) ) {
			int const num_clones( s.chi_clones(i).size() );
			for ( int j=0; j< num_clones; ++j ) {
				int const clone_pos( s.chi_clones(i)[j] );
				hbchk_(1,clone_pos) = hbchk_(1,i);
				hbchk_(2,clone_pos) = hbchk_(2,i);
			}
		}
	}
}

