// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 16334 $
//  $Date: 2007-08-01 23:39:03 +0300 (Wed, 01 Aug 2007) $
//  $Author: yab $

#ifndef INTERACTION_GRAPH_CLASS_FORWARD_DECLARATION_H
#define INTERACTION_GRAPH_CLASS_FORWARD_DECLARATION_H

namespace pack {

class InteractionGraph;
class InteractionGraphBase;
class PrecomputedPairEnergiesInteractionGraph;

class PDNode;
class PDEdge;
class PDInteractionGraph;

class OnTheFlyNode;
class OnTheFlyEdge;
class OnTheFlyInteractionGraph;

class LazyNode;
class LazyEdge;
class LazyInteractionGraph;

class LinearMemNode;
class LinearMemEdge;
class LinearMemoryInteractionGraph;

class MinimalistNode;
class MinimalistEdge;
class MinimalistInteractionGraph;

//class FlexBBNode;
//class FlexBBEdge;
//class FlexBBInteractionGraph;

template < typename V, typename E, typename G > class AdditionalBackgroundNodesInteractionGraph;

class SASAGraph;

template < typename V, typename E, typename G > class SASAInteractionGraph;

typedef SASAInteractionGraph< PDNode, PDEdge, PDInteractionGraph > SparseSASAInteractionGraph;
typedef SASAInteractionGraph< LazyNode, LazyEdge, LazyInteractionGraph > LazySASAInteractionGraph;
typedef SASAInteractionGraph< LinearMemNode, LinearMemEdge, LinearMemoryInteractionGraph > LinMemSASAInteractionGraph;
typedef SASAInteractionGraph< MinimalistNode, MinimalistEdge, MinimalistInteractionGraph > MinimalistSASAInteractionGraph;


}

#endif
